/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.data.FieldChangeTriggers;
import nl.mpi.arbil.data.IMDIVocabularies;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import nl.mpi.arbilcommons.model.HistoryField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilField
extends HistoryField
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ArbilField.class);
    private transient ArbilDataNode parentDataNode;
    private URI parentDataNodeURI;
    public String xmlPath;
    private String translatedPath = null;
    private String fieldValue;
    public String originalFieldValue = this.fieldValue = "";
    private String cvUrlString;
    private int fieldOrder = -1;
    private ArbilVocabulary fieldVocabulary = null;
    private boolean hasVocabularyType = false;
    private boolean vocabularyIsOpen;
    private boolean vocabularyIsList;
    private boolean attributeField;
    private String keyName = null;
    private String originalKeyName = null;
    protected boolean allowsLanguageId;
    private String languageId = null;
    private String originalLanguageId = null;
    private int isRequiredField = -1;
    private int canValidateField = -1;
    private int siblingCount;
    private static SessionStorage sessionStorage;
    private List<String[]> attributePaths;
    private Map<String, Object> attributeValuesMap;
    private Map<String, Object> originalAttributeValuesMap;
    private static DataNodeLoader dataNodeLoader;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public ArbilField(int fieldOrderLocal, ArbilDataNode localParentDataNode, String tempPath, String tempValue, int tempSiblingCount, boolean allowsLanguageId) {
        this(fieldOrderLocal, localParentDataNode, tempPath, tempValue, tempSiblingCount, allowsLanguageId, null, null);
    }

    public ArbilField(int fieldOrderLocal, ArbilDataNode parentDataNode, String xmlPath, String fieldValue, int siblingCount, boolean allowsLanguageId, List<String[]> attributePaths, Map<String, Object> attributeValuesMap) {
        this.fieldOrder = fieldOrderLocal;
        this.setParentDataNode(parentDataNode);
        this.fieldValue = fieldValue;
        this.originalFieldValue = fieldValue;
        this.xmlPath = xmlPath;
        this.siblingCount = siblingCount;
        this.allowsLanguageId = allowsLanguageId;
        this.attributeField = xmlPath.matches("^.*\\.@[^.]*$");
        this.attributePaths = attributePaths;
        if (attributeValuesMap != null) {
            this.attributeValuesMap = new HashMap<String, Object>(attributeValuesMap);
            this.originalAttributeValuesMap = Collections.unmodifiableMap(new HashMap<String, Object>(attributeValuesMap));
        }
    }

    public boolean isRequiredField() {
        if (this.isRequiredField < 0) {
            this.isRequiredField = 0;
            String fullXmlPath = this.getGenericFullXmlPath();
            for (String currentRequiredField : this.getParentDataNode().getNodeTemplate().getRequiredFields()) {
                if (!fullXmlPath.matches(currentRequiredField)) continue;
                this.isRequiredField = 1;
                break;
            }
        }
        return this.isRequiredField == 1;
    }

    public boolean fieldValueValidates() {
        return this.fieldValueValidatesToTemplate() && this.fieldValueValidatesToVocabulary();
    }

    private boolean fieldValueValidatesToVocabulary() {
        if (this.hasVocabulary() && !this.isVocabularyOpen()) {
            return null != this.getVocabulary().findVocabularyItem(this.fieldValue);
        }
        return true;
    }

    private boolean fieldValueValidatesToTemplate() {
        boolean isValidValue = true;
        if (this.canValidateField != 0) {
            this.canValidateField = 0;
            String fullXmlPath = this.getGenericFullXmlPath();
            for (String[] currentRequiredField : this.getParentDataNode().getNodeTemplate().getFieldConstraints()) {
                if (!fullXmlPath.matches(currentRequiredField[0])) continue;
                this.canValidateField = 1;
                isValidValue = this.fieldValue.matches(currentRequiredField[1]);
                break;
            }
        }
        return isValidValue;
    }

    private static boolean valuesDiffer(Object leftString, Object rightString) {
        if (leftString == null) {
            return rightString != null;
        }
        return !leftString.equals(rightString);
    }

    private static boolean valuesDiffer(Map<String, Object> originalMap, Map<String, Object> currentMap) {
        if (originalMap == null) {
            return currentMap != null;
        }
        if (currentMap == null) {
            return true;
        }
        if (originalMap.size() != currentMap.size()) {
            return true;
        }
        Iterator<Map.Entry<String, Object>> i$ = originalMap.entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry<String, Object> originalEntry = i$.next();
            Object currentValue = currentMap.get(originalEntry.getKey());
            if (currentValue == null) {
                return originalEntry.getValue() != null;
            }
            return !currentValue.equals(originalEntry.getValue());
        }
        return false;
    }

    public boolean fieldNeedsSaveToDisk() {
        if (ArbilField.valuesDiffer(this.originalFieldValue, this.getFieldValueForXml())) {
            return true;
        }
        if (ArbilField.valuesDiffer(this.originalLanguageId, this.languageId)) {
            return true;
        }
        if (ArbilField.valuesDiffer(this.originalKeyName, this.keyName)) {
            return true;
        }
        return ArbilField.valuesDiffer(this.originalAttributeValuesMap, this.attributeValuesMap);
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public String getFieldValueForXml() {
        ArbilVocabularyItem vocabularyItem;
        if (this.hasVocabulary() && (vocabularyItem = this.getVocabulary().findVocabularyItem(this.getFieldValue())) != null) {
            return vocabularyItem.getValue();
        }
        return this.getFieldValue();
    }

    public String getGenericFullXmlPath() {
        return this.getFullXmlPath().replaceAll("\\(\\d*?\\)", "(x)").replaceFirst("\\(x\\)$", "");
    }

    public String getPath() {
        return this.getFullXmlPath();
    }

    public String getFullXmlPath() {
        String[] pathStringArray = this.getParentDataNode().getUrlString().split("#");
        String returnValue = pathStringArray.length > 1 ? pathStringArray[1] + this.xmlPath : this.xmlPath;
        if (this.siblingCount > 0) {
            returnValue = returnValue + "(" + (this.siblingCount + 1) + ")";
        }
        return returnValue;
    }

    public void setFieldValue(String fieldValueToBe, boolean updateUI, boolean excludeFromUndoHistory) {
        if (!this.fieldValue.equals(fieldValueToBe = fieldValueToBe.trim())) {
            if (!excludeFromUndoHistory) {
                ArbilJournal.getSingleInstance().recordFieldChange((HistoryField)this, this.fieldValue, fieldValueToBe, ArbilJournal.UndoType.Value);
            }
            ArbilJournal.getSingleInstance().saveJournalEntry(this.getParentDataNode().getUrlString(), this.getFullXmlPath(), this.fieldValue, fieldValueToBe, "edit");
            this.fieldValue = fieldValueToBe;
            new FieldChangeTriggers().actOnChange(this);
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
        }
    }

    public boolean hasVocabulary() {
        return this.fieldVocabulary != null;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageIdLocal, boolean updateUI, boolean excludeFromUndoHistory) {
        String oldLanguageId = this.getLanguageId();
        boolean valueChanged = false;
        if (languageIdLocal == null) {
            valueChanged = oldLanguageId != null;
        } else if (!languageIdLocal.equals(oldLanguageId)) {
            valueChanged = true;
        }
        if (valueChanged) {
            if (!excludeFromUndoHistory) {
                ArbilJournal.getSingleInstance().recordFieldChange((HistoryField)this, this.getLanguageId(), languageIdLocal, ArbilJournal.UndoType.LanguageId);
            }
            ArbilJournal.getSingleInstance().saveJournalEntry(this.getParentDataNode().getUrlString(), this.getFullXmlPath() + ":LanguageId", oldLanguageId, languageIdLocal, "edit");
            this.languageId = languageIdLocal;
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
        }
    }

    public ArbilVocabulary getVocabulary() {
        return this.fieldVocabulary;
    }

    public boolean isAttributeField() {
        return this.attributeField;
    }

    public ArbilField[] getSiblingField(String pathString) {
        for (ArbilField[] tempField : (ArbilField[][])this.getParentDataNode().getFields().values().toArray((T[])new ArbilField[0][])) {
            if (!tempField[0].getFullXmlPath().equals(pathString) && !tempField[0].getGenericFullXmlPath().equals(pathString)) continue;
            return tempField;
        }
        return null;
    }

    public boolean isDisplayable() {
        return this.fieldValue != null && !this.xmlPath.contains("CorpusLink") && !this.xmlPath.endsWith(".Keys") && !this.xmlPath.endsWith(".History");
    }

    public void finishLoading() {
    }

    public void revertChanges() {
        this.setFieldValue(this.originalFieldValue, false, false);
        this.setLanguageId(this.originalLanguageId, false, false);
        this.setKeyName(this.originalKeyName, false, false);
        boolean updateUI = true;
        this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
    }

    public void setFieldAttribute(String cvType, String cvUrlString, String languageIdLocal, String keyNameLocal) {
        this.originalLanguageId = this.languageId = languageIdLocal;
        this.originalKeyName = this.keyName = keyNameLocal;
        this.cvUrlString = cvUrlString;
        this.hasVocabularyType = false;
        if (cvType != null) {
            if (cvType.equals("OpenVocabularyList")) {
                this.vocabularyIsList = true;
                this.vocabularyIsOpen = true;
                this.hasVocabularyType = true;
            } else if (cvType.equals("OpenVocabulary")) {
                this.vocabularyIsList = false;
                this.vocabularyIsOpen = true;
                this.hasVocabularyType = true;
            } else if (cvType.equals("ClosedVocabularyList")) {
                this.vocabularyIsList = true;
                this.vocabularyIsOpen = false;
                this.hasVocabularyType = true;
            } else if (cvType.equals("ClosedVocabulary")) {
                this.vocabularyIsList = false;
                this.vocabularyIsOpen = false;
                this.hasVocabularyType = true;
            }
        }
        this.loadVocabulary();
    }

    public synchronized List<String[]> getAttributePaths() {
        return Collections.unmodifiableList(this.attributePaths);
    }

    public synchronized boolean hasEditableFieldAttributes() {
        return this.attributePaths != null && this.attributePaths.size() > 0;
    }

    public synchronized Map<String, Object> getAttributeValuesMap() {
        if (this.attributeValuesMap == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.attributeValuesMap);
    }

    public synchronized Object getAttributeValue(String attributePath) {
        if (this.attributeValuesMap != null) {
            return this.attributeValuesMap.get(attributePath);
        }
        return null;
    }

    public synchronized void setAttributeValue(String attributePath, Object value, boolean updateUI) {
        if (ArbilField.valuesDiffer(value, this.getAttributeValue(attributePath))) {
            if (this.attributeValuesMap == null) {
                this.attributeValuesMap = new HashMap<String, Object>();
            }
            if (value == null) {
                this.attributeValuesMap.remove(attributePath);
            } else {
                this.attributeValuesMap.put(attributePath, value);
            }
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
        }
    }

    public void loadVocabulary() {
        ArbilVocabularyItem vocabItem;
        if (this.hasVocabularyType) {
            if (this.cvUrlString != null && this.cvUrlString.length() > 0) {
                this.fieldVocabulary = IMDIVocabularies.getSingleInstance().getVocabulary(this, this.cvUrlString);
            }
        } else if (this.getParentDataNode().getParentDomNode().nodeTemplate != null) {
            String strippedXmlPath = this.getGenericFullXmlPath().replaceAll("\\(x\\)", "");
            this.fieldVocabulary = this.getParentDataNode().getParentDomNode().nodeTemplate.getFieldVocabulary(strippedXmlPath);
        }
        if (this.fieldVocabulary != null && (vocabItem = this.fieldVocabulary.getVocabularyItemByCode(this.fieldValue)) != null) {
            this.fieldValue = vocabItem.getDisplayValue();
        }
    }

    public String toString() {
        return this.getFieldValue();
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean setKeyName(String keyNameLocal, boolean updateUI, boolean excludeFromUndoHistory) {
        logger.debug("setKeyName: {}", (Object)keyNameLocal);
        String lastValue = this.getKeyName();
        logger.debug("lastValue: {}", (Object)lastValue);
        if (lastValue != null && !lastValue.equals(keyNameLocal)) {
            if (!excludeFromUndoHistory) {
                ArbilJournal.getSingleInstance().recordFieldChange((HistoryField)this, this.getKeyName(), keyNameLocal, ArbilJournal.UndoType.KeyName);
            }
            ArbilJournal.getSingleInstance().saveJournalEntry(this.getParentDataNode().getUrlString(), this.getFullXmlPath(), lastValue, keyNameLocal, "editkeyname");
            this.keyName = keyNameLocal;
            this.translatedPath = null;
            this.getTranslateFieldName();
            this.getParentDataNode().setDataNodeNeedsSaveToDisk(this, updateUI);
            if (this.getParentDataNode().getNeedsSaveToDisk(false)) {
                this.getParentDataNode().saveChangesToCache(true);
            }
            this.getParentDataNode().reloadNode();
            return true;
        }
        return false;
    }

    public String getTranslateFieldName() {
        if (this.translatedPath == null) {
            String fieldName = this.xmlPath;
            fieldName = fieldName.replace(".METATRANSCRIPT.Session.MDGroup", "");
            fieldName = fieldName.replace(".METATRANSCRIPT.Session", "");
            fieldName = fieldName.replace(".METATRANSCRIPT.Corpus", "");
            fieldName = fieldName.replace(".METATRANSCRIPT.Catalogue", "");
            fieldName = fieldName.replaceFirst("^\\.CMD\\.Components\\.[^\\.]+\\.", "");
            if ((fieldName = fieldName.replaceFirst("^\\.Kinnate\\.CustomData\\.", "")).endsWith("Keys.Key") && this.keyName != null) {
                fieldName = fieldName + "." + this.keyName;
            }
            if (fieldName.startsWith(".")) {
                fieldName = fieldName.substring(1);
            }
            if (sessionStorage.loadBoolean("useLanguageIdInColumnName", false) && this.getLanguageId() != null && this.getLanguageId().length() > 0) {
                fieldName = fieldName + " [" + this.getLanguageId() + "]";
            }
            this.translatedPath = fieldName;
        }
        if (this.isAttributeField()) {
            return this.translatedPath.replaceAll("^@", "");
        }
        return this.translatedPath;
    }

    public boolean isVocabularyOpen() {
        return this.vocabularyIsOpen;
    }

    public boolean isVocabularyList() {
        return this.vocabularyIsList;
    }

    public boolean isAllowsLanguageId() {
        return this.allowsLanguageId || this.languageId != null;
    }

    public synchronized ArbilDataNode getParentDataNode() {
        if (this.parentDataNode == null && this.parentDataNodeURI != null) {
            this.parentDataNode = dataNodeLoader.getArbilDataNode(null, this.parentDataNodeURI);
        }
        return this.parentDataNode;
    }

    public final synchronized void setParentDataNode(ArbilDataNode parentDataNode) {
        this.parentDataNode = parentDataNode;
        this.parentDataNodeURI = parentDataNode != null ? parentDataNode.getURI() : null;
    }

    public DocumentationLanguages getDocumentationLanguages() {
        return this.getParentDataNode().getNodeTemplate().getDocumentationLanguages();
    }
}

