/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.awt.Component;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.data.AbstractTreeHelper;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilTreeHelper
extends AbstractTreeHelper {
    private static final Logger logger = LoggerFactory.getLogger(ArbilTreeHelper.class);
    private SessionStorage sessionStorage;
    private ArbilTreePanels arbilTreePanel;

    public ArbilTreeHelper(SessionStorage sessionStorage, MessageDialogHandler messageDialogHandler) {
        super(messageDialogHandler);
        this.sessionStorage = sessionStorage;
    }

    public void init() {
        this.initTrees();
        this.loadLocationsList();
    }

    protected SessionStorage getSessionStorage() {
        return this.sessionStorage;
    }

    public void setTrees(ArbilTreePanels arbilTreePanelLocal) {
        this.arbilTreePanel = arbilTreePanelLocal;
        this.arbilTreePanel.remoteCorpusTree.setName("RemoteCorpusTree");
        this.arbilTreePanel.localCorpusTree.setName("LocalCorpusTree");
        this.arbilTreePanel.localDirectoryTree.setName("LocalDirectoryTree");
        this.arbilTreePanel.favouritesTree.setName("FavouritesTree");
        this.applyRootLocations();
    }

    public boolean componentIsTheLocalCorpusTree(Component componentToTest) {
        return componentToTest.equals(this.arbilTreePanel.localCorpusTree);
    }

    public boolean componentIsTheFavouritesTree(Component componentToTest) {
        return componentToTest.equals(this.arbilTreePanel.favouritesTree);
    }

    public void applyRootLocations() {
        logger.debug("applyRootLocations");
        this.arbilTreePanel.localCorpusTree.requestResort();
        this.arbilTreePanel.remoteCorpusTree.requestResort();
        this.arbilTreePanel.localDirectoryTree.requestResort();
        this.arbilTreePanel.favouritesTree.requestResort();
    }

    public DefaultMutableTreeNode getLocalCorpusTreeSingleSelection() {
        logger.debug("localCorpusTree: {}", (Object)this.arbilTreePanel.localCorpusTree);
        return (DefaultMutableTreeNode)this.arbilTreePanel.localCorpusTree.getSelectionPath().getLastPathComponent();
    }

    public void deleteNodes(Object sourceObject) {
        logger.debug("deleteNode: {}", sourceObject);
        if (sourceObject == this.arbilTreePanel.localCorpusTree || sourceObject == this.arbilTreePanel.favouritesTree) {
            ArbilTree tree = (ArbilTree)sourceObject;
            this.deleteNodesFromTree(tree);
        } else if (sourceObject instanceof ArbilTable) {
            ArbilTable table = (ArbilTable)sourceObject;
            this.deleteNodesFromParent(Arrays.asList(table.getSelectedRowsFromTable()));
        } else {
            logger.info("Cannot delete from this source: {}", sourceObject);
        }
    }

    private void deleteNodesFromTree(ArbilTree tree) {
        TreePath[] currentNodePaths = tree.getSelectionPaths();
        int toDeleteCount = 0;
        String nameOfFirst = null;
        for (TreePath currentNodePath : currentNodePaths) {
            DefaultMutableTreeNode selectedTreeNode;
            Object userObject;
            if (currentNodePath == null || !((userObject = (selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent()).getUserObject()) instanceof ArbilDataNode)) continue;
            toDeleteCount = ((ArbilDataNode)userObject).fileNotFound ? ++toDeleteCount : (((ArbilDataNode)userObject).isEmptyMetaNode() ? (toDeleteCount += ((ArbilDataNode)userObject).getChildCount()) : ++toDeleteCount);
            if (nameOfFirst != null) continue;
            nameOfFirst = ((ArbilDataNode)userObject).toString();
        }
        if (0 == this.getMessageDialogHandler().showDialogBox("Delete " + (toDeleteCount == 1 ? "the node \"" + nameOfFirst + "\"?" : toDeleteCount + " nodes?") + " This will also save any pending changes to disk.", "Delete", 0, -1)) {
            HashMap<ArbilDataNode, List<ArbilDataNode>> dataNodesDeleteList = new HashMap<ArbilDataNode, List<ArbilDataNode>>();
            HashMap<ArbilDataNode, List<String>> childNodeDeleteList = new HashMap<ArbilDataNode, List<String>>();
            HashMap<ArbilDataNode, List<ArbilDataNode>> cmdiLinksDeleteList = new HashMap<ArbilDataNode, List<ArbilDataNode>>();
            this.determineNodesToDelete(currentNodePaths, childNodeDeleteList, dataNodesDeleteList, cmdiLinksDeleteList);
            this.deleteNodesByChidXmlIdLink(childNodeDeleteList);
            this.deleteNodesByCorpusLink(dataNodesDeleteList);
            this.deleteCmdiLinks(cmdiLinksDeleteList);
        }
    }

    public boolean addLocationInteractive(URI addableLocation) {
        boolean added = this.addLocation(addableLocation);
        if (!added) {
            this.getMessageDialogHandler().addMessageDialogToQueue("The location already exists and cannot be added again", "Add location");
        }
        this.applyRootLocations();
        return added;
    }

    public ArbilTreePanels getArbilTreePanel() {
        return this.arbilTreePanel;
    }
}

