/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.importexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xml.utils.DefaultErrorHandler;

public class ArbilToHtmlConverter {
    private static MessageDialogHandler messageDialogHandler;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public URI exportImdiToHtml(ArbilDataNode[] inputNodeArray) {
        File destinationDirectory = messageDialogHandler.showEmptyExportDirectoryDialogue("Export HTML");
        if (destinationDirectory == null) {
            return null;
        }
        this.copyDependancies(destinationDirectory, false);
        for (ArbilDataNode currentNode : inputNodeArray) {
            File destinationFile = new File(destinationDirectory, currentNode.toString() + ".html");
            int fileCounter = 1;
            while (destinationFile.exists()) {
                destinationFile = new File(destinationDirectory, currentNode.toString() + "(" + fileCounter + ").html");
            }
            try {
                this.transformNodeToHtml(currentNode, destinationFile);
            }
            catch (Exception exception) {
                messageDialogHandler.addMessageDialogToQueue("Cannot convert data", "HTML Export");
                BugCatcherManager.getBugCatcher().logError(exception);
            }
        }
        return destinationDirectory.toURI();
    }

    public File convertToHtml(ArbilDataNode inputNode) throws IOException, TransformerException {
        File tempHtmlFile = File.createTempFile("tmp", ".html");
        tempHtmlFile.deleteOnExit();
        this.copyDependancies(tempHtmlFile.getParentFile(), true);
        this.transformNodeToHtml(inputNode, tempHtmlFile);
        return tempHtmlFile;
    }

    private void transformNodeToHtml(ArbilDataNode inputNode, File destinationFile) throws IOException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        URL xslUrl = this.getClass().getResource("/nl/mpi/arbil/resources/xsl/imdi-viewer.xsl");
        File xslFile = null;
        xslFile = new File(inputNode.getNodeTemplate().getTemplateDirectory(), "format.xsl");
        if (xslFile != null && xslFile.exists()) {
            xslUrl = xslFile.toURL();
        }
        StreamSource streamSource = new StreamSource(xslUrl.toString());
        Transformer transformer = tFactory.newTransformer(streamSource);
        StringWriter errorStringWriter = new StringWriter();
        DefaultErrorHandler errorHandler = new DefaultErrorHandler(new PrintWriter(errorStringWriter));
        transformer.setErrorListener((ErrorListener)errorHandler);
        try {
            transformer.transform(new StreamSource(inputNode.getURI().toString()), new StreamResult(new FileOutputStream(destinationFile.getCanonicalPath())));
        }
        catch (TransformerException tEx) {
            BugCatcherManager.getBugCatcher().logError("Transformer error messages: " + errorStringWriter.toString(), null);
            throw tEx;
        }
    }

    private void copyDependancies(File destinationDirectory, boolean deleteOnExit) {
        String[] dependentFiles;
        for (String dependantFileString : dependentFiles = new String[]{"imdi-viewer-open.gif", "imdi-viewer-closed.gif", "imdi-viewer.js", "imdi-viewer.css"}) {
            File tempDependantFile = new File(destinationDirectory, dependantFileString);
            if (deleteOnExit) {
                tempDependantFile.deleteOnExit();
            }
            try {
                FileOutputStream outFile = new FileOutputStream(tempDependantFile);
                InputStream inputStream = this.getClass().getResourceAsStream("/nl/mpi/arbil/resources/xsl/" + dependantFileString);
                if (inputStream == null) {
                    BugCatcherManager.getBugCatcher().logError(new Exception("Missing file in jar: " + dependantFileString));
                } else {
                    int bufferLength = 4096;
                    byte[] buffer = new byte[bufferLength];
                    int bytesread = 0;
                    while (bytesread >= 0 && (bytesread = inputStream.read(buffer)) != -1) {
                        outFile.write(buffer, 0, bytesread);
                    }
                    inputStream.close();
                }
                outFile.close();
            }
            catch (IOException iOException) {
                messageDialogHandler.addMessageDialogToQueue("Cannot copy requisite file", "HTML Export");
                BugCatcherManager.getBugCatcher().logError(iOException);
            }
        }
    }
}

