/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.ui.ArbilFieldPlaceHolder;
import nl.mpi.arbil.ui.ArbilFieldView;
import nl.mpi.arbil.ui.ArbilTableCellEditor;
import nl.mpi.arbil.ui.ArbilTableCellRenderer;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.JListToolTip;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.flap.plugin.PluginArbilTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTable
extends JTable
implements PluginArbilTable {
    public static final int MIN_COLUMN_WIDTH = 50;
    public static final int MAX_COLUMN_WIDTH = 300;
    private static final Logger logger = LoggerFactory.getLogger(ArbilTable.class);
    private final ArbilTableModel arbilTableModel;
    private final TableController tableController;
    private final JListToolTip listToolTip = new JListToolTip();
    private int lastColumnCount = -1;
    private int lastRowCount = -1;
    private int lastColumnPreferedWidth = 0;
    private boolean deferColumnWidthUpdates = false;
    protected boolean allowNodeDrop = true;

    public ArbilTable(ArbilTableModel arbilTableModel, TableController tableController, String frameTitle) {
        this.tableController = tableController;
        this.arbilTableModel = arbilTableModel;
        this.arbilTableModel.setShowIcons(true);
        this.setModel(arbilTableModel);
        this.setName(frameTitle);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(2);
        this.setGridColor(Color.LIGHT_GRAY);
        this.getTableHeader().addMouseListener(tableController.getTableHeaderMouseListener());
        this.addMouseListener(tableController.getTableMouseListener());
        tableController.initKeyMapping(this);
    }

    @Override
    public void setTableHeader(JTableHeader tableHeader) {
        super.setTableHeader(tableHeader);
        final TableCellRenderer defaultRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof JLabel && ArbilTable.this.arbilTableModel.getSortColumn() == column) {
                    ((JLabel)component).setHorizontalTextPosition(11);
                    ((JLabel)component).setIcon(ArbilTable.this.arbilTableModel.isSortReverse() ? ArbilIcons.getSingleInstance().orderDesc : ArbilIcons.getSingleInstance().orderAsc);
                }
                return component;
            }
        });
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    @Override
    public JToolTip createToolTip() {
        this.listToolTip.updateList();
        return this.listToolTip;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int viewcolumn) {
        return new ArbilTableCellEditor(this.tableController);
    }

    @Override
    public ArbilTableCellRenderer getCellRenderer(int row, int viewcolumn) {
        int modelcolumn = this.convertColumnIndexToModel(viewcolumn);
        ArbilTableCellRenderer arbilCellRenderer = new ArbilTableCellRenderer();
        arbilCellRenderer.setBackground(this.arbilTableModel.getCellColour(row, modelcolumn));
        return arbilCellRenderer;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.setColumnWidths();
    }

    @Override
    public int getRowHeight() {
        try {
            if (this.getGraphics() != null) {
                FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
                int requiredHeight = fontMetrics.getHeight();
                return requiredHeight;
            }
        }
        catch (Exception exception) {
            logger.debug("getRowHeight could not get the font metrics, using the default row height");
        }
        return super.getRowHeight();
    }

    public void setDeferColumnWidthUpdates(boolean deferColumnWidthUpdates) {
        boolean reenabled = deferColumnWidthUpdates && this.deferColumnWidthUpdates != deferColumnWidthUpdates;
        this.deferColumnWidthUpdates = deferColumnWidthUpdates;
        if (reenabled) {
            this.setColumnWidths();
        }
    }

    public void setColumnWidths() {
        if (!this.deferColumnWidthUpdates) {
            boolean resizeColumns = this.arbilTableModel.isWidthsChanged() || this.lastColumnCount != this.getModel().getColumnCount() || this.lastRowCount != this.getModel().getRowCount();
            this.lastColumnCount = this.getModel().getColumnCount();
            this.lastRowCount = this.getModel().getRowCount();
            int parentWidth = this.getParent().getWidth();
            if (this.getRowCount() > 0 && this.getColumnCount() > 2) {
                if (resizeColumns) {
                    this.doResizeColumns();
                } else if (this.getParent() != null) {
                    boolean lastcolumnSquished;
                    int lastColumnWidth = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1).getWidth();
                    int totalColWidth = this.getColumnModel().getTotalColumnWidth();
                    boolean bl = lastcolumnSquished = lastColumnWidth < 50;
                    if (parentWidth > totalColWidth) {
                        this.setAutoResizeMode(2);
                    } else if (parentWidth < totalColWidth) {
                        this.setAutoResizeMode(0);
                    } else if (lastcolumnSquished) {
                        this.setAutoResizeMode(0);
                        this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1).setPreferredWidth(this.lastColumnPreferedWidth);
                    }
                }
            } else {
                this.setAutoResizeMode(4);
            }
        }
    }

    public void doResizeColumns() {
        this.doResizeColumns(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResizeColumns(Collection<Integer> columnsToResize) {
        this.setAutoResizeMode(0);
        ArbilTableCellRenderer arbilCellRenderer = new ArbilTableCellRenderer();
        int totalColumnWidth = 0;
        int columnCount = this.getColumnModel().getColumnCount();
        Graphics g = this.getGraphics();
        try {
            FontMetrics fontMetrics = g.getFontMetrics();
            for (int columnCounter = 0; columnCounter < columnCount; ++columnCounter) {
                int currentWidth;
                TableColumn tableColumn = this.getColumnModel().getColumn(columnCounter);
                if (columnsToResize == null || columnsToResize.contains(columnCounter)) {
                    currentWidth = 50;
                    Integer storedColumnWidth = this.arbilTableModel.getPreferredColumnWidth(tableColumn.getHeaderValue().toString());
                    if (storedColumnWidth != null) {
                        currentWidth = storedColumnWidth;
                        tableColumn.setMaxWidth(currentWidth);
                        tableColumn.setMinWidth(currentWidth);
                        tableColumn.setResizable(false);
                    } else {
                        for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                            int requiredWidth = arbilCellRenderer.getRequiredWidth(fontMetrics, this.arbilTableModel.getTableCellAt(rowCounter, this.convertColumnIndexToModel(columnCounter)));
                            if (currentWidth >= requiredWidth) continue;
                            currentWidth = requiredWidth;
                        }
                        tableColumn.setMinWidth(0);
                        tableColumn.setMaxWidth(300);
                        tableColumn.setResizable(true);
                    }
                } else {
                    currentWidth = tableColumn.getWidth();
                }
                tableColumn.setPreferredWidth(currentWidth);
                tableColumn.setWidth(currentWidth);
                totalColumnWidth += tableColumn.getWidth();
                this.lastColumnPreferedWidth = currentWidth;
            }
            if (this.getParent().getWidth() > totalColumnWidth) {
                this.setAutoResizeMode(2);
            } else {
                this.setAutoResizeMode(0);
            }
        }
        finally {
            g.dispose();
            this.arbilTableModel.setWidthsChanged(false);
        }
    }

    public void updateStoredColumnWidths() {
        ArbilFieldView fieldView = this.arbilTableModel.getFieldView();
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            String columnName = column.getHeaderValue().toString();
            if (!fieldView.hasColumnWidthForColumn(columnName)) continue;
            fieldView.setColumnWidth(columnName, column.getWidth());
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        if (rowIndex >= 0 && colIndex >= 0) {
            tip = this.getTableCellContentAt(rowIndex, colIndex).toString();
            this.listToolTip.setTartgetObject(this.getTableCellContentAt(rowIndex, colIndex));
        } else {
            this.listToolTip.setTartgetObject(null);
        }
        return tip;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.arbilTableModel.isHorizontalView()) {
            boolean rowSelection = this.arbilTableModel.getTableCellContentAt(rowIndex, columnIndex) instanceof ArbilDataNode;
            if (!this.arbilTableModel.isHorizontalView()) {
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(false);
            } else if (rowSelection) {
                this.getSelectionModel().setSelectionMode(2);
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(false);
            } else {
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(true);
                this.getSelectionModel().setSelectionMode(1);
            }
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        } else {
            KeyEvent nextPress;
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            Toolkit.getDefaultToolkit().getSystemEventQueue();
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            if (currentEvent instanceof KeyEvent && currentEvent != null && (nextPress = (KeyEvent)currentEvent).isShiftDown() && --rowIndex < 0) {
                rowIndex = this.getRowCount() - 1;
            }
            super.changeSelection(rowIndex, 1, toggle, extend);
        }
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                String columnName = ArbilTable.this.getColumnName(index);
                Integer preferredColumnWidth = ArbilTable.this.arbilTableModel.getPreferredColumnWidth(columnName);
                if (preferredColumnWidth == null) {
                    return columnName;
                }
                return String.format("%s [fixed width]", columnName);
            }
        };
    }

    public ArbilField[] getSelectedFields() {
        HashSet<ArbilField> selectedFields = new HashSet<ArbilField>();
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (this.getCellSelectionEnabled()) {
                selectedCols = this.getSelectedColumns();
            } else {
                selectedCols = new int[this.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                for (int currentCol : selectedCols) {
                    if (this.getTableCellContentAt(currentRow, currentCol) instanceof ArbilField) {
                        selectedFields.add((ArbilField)this.getTableCellContentAt(currentRow, currentCol));
                        continue;
                    }
                    if (!(this.getTableCellContentAt(currentRow, currentCol) instanceof ArbilField[])) continue;
                    for (ArbilField currentField : (ArbilField[])this.getTableCellContentAt(currentRow, currentCol)) {
                        selectedFields.add(currentField);
                    }
                }
            }
            return selectedFields.toArray(new ArbilField[0]);
        }
        return null;
    }

    public ArbilDataNode getDataNodeForSelection() {
        Object cellValue = this.arbilTableModel.getTableCellContentAt(this.getSelectedRow(), this.getSelectedColumn());
        if (cellValue instanceof ArbilField) {
            return ((ArbilField)cellValue).getParentDataNode();
        }
        if (cellValue instanceof ArbilField[]) {
            return ((ArbilField[])cellValue)[0].getParentDataNode();
        }
        if (cellValue instanceof ArbilFieldPlaceHolder) {
            return ((ArbilFieldPlaceHolder)cellValue).getArbilDataNode();
        }
        if (cellValue instanceof ArbilDataNode) {
            return (ArbilDataNode)cellValue;
        }
        if (cellValue instanceof ArbilDataNode[]) {
            return ((ArbilDataNode[])cellValue)[0];
        }
        return null;
    }

    public ArbilDataNode[] getSelectedRowsFromTable() {
        int[] selectedRows = this.getSelectedRows();
        return this.arbilTableModel.getSelectedDataNodes(selectedRows);
    }

    public void hideSelectedColumnsFromTable() {
        int[] selectedColumns = this.getSelectedColumns();
        Integer[] selectedModelColumns = new Integer[selectedColumns.length];
        for (int columnCounter = 0; columnCounter < selectedColumns.length; ++columnCounter) {
            selectedModelColumns[columnCounter] = this.convertColumnIndexToModel(selectedColumns[columnCounter]);
        }
        Arrays.sort(selectedModelColumns, Collections.reverseOrder());
        Integer[] arr$ = selectedModelColumns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int selectedModelCol = arr$[i$];
            this.arbilTableModel.hideColumn(selectedModelCol);
        }
    }

    public void removeSelectedRowsFromTable() {
        int[] selectedRows = this.getSelectedRows();
        this.arbilTableModel.removeArbilDataNodeRows(selectedRows);
    }

    public ArbilTableModel getArbilTableModel() {
        return this.arbilTableModel;
    }

    public ArbilTableCell getTableCellAt(int row, int col) {
        Object object = this.getValueAt(row, col);
        if (object instanceof ArbilTableCell) {
            return (ArbilTableCell)object;
        }
        return null;
    }

    public Object getTableCellContentAt(int row, int col) {
        ArbilTableCell cell = this.getTableCellAt(row, col);
        return cell != null ? cell.getContent() : null;
    }

    public boolean isAllowNodeDrop() {
        return this.allowNodeDrop;
    }

    public void setAllowNodeDrop(boolean allowNodeDrop) {
        this.allowNodeDrop = allowNodeDrop;
    }
}

