/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import nl.mpi.arbil.util.task.ArbilTask;
import nl.mpi.arbil.util.task.ArbilTaskEvent;
import nl.mpi.arbil.util.task.ArbilTaskListener;

public class ArbilTaskStatusBar
extends JPanel
implements ArbilTaskListener {
    public static final int STATUS_BAR_HEIGHT = 25;
    public static final int PROGRESS_AREA_WIDTH = 400;
    private JPanel progressArea;
    private HashMap<ArbilTask, ArbilTaskProgressPanel> progressPanels = new HashMap();

    public ArbilTaskStatusBar() {
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
        this.progressArea = new JPanel();
        this.progressArea.setLayout(new BoxLayout(this.progressArea, 3));
        this.progressArea.setSize(new Dimension(400, 25));
        this.progressArea.setPreferredSize(new Dimension(400, 25));
        this.progressArea.setMinimumSize(new Dimension(400, 25));
        this.progressArea.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.progressArea, "East");
        this.revalidate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getParent().getWidth(), 25);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getWidth(), 25);
    }

    public void notifyTask(final ArbilTaskEvent taskEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArbilTask task = taskEvent.getSource();
                ArbilTaskProgressPanel panel = (ArbilTaskProgressPanel)ArbilTaskStatusBar.this.progressPanels.get(task);
                if (taskEvent.getEventType() == ArbilTaskEvent.ArbilTaskEventType.STARTED && panel == null) {
                    panel = ArbilTaskStatusBar.this.createProgressPanel(task);
                }
                if (panel != null) {
                    panel.handleEvent(taskEvent);
                    if (taskEvent.getEventType() == ArbilTaskEvent.ArbilTaskEventType.COMPLETED || taskEvent.getEventType() == ArbilTaskEvent.ArbilTaskEventType.CANCELED) {
                        ArbilTaskStatusBar.this.removeTask(task);
                    }
                }
            }
        });
    }

    private synchronized ArbilTaskProgressPanel createProgressPanel(ArbilTask task) {
        ArbilTaskProgressPanel progressPanel = new ArbilTaskProgressPanel(task);
        this.progressPanels.put(task, progressPanel);
        this.progressArea.add(progressPanel);
        this.revalidate();
        this.repaint();
        return progressPanel;
    }

    private synchronized void removeTask(ArbilTask task) {
        ArbilTaskProgressPanel bar = this.progressPanels.remove(task);
        if (bar != null) {
            this.progressArea.remove(bar);
            this.revalidate();
            this.repaint();
        }
    }

    private static class ArbilTaskProgressPanel
    extends JPanel {
        private JProgressBar progressBar;
        private JLabel label;
        private ArbilTask task;

        public ArbilTaskProgressPanel(ArbilTask task) {
            this.task = task;
            this.progressBar = new JProgressBar(0, task.getTargetValue());
            this.progressBar.setStringPainted(true);
            this.label = new JLabel(task.getName());
            this.setLayout(new BorderLayout());
            this.add((Component)this.label, "West");
            this.add((Component)this.progressBar, "Center");
            this.progressBar.setSize(200, 25);
            this.setToolTipText("");
            this.revalidate();
            this.repaint();
        }

        public Dimension getMinimumSize() {
            return new Dimension(400, 25);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.getParent().getWidth(), 25);
        }

        public String getToolTipText(MouseEvent event) {
            return ArbilTaskProgressPanel.getToolTipText(this.task);
        }

        public void handleEvent(ArbilTaskEvent taskEvent) {
            switch (taskEvent.getEventType()) {
                case CHANGED: {
                    this.update();
                    return;
                }
                case STARTED: 
                case PROGRESS: {
                    this.setProgress();
                    return;
                }
            }
        }

        private synchronized void update() {
            this.label.setText(this.task.getName());
        }

        private synchronized void setProgress() {
            if (this.task.isIndeterminate()) {
                if (!this.progressBar.isIndeterminate()) {
                    this.progressBar.setIndeterminate(true);
                }
                if (this.task.getStatus() != null) {
                    this.progressBar.setString(this.task.getStatus());
                }
            } else {
                if (this.task.getTargetValue() != this.progressBar.getMaximum()) {
                    this.progressBar.setMaximum(this.task.getTargetValue());
                }
                this.progressBar.setValue(this.task.getProgressValue());
            }
            this.progressBar.setString(this.task.getProgressString());
        }

        private static String getToolTipText(ArbilTask task) {
            StringBuilder toolTipBuilder = new StringBuilder();
            if (task.getDescription() != null) {
                toolTipBuilder.append(task.getDescription());
                toolTipBuilder.append("<br /><br />");
            }
            if (task.getStatus() != null) {
                toolTipBuilder.append(task.getStatus());
            }
            if (toolTipBuilder.length() > 0) {
                return toolTipBuilder.insert(0, "<html>").append("</html>").toString();
            }
            return null;
        }
    }
}

