/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.favourites;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.favourites.FavouritesExporter;
import nl.mpi.arbil.favourites.FavouritesImportExportException;
import nl.mpi.arbil.ui.favourites.ExportUI;
import nl.mpi.flap.plugin.PluginDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(ExportAction.class);
    private final PluginDialogHandler dialogHandler;
    private final FavouritesExporter exporter;

    public ExportAction(PluginDialogHandler dialogHandler, FavouritesExporter exporter) {
        super("export");
        this.dialogHandler = dialogHandler;
        this.exporter = exporter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof ExportUI)) {
            throw new RuntimeException("Cannot retrieve favourites selection from UI, action source does not implement ExportUI");
        }
        ExportUI source = (ExportUI)e.getSource();
        this.exportFavourites(source.getSelectedFavourites());
    }

    private void exportFavourites(List<ArbilDataNode> nodesToExport) {
        if (nodesToExport.size() > 0) {
            try {
                File[] exportLocation = this.dialogHandler.showFileSelectBox("Select export destination", true, false, null, PluginDialogHandler.DialogueType.save, null);
                if (exportLocation != null && exportLocation.length > 0 && exportLocation[0] != null) {
                    this.exporter.exportFavourites(exportLocation[0], nodesToExport.toArray(new ArbilDataNode[0]));
                    this.openDirectory(exportLocation[0]);
                    this.dialogHandler.addMessageDialogToQueue("Favourites have been exported", "Export complete");
                }
            }
            catch (FavouritesImportExportException ex) {
                logger.error("An error occurred while exporting favourites", (Throwable)ex);
                this.dialogHandler.addMessageDialogToQueue(String.format("An error occurred while exporting favourites:\n%s.\nSee error log for details.", ex.getMessage()), "Error");
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue("No nodes are selected. Select at least one node to export.", "Select nodes to export");
        }
    }

    private void openDirectory(File exportLocation) {
        try {
            Desktop.getDesktop().open(exportLocation);
        }
        catch (IOException ex) {
            logger.warn("Could not open target location {}", (Object)exportLocation, (Object)ex);
        }
        catch (RuntimeException ex) {
            logger.warn("Could not open target location {}", (Object)exportLocation, (Object)ex);
        }
    }
}

