/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.ui.menu.ArbilContextMenu;
import nl.mpi.arbil.util.BugCatcherManager;

public class TableContextMenu
extends ArbilContextMenu {
    private final TableController tableController;
    private ArbilTable table;
    private JMenuItem copySelectedRowsMenuItem = new JMenuItem();
    private JMenuItem pasteIntoSelectedRowsMenuItem = new JMenuItem();
    private JMenuItem viewSelectedRowsMenuItem = new JMenuItem();
    private JMenuItem matchingRowsMenuItem = new JMenuItem();
    private JMenuItem removeSelectedRowsMenuItem = new JMenuItem();
    private JMenuItem hideSelectedColumnsMenuItem = new JMenuItem();
    private JMenuItem searchReplaceMenuItem = new JMenuItem();
    private JMenuItem deleteFieldMenuItem = new JMenuItem();
    private JMenuItem revertFieldMenuItem = new JMenuItem();
    private JMenuItem copyCellToColumnMenuItem = new JMenuItem();
    private JMenuItem matchingCellsMenuItem = new JMenuItem();
    private JMenuItem openInLongFieldEditorMenuItem = new JMenuItem();
    private JMenuItem clearCellColoursMenuItem = new JMenuItem();
    private JMenuItem jumpToNodeInTreeMenuItem = new JMenuItem();
    private JMenuItem showChildNodesMenuItem = new JMenuItem();
    private JMenuItem showInContextMenuItem = new JMenuItem();
    private JMenuItem deleteFromParentMenuItem = new JMenuItem();

    public TableContextMenu(ArbilTable table, TableController tableController) {
        this.tableController = tableController;
        this.table = table;
        this.setInvoker(table);
        this.selectedTreeNodes = table.getSelectedRowsFromTable();
        this.leadSelectedDataNode = table.getDataNodeForSelection();
    }

    protected void setUpMenu() {
        this.setUpItems();
        this.setUpActions();
    }

    private void setUpItems() {
        if (this.table.getSelectedRow() != -1) {
            ArbilField[] currentSelection;
            this.copySelectedRowsMenuItem.setVisible(true);
            this.pasteIntoSelectedRowsMenuItem.setVisible(true);
            this.openInLongFieldEditorMenuItem.setVisible(true);
            if (this.table.getArbilTableModel().isHorizontalView()) {
                this.viewSelectedRowsMenuItem.setVisible(true);
                this.matchingRowsMenuItem.setVisible(true);
                this.removeSelectedRowsMenuItem.setVisible(true);
                this.showChildNodesMenuItem.setVisible(true);
                this.showInContextMenuItem.setVisible(true);
                if (this.table.getSelectedColumn() == 0 && this.leadSelectedDataNode.isLocal()) {
                    this.deleteFromParentMenuItem.setVisible(true);
                }
            }
            boolean canDeleteSelectedFields = true;
            for (ArbilField currentField : currentSelection = this.table.getSelectedFields()) {
                if (currentField.getParentDataNode().getNodeTemplate().pathIsDeleteableField(currentField.getGenericFullXmlPath())) continue;
                canDeleteSelectedFields = false;
                break;
            }
            if (canDeleteSelectedFields && currentSelection.length > 0) {
                String menuText = currentSelection[0].isAttributeField() ? MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("DELETE ATTRIBUTE {0} X {1}"), currentSelection[0].getTranslateFieldName(), currentSelection.length) : MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("DELETE {0} X {1}"), currentSelection[0].getTranslateFieldName(), currentSelection.length);
                this.deleteFieldMenuItem.setText(menuText);
                this.deleteFieldMenuItem.setVisible(true);
            }
            for (ArbilField currentField : currentSelection) {
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                this.revertFieldMenuItem.setVisible(true);
                break;
            }
        }
        if (this.table.getSelectedRow() != -1 && this.table.getSelectedColumn() != -1) {
            if (this.table.getArbilTableModel().isHorizontalView() && this.table.getSelectionModel().getSelectionMode() == 1) {
                this.copyCellToColumnMenuItem.setVisible(true);
                this.hideSelectedColumnsMenuItem.setVisible(true);
            }
            if (!this.table.getArbilTableModel().isHorizontalView() || this.table.getSelectionModel().getSelectionMode() == 1) {
                this.matchingCellsMenuItem.setVisible(true);
            }
            this.jumpToNodeInTreeMenuItem.setVisible(this.leadSelectedDataNode.isLocal());
            this.clearCellColoursMenuItem.setVisible(true);
        }
        if (this.table.getParent().getParent().getParent().getParent() instanceof ArbilSplitPanel) {
            this.searchReplaceMenuItem.setVisible(true);
        }
    }

    private void setUpActions() {
        this.copySelectedRowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY"));
        this.copySelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.tableController.copySelectedTableRowsToClipBoard(TableContextMenu.this.table);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("edit", 105, this.copySelectedRowsMenuItem);
        this.pasteIntoSelectedRowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("PASTE"));
        this.pasteIntoSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.tableController.pasteIntoSelectedTableRowsFromClipBoard(TableContextMenu.this.table);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("edit", 110, this.pasteIntoSelectedRowsMenuItem);
        this.openInLongFieldEditorMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("OPEN IN LONG FIELD EDITOR"));
        this.openInLongFieldEditorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.tableController.startLongFieldEditorForSelectedFields(TableContextMenu.this.table);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.hideSelectedColumnsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("HIDE SELECTED COLUMNS"));
        this.hideSelectedColumnsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.hideSelectedColumnsFromTable();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem("table cell1", 15, this.hideSelectedColumnsMenuItem);
        this.showChildNodesMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHOW CHILD NODES"));
        this.showChildNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.tableController.showRowChildData(TableContextMenu.this.table.getArbilTableModel());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        if (this.deleteFieldMenuItem.getText() == null || this.deleteFieldMenuItem.getText().length() == 0) {
            this.deleteFieldMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("DELETE MULTIFIELD"));
        }
        this.deleteFieldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableContextMenu.this.tableController.deleteSelectedFields(TableContextMenu.this.table);
            }
        });
        this.revertFieldMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("REVERT SELECTED FIELDS"));
        this.revertFieldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilField[] selectedFields = TableContextMenu.this.table.getSelectedFields();
                    if (selectedFields != null) {
                        for (ArbilField currentField : selectedFields) {
                            currentField.revertChanges();
                        }
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.copyCellToColumnMenuItem.setText("Copy Cell to Whole Column");
        this.copyCellToColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableContextMenu.this.tableController.copySelectedCellToColumn(TableContextMenu.this.table);
            }
        });
        this.addItem("edit", 100, this.copyCellToColumnMenuItem);
        this.matchingCellsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("HIGHLIGHT MATCHING CELLS"));
        this.matchingCellsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.getArbilTableModel().highlightMatchingCells(TableContextMenu.this.table.getSelectedRow(), TableContextMenu.this.table.getSelectedColumn());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.clearCellColoursMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CLEAR CELL HIGHLIGHT"));
        this.clearCellColoursMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.getArbilTableModel().clearCellColours();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.searchReplaceMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("FIND/REPLACE"));
        this.searchReplaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ((ArbilSplitPanel)TableContextMenu.this.table.getParent().getParent().getParent().getParent()).showSearchPane();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.viewSelectedRowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("VIEW SELECTED ROWS"));
        this.viewSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.tableController.viewSelectedTableRows(TableContextMenu.this.table);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.matchingRowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SELECT MATCHING ROWS"));
        this.matchingRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.tableController.highlightMatchingRows(TableContextMenu.this.table);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.removeSelectedRowsMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("REMOVE SELECTED ROWS"));
        this.removeSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.removeSelectedRowsFromTable();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.deleteFromParentMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("REMOVE SELECTED NODES FROM PARENT"));
        this.deleteFromParentMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableContextMenu.this.tableController.deleteNodes(TableContextMenu.this.table);
            }
        });
        this.jumpToNodeInTreeMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("JUMP TO IN TREE"));
        this.jumpToNodeInTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableContextMenu.this.tableController.jumpToSelectionInTree(TableContextMenu.this.table);
            }
        });
        this.jumpToNodeInTreeMenuItem.setEnabled(true);
        this.showInContextMenuItem.setText(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SHOW CONTEXT"));
        this.showInContextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableContextMenu.this.tableController.showContextForSelectedNodes(TableContextMenu.this.table);
            }
        });
        this.addItem("table cell1", 10, this.openInLongFieldEditorMenuItem);
        this.addItem("table cell1", 15, this.hideSelectedColumnsMenuItem);
        this.addItem("table cell1", 20, this.showChildNodesMenuItem);
        this.addItem("table cell1", 25, this.showInContextMenuItem);
        this.addItem("table cell2", 10, this.copyCellToColumnMenuItem);
        this.addItem("table cell2", 20, this.matchingCellsMenuItem);
        this.addItem("table cell2", 30, this.clearCellColoursMenuItem);
        this.addItem("table cell2", 60, this.searchReplaceMenuItem);
        this.addItem("table cell2", 65, this.deleteFieldMenuItem);
        this.addItem("table cell2", 70, this.revertFieldMenuItem);
        this.addItem("table row", 10, this.viewSelectedRowsMenuItem);
        this.addItem("table row", 15, this.matchingRowsMenuItem);
        this.addItem("table row", 20, this.removeSelectedRowsMenuItem);
        this.addItem("table row", 50, this.jumpToNodeInTreeMenuItem);
        this.addItem("table row", 110, this.deleteFromParentMenuItem);
        this.addItem("edit", 60, this.copySelectedRowsMenuItem);
        this.addItem("edit", 65, this.pasteIntoSelectedRowsMenuItem);
    }

    protected void setAllInvisible() {
        this.copySelectedRowsMenuItem.setVisible(false);
        this.pasteIntoSelectedRowsMenuItem.setVisible(false);
        this.viewSelectedRowsMenuItem.setVisible(false);
        this.matchingRowsMenuItem.setVisible(false);
        this.removeSelectedRowsMenuItem.setVisible(false);
        this.hideSelectedColumnsMenuItem.setVisible(false);
        this.deleteFieldMenuItem.setVisible(false);
        this.revertFieldMenuItem.setVisible(false);
        this.copyCellToColumnMenuItem.setVisible(false);
        this.matchingCellsMenuItem.setVisible(false);
        this.openInLongFieldEditorMenuItem.setVisible(false);
        this.clearCellColoursMenuItem.setVisible(false);
        this.searchReplaceMenuItem.setVisible(false);
        this.jumpToNodeInTreeMenuItem.setVisible(false);
        this.showChildNodesMenuItem.setVisible(false);
        this.showInContextMenuItem.setVisible(false);
        this.deleteFromParentMenuItem.setVisible(false);
    }
}

