/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.ArchiveObjectsDBImplHS;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.util.DBConnection;
import nl.mpi.util.OurURL;
import org.apache.log4j.Logger;

public class ArchiveObjectsDBImpl
implements ArchiveObjectsDB {
    protected static Logger logger = Logger.getLogger((String)ArchiveObjectsDBImpl.class.getName());
    protected static ArchiveObjectsDB aoHS = null;
    protected static Hashtable rootsHash = new Hashtable();
    protected static String dbname = null;
    protected static final String adminTableName = "IMDIADMIN";
    protected static String ARCHIVEOBJECTS = "ARCHIVEOBJECTS";
    protected static String staticSyncFlag = "dummy";
    protected boolean status = false;
    protected DBConnection db = null;
    protected static int instance = 0;
    private ArchiveObjectsDB aodbPlugin = null;
    private final String getByValueSync = "x";
    private PreparedStatement getURLFromArchiveObjectsSTM = null;
    private PreparedStatement getURLFromArchiveObjectsForPIDSTM = null;
    private PreparedStatement getPIDFromArchiveObjectsSTM = null;
    private PreparedStatement getTimestampFromArchiveObjectsSTM = null;
    private PreparedStatement getFileTimeFromArchiveObjectsSTM = null;
    private PreparedStatement getAccessInfoFromArchiveObjectsSTM = null;
    private PreparedStatement getIdFromArchiveObjectsSTMurl = null;
    private PreparedStatement getIdFromArchiveObjectsSTMpid = null;
    private PreparedStatement getIdsFromArchiveObjectsChecksumSTM = null;
    private PreparedStatement getSizeFromArchiveObjectsSTM = null;
    private PreparedStatement getChecksumFromArchiveObjectsSTM = null;
    private PreparedStatement getOnSiteFromArchiveObjectsSTM = null;
    private static final String PROPERTYFILENAME = "CorpusStructure.props";

    protected ArchiveObjectsDBImpl(Exception e) {
    }

    public ArchiveObjectsDBImpl(String dbname) {
        this(dbname, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveObjectsDBImpl(String dbname, String user, String passwd) {
        String string = staticSyncFlag;
        synchronized (string) {
            this.db = new DBConnection(dbname, user, passwd, "ArchiveObjectsDBImpl:constructor");
            if (this.db == null || !this.db.getStatus()) {
                if (this.db == null) {
                    logger.error((Object)"constructor: NULL DB connection!");
                } else {
                    logger.error((Object)("constructor: ERROR creating DB connection: " + this.db.getMessage()));
                }
                this.status = false;
                return;
            }
            this.status = true;
            ++instance;
            ArchiveObjectsDBImpl.dbname = dbname;
            this.initArchiveAccessRoots();
            this.initPreparedStatements();
        }
    }

    public boolean setArchiveObjectsDBAccessPlugin(ArchiveObjectsDB aodbp) {
        this.aodbPlugin = aodbp;
        if (aodbp != null) {
            return aodbp.getStatus();
        }
        return true;
    }

    protected void initArchiveAccessRoots() {
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        if (aac != null) {
            if (aoHS != null) {
                aoHS.setArchiveRoots(aac);
            }
            return;
        }
        aac = new ArchiveAccessContext();
        int[] contexts = new int[]{1, 2, 3, 4, 5, 6};
        int j = 0;
        for (int i = 0; i < contexts.length; ++i) {
            String defValue = this.getAdminKey(ArchiveAccessContext.aRootsPropertyNames[contexts[i]]);
            if (defValue != null && !defValue.equals("")) {
                try {
                    aac.updateRoot(contexts[i], defValue);
                }
                catch (MalformedURLException murle) {
                    logger.error((Object)("initArchiveAccessRoots: Error in ArchiveAccessContext roots: " + murle), (Throwable)murle);
                    System.exit(0);
                }
                continue;
            }
            ++j;
            logger.warn((Object)("initArchiveAccessRoots: No root setup in DB yet, starting with dummy default for " + ArchiveAccessContext.aRootsPropertyNames[i]));
            try {
                aac.updateRoot(contexts[i], null);
                continue;
            }
            catch (MalformedURLException murle) {
                logger.error((Object)("initArchiveAccessRoots: Error in ArchiveAccessContext roots: " + murle), (Throwable)murle);
                System.exit(0);
            }
        }
        Properties csProps = new Properties(System.getProperties());
        String propertyfile = csProps.getProperty("Properties", PROPERTYFILENAME);
        if (aac.loadPropertyFile("ArchiveRoots")) {
            logger.info((Object)"initArchiveAccessRoots: loaded ArchiveRoots file");
            j = 0;
        }
        if (aac.loadPropertyFile(propertyfile)) {
            logger.info((Object)("initArchiveAccessRoots: loaded " + propertyfile + " file"));
            j = 0;
        }
        if (j > 0) {
            logger.error((Object)("initArchiveAccessRoots: Dummy default settings active (" + j + " items) and no user ArchiveRoots or properties setup file found!"));
        }
        logger.info((Object)("Initialised archive access roots: " + aac.getRoot(1) + ", " + aac.getRoot(2) + ", " + aac.getRoot(3)));
        logger.info((Object)("Initialised Handle System settings: " + aac.getHandleProxy() + ", " + aac.getHandlePrefix()));
        logger.info((Object)("Initialised archive name: " + aac.getArchiveName()));
        rootsHash.put(dbname, aac);
        if (aoHS != null) {
            aoHS.setArchiveRoots(aac);
        }
    }

    protected synchronized void initPreparedStatements() {
        try {
            this.getURLFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT URL FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getURLFromArchiveObjectsForPIDSTM = this.db.getConnection().prepareStatement("SELECT URL FROM " + ARCHIVEOBJECTS + " WHERE PID = ?");
            this.getPIDFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT PID FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getTimestampFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT CRAWLTIME FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getFileTimeFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT FILETIME FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getAccessInfoFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT (SELECT ACLSTRING FROM accessgroups WHERE MD5 = (SELECT READRIGHTS FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?))" + " AS READRIGHTS, " + "(SELECT ACLSTRING FROM " + "accessgroups" + " WHERE MD5 = " + "(SELECT WRITERIGHTS FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?))" + " AS WRITERIGHTS, " + "ACCESSLEVEL " + "FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getIdFromArchiveObjectsSTMurl = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ARCHIVEOBJECTS + " WHERE URL = ?");
            this.getIdFromArchiveObjectsSTMpid = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ARCHIVEOBJECTS + " WHERE PID = ?");
            this.getIdsFromArchiveObjectsChecksumSTM = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ARCHIVEOBJECTS + " WHERE CHECKSUM = ?");
            this.getSizeFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT SIZE FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getChecksumFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT CHECKSUM FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getOnSiteFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT ONSITE FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
        }
        catch (SQLException sqle) {
            logger.error((Object)("initPreparedStatements: " + sqle));
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)("initPreparedStatements: " + sqle));
            }
        }
    }

    protected synchronized void closePreparedStatements() {
        try {
            if (this.getURLFromArchiveObjectsSTM != null) {
                this.getURLFromArchiveObjectsSTM.close();
            }
            if (this.getURLFromArchiveObjectsForPIDSTM != null) {
                this.getURLFromArchiveObjectsForPIDSTM.close();
            }
            if (this.getPIDFromArchiveObjectsSTM != null) {
                this.getPIDFromArchiveObjectsSTM.close();
            }
            if (this.getTimestampFromArchiveObjectsSTM != null) {
                this.getTimestampFromArchiveObjectsSTM.close();
            }
            if (this.getFileTimeFromArchiveObjectsSTM != null) {
                this.getFileTimeFromArchiveObjectsSTM.close();
            }
            if (this.getAccessInfoFromArchiveObjectsSTM != null) {
                this.getAccessInfoFromArchiveObjectsSTM.close();
            }
            if (this.getIdFromArchiveObjectsSTMurl != null) {
                this.getIdFromArchiveObjectsSTMurl.close();
            }
            if (this.getIdFromArchiveObjectsSTMpid != null) {
                this.getIdFromArchiveObjectsSTMpid.close();
            }
            if (this.getIdsFromArchiveObjectsChecksumSTM != null) {
                this.getIdsFromArchiveObjectsChecksumSTM.close();
            }
            if (this.getSizeFromArchiveObjectsSTM != null) {
                this.getSizeFromArchiveObjectsSTM.close();
            }
            if (this.getChecksumFromArchiveObjectsSTM != null) {
                this.getChecksumFromArchiveObjectsSTM.close();
            }
            if (this.getOnSiteFromArchiveObjectsSTM != null) {
                this.getOnSiteFromArchiveObjectsSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"closePreparedStatements: ", (Throwable)sqle);
        }
        this.getURLFromArchiveObjectsSTM = null;
        this.getURLFromArchiveObjectsForPIDSTM = null;
        this.getPIDFromArchiveObjectsSTM = null;
        this.getTimestampFromArchiveObjectsSTM = null;
        this.getFileTimeFromArchiveObjectsSTM = null;
        this.getAccessInfoFromArchiveObjectsSTM = null;
        this.getIdFromArchiveObjectsSTMurl = null;
        this.getIdFromArchiveObjectsSTMpid = null;
        this.getIdsFromArchiveObjectsChecksumSTM = null;
        this.getSizeFromArchiveObjectsSTM = null;
        this.getChecksumFromArchiveObjectsSTM = null;
        this.getOnSiteFromArchiveObjectsSTM = null;
    }

    public synchronized void close() {
        this.closePreparedStatements();
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
        this.status = false;
    }

    public boolean getStatus() {
        if (!this.status) {
            return this.status;
        }
        if (!this.db.getStatus()) {
            this.status = false;
        }
        if (this.aodbPlugin != null && !this.aodbPlugin.getStatus()) {
            this.status = false;
        }
        return this.status;
    }

    public static void setLogger(Logger l) {
        logger = l;
        NodeIdUtils.setLogger(l);
        DBConnection.setLogger((Logger)l);
    }

    public String getAdminKey(String name) {
        return this.getMultiAdminKey(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMultiAdminKey(String name, boolean multi) {
        PreparedStatement ps = null;
        String answer = null;
        ResultSet rs = null;
        try {
            Object o;
            ps = this.db.getConnection().prepareStatement("SELECT Value FROM IMDIADMIN WHERE NAME = ?");
            ps.clearParameters();
            ps.setString(1, name);
            rs = ps.executeQuery();
            while (rs.next()) {
                answer = answer == null ? "" : answer + ";";
                o = rs.getObject(1);
                if (o != null) {
                    answer = answer + o.toString();
                    if (multi) continue;
                    String string = answer;
                    return string;
                }
                logger.error((Object)("getAdminKey: " + name + " error Object is null"));
            }
            o = answer;
            return o;
        }
        catch (SQLException sqle) {
            logger.warn((Object)("getAdminKey: cannot read key '" + name + "' - admin table not yet there? SQLException: " + sqle.getMessage()));
            String string = null;
            return string;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            ps = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
    }

    public void setArchiveRoots(ArchiveAccessContext aac) {
        if (dbname == null) {
            logger.error((Object)"Cannot setArchiveRoots for null dbname");
            return;
        }
        rootsHash.put(dbname, aac);
        if (aoHS != null) {
            aoHS.setArchiveRoots(aac);
        }
        logger.info((Object)("setArchiveRoots for database " + dbname));
    }

    public ArchiveAccessContext getArchiveRoots() {
        if (dbname == null) {
            logger.error((Object)"Cannot getArchiveRoots for null dbname");
            return null;
        }
        return (ArchiveAccessContext)rootsHash.get(dbname);
    }

    public boolean hasReadAccess(String nodeId, String uid) throws UnknownNodeException {
        AccessInfo ai = this.getObjectAccessInfo(nodeId);
        if (ai == null) {
            return false;
        }
        return ai.hasReadAccess(uid);
    }

    public boolean canWrite() {
        return false;
    }

    public OurURL getObjectURL(String id, int context) throws UnknownNodeException {
        String urlstr = null;
        URI objectURI = this.getObjectURI(id);
        if (objectURI == null) {
            return null;
        }
        try {
            URI result;
            ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
            if (aoHS == null && objectURI.toString().startsWith("hdl")) {
                aoHS = new ArchiveObjectsDBImplHS();
                aoHS.setArchiveRoots(aac);
            }
            if ((result = aac.uriInContext(urlstr = aac.toClassicURL(objectURI.toString(), false, aoHS).toString(), context)) == null) {
                logger.error((Object)("getObjectURL: urlInContext error, context: " + context));
                return null;
            }
            return new OurURL(result.toString().replace("%20", " "));
        }
        catch (MalformedURLException mue) {
            logger.error((Object)("getObjectURL: error creating URL from " + objectURI + " error: " + mue), (Throwable)mue);
        }
        catch (URISyntaxException use) {
            logger.error((Object)("getObjectURL: error creating URI from " + urlstr + " error: " + use), (Throwable)use);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OurURL getObjectURLForPid(String pid) throws UnknownNodeException {
        String methodSignature = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (pid == null) {
            throw new IllegalArgumentException("PID has to be specified. Null is not allowed.");
        }
        if (this.aodbPlugin != null) {
            OurURL pluginResult = this.aodbPlugin.getObjectURLForPid(pid);
            return pluginResult;
        }
        if (!this.statusLog(methodSignature)) {
            return null;
        }
        ResultSet rs = null;
        String urlstr = null;
        try {
            PreparedStatement preparedStatement = this.getURLFromArchiveObjectsForPIDSTM;
            synchronized (preparedStatement) {
                this.getURLFromArchiveObjectsForPIDSTM.clearParameters();
                this.getURLFromArchiveObjectsForPIDSTM.setString(1, pid);
                rs = this.getURLFromArchiveObjectsForPIDSTM.executeQuery();
                if (rs.next()) {
                    urlstr = rs.getString("URL");
                    if (rs.next()) {
                        throw new IllegalStateException("More than one URL found for the supplied PID.");
                    }
                } else {
                    this.throwUnknownObjectException(methodSignature, "", pid);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)(methodSignature + ": SQL exception: pid=" + pid + " " + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        if (urlstr != null) {
            try {
                return new OurURL(urlstr);
            }
            catch (MalformedURLException e) {
                logger.error((Object)(methodSignature + ": Failed to create OurURL object from url: " + urlstr), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI getObjectURI(String id) throws UnknownNodeException {
        block29: {
            if (this.aodbPlugin != null) {
                try {
                    URI pluginResult = this.aodbPlugin.getObjectURI(id);
                    if (pluginResult != null) {
                        return pluginResult;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        return pluginResult;
                    }
                }
                catch (UnknownNodeException une) {
                    if (NodeIdUtils.isNodeId(id)) break block29;
                    throw une;
                }
            }
        }
        if (!this.statusLog("getObjectURI")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectURI", "", id);
        }
        ResultSet rs = null;
        String urlstr = "";
        try {
            PreparedStatement preparedStatement = this.getURLFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getURLFromArchiveObjectsSTM.clearParameters();
                this.getURLFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                rs = this.getURLFromArchiveObjectsSTM.executeQuery();
                while (rs.next()) {
                    urlstr = rs.getString("URL");
                    if (!rs.isLast()) {
                        logger.error((Object)("getObjectURI: ERROR more than one entry for object: " + id));
                    }
                    try {
                        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
                        URI uRI = aac.stringToURI(urlstr);
                        return uRI;
                    }
                    catch (URISyntaxException use) {
                        logger.error((Object)("getObjectURI: DB contained invalid URI: " + urlstr));
                    }
                }
                this.throwUnknownObjectException("getObjectURI", "", id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getObjectURI: SQL exception: nodeid=" + NodeIdUtils.TOINT(id) + " " + e));
            return null;
        }
        return null;
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
    }

    public String getObjectId(OurURL urlin, int context) {
        String pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectId(urlin, context)) != null) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        if (urlin == null) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        URI uri = null;
        try {
            uri = aac.uriToTableContext(aac.stringToURI(urlin.toString()), context);
        }
        catch (URISyntaxException use) {
            uri = null;
        }
        if (uri == null) {
            logger.warn((Object)("getObjectId: urlToTableContext(" + urlin + ", " + context + ") failed"));
            return null;
        }
        return this.getObjectId(uri);
    }

    public String getObjectId(OurURL url) {
        String pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectId(url)) != null) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        int context = aac.getAccessContextFromURI(url.toString());
        if (context == -1) {
            logger.error((Object)("getObjectId: Could not guess access context for URL: " + url));
            context = 0;
        }
        return this.getObjectId(url, context);
    }

    public String getObjectId(URI uri) {
        String pluginResult;
        if (uri == null || !uri.isAbsolute()) {
            logger.warn((Object)("getObjectId: Invalid URI, must specify schema/protocol: " + uri));
            return null;
        }
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectId(uri)) != null) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        uri = aac.inTableContext(uri);
        return this.getObjectIDByValue("URL", uri.toString().replace("%20", " "));
    }

    public String getObjectForPID(String pid) {
        String pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectForPID(pid)) != null) {
            return pluginResult;
        }
        return this.getObjectIDByValue("PID", pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getObjectIDByValue(String name, String value) {
        if (!this.statusLog("getObjectIDByValue")) {
            return null;
        }
        ResultSet rs = null;
        try {
            String string = "x";
            synchronized ("x") {
                block25: {
                    PreparedStatement getByValue = null;
                    if ("URL".equals(name)) {
                        getByValue = this.getIdFromArchiveObjectsSTMurl;
                    } else if ("PID".equals(name)) {
                        getByValue = this.getIdFromArchiveObjectsSTMpid;
                    } else {
                        logger.error((Object)("You cannot getObjectIDByValue for name: " + name));
                    }
                    getByValue.clearParameters();
                    getByValue.setString(1, value);
                    rs = getByValue.executeQuery();
                    if (!rs.next()) break block25;
                    String id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                    if (!rs.isLast()) {
                        logger.error((Object)("getObjectIDByValue: ERROR more than one id for name / value: " + name + " / " + value));
                    }
                    String string2 = id;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return string2;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                logger.debug((Object)("## getObjectIDByValue: NONE for name / value: " + name + " / " + value));
                string = null;
                return string;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getObjectIDByValue: SQL exception: " + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getObjectsByChecksum(String checksum) {
        String[] pluginResult;
        if (checksum == null || !checksum.matches("^[0-9a-f]*$")) {
            logger.warn((Object)("getObjectsByChecksum: Invalid checksum, must be lower case hex: " + checksum));
            return null;
        }
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectsByChecksum(checksum)) != null && pluginResult.length > 0) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectsByChecksum")) {
            return null;
        }
        ResultSet rs = null;
        TreeSet<String> items = new TreeSet<String>(new NodeIdComparator());
        try {
            PreparedStatement preparedStatement = this.getIdsFromArchiveObjectsChecksumSTM;
            synchronized (preparedStatement) {
                this.getIdsFromArchiveObjectsChecksumSTM.clearParameters();
                this.getIdsFromArchiveObjectsChecksumSTM.setString(1, checksum);
                rs = this.getIdsFromArchiveObjectsChecksumSTM.executeQuery();
                while (rs.next()) {
                    String id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                    items.add(id);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getObjectsByChecksum: SQL exception: " + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return items.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectPID(String nodeId) throws UnknownNodeException {
        String pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectPID(nodeId)) != null && pluginResult.length() > 0) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectPID")) {
            return null;
        }
        ResultSet rs = null;
        String pid = null;
        try {
            PreparedStatement preparedStatement = this.getPIDFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getPIDFromArchiveObjectsSTM.clearParameters();
                this.getPIDFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getPIDFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    pid = rs.getString("PID");
                }
                if (rs.next()) {
                    logger.warn((Object)("getObjectPID: Multiple rows returned for nodeid: " + nodeId));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getObjectPID: SQL exception: " + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getObjectTimestamp(String id) throws UnknownNodeException {
        block27: {
            if (this.aodbPlugin != null) {
                try {
                    Timestamp pluginResult = this.aodbPlugin.getObjectTimestamp(id);
                    if (pluginResult != null) {
                        return pluginResult;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        return pluginResult;
                    }
                }
                catch (UnknownNodeException une) {
                    if (NodeIdUtils.isNodeId(id)) break block27;
                    throw une;
                }
            }
        }
        if (!this.statusLog("getObjectTimestamp")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectTimestamp", "", id);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getTimestampFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getTimestampFromArchiveObjectsSTM.clearParameters();
                this.getTimestampFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                rs = this.getTimestampFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp("CRAWLTIME");
                    if (!rs.isLast()) {
                        logger.error((Object)("getTimestamp: ERROR more than one entry for object: " + id));
                    }
                    Timestamp timestamp2 = timestamp;
                    return timestamp2;
                }
            }
            this.throwUnknownObjectException("getObjectTimeStamp", "", id);
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)"getObjectTimeStamp", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getObjectFileTime(String id) throws UnknownNodeException {
        block27: {
            if (this.aodbPlugin != null) {
                try {
                    Timestamp pluginResult = this.aodbPlugin.getObjectFileTime(id);
                    if (pluginResult != null) {
                        return pluginResult;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        return pluginResult;
                    }
                }
                catch (UnknownNodeException une) {
                    if (NodeIdUtils.isNodeId(id)) break block27;
                    throw une;
                }
            }
        }
        if (!this.statusLog("getObjectFileTime")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectFileTime", "", id);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getFileTimeFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getFileTimeFromArchiveObjectsSTM.clearParameters();
                this.getFileTimeFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                rs = this.getFileTimeFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp("FILETIME");
                    if (!rs.isLast()) {
                        logger.error((Object)("getObjectFileTime: ERROR more than one entry for object: " + id));
                    }
                    Timestamp timestamp2 = timestamp;
                    return timestamp2;
                }
            }
            this.throwUnknownObjectException("getObjectFileTime", "", id);
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)"getObjectFileTime", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessInfo getObjectAccessInfo(String id) {
        block27: {
            if (this.aodbPlugin != null) {
                try {
                    AccessInfo pluginResult = this.aodbPlugin.getObjectAccessInfo(id);
                    if (pluginResult != null) {
                        return pluginResult;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        return pluginResult;
                    }
                }
                catch (UnknownNodeException une) {
                    if (NodeIdUtils.isNodeId(id)) break block27;
                    throw une;
                }
            }
        }
        if (!this.statusLog("getObjectAccessInfo")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(id)) {
            this.throwUnknownObjectException("getObjectAccessInfo", "", id);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getAccessInfoFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getAccessInfoFromArchiveObjectsSTM.clearParameters();
                this.getAccessInfoFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                this.getAccessInfoFromArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                this.getAccessInfoFromArchiveObjectsSTM.setInt(3, NodeIdUtils.TOINT(id));
                rs = this.getAccessInfoFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    AccessInfo ai = new AccessInfo(null, null, rs.getString("READRIGHTS"), rs.getString("WRITERIGHTS"), rs.getInt("ACCESSLEVEL"));
                    if (!rs.isLast()) {
                        logger.error((Object)("getAccessInfo: ERROR more than one entry for object: " + id));
                    }
                    AccessInfo accessInfo = ai;
                    return accessInfo;
                }
            }
            this.throwUnknownObjectException("getObjectAccessInfo", "", id);
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)"getObjectAccessInfo: ", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getObjectSize(String nodeId) throws UnknownNodeException {
        block27: {
            if (this.aodbPlugin != null) {
                try {
                    long pluginResult = this.aodbPlugin.getObjectSize(nodeId);
                    if (pluginResult >= 0L) {
                        return pluginResult;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        return pluginResult;
                    }
                }
                catch (UnknownNodeException une) {
                    if (NodeIdUtils.isNodeId(nodeId)) break block27;
                    throw une;
                }
            }
        }
        if (!this.statusLog("getObjectSize")) {
            return -1L;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("getObjectSize", "", nodeId);
        }
        ResultSet rs = null;
        long size = 0L;
        try {
            PreparedStatement preparedStatement = this.getSizeFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getSizeFromArchiveObjectsSTM.clearParameters();
                this.getSizeFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getSizeFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    size = rs.getLong("SIZE");
                    if (!rs.isLast()) {
                        logger.error((Object)("getObjectSize: ERROR more than one entry for object: " + nodeId));
                    }
                    long l = size;
                    return l;
                }
            }
            this.throwUnknownObjectException("getObjectSize: ", "", nodeId);
            return -1L;
        }
        catch (SQLException e) {
            logger.error((Object)("getObjectSize: nodeid=" + NodeIdUtils.TOINT(nodeId) + " " + e));
            return -1L;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getObjectChecksum(String nodeId) {
        block27: {
            if (this.aodbPlugin != null) {
                try {
                    String pluginResult = this.aodbPlugin.getObjectChecksum(nodeId);
                    if (pluginResult != null) {
                        return pluginResult;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        return pluginResult;
                    }
                }
                catch (UnknownNodeException une) {
                    if (NodeIdUtils.isNodeId(nodeId)) break block27;
                    throw une;
                }
            }
        }
        if (!this.statusLog("getObjectChecksum")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("getObjectChecksum", "", nodeId);
        }
        ResultSet rs = null;
        String checksum = null;
        try {
            PreparedStatement preparedStatement = this.getChecksumFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getChecksumFromArchiveObjectsSTM.clearParameters();
                this.getChecksumFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getChecksumFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    checksum = rs.getString("CHECKSUM");
                    if (!rs.isLast()) {
                        logger.error((Object)("getObjectChecksum: ERROR more than one entry for object: " + nodeId));
                    }
                    String string = checksum;
                    return string;
                }
            }
            this.throwUnknownObjectException("getObjectChecksum: ", "", nodeId);
            return null;
        }
        catch (SQLException e) {
            logger.error((Object)"getObjectChecksum: ", (Throwable)e);
            return null;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
    }

    public boolean isAccessible(String nodeId) throws UnknownNodeException {
        block4: {
            try {
                if (this.aodbPlugin != null && this.aodbPlugin.isAccessible(nodeId)) {
                    return true;
                }
                if (!NodeIdUtils.isNodeId(nodeId)) {
                    return false;
                }
            }
            catch (UnknownNodeException une) {
                if (NodeIdUtils.isNodeId(nodeId)) break block4;
                throw une;
            }
        }
        return this.getObjectSize(nodeId) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOnSite(String nodeId) throws UnknownNodeException {
        block26: {
            try {
                if (this.aodbPlugin != null && this.aodbPlugin.isOnSite(nodeId)) {
                    return true;
                }
                if (!NodeIdUtils.isNodeId(nodeId)) {
                    return false;
                }
            }
            catch (UnknownNodeException une) {
                if (NodeIdUtils.isNodeId(nodeId)) break block26;
                throw une;
            }
        }
        if (!this.statusLog("isOnSite")) {
            return false;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            this.throwUnknownObjectException("isOnSite", "", nodeId);
        }
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.getOnSiteFromArchiveObjectsSTM;
            synchronized (preparedStatement) {
                this.getOnSiteFromArchiveObjectsSTM.clearParameters();
                this.getOnSiteFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                rs = this.getOnSiteFromArchiveObjectsSTM.executeQuery();
                if (rs.next()) {
                    boolean onSite = rs.getBoolean("ONSITE");
                    if (!rs.isLast()) {
                        logger.error((Object)("isOnSite: ERROR more than one entry for object: " + nodeId));
                    }
                    boolean bl = onSite;
                    return bl;
                }
            }
            this.throwUnknownObjectException("isOnSite: ", "", nodeId);
            return false;
        }
        catch (SQLException sqle) {
            logger.error((Object)("isOnSite(" + nodeId + ") : "), (Throwable)sqle);
            return false;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNewArchiveObjectsSince(Timestamp timestamp, boolean onsiteonly, boolean urlformat, boolean usefiletime) {
        String[] pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getNewArchiveObjectsSince(timestamp, onsiteonly, urlformat, usefiletime)) != null) {
            return pluginResult;
        }
        if (!this.statusLog("getNewArchiveObjectsSince")) {
            return null;
        }
        String format = urlformat ? "URL" : "NODEID";
        if (timestamp != null && timestamp.getTime() == 0L) {
            timestamp = null;
        }
        TreeSet<String> results = new TreeSet<String>(urlformat ? null : new NodeIdComparator());
        ResultSet rs = null;
        Statement statement = null;
        try {
            statement = this.db.getConnection().createStatement();
            String cmd = "SELECT " + format + " FROM " + ARCHIVEOBJECTS;
            if (timestamp != null || onsiteonly) {
                cmd = cmd + " WHERE ";
            }
            if (timestamp != null) {
                cmd = usefiletime ? cmd + "FILETIME" : cmd + "CRAWLTIME";
                cmd = cmd + " > '" + timestamp + "'";
                if (onsiteonly) {
                    cmd = cmd + " AND ";
                }
            }
            if (onsiteonly) {
                cmd = cmd + "ONSITE";
            }
            logger.debug((Object)("getNewArchiveObjectsSince: " + cmd));
            rs = statement.executeQuery(cmd);
            while (rs.next()) {
                String res = null;
                res = urlformat ? rs.getString(1) : NodeIdUtils.TONODEID(rs.getInt(1));
                results.add(res);
            }
            String[] stringArray = results.toArray(new String[0]);
            return stringArray;
        }
        catch (SQLException e) {
            logger.error((Object)"getNewArchiveObjectsSince: ", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return null;
    }

    protected void throwUnknownNodeException(String method, String message, String nodeId) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no node with nodeId " + nodeId + ", " + message);
    }

    protected void throwUnknownObjectException(String method, String message, String id) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no object with Id " + id + ", " + message);
    }

    protected boolean statusLog(String method) {
        boolean okay = this.getStatus();
        if (!okay) {
            logger.error((Object)("ArchiveObjectsDBImpl." + method + ": DB / object status is false"));
        }
        return okay;
    }

    protected class NodeIdComparator
    implements Comparator {
        protected NodeIdComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int n1 = NodeIdUtils.TOINT((String)o1);
                int n2 = NodeIdUtils.TOINT((String)o2);
                return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
            }
            catch (UnknownNodeException une) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
    }
}

