/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBImpl;
import nl.mpi.corpusstructure.Node;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.util.OurURL;
import org.apache.log4j.Logger;

public class StreamingPreparation {
    private static String streamingServer = "sun2.mpi.nl";
    private static int streamingHelperPort = 7777;
    private static String fileExtensionStreamingVideo = "mp4";
    private static String fileExtensionStreamingAudio = "m4a";
    private CorpusStructureDB csdb = null;
    private ArchiveObjectsDB aodb = null;
    private static Logger logger = Logger.getLogger((String)StreamingPreparation.class.getName());

    public StreamingPreparation(String cs_dbname, String cs_username, String cs_password) {
        CorpusStructureDBImpl csi = new CorpusStructureDBImpl(cs_dbname, false, cs_username, cs_password);
        this.csdb = csi;
        this.aodb = csi;
    }

    public StreamingPreparation(String cs_dbname, String cs_username, String cs_password, String streamingServer, int streamingHelperPort) {
        this(cs_dbname, cs_username, cs_password);
        StreamingPreparation.streamingServer = streamingServer;
        StreamingPreparation.streamingHelperPort = streamingHelperPort;
    }

    public void close() {
        if (this.csdb != null) {
            this.csdb.close();
        }
        if (this.aodb != null) {
            this.aodb.close();
        }
    }

    public URL getStreamingLink(String nodeId) {
        if (nodeId == null || nodeId.equals("")) {
            return null;
        }
        String pathToStreamable = this.getStreamableForMedia(nodeId);
        if (pathToStreamable == null) {
            logger.warn((Object)"getStreamingLink: pathToStreamable is null");
            return null;
        }
        logger.debug((Object)("getStreamingLink: Sending 'create " + pathToStreamable + "'"));
        String response = StreamingPreparation.queryStreamingHelper("create " + pathToStreamable);
        if (!response.equals("0")) {
            try {
                logger.debug((Object)("getStreamingLink: queryStreamingHelper replied: " + response));
                return new URL("rtsp://" + streamingServer + response);
            }
            catch (MalformedURLException mue) {
                logger.warn((Object)("Cannot make rtsp URL: rtsp://" + streamingServer + response));
            }
        }
        return null;
    }

    public String getStreamingLinkString(String nodeId) {
        if (nodeId == null || nodeId.equals("")) {
            return null;
        }
        String pathToStreamable = this.getStreamableForMedia(nodeId);
        if (pathToStreamable == null) {
            logger.warn((Object)"getStreamingLink: pathToStreamable is null");
            return null;
        }
        logger.debug((Object)("getStreamingLink: Sending 'create " + pathToStreamable + "'"));
        String response = StreamingPreparation.queryStreamingHelper("create " + pathToStreamable);
        if (!response.equals("0")) {
            logger.debug((Object)("getStreamingLink: queryStreamingHelper replied: " + response));
            return response;
        }
        return null;
    }

    public String getURLForNode(String nodeId) throws UnknownNodeException {
        return this.aodb.getObjectURL(nodeId, 3).toString();
    }

    public String getStreamableForMedia(String nodeId) {
        Node node;
        String nodeBaseName = null;
        String nodeFormat = null;
        String streamingFileExtension = fileExtensionStreamingVideo;
        int separator = 47;
        OurURL nodeURL = this.aodb.getObjectURL(nodeId, 1);
        if (nodeURL != null) {
            nodeBaseName = nodeURL.getPath();
            if (nodeBaseName.endsWith(fileExtensionStreamingVideo) || nodeBaseName.endsWith(fileExtensionStreamingAudio)) {
                return nodeBaseName;
            }
            if (nodeBaseName.lastIndexOf(92) > nodeBaseName.lastIndexOf(47)) {
                separator = 92;
            }
            nodeBaseName = nodeBaseName.substring(nodeBaseName.lastIndexOf(separator) + 1);
            nodeBaseName = nodeBaseName.substring(0, nodeBaseName.lastIndexOf(46));
        }
        if ((node = this.csdb.getNode(nodeId)) != null && (nodeFormat = node.getFormat()) != null && nodeFormat.matches("audio.*")) {
            streamingFileExtension = fileExtensionStreamingAudio;
        }
        String[] parents = this.csdb.getParentNodes(nodeId);
        if (nodeBaseName == null || parents == null) {
            return null;
        }
        for (int i = 0; i < parents.length; ++i) {
            String[] siblings = this.csdb.getSubnodes(parents[i]);
            for (int j = 0; j < siblings.length; ++j) {
                OurURL siblingURL = this.aodb.getObjectURL(siblings[j], 1);
                if (siblingURL == null || !siblingURL.getProtocol().equals("file") || !siblingURL.getPath().endsWith(streamingFileExtension)) continue;
                String siblingBaseName = siblingURL.getPath();
                if (siblingBaseName.lastIndexOf(92) > siblingBaseName.lastIndexOf(47)) {
                    separator = 92;
                }
                siblingBaseName = siblingBaseName.substring(nodeBaseName.lastIndexOf(separator) + 1);
                siblingBaseName = siblingBaseName.substring(0, siblingBaseName.lastIndexOf(46));
                if (!(siblingBaseName = siblingBaseName.substring(siblingBaseName.lastIndexOf(separator) + 1)).equals(nodeBaseName)) continue;
                return siblingURL.getPath();
            }
        }
        return null;
    }

    public static boolean deleteStreamingLink(URL link) {
        if (link == null) {
            return false;
        }
        String file = link.getPath();
        logger.info((Object)("deleteStreamingLink/URL: Sending 'delete " + file + "'"));
        String response = StreamingPreparation.queryStreamingHelper("delete " + file);
        return response.equals("1");
    }

    public static boolean deleteStreamingLink(String link) {
        if (link == null) {
            return false;
        }
        logger.info((Object)("deleteStreamingLink/String: Sending 'delete " + link + "'"));
        String response = StreamingPreparation.queryStreamingHelper("delete " + link);
        return response.equals("1");
    }

    private static String queryStreamingHelper(String request) {
        StringBuffer response = new StringBuffer();
        try {
            Socket sock = new Socket(streamingServer, streamingHelperPort);
            DataOutputStream os = new DataOutputStream(sock.getOutputStream());
            if (request != null && !request.equals("")) {
                request = request + "\n";
                os.writeBytes(request);
            }
            os.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            String str = "";
            while ((str = rd.readLine()) != null) {
                response.append(str);
            }
            rd.close();
            os.close();
            sock.close();
        }
        catch (IOException ioe) {
            logger.error((Object)("queryStreamingHelper failure for request: '" + request + "' IOException: " + ioe), (Throwable)ioe);
        }
        return response.toString();
    }
}

