/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.util.DBConnection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IMDIDBTable {
    private static Logger logger = Logger.getLogger((String)IMDIDBTable.class.getName());
    public static final String tablePFX = "IMDIMD_";
    private static boolean bootstrap = false;
    private static Set mainTables = new HashSet();
    private static Map allTables = new Hashtable();
    private String tableName;
    private String constraint = null;
    private static boolean useTmpTableNames = false;
    private DBConnection db = null;
    private Statement bstatement = null;
    private int ninserts = 0;
    private static int MAXINSERTS = 1000;
    private int nid;
    private List<Integer> lastIds = null;
    private boolean hasUniqueId;
    private Vector dbColumnNames = new Vector();
    private Vector columnNames = new Vector();
    private HashMap columnValues;
    private Hashtable columnTypes;
    private boolean flushed = false;
    private Vector indexesToCreate = new Vector();
    static String[] availableTables = null;
    static String[] availableTmpTables = null;

    public static void setLogger(Logger l) {
        logger = l;
    }

    public static void setTmpTableNames() {
        useTmpTableNames = true;
    }

    public static void unsetTmpTableNames() {
        useTmpTableNames = false;
    }

    private static String encodeTableName(String name) {
        name = useTmpTableNames ? "TMPIMDIMD_" + name.replace('.', '_') : tablePFX + name.replace('.', '_');
        return name.toUpperCase();
    }

    public static void setBootstrapMode(boolean b) {
        bootstrap = b;
    }

    static IMDIDBTable get(DBConnection db, String name, int nid, boolean hasUniqueId, String mainTableName) throws SQLException {
        IMDIDBTable t = (IMDIDBTable)allTables.get(name = IMDIDBTable.encodeTableName(name));
        if (t == null) {
            return new IMDIDBTable(db, name, nid, hasUniqueId, mainTableName);
        }
        return t;
    }

    static boolean exists(String name) {
        return allTables.get(IMDIDBTable.encodeTableName(name)) != null;
    }

    public static void init(DBConnection db) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMDIDBTable(DBConnection db, String name, int nid, boolean hasUniqueId, String mainTableName) throws SQLException {
        Statement statement = null;
        try {
            this.nid = nid;
            this.hasUniqueId = hasUniqueId;
            this.tableName = name.toUpperCase();
            this.db = db;
            this.columnNames = new Vector();
            this.columnTypes = new Hashtable();
            this.columnValues = new HashMap();
            this.flushed = false;
            this.bstatement = db.getConnection().createStatement();
            statement = db.getConnection().createStatement();
            statement.setEscapeProcessing(false);
            this.bstatement.setEscapeProcessing(false);
            boolean isMasterTable = false;
            if (nid == 1) {
                mainTables.add(this);
                isMasterTable = true;
                statement.execute(db.startTransaction);
                logger.debug((Object)"start transaction");
                this.setDeferredConstraints(statement);
            }
            this.dbColumnNames = IMDIDBTable.getColumnNames(db, this.tableName);
            if (bootstrap || this.getRealColumnName("NODEID") == null) {
                String idspecstr = "NODEID INTEGER ";
                String constr = "";
                for (int i = 2; i <= nid; ++i) {
                    idspecstr = idspecstr + ", Id" + i + " INTEGER ";
                }
                String tname = this.getName();
                if (tname.startsWith("TMP")) {
                    tname = tname.substring(3);
                }
                if (isMasterTable) {
                    if (db.dbType == 2) {
                        idspecstr = idspecstr + " PRIMARY KEY";
                    } else {
                        this.constraint = "ALTER TABLE " + tname + " ADD PRIMARY KEY (NODEID)";
                    }
                } else {
                    String mtname = IMDIDBTable.encodeTableName(mainTableName);
                    if (mtname.startsWith("TMP")) {
                        mtname = mtname.substring(3);
                    }
                    this.constraint = "ALTER TABLE " + tname + " ADD CONSTRAINT FK_" + tname + " FOREIGN KEY (NODEID) REFERENCES " + mtname + "(NODEID) ON DELETE CASCADE";
                    if (db.dbType == 1) {
                        this.constraint = this.constraint + " DEFERRABLE";
                    }
                }
                String ctable = "CREATE " + db.tableType + " TABLE " + this.tableName + " (" + idspecstr + constr + " )";
                logger.debug((Object)("Creating table: " + this.tableName + " -> " + ctable));
                statement.execute(ctable);
                statement.execute("GRANT SELECT ON " + this.tableName + " TO PUBLIC");
                this.indexesToCreate.add("NODEID");
                if (!useTmpTableNames) {
                    this.createIndexes();
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("ERROR creating IMDI table: " + this.tableName), (Throwable)sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            statement = null;
        }
        allTables.put(this.tableName.toUpperCase(), this);
    }

    private void setDeferredConstraints(Statement statement) throws SQLException {
        if (this.db.dbType == 2) {
            statement.execute("SET REFERENTIAL_INTEGRITY FALSE");
        } else if (this.db.dbType == 1) {
            statement.execute("SET CONSTRAINTS ALL DEFERRED");
        } else {
            logger.error((Object)("Unknown DB type: " + this.db.dbType));
        }
    }

    private void close() {
        if (this.bstatement != null) {
            try {
                allTables.remove(this.tableName.toUpperCase());
                this.bstatement.close();
            }
            catch (SQLException sqle) {
                logger.error((Object)("Closing batch statement: " + sqle));
            }
            this.bstatement = null;
        }
    }

    private String indexName(String column) {
        String name = this.getName();
        if (name.startsWith("TMP")) {
            name = name.substring(3);
        }
        return column + "_" + name + "_IDX";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(String column) {
        String name = this.getName();
        if (name.startsWith("TMP")) {
            name = name.substring(3);
        }
        Statement stat = null;
        try {
            stat = this.db.getConnection().createStatement();
            String str = "CREATE INDEX " + this.indexName(column) + " ON " + name + " ( " + column + " )";
            logger.debug((Object)str);
            stat.execute(str);
        }
        catch (SQLException sqle) {
            logger.error((Object)("createIndex: SQLException " + sqle));
        }
        finally {
            try {
                if (stat != null) {
                    // empty if block
                }
                stat.close();
            }
            catch (SQLException e) {}
            stat = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConstraint() {
        Statement stat = null;
        try {
            stat = this.db.getConnection().createStatement();
            logger.debug((Object)this.constraint);
            stat.execute(this.constraint);
        }
        catch (SQLException sqle) {
            logger.error((Object)("createConstraint: constraint= " + this.constraint + "\n SQLException= " + sqle));
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)("createConstraint: " + sqle));
            }
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException sQLException) {}
            }
            stat = null;
            this.constraint = null;
        }
    }

    public void createIndexes() {
        if (this.constraint != null) {
            this.createConstraint();
        }
        for (int i = 0; i < this.indexesToCreate.size(); ++i) {
            String name = (String)this.indexesToCreate.get(i);
            this.createIndex(name);
        }
        this.indexesToCreate = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(String column, String value, String type, List<Integer> ids) throws SQLException {
        String tabmod = "";
        String s = "";
        Statement stat = null;
        column = column.toUpperCase();
        try {
            if (this.getNewColumnName(column) == null) {
                if (bootstrap || this.getRealColumnName(column) == null) {
                    logger.debug((Object)("insert: column=" + column + " gRCN=" + this.getRealColumnName(column) + " bootstrap=" + bootstrap));
                    stat = this.db.getConnection().createStatement();
                    tabmod = "ALTER TABLE " + this.tableName + " ADD COLUMN " + column + " " + type + " DEFAULT NULL";
                    logger.debug((Object)("## " + tabmod));
                    stat.execute(tabmod);
                    if (type.equalsIgnoreCase("DECIMAL")) {
                        this.indexesToCreate.add(column);
                    }
                    if (type.equalsIgnoreCase("DATE")) {
                        this.indexesToCreate.add(column);
                    }
                    if (type.equalsIgnoreCase("INTEGER")) {
                        this.indexesToCreate.add(column);
                    }
                    logger.info((Object)("insert: Created column " + column + " with type " + type + " in table " + this.tableName));
                    this.dbColumnNames = IMDIDBTable.getColumnNames(this.db, this.tableName);
                }
                this.columnTypes.put(column, type.toUpperCase());
                this.columnNames.add(column);
            }
            if (!this.hasUniqueId && this.columnValues.get(column) != null || this.idsDiffer(this.lastIds, ids)) {
                s = this.createInsertCommand(this.lastIds);
                this.insert(s);
            }
            this.lastIds = new LinkedList<Integer>(ids);
            this.columnValues.put(column, value);
        }
        catch (SQLException sqle) {
            logger.error((Object)("insert: " + s + " cause=" + sqle));
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)("insert: " + sqle));
            }
        }
        catch (Exception e) {
            logger.error((Object)("insert: Execption occured processing " + ids + ", " + tabmod + ", " + s));
            logger.error((Object)("insert: " + this.getName() + ", " + column + ", " + value + ", " + type + ", " + ids + " ,, " + this.lastIds));
            logger.error((Object)("insert: columns=" + this.columnNames), (Throwable)e);
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException e) {}
            stat = null;
        }
    }

    private boolean idsDiffer(List<Integer> ids1, List<Integer> ids2) {
        if (ids1 != null) {
            return !((Object)ids1).equals(ids2);
        }
        return false;
    }

    private String getRealColumnName(String column) {
        if (this.dbColumnNames == null || this.dbColumnNames.size() == 0) {
            this.dbColumnNames = IMDIDBTable.getColumnNames(this.db, this.tableName);
        }
        for (int i = 0; i < this.dbColumnNames.size(); ++i) {
            String uColumnName = ((String)this.dbColumnNames.get(i)).toUpperCase();
            if (!column.toUpperCase().equals(uColumnName)) continue;
            return (String)this.dbColumnNames.get(i);
        }
        return null;
    }

    private String getNewColumnName(String column) {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String uColumnName = ((String)this.columnNames.get(i)).toUpperCase();
            if (!column.toUpperCase().equals(uColumnName)) continue;
            return (String)this.columnNames.get(i);
        }
        return null;
    }

    private String createInsertCommand(List<Integer> ids) {
        int i;
        String idstr1 = "";
        String idstr2 = "";
        String colstr = "";
        String valstr = "";
        String columnType = "";
        String columnValue = "";
        String cname = "";
        idstr1 = idstr1 + "NODEID ";
        idstr2 = idstr2 + ids.get(0);
        for (i = 2; i <= this.nid; ++i) {
            idstr1 = idstr1 + ", Id" + i;
            idstr2 = idstr2 + ", " + ids.get(i - 1);
        }
        for (i = 0; i < this.columnNames.size(); ++i) {
            cname = (String)this.columnNames.get(i);
            colstr = colstr + cname;
            if (i != this.columnNames.size() - 1) {
                colstr = colstr + ", ";
            }
            columnType = (String)this.columnTypes.get(cname);
            columnValue = this.columnValues.get(cname);
            valstr = columnValue == null ? valstr + "NULL" : (columnType.startsWith("VARCHAR") ? valstr + "'" + this.escapeSql((String)this.columnValues.get(cname)) + "'" : (columnType.equalsIgnoreCase("DATE") ? valstr + "'" + this.escapeSql((String)this.columnValues.get(cname)) + "'" : valstr + this.escapeSql(columnValue)));
            if (i != this.columnNames.size() - 1) {
                valstr = valstr + ", ";
            }
            this.columnValues.put(cname, null);
        }
        String insertstr = "INSERT INTO  " + this.tableName + " ( " + idstr1 + ", " + colstr + " ) VALUES(" + idstr2 + ", " + valstr + ")";
        return insertstr;
    }

    private String escapeSql(String in) {
        return in.replaceAll("'", "''").replaceAll("\\\\", "\\\\\\\\");
    }

    private static void finish() {
        mainTables = new HashSet();
        allTables = new Hashtable();
        bootstrap = false;
    }

    String getName() {
        if (this.tableName == null) {
            return this.tableName;
        }
        return this.tableName.toUpperCase();
    }

    void insert(String s) throws SQLException {
        this.bstatement.addBatch(s);
        ++this.ninserts;
        if (this.ninserts >= MAXINSERTS) {
            this.bstatement.executeBatch();
            this.ninserts = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertAll() {
        if (this.flushed) {
            return;
        }
        Statement statement = null;
        String ls = "";
        try {
            statement = this.db.getConnection().createStatement();
            if (this.lastIds != null) {
                ls = this.createInsertCommand(this.lastIds);
                this.insert(ls);
            }
            this.bstatement.executeBatch();
            this.ninserts = 0;
            this.flushed = true;
        }
        catch (SQLException sqle) {
            logger.error((Object)("insertAll: " + ls + ", " + sqle));
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)("insertAll: " + sqle));
            }
            try {
                statement.execute(this.db.endTransaction);
                statement.execute(this.db.startTransaction);
                logger.debug((Object)"end/restart transaction again");
                this.setDeferredConstraints(statement);
            }
            catch (SQLException e) {
                logger.error((Object)("error stopping/restarting transaction " + e));
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushAllTables(DBConnection db) {
        for (IMDIDBTable mainTable : mainTables) {
            mainTable.insertAll();
        }
        HashSet tableNames = new HashSet(allTables.keySet());
        Iterator iter = tableNames.iterator();
        while (iter.hasNext()) {
            String tname = iter.next().toString();
            IMDIDBTable table = (IMDIDBTable)allTables.get(tname);
            if (mainTables.contains(table)) continue;
            table.insertAll();
        }
        Statement statement = null;
        try {
            statement = db.getConnection().createStatement();
            statement.execute(db.endTransaction);
            logger.debug((Object)"flushAllTables: end transaction");
        }
        catch (SQLException sqle) {
            logger.error((Object)("flushAllTables: " + sqle));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            statement = null;
        }
    }

    public static void closeAll() {
        logger.debug((Object)"closeAll: closing all tables");
        HashSet tableNames = new HashSet(allTables.keySet());
        Iterator iter = tableNames.iterator();
        while (iter.hasNext()) {
            String tname = iter.next().toString();
            IMDIDBTable table = (IMDIDBTable)allTables.get(tname);
            table.close();
        }
        IMDIDBTable.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFromAllTables(DBConnection db, String nodeId) throws UnknownNodeException {
        Statement statement = null;
        try {
            if (availableTables == null) {
                availableTables = IMDIDBTable.getTableNames(db, tablePFX).toArray(new String[0]);
            }
            statement = db.getConnection().createStatement();
            for (int i = 0; i < availableTables.length; ++i) {
                String tablename = availableTables[i];
                String cmd = "DELETE FROM " + tablename + " WHERE NODEID =" + NodeIdUtils.TOINT(nodeId);
                int n = 0;
                try {
                    n = statement.executeUpdate(cmd);
                    if (n != 0 || !tablename.toLowerCase().equals("imdimd_session")) continue;
                    throw new UnknownNodeException("Unknown node " + nodeId);
                }
                catch (SQLException sqle) {
                    logger.error((Object)("deleteFromAllTables: error deleting from table " + tablename + " " + nodeId + " " + sqle));
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("deleteFromAllTables: " + sqle));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            statement = null;
        }
    }

    public static void createAllIndexes(DBConnection db) {
        for (IMDIDBTable mainTable : mainTables) {
            mainTable.createIndexes();
        }
        HashSet tableNames = new HashSet(allTables.keySet());
        Iterator iter = tableNames.iterator();
        while (iter.hasNext()) {
            String tname = iter.next().toString();
            IMDIDBTable table = (IMDIDBTable)allTables.get(tname);
            if (mainTables.contains(table)) continue;
            table.createIndexes();
        }
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector getTableNames(DBConnection db, String prefix) {
        Statement statement = null;
        ResultSet rs = null;
        Vector<Object> results = new Vector<Object>();
        try {
            Object tName;
            DatabaseMetaData md = db.getConnection().getMetaData();
            statement = db.getConnection().createStatement();
            rs = md.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                tName = rs.getString("TABLE_NAME").toUpperCase();
                if (!((String)tName).startsWith(prefix.toUpperCase())) continue;
                results.add(tName);
            }
            tName = results;
            return tName;
        }
        catch (SQLException sqle) {
            logger.error((Object)"getTableNames: ", (Throwable)sqle);
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)"getTableNames: ", (Throwable)sqle);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            statement = null;
            rs = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector getColumnNames(DBConnection db, String tName) {
        String nTableName = tName.toUpperCase();
        Statement statement = null;
        ResultSet rs = null;
        Vector<String> results = new Vector<String>();
        try {
            int i = 0;
            int j = 0;
            DatabaseMetaData md = db.getConnection().getMetaData();
            statement = db.getConnection().createStatement();
            rs = md.getColumns(null, null, null, null);
            while (rs.next()) {
                if (rs.getString("TABLE_NAME").toUpperCase().equals(nTableName)) {
                    results.add(rs.getString("COLUMN_NAME"));
                    ++i;
                    continue;
                }
                ++j;
            }
            logger.debug((Object)("getColumnNames: " + nTableName + "(" + tName + ") has " + i + " columns, " + " columns of other tables: " + j));
            Vector<String> vector = results;
            return vector;
        }
        catch (SQLException sqle) {
            logger.error((Object)"getColumnNames: ", (Throwable)sqle);
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)"getColumnNames: ", (Throwable)sqle);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            statement = null;
            rs = null;
        }
        logger.debug((Object)("getColumnNames: error checking table " + nTableName));
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteAllTables(DBConnection db) {
        availableTables = IMDIDBTable.getTableNames(db, tablePFX).toArray(new String[0]);
        if (availableTables == null) {
            return;
        }
        Statement statement = null;
        Vector results = new Vector();
        try {
            String sessionTable = null;
            statement = db.getConnection().createStatement();
            for (int i = 0; i < availableTables.length; ++i) {
                if (availableTables[i].toUpperCase().endsWith("SESSION")) {
                    sessionTable = availableTables[i];
                    continue;
                }
                try {
                    statement.execute("DROP TABLE " + availableTables[i]);
                    logger.debug((Object)("// deleteAllTables: DROP TABLE " + availableTables[i]));
                    continue;
                }
                catch (SQLException sqle) {
                    logger.error((Object)("deleteAllTables: error deleting: " + availableTables[i] + ", " + sqle));
                }
            }
            if (sessionTable != null) {
                try {
                    statement.execute("DROP TABLE " + sessionTable);
                    logger.debug((Object)("// deleteAllTables: session table: DROP TABLE " + sessionTable));
                }
                catch (SQLException sqle) {
                    logger.error((Object)("deleteAllTables: error deleting session table: " + sessionTable + ", " + sqle));
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"deleteAllTables: ", (Throwable)sqle);
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)"deleteAllTables: ", (Throwable)sqle);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteAllTmpTables(DBConnection db) {
        logger.debug((Object)"deleteAllTmpTables");
        availableTmpTables = IMDIDBTable.getTableNames(db, "TMPIMDIMD_").toArray(new String[0]);
        Statement statement = null;
        try {
            statement = db.getConnection().createStatement();
            String sessionTable = null;
            for (int i = 0; i < availableTmpTables.length; ++i) {
                if (availableTmpTables[i].toUpperCase().endsWith("SESSION")) {
                    sessionTable = availableTmpTables[i];
                    continue;
                }
                try {
                    statement.execute("DROP TABLE " + availableTmpTables[i]);
                    continue;
                }
                catch (SQLException sqle) {
                    logger.warn((Object)("deleteAllTmpTables: error deleting: " + availableTmpTables[i] + ", " + sqle));
                }
            }
            if (sessionTable != null) {
                try {
                    statement.execute("DROP TABLE " + sessionTable);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)("deleteAllTmpTables: error deleting session table: " + sessionTable + ", " + sqle));
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"deleteAllTmpTables: ", (Throwable)sqle);
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)"deleteAllTmpTables: ", (Throwable)sqle);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            statement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rename(String newname) {
        Statement statement = null;
        String newName = newname.toUpperCase();
        try {
            statement = this.db.getConnection().createStatement();
            statement.execute("ALTER TABLE " + this.getName() + " RENAME TO " + newName);
            logger.debug((Object)("rename: " + this.getName() + " to " + newName));
            if (allTables.remove(this.getName()) == null) {
                logger.error((Object)("rename: ERROR table was not in tableHash: " + this.getName()));
                return;
            }
            allTables.put(newName, this);
        }
        catch (SQLException sqle) {
            logger.error((Object)("rename: error renaming: " + this.getName() + ", " + sqle));
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            statement = null;
        }
    }

    public static void renameTmpTables(DBConnection db) {
        logger.debug((Object)"renameTmpTables");
        HashSet tableNames = new HashSet(allTables.keySet());
        Iterator iter = tableNames.iterator();
        while (iter.hasNext()) {
            String s = iter.next().toString();
            if (!s.startsWith("TMPIMDIMD_")) continue;
            IMDIDBTable table = (IMDIDBTable)allTables.get(s);
            table.rename(s.substring(3));
        }
    }
}

