/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdidb;

import java.sql.ResultSet;
import java.sql.Statement;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.imdidb.IMDIQueryToSQL;
import nl.mpi.util.DBConnection;

public class MakeIMDIQuery {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("MakeIMDIQuery: No arguments");
            System.exit(1);
        }
        String user = null;
        String passwd = null;
        String query = null;
        String dbname = args[0];
        for (int ai = 1; ai < args.length; ++ai) {
            if (args[ai].startsWith("-user")) {
                user = args[ai + 1];
                ++ai;
                continue;
            }
            if (args[ai].startsWith("-passwd")) {
                passwd = args[ai + 1];
                ++ai;
                continue;
            }
            if (!args[ai].startsWith("-q")) continue;
            query = args[ai + 1];
            ++ai;
        }
        System.out.println("MakeIMDIQuery: dbname=" + dbname + " ,user=" + user + " ,q=" + query);
        IMDIQueryToSQL q2sql = new IMDIQueryToSQL();
        String sql = null;
        try {
            sql = q2sql.IMDIqueryToSQL(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("MakeIMDIQuery: SQL statement=" + sql);
        try {
            DBConnection db = new DBConnection(dbname, user, passwd, "ArchiveCrawler:main()");
            System.out.println("MakeIMDIQuery: created connection to: " + dbname);
            if (db == null) {
                System.err.println("MakeIMDIQuery: Error creating DBConnection");
            }
            Statement statement = db.getConnection().createStatement();
            ResultSet rs = statement.executeQuery(sql);
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                System.out.print(NodeIdUtils.TONODEID((Integer)rs.getObject(1)) + " ");
                for (int i = 1; i < columns; ++i) {
                    System.out.print(rs.getObject(i + 1) + " ");
                }
                System.out.println("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

