/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.ui.ImportExportUI;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CopyRunner.class);
    public static final String DISK_FREE_LABEL_TEXT = "Total Disk Free: ";
    private final ImportExportUI impExpUI;
    private final SessionStorage sessionStorage;
    private final DataNodeLoader dataNodeLoader;
    private final TreeHelper treeHelper;
    private Boolean exportToUniqueLocation = null;
    private int freeGbWarningPoint = 3;
    private int xsdErrors = 0;
    private int totalLoaded = 0;
    private int totalErrors = 0;
    private int totalExisting = 0;
    private int resourceCopyErrors = 0;
    private String finalMessageString = "";
    private File directoryForSizeTest;
    private boolean testFreeSpace;

    public CopyRunner(ImportExportUI ui, SessionStorage sessionStorage, DataNodeLoader dataNodeLoader, TreeHelper treeHelper) {
        this.impExpUI = ui;
        this.sessionStorage = sessionStorage;
        this.dataNodeLoader = dataNodeLoader;
        this.treeHelper = treeHelper;
    }

    @Override
    public void run() {
        String javaVersionString = System.getProperty("java.version");
        this.testFreeSpace = !javaVersionString.startsWith("1.4.") && !javaVersionString.startsWith("1.5.");
        File exportDestinationDirectory = this.impExpUI.getExportDestinationDirectory();
        File file = this.directoryForSizeTest = exportDestinationDirectory != null ? exportDestinationDirectory : this.sessionStorage.getProjectWorkingDirectory();
        if (this.impExpUI.isCopyFilesOnImport() || this.impExpUI.isCopyFilesOnExport()) {
            this.impExpUI.appendToResourceCopyOutput("'Copy Resource Files' is selected: Resource files will be downloaded where appropriate permission are granted.\n");
        } else {
            this.impExpUI.appendToResourceCopyOutput("'Copy Resource Files' is not selected: No resource files will be downloaded, however they will be still accessible via the web server.\n");
        }
        try {
            this.impExpUI.onCopyStart();
            this.impExpUI.setProgressIndeterminate(true);
            this.copyElements(this.impExpUI.getSelectedNodesIterator(), this.impExpUI.getDestinationNode(), exportDestinationDirectory);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            this.finalMessageString = this.finalMessageString + "There was a critical error.";
        }
        this.impExpUI.onCopyEnd(this.finalMessageString);
    }

    private void copyElements(Iterator<ArbilDataNode> selectedNodesEnum, ArbilDataNode destinationNode, File exportDestinationDirectory) {
        ArrayList<ArbilDataNode> finishedTopNodes = new ArrayList<ArbilDataNode>();
        HashMap<URI, RetrievableFile> seenFiles = new HashMap<URI, RetrievableFile>();
        ArrayList<URI> getList = new ArrayList<URI>();
        ArrayList<URI> doneList = new ArrayList<URI>();
        XsdChecker xsdChecker = new XsdChecker();
        while (selectedNodesEnum.hasNext() && !this.impExpUI.isStopCopy()) {
            ArbilDataNode currentElement = selectedNodesEnum.next();
            this.copyElement(currentElement, exportDestinationDirectory, getList, seenFiles, doneList, xsdChecker, finishedTopNodes);
        }
        this.finalMessageString = this.finalMessageString + "Processed " + this.totalLoaded + " Metadata Files.\n";
        if (exportDestinationDirectory == null) {
            this.addImportedNodesToLocalCorpus(destinationNode, finishedTopNodes);
        }
        this.impExpUI.setProgressIndeterminate(false);
        if (this.totalErrors != 0) {
            this.finalMessageString = this.finalMessageString + "There were " + this.totalErrors + " errors, some files may not have been copied.\n";
        }
        if (this.xsdErrors != 0) {
            this.finalMessageString = this.finalMessageString + "There were " + this.xsdErrors + " files that failed to validate and have xml errors.\n";
        }
        if (this.impExpUI.isStopCopy()) {
            this.impExpUI.appendToTaskOutput("copy canceled");
            logger.debug("copy canceled");
            this.finalMessageString = this.finalMessageString + "The process was canceled, some files may not have been copied.\n";
        } else {
            this.impExpUI.removeNodeSelection();
        }
    }

    private void addImportedNodesToLocalCorpus(ArbilDataNode destinationNode, List<ArbilDataNode> copiedNodes) {
        if (!this.impExpUI.isStopCopy()) {
            for (ArbilDataNode currentFinishedNode : copiedNodes) {
                if (destinationNode != null) {
                    if (!destinationNode.getURI().equals(currentFinishedNode.getURI())) {
                        destinationNode.addCorpusLink(currentFinishedNode);
                    }
                } else if (!this.treeHelper.addLocation(currentFinishedNode.getURI())) {
                    this.finalMessageString = this.finalMessageString + "The location:\n" + currentFinishedNode + "\nalready exists and need not be added again\n";
                }
                currentFinishedNode.reloadNode();
            }
        }
        if (destinationNode == null) {
            this.treeHelper.applyRootLocations();
        } else {
            destinationNode.reloadNode();
        }
    }

    private void copyElement(Object currentElement, File exportDestinationDirectory, List<URI> getList, Map<URI, RetrievableFile> seenFiles, List<URI> doneList, XsdChecker xsdChecker, List<ArbilDataNode> finishedTopNodes) {
        URI currentGettableUri = ((ArbilDataNode)currentElement).getParentDomNode().getURI();
        getList.add(currentGettableUri);
        if (!seenFiles.containsKey(currentGettableUri)) {
            seenFiles.put(currentGettableUri, new RetrievableFile(((ArbilDataNode)currentElement).getParentDomNode().getURI(), exportDestinationDirectory));
        }
        while (!this.impExpUI.isStopCopy() && getList.size() > 0) {
            RetrievableFile currentRetrievableFile = seenFiles.get(getList.remove(0));
            this.copyFile(currentRetrievableFile, exportDestinationDirectory, seenFiles, doneList, getList, xsdChecker);
        }
        if (exportDestinationDirectory == null) {
            File newNodeLocation = this.sessionStorage.getSaveLocation(((ArbilDataNode)currentElement).getParentDomNode().getUrlString());
            finishedTopNodes.add(this.dataNodeLoader.getArbilDataNodeWithoutLoading(newNodeLocation.toURI()));
        }
    }

    private void copyFile(RetrievableFile currentRetrievableFile, File exportDestinationDirectory, Map<URI, RetrievableFile> seenFiles, List<URI> doneList, List<URI> getList, XsdChecker xsdChecker) {
        try {
            if (!doneList.contains(currentRetrievableFile.sourceURI)) {
                boolean overwriteFile;
                String journalActionString;
                if (exportDestinationDirectory == null) {
                    currentRetrievableFile.calculateUriFileName();
                    journalActionString = "import";
                } else {
                    if (this.impExpUI.isRenameFileToNodeName()) {
                        this.calculateTreeFileName(currentRetrievableFile, Collections.<URI[]>emptyList());
                    } else {
                        currentRetrievableFile.calculateUriFileName();
                    }
                    journalActionString = "export";
                }
                if (this.impExpUI.isStopCopy()) {
                    return;
                }
                MetadataUtils metadataUtils = ArbilDataNode.getMetadataUtils(currentRetrievableFile.sourceURI.toString());
                if (metadataUtils == null) {
                    throw new ArbilMetadataException("Metadata format could not be determined");
                }
                ArrayList<URI[]> uncopiedLinks = new ArrayList<URI[]>();
                MetadataUtils.MetadataLinkSet linkSet = metadataUtils.getCorpusLinks(currentRetrievableFile.sourceURI);
                if (linkSet != null) {
                    this.copyLinks(exportDestinationDirectory, linkSet, seenFiles, currentRetrievableFile, getList, uncopiedLinks);
                }
                if (currentRetrievableFile.destinationFile.exists()) {
                    ++this.totalExisting;
                    overwriteFile = this.impExpUI.askOverwrite(currentRetrievableFile);
                } else {
                    overwriteFile = false;
                }
                if (!this.impExpUI.isStopCopy()) {
                    if (currentRetrievableFile.destinationFile.exists() && !overwriteFile) {
                        this.impExpUI.appendToTaskOutput(currentRetrievableFile.sourceURI.toString());
                        this.impExpUI.appendToTaskOutput("Destination already exists, skipping file: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                    } else {
                        ArbilDataNode destinationNode;
                        boolean replacingExistingFile;
                        boolean bl = replacingExistingFile = currentRetrievableFile.destinationFile.exists() && overwriteFile;
                        if (replacingExistingFile) {
                            this.impExpUI.appendToTaskOutput("Replaced: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                        }
                        if ((destinationNode = this.dataNodeLoader.getArbilDataNodeWithoutLoading(currentRetrievableFile.destinationFile.toURI())).getNeedsSaveToDisk(false)) {
                            destinationNode.saveChangesToCache(true);
                        }
                        if (destinationNode.hasHistory()) {
                            destinationNode.bumpHistory();
                        }
                        if (!currentRetrievableFile.destinationFile.getParentFile().exists() && !currentRetrievableFile.destinationFile.getParentFile().mkdir()) {
                            BugCatcherManager.getBugCatcher().logError(new IOException("Could not create missing parent directory for " + currentRetrievableFile.destinationFile));
                        }
                        metadataUtils.copyMetadataFile(currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, (URI[][])uncopiedLinks.toArray((T[])new URI[0][]), true);
                        ArbilJournal.getSingleInstance().saveJournalEntry(currentRetrievableFile.destinationFile.getAbsolutePath(), "", currentRetrievableFile.sourceURI.toString(), "", journalActionString);
                        String checkerResult = xsdChecker.simpleCheck(currentRetrievableFile.destinationFile);
                        if (checkerResult != null) {
                            this.impExpUI.appendToXmlOutput(currentRetrievableFile.sourceURI.toString() + "\n");
                            this.impExpUI.appendToXmlOutput("destination path: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                            logger.debug("checkerResult: {}", (Object)checkerResult);
                            this.impExpUI.appendToXmlOutput(checkerResult + "\n");
                            this.impExpUI.addToValidationErrors(currentRetrievableFile.sourceURI);
                            ++this.xsdErrors;
                        }
                        if (replacingExistingFile) {
                            this.dataNodeLoader.requestReloadOnlyIfLoaded(currentRetrievableFile.destinationFile.toURI());
                        }
                    }
                }
            }
        }
        catch (ArbilMetadataException ex) {
            logger.error("Error processing {} with destination {}", new Object[]{currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, ex});
            ++this.totalErrors;
            this.impExpUI.addToMetadataCopyErrors(currentRetrievableFile.sourceURI);
            this.impExpUI.appendToTaskOutput(String.format("Unable to process the file: %1$s (%2$s)", currentRetrievableFile.sourceURI, ex.getLocalizedMessage()));
        }
        catch (MalformedURLException ex) {
            logger.error("Error processing {} with destination {}", new Object[]{currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, ex});
            ++this.totalErrors;
            this.impExpUI.addToMetadataCopyErrors(currentRetrievableFile.sourceURI);
            this.impExpUI.appendToTaskOutput(String.format("Unable to process the file: %1$s", currentRetrievableFile.sourceURI));
            logger.debug("Error getting links from: {}", (Object)currentRetrievableFile.sourceURI);
        }
        catch (IOException ex) {
            logger.error("Error while trying to copy {} to {}", new Object[]{currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, ex});
            ++this.totalErrors;
            this.impExpUI.addToMetadataCopyErrors(currentRetrievableFile.sourceURI);
            this.impExpUI.appendToTaskOutput(String.format("Unable to process the file: %1$s (%2$s)", currentRetrievableFile.sourceURI, ex.getLocalizedMessage()));
        }
        ++this.totalLoaded;
        int getCount = getList.size();
        this.impExpUI.updateStatus(getCount, this.totalLoaded, this.totalExisting, this.totalErrors, this.xsdErrors, this.resourceCopyErrors);
        if (this.testFreeSpace) {
            this.testFreeSpace();
        }
    }

    private void copyLinks(File exportDestinationDirectory, MetadataUtils.MetadataLinkSet linksUriArray, Map<URI, RetrievableFile> seenFiles, RetrievableFile currentRetrievableFile, List<URI> getList, List<URI[]> uncopiedLinks) throws MalformedURLException {
        for (URI linkUri : linksUriArray.getResourceLinks()) {
            if (this.impExpUI.isStopCopy()) {
                return;
            }
            logger.debug("Resource link: {}", (Object)linkUri);
            String currentLink = linkUri.toString();
            URI gettableLinkUri = linkUri.normalize();
            if (!seenFiles.containsKey(gettableLinkUri)) {
                seenFiles.put(gettableLinkUri, new RetrievableFile(gettableLinkUri, currentRetrievableFile.childDestinationDirectory));
            }
            RetrievableFile retrievableLink = seenFiles.get(gettableLinkUri);
            this.copyResourceLink(currentRetrievableFile, currentLink, retrievableLink, exportDestinationDirectory, uncopiedLinks, linkUri);
        }
        for (URI linkUri : linksUriArray.getMetadataLinks()) {
            if (this.impExpUI.isStopCopy()) {
                return;
            }
            logger.debug("Metadata link: {}", (Object)linkUri);
            URI gettableLinkUri = linkUri.normalize();
            if (!seenFiles.containsKey(gettableLinkUri)) {
                seenFiles.put(gettableLinkUri, new RetrievableFile(gettableLinkUri, currentRetrievableFile.childDestinationDirectory));
            }
            RetrievableFile retrievableLink = seenFiles.get(gettableLinkUri);
            this.copyMetadataLink(gettableLinkUri, retrievableLink, exportDestinationDirectory, getList, uncopiedLinks, linkUri);
        }
    }

    private void copyMetadataLink(URI gettableLinkUri, RetrievableFile retrievableLink, File exportDestinationDirectory, List<URI> getList, List<URI[]> uncopiedLinks, URI linkUri) {
        getList.add(gettableLinkUri);
        if (this.impExpUI.isRenameFileToNodeName() && exportDestinationDirectory != null) {
            this.calculateTreeFileName(retrievableLink, uncopiedLinks);
        } else {
            retrievableLink.calculateUriFileName();
        }
        uncopiedLinks.add(new URI[]{linkUri, retrievableLink.destinationFile.toURI()});
    }

    private void copyResourceLink(RetrievableFile currentRetrievableFile, String currentLink, RetrievableFile retrievableLink, File exportDestinationDirectory, List<URI[]> uncopiedLinks, URI linkUri) throws MalformedURLException {
        if (!this.impExpUI.isCopyFilesOnImport() && !this.impExpUI.isCopyFilesOnExport()) {
            uncopiedLinks.add(new URI[]{linkUri, linkUri});
        } else {
            File downloadFileLocation;
            if (exportDestinationDirectory == null) {
                downloadFileLocation = this.sessionStorage.updateCache(currentLink, this.impExpUI.getShibbolethNegotiator(), false, false, this.impExpUI.getDownloadAbortFlag(), this.impExpUI);
            } else {
                if (this.impExpUI.isRenameFileToNodeName()) {
                    this.calculateTreeFileName(retrievableLink, uncopiedLinks);
                } else {
                    retrievableLink.calculateUriFileName();
                }
                if (!retrievableLink.destinationFile.getParentFile().exists() && !retrievableLink.destinationFile.getParentFile().mkdirs()) {
                    BugCatcherManager.getBugCatcher().logError(new IOException("Could not create missing parent directory for " + retrievableLink.destinationFile));
                }
                downloadFileLocation = retrievableLink.destinationFile;
                this.sessionStorage.saveRemoteResource(new URL(currentLink), downloadFileLocation, this.impExpUI.getShibbolethNegotiator(), true, false, this.impExpUI.getDownloadAbortFlag(), this.impExpUI);
                this.impExpUI.setProgressText(" ");
            }
            if (downloadFileLocation != null && downloadFileLocation.exists()) {
                this.impExpUI.appendToTaskOutput("Downloaded resource: " + downloadFileLocation.getAbsolutePath());
                uncopiedLinks.add(new URI[]{linkUri, downloadFileLocation.toURI()});
            } else {
                this.impExpUI.appendToResourceCopyOutput("Download failed: " + currentLink + " \n");
                this.impExpUI.addToFileCopyErrors(currentRetrievableFile.sourceURI);
                uncopiedLinks.add(new URI[]{linkUri, linkUri});
                ++this.resourceCopyErrors;
            }
        }
    }

    private void testFreeSpace() {
        try {
            int freeGBytes = (int)(this.directoryForSizeTest.getFreeSpace() / 0x40000000L);
            this.impExpUI.setDiskspaceState(DISK_FREE_LABEL_TEXT + freeGBytes + "GB");
            if (this.freeGbWarningPoint > freeGBytes) {
                this.impExpUI.setProgressIndeterminate(false);
                if (this.impExpUI.askContinue("There is only " + freeGBytes + "GB free space left on the disk.\nTo you still want to continue?")) {
                    this.freeGbWarningPoint = freeGBytes - 1;
                } else {
                    this.impExpUI.setStopCopy(true);
                }
                this.impExpUI.setProgressIndeterminate(true);
            }
        }
        catch (Exception ex) {
            this.impExpUI.setDiskspaceState("Total Disk Free: N/A");
            this.testFreeSpace = false;
        }
    }

    private void calculateTreeFileName(RetrievableFile retrievableFile, List<URI[]> reservedLinks) {
        retrievableFile.calculateTreeFileName(this.impExpUI.isRenameFileToLamusFriendlyName(), reservedLinks);
        if (retrievableFile.destinationFile.exists()) {
            if (this.exportToUniqueLocation == null) {
                this.exportToUniqueLocation = this.impExpUI.askCreateNewExportDir(retrievableFile.destinationFile);
            }
            if (this.exportToUniqueLocation.booleanValue()) {
                retrievableFile.makeUnique(reservedLinks);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RetrievableFile {
        private final URI sourceURI;
        private final File destinationDirectory;
        private File childDestinationDirectory;
        private File destinationFile;
        private String fileName;
        private String fileSuffix;
        boolean lamusFriendly;
        boolean metadata;

        public RetrievableFile(URI sourceURILocal, File destinationDirectoryLocal) {
            this.sourceURI = sourceURILocal;
            this.destinationDirectory = destinationDirectoryLocal;
        }

        public void calculateUriFileName() {
            this.destinationFile = this.destinationDirectory != null ? CopyRunner.this.sessionStorage.getExportPath(this.sourceURI.toString(), this.destinationDirectory.getPath()) : CopyRunner.this.sessionStorage.getSaveLocation(this.sourceURI.toString());
            this.childDestinationDirectory = this.destinationDirectory;
        }

        public void calculateTreeFileName(boolean lamusFriendly, List<URI[]> reservedLinks) {
            String urlString = this.sourceURI.toString();
            int suffixSeparator = urlString.lastIndexOf(".");
            this.fileSuffix = suffixSeparator > 0 && suffixSeparator > urlString.lastIndexOf("/") ? urlString.substring(suffixSeparator) : "";
            ArbilDataNode currentNode = CopyRunner.this.dataNodeLoader.getArbilDataNode(null, this.sourceURI);
            currentNode.waitTillLoaded();
            this.fileName = this.normalizeFileName(this.determineFileName(currentNode), lamusFriendly);
            this.destinationFile = new File(this.destinationDirectory, this.fileName + this.fileSuffix);
            this.childDestinationDirectory = new File(this.destinationDirectory, this.fileName);
        }

        private void makeUnique(List<URI[]> reservedLinks) {
            if (this.destinationFile.exists()) {
                int fileCounter = 1;
                while (this.destinationExistsOrIsReserved(reservedLinks)) {
                    if (this.lamusFriendly) {
                        this.destinationFile = new File(this.destinationDirectory, this.fileName + "_" + fileCounter + this.fileSuffix);
                        this.childDestinationDirectory = new File(this.destinationDirectory, this.fileName + "_" + fileCounter);
                    } else {
                        this.destinationFile = new File(this.destinationDirectory, this.fileName + "(" + fileCounter + ")" + this.fileSuffix);
                        this.childDestinationDirectory = new File(this.destinationDirectory, this.fileName + "(" + fileCounter + ")");
                    }
                    ++fileCounter;
                }
            }
        }

        private boolean destinationExistsOrIsReserved(List<URI[]> reservedLinks) {
            URI destinationURI = this.destinationFile.toURI();
            if (this.destinationFile.exists()) {
                return true;
            }
            for (URI[] link : reservedLinks) {
                if (!link[1].equals(destinationURI)) continue;
                return true;
            }
            return false;
        }

        private String determineFileName(ArbilDataNode currentNode) {
            int lastPathSeparatorIndex;
            if (currentNode.isMetaDataNode()) {
                return currentNode.toString();
            }
            String urlString = this.sourceURI.toString();
            try {
                urlString = URLDecoder.decode(urlString, "UTF-8");
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(urlString, ex);
                CopyRunner.this.impExpUI.appendToTaskOutput("unable to decode the file name for: " + urlString);
                logger.debug("unable to decode the file name for: {}", (Object)urlString);
            }
            if (urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length() - 1);
            }
            if ((lastPathSeparatorIndex = urlString.lastIndexOf("/")) >= 0) {
                int lastSuffixIndex = urlString.lastIndexOf(".");
                if (lastSuffixIndex > 0 && lastSuffixIndex > lastPathSeparatorIndex) {
                    return urlString.substring(lastPathSeparatorIndex + 1, lastSuffixIndex);
                }
                return urlString.substring(lastPathSeparatorIndex + 1);
            }
            return urlString;
        }

        private String makeFileNameLamusFriendly(String fileNameString) {
            return fileNameString.replaceAll("[^A-Za-z0-9-]", "_").replaceAll("__+", "_");
        }

        public URI getSourceURI() {
            return this.sourceURI;
        }

        private String normalizeFileName(String fileNameString, boolean lamusFriendly) {
            fileNameString = fileNameString.replace("\\", "_");
            fileNameString = fileNameString.replace("/", "_");
            if (lamusFriendly) {
                fileNameString = this.makeFileNameLamusFriendly(fileNameString);
            }
            if (fileNameString.length() < 1) {
                fileNameString = "unnamed";
            }
            return fileNameString;
        }
    }
}

