/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.metadatafile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.imdi.api.IMDIDom;
import nl.mpi.imdi.api.IMDIElement;
import nl.mpi.imdi.api.IMDILink;
import nl.mpi.util.OurURL;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ImdiUtils
implements MetadataUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImdiUtils.class);
    private static MessageDialogHandler messageDialogHandler;
    public static final IMDIDom api;

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    private boolean isCatalogue(URI sourceURI) {
        try {
            OurURL inUrlLocal = new OurURL(sourceURI.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            this.checkImdiApiResult(nodDom, sourceURI);
            return null != XPathAPI.selectSingleNode((Node)nodDom, (String)"/:METATRANSCRIPT/:Catalogue");
        }
        catch (MalformedURLException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        catch (TransformerException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        return false;
    }

    private boolean isSession(URI sourceURI) {
        try {
            OurURL inUrlLocal = new OurURL(sourceURI.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            this.checkImdiApiResult(nodDom, sourceURI);
            return null != XPathAPI.selectSingleNode((Node)nodDom, (String)"/:METATRANSCRIPT/:Session");
        }
        catch (MalformedURLException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        catch (TransformerException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
        }
        return false;
    }

    public boolean addCorpusLink(URI nodeURI, URI[] linkURI) {
        try {
            OurURL inUrlLocal = new OurURL(nodeURI.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            this.checkImdiApiResult(nodDom, nodeURI);
            if (nodDom == null) {
                BugCatcherManager.getBugCatcher().logError(new Exception(api.getMessage()));
                messageDialogHandler.addMessageDialogToQueue("Error reading via the IMDI API", "Add Link");
                return false;
            }
            int nodeType = 2;
            for (URI currentLinkUri : linkURI) {
                if (this.isCatalogue(currentLinkUri)) {
                    nodeType = 8;
                }
                if (this.isSession(currentLinkUri)) {
                    nodeType = 1;
                }
                IMDILink createdLink = api.createIMDILink(nodDom, inUrlLocal, currentLinkUri.toString(), "", nodeType, "");
                this.checkImdiApiResult(createdLink, nodeURI);
                if (createdLink != null) continue;
                return false;
            }
            return api.writeDOM(nodDom, new File(nodeURI), true);
        }
        catch (MalformedURLException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return true;
        }
    }

    public void copyMetadataFile(URI sourceURI, File destinationFile, URI[][] linksToUpdate, boolean updateLinks) throws IOException, ArbilMetadataException {
        boolean removeIdAttributes;
        OurURL inUrlLocal = new OurURL(sourceURI.toURL());
        OurURL destinationUrl = new OurURL(destinationFile.toURI().toURL());
        Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
        this.checkImdiApiResult(nodDom, sourceURI);
        if (nodDom == null) {
            messageDialogHandler.addMessageDialogToQueue("Error reading via the IMDI API. See error log for details.", "Copy IMDI File");
            throw new ArbilMetadataException(api.getMessage());
        }
        IMDILink[] links = api.getIMDILinks(nodDom, inUrlLocal, 6);
        this.checkImdiApiResult(links, sourceURI);
        if (links != null && updateLinks) {
            for (IMDILink currentLink : links) {
                URI linkUriToUpdate = null;
                if (linksToUpdate == null) continue;
                for (URI[] updatableLink : linksToUpdate) {
                    try {
                        if (!currentLink.getRawURL().toURL().toURI().equals(updatableLink[0])) continue;
                        linkUriToUpdate = updatableLink[1];
                        break;
                    }
                    catch (URISyntaxException exception) {
                        BugCatcherManager.getBugCatcher().logError(exception);
                    }
                }
                logger.debug("currentLink: {} : {}", linkUriToUpdate, (Object)currentLink.getRawURL());
                if (linkUriToUpdate != null) {
                    currentLink.setURL(new OurURL(linkUriToUpdate.toURL()));
                    boolean changeLinkResult = api.changeIMDILink(nodDom, destinationUrl, currentLink);
                    if (changeLinkResult) continue;
                    this.checkImdiApiResult(null, sourceURI);
                    continue;
                }
                throw new ArbilMetadataException(api.getMessage());
            }
        }
        if (!api.writeDOM(nodDom, destinationFile, removeIdAttributes = true)) {
            throw new ArbilMetadataException(api.getMessage());
        }
    }

    public boolean moveMetadataFile(URI sourceURI, File destinationFile, boolean updateLinks) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeCorpusLink(URI nodeURI, URI[] linkURI) {
        block7: {
            try {
                OurURL destinationUrl = new OurURL(nodeURI.toString());
                Document nodDom = api.loadIMDIDocument(destinationUrl, false);
                this.checkImdiApiResult(nodDom, nodeURI);
                if (nodDom == null) {
                    BugCatcherManager.getBugCatcher().logError(new Exception(api.getMessage()));
                    messageDialogHandler.addMessageDialogToQueue("Error reading via the IMDI API", "Remove IMDI Links");
                    return false;
                }
                IMDILink[] allImdiLinks = api.getIMDILinks(nodDom, destinationUrl, 6);
                this.checkImdiApiResult(allImdiLinks, nodeURI);
                if (allImdiLinks == null) break block7;
                for (IMDILink currentLink : allImdiLinks) {
                    for (URI currentUri : linkURI) {
                        try {
                            if (!currentUri.equals(currentLink.getRawURL().toURL().toURI()) || api.removeIMDILink(nodDom, (IMDIElement)currentLink)) continue;
                            this.checkImdiApiResult(null, nodeURI);
                            return false;
                        }
                        catch (URISyntaxException exception) {
                            BugCatcherManager.getBugCatcher().logError(exception);
                        }
                    }
                }
                boolean removeIdAttributes = true;
                return api.writeDOM(nodDom, new File(nodeURI), removeIdAttributes);
            }
            catch (MalformedURLException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                messageDialogHandler.addMessageDialogToQueue("Error reading links via the IMDI API", "Get Links");
            }
        }
        return false;
    }

    public MetadataUtils.MetadataLinkSet getCorpusLinks(URI nodeURI) throws ArbilMetadataException {
        try {
            OurURL destinationUrl = new OurURL(nodeURI.toString());
            Document nodDom = api.loadIMDIDocument(destinationUrl, false);
            this.checkImdiApiResult(nodDom, nodeURI);
            if (nodDom == null) {
                throw new ArbilMetadataException("could not load file");
            }
            IMDILink[] allImdiLinks = api.getIMDILinks(nodDom, destinationUrl, 6);
            this.checkImdiApiResult(allImdiLinks, nodeURI);
            if (allImdiLinks != null) {
                ArrayList<URI> metadataLinks = new ArrayList<URI>();
                ArrayList<URI> resourceLinks = new ArrayList<URI>();
                for (int linkCount = 0; linkCount < allImdiLinks.length; ++linkCount) {
                    try {
                        this.checkImdiApiResult(allImdiLinks[linkCount], nodeURI);
                        URI linkUri = allImdiLinks[linkCount].getRawURL().toURL().toURI();
                        this.checkImdiApiResult(linkUri, nodeURI);
                        if (MetadataFormat.isPathImdi(linkUri.toString())) {
                            metadataLinks.add(linkUri);
                            continue;
                        }
                        resourceLinks.add(linkUri);
                        continue;
                    }
                    catch (URISyntaxException exception) {
                        BugCatcherManager.getBugCatcher().logError(exception);
                        messageDialogHandler.addMessageDialogToQueue("Error reading one of the links via the IMDI API", "Get Links");
                    }
                }
                return new MetadataUtils.MetadataLinkSet(resourceLinks, metadataLinks);
            }
        }
        catch (MalformedURLException exception) {
            BugCatcherManager.getBugCatcher().logError(exception);
            messageDialogHandler.addMessageDialogToQueue("Error reading links via the IMDI API", "Get Links");
        }
        return null;
    }

    private void checkImdiApiResult(Object resultUnknown, URI imdiURI) {
        if (resultUnknown == null) {
            BugCatcherManager.getBugCatcher().logError(new Exception("The IMDI API returned null for: " + imdiURI.toString()));
            BugCatcherManager.getBugCatcher().logError("The following is the last known error from the API: ", new Exception(api.getMessage()));
        }
    }

    public boolean overrideTypecheckerDecision(ArbilDataNode[] selectedNodes) {
        Object[] optionStrings = new String[]{"WrittenResource", "MediaFile", "Cancel"};
        String messageString = "The type checker does not recognise the selected file(s), which means that they\nare not an archivable type. This action will override that decision and allow you\nto add the file(s) to a session, as either media or written resources,\nhowever it might not be possible to import the result to the corpus server.";
        String titleString = "Override Type Checker Decision";
        int userSelection = messageDialogHandler.showDialogBox(messageString, titleString, -1, -1, optionStrings, optionStrings[2]);
        if (((String)optionStrings[userSelection]).equals("WrittenResource") || ((String)optionStrings[userSelection]).equals("MediaFile")) {
            for (ArbilDataNode currentNode : selectedNodes) {
                if (currentNode.mpiMimeType != null) continue;
                currentNode.mpiMimeType = "Manual/" + (String)optionStrings[userSelection];
                currentNode.typeCheckerMessage = "Manually overridden (might not be compatible with the archive)";
                currentNode.clearIcon();
            }
            return true;
        }
        return false;
    }

    static {
        api = new IMDIDom();
    }
}

