/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.plugins;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import nl.mpi.flap.module.BaseModule;
import nl.mpi.flap.plugin.ActivatablePlugin;
import nl.mpi.flap.plugin.ArbilWindowPlugin;
import nl.mpi.flap.plugin.JournalWatcherPlugin;
import nl.mpi.flap.plugin.PluginArbilDataNodeLoader;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginException;
import nl.mpi.flap.plugin.PluginJournal;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.flap.plugin.PluginWidgetFactory;
import nl.mpi.pluginloader.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilPluginManager
implements PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(ArbilPluginManager.class);
    public static final String ARCHIVING_PLUGINS_DIR_NAME = "ArchivingPlugins";
    private final SessionStorage arbilSessionStorage;
    private final ArbilWindowManager dialogHandler;
    private final BugCatcher bugCatcher;
    private final PluginArbilDataNodeLoader arbilDataNodeLoader;
    private final HashSet<BaseModule> hashSet = new HashSet();

    public ArbilPluginManager(SessionStorage arbilSessionStorage, ArbilWindowManager dialogHandler, PluginArbilDataNodeLoader arbilDataNodeLoader, BugCatcher bugCatcher) {
        this.arbilSessionStorage = arbilSessionStorage;
        this.dialogHandler = dialogHandler;
        this.arbilDataNodeLoader = arbilDataNodeLoader;
        this.bugCatcher = bugCatcher;
    }

    public void activatePlugin(BaseModule kinOathPlugin) {
        boolean pluginActivated = false;
        if (kinOathPlugin instanceof JournalWatcherPlugin) {
            try {
                ArbilJournal arbilJournal = ArbilJournal.getSingleInstance();
                arbilJournal.addJounalWatcher((JournalWatcherPlugin)kinOathPlugin);
                ((JournalWatcherPlugin)kinOathPlugin).initJournalWatcher((PluginJournal)arbilJournal);
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to pass the journal to the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Journal Plugin Error");
            }
        }
        if (kinOathPlugin instanceof ActivatablePlugin) {
            try {
                ((ActivatablePlugin)kinOathPlugin).activatePlugin((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.arbilSessionStorage);
                this.hashSet.add(kinOathPlugin);
                pluginActivated = true;
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to activate the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        }
        if (kinOathPlugin instanceof ArbilWindowPlugin) {
            try {
                this.dialogHandler.createWindow(kinOathPlugin.getName(), ((ArbilWindowPlugin)kinOathPlugin).getUiPanel((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.arbilSessionStorage, (PluginBugCatcher)this.bugCatcher, this.arbilDataNodeLoader, (PluginWidgetFactory)this.dialogHandler));
                pluginActivated = true;
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to show the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        }
        if (!pluginActivated) {
            this.dialogHandler.addMessageDialogToQueue("No method to activate this type of plugin yet.\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin");
        }
    }

    public void deactivatePlugin(BaseModule kinOathPlugin) {
        if (kinOathPlugin instanceof ActivatablePlugin) {
            try {
                ((ActivatablePlugin)kinOathPlugin).deactivatePlugin((PluginDialogHandler)this.dialogHandler, (PluginSessionStorage)this.arbilSessionStorage);
                this.hashSet.remove(kinOathPlugin);
            }
            catch (PluginException exception) {
                this.dialogHandler.addMessageDialogToQueue("Failed to deactivate the requested plugin.\n" + exception.getMessage() + "\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin Error");
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue("No method to deactivate this type of plugin yet.\n" + kinOathPlugin.getName() + "\n" + kinOathPlugin.getMajorVersionNumber() + "." + kinOathPlugin.getMinorVersionNumber() + "." + kinOathPlugin.getBuildVersionNumber() + "\n" + kinOathPlugin.getDescription(), "Enable Plugin");
        }
    }

    public boolean isActivated(BaseModule kinOathPlugin) {
        return this.hashSet.contains(kinOathPlugin);
    }

    public List<URL> getPluginsFromDirectoriesAndPluginsList() {
        HashSet<URL> pluginsSet = new HashSet<URL>();
        pluginsSet.addAll(this.getPluginsFromDirectories());
        pluginsSet.addAll(this.getPluginsFromPluginList());
        return new ArrayList<URL>(pluginsSet);
    }

    public Collection<URL> getPluginsFromDirectories() {
        String[] locationOptions;
        HashSet<URL> pluginURLs = new HashSet<URL>();
        FileFilter jarFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.toString().toLowerCase().endsWith(".jar");
            }
        };
        for (String locationOption : locationOptions = new String[]{System.getProperty("user.home") + File.separatorChar + "Local Settings" + File.separatorChar + "Application Data" + File.separatorChar + ARCHIVING_PLUGINS_DIR_NAME + File.separatorChar, System.getenv("APPDATA") + File.separatorChar + ARCHIVING_PLUGINS_DIR_NAME + File.separatorChar, System.getProperty("user.home") + File.separatorChar + ARCHIVING_PLUGINS_DIR_NAME + File.separatorChar, System.getenv("USERPROFILE") + File.separatorChar + ARCHIVING_PLUGINS_DIR_NAME + File.separatorChar, System.getProperty("user.dir") + File.separatorChar + ARCHIVING_PLUGINS_DIR_NAME + File.separatorChar, new File(this.arbilSessionStorage.getProjectDirectory(), ARCHIVING_PLUGINS_DIR_NAME).getAbsolutePath(), new File(this.arbilSessionStorage.getProjectWorkingDirectory(), ARCHIVING_PLUGINS_DIR_NAME).getAbsolutePath()}) {
            File[] jarFiles;
            File pluginDir = new File(locationOption);
            if (!pluginDir.isDirectory()) continue;
            for (File jarFile : jarFiles = pluginDir.listFiles(jarFileFilter)) {
                try {
                    pluginURLs.add(jarFile.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    this.bugCatcher.logError(ex);
                }
            }
        }
        return pluginURLs;
    }

    public Collection<URL> getPluginsFromPluginList() {
        HashSet<URL> pluginUlrs = new HashSet<URL>();
        String errorMessages = "";
        try {
            String[] pluginStringArray = this.arbilSessionStorage.loadStringArray("PluginList");
            if (pluginStringArray != null) {
                for (String pluginString : pluginStringArray) {
                    try {
                        pluginUlrs.add(new URL(pluginString));
                    }
                    catch (MalformedURLException exception) {
                        logger.warn(exception.getMessage());
                        errorMessages = errorMessages + MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COULD NOT LOAD PLUGIN: {0}"), pluginString);
                    }
                }
            }
            if (!"".equals(errorMessages)) {
                this.dialogHandler.addMessageDialogToQueue(errorMessages, "Plugin Error");
            }
        }
        catch (IOException ex) {
            logger.debug("PluginList not found");
        }
        return pluginUlrs;
    }
}

