/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.util.MimeHashQueue;

class JListToolTip
extends JToolTip {
    JPanel jPanel;
    Object targetObject;
    String preSpaces = "      ";

    public JListToolTip() {
        this.setLayout(new BorderLayout());
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 1));
        this.add((Component)this.jPanel, "Center");
        this.jPanel.setBackground(this.getBackground());
        this.jPanel.setBorder(this.getBorder());
        ToolTipManager.sharedInstance().setDismissDelay(100000);
    }

    private String truncateString(String inputString) {
        if (inputString.length() > 100) {
            inputString = inputString.substring(0, 100) + "...";
        }
        return inputString + " ";
    }

    private void addIconLabel(Object tempObject) {
        JLabel jLabel = new JLabel(this.truncateString(tempObject.toString()));
        if (tempObject instanceof ArbilDataNode) {
            jLabel.setIcon(((ArbilDataNode)tempObject).getIcon());
        }
        jLabel.doLayout();
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(this.getBackground());
        labelPanel.add((Component)jLabel, "Center");
        this.jPanel.add(labelPanel);
    }

    private void addDetailLabel(String labelString) {
        this.addDetailLabelIcon(labelString, null);
    }

    private void addDetailLabelIcon(String labelString, Icon icon) {
        JLabel jLabel = icon == null ? new JLabel(labelString) : new JLabel(labelString, icon, 11);
        jLabel.setBackground(this.getBackground());
        jLabel.doLayout();
        this.jPanel.add(jLabel);
    }

    private void addTabbedLabel(String labelString) {
        this.addDetailLabel(this.preSpaces + labelString);
    }

    private void addDetailLabel(String prefixString, ArbilField[] tempFieldArray) {
        if (tempFieldArray != null) {
            for (ArbilField tempField : tempFieldArray) {
                String labelString = tempField.toString();
                this.addTabbedLabel(prefixString + labelString);
            }
        }
    }

    private void addFieldType(ArbilField field) {
        if (field.hasVocabulary()) {
            StringBuilder sb = new StringBuilder();
            sb.append(field.isVocabularyOpen() ? "Open vocabulary" : "Closed vocabulary");
            if (field.isVocabularyList()) {
                sb.append(" list. To enter multiple values, insert a comma (,) between separate entries.");
            } else {
                sb.append(". Only one value can be entered.");
            }
            this.addDetailLabelIcon(sb.toString(), ArbilIcons.getSingleInstance().getIconForVocabulary(field));
        }
        if (field.isAttributeField()) {
            this.addDetailLabelIcon("Attribute of " + field.getParentDataNode().toString(), ArbilIcons.getSingleInstance().attributeIcon);
        }
        if (field.hasEditableFieldAttributes()) {
            List<String[]> fieldAttributePaths = field.getAttributePaths();
            this.addDetailLabel("Field has " + fieldAttributePaths.size() + " attribute(s)");
            for (String[] path : fieldAttributePaths) {
                Object attributeValue = field.getAttributeValue(path[0]);
                if (attributeValue == null) continue;
                this.addDetailLabelIcon(path[1] + ": " + attributeValue, ArbilIcons.getSingleInstance().attributeIcon);
            }
            this.addDetailLabel("Open in long field editor to set attributes");
        }
        if (field.isAllowsLanguageId()) {
            this.addDetailLabelIcon("Field has language attribute", ArbilIcons.getSingleInstance().languageIcon);
        }
    }

    private void addLabelsForDataNode(ArbilDataNode tempObject) {
        if (tempObject.isMetaDataNode()) {
            Map<String, ArbilField[]> tempFields = tempObject.getFields();
            this.addDetailLabel("Name: ", tempFields.get("Name"));
            this.addDetailLabel("Title: ", tempFields.get("Title"));
            this.addDetailLabel("Description: ", tempFields.get("Description"));
            this.addTabbedLabel("Template: " + tempObject.getNodeTemplate().getTemplateName());
            String nodePath = tempObject.getNodePath();
            if (nodePath != null) {
                this.addTabbedLabel("Path: " + nodePath);
            }
            this.addDetailLabel("Format: ", tempFields.get("Format"));
        } else if (!tempObject.isDirectory()) {
            this.addTabbedLabel("Unattached file");
            if (tempObject.getTypeCheckerState().equals((Object)MimeHashQueue.TypeCheckerState.CHECKED)) {
                if (tempObject.isArchivableFile()) {
                    this.addTabbedLabel("Archivable file");
                } else {
                    this.addTabbedLabel("Not archivable");
                    this.addTabbedLabel("Type checker message:\n\"" + tempObject.typeCheckerMessage + "\"");
                }
            } else {
                this.addTabbedLabel("Status: " + (Object)((Object)tempObject.getTypeCheckerState()));
            }
        }
        if (tempObject.hasResource() || !tempObject.isMetaDataNode() && !tempObject.isDirectory()) {
            this.addTabbedLabel("Copies in cache: " + tempObject.matchesInCache);
            this.addTabbedLabel("Copies on local file system: " + tempObject.matchesLocalFileSystem);
            this.addTabbedLabel("Copies on server: ?");
        }
        if (!tempObject.isLocal()) {
            this.addTabbedLabel("Remote file (read only)");
        } else if (tempObject.hasResource()) {
            if (tempObject.resourceFileNotFound()) {
                this.addTabbedLabel("Resource file not found");
            }
        } else if (tempObject.isMetaDataNode()) {
            if (tempObject.isEditable()) {
                this.addTabbedLabel("Local file (editable)");
            } else {
                this.addTabbedLabel("Local file (read only)");
            }
            if (tempObject.fileNotFound) {
                this.addTabbedLabel("File not found");
            }
        }
        if (tempObject.hasHistory()) {
            this.addTabbedLabel("History of changes are available");
        }
        if (tempObject.getNeedsSaveToDisk(true)) {
            this.addTabbedLabel("Unsaved changes");
        }
        if (tempObject.isFavorite()) {
            this.addTabbedLabel("Available in the favourites menu");
        }
        if (tempObject.hasSchemaError) {
            this.addTabbedLabel("Schema validation error (Check XML Conformance for details)");
        }
    }

    public void updateList() {
        this.jPanel.removeAll();
        if (this.targetObject != null) {
            if (this.targetObject instanceof Object[]) {
                for (int childCounter = 0; childCounter < ((Object[])this.targetObject).length; ++childCounter) {
                    this.addIconLabel(((Object[])this.targetObject)[childCounter]);
                }
                if (((Object[])this.targetObject)[0] != null && ((Object[])this.targetObject)[0] instanceof ArbilField) {
                    this.addDetailLabel(((ArbilField)((Object[])this.targetObject)[0]).getParentDataNode().getNodeTemplate().getHelpStringForField(((ArbilField)((Object[])this.targetObject)[0]).getFullXmlPath()));
                }
            } else if (this.targetObject instanceof ArbilDataNode) {
                this.addIconLabel(this.targetObject);
                this.addLabelsForDataNode((ArbilDataNode)this.targetObject);
            } else if (this.targetObject instanceof ArbilField) {
                this.addDetailLabel(this.targetObject.toString());
                this.addDetailLabel(((ArbilField)this.targetObject).getParentDataNode().getNodeTemplate().getHelpStringForField(((ArbilField)this.targetObject).getFullXmlPath()));
                this.addFieldType((ArbilField)this.targetObject);
            } else {
                this.addDetailLabel(this.targetObject.toString());
            }
            this.jPanel.doLayout();
            this.doLayout();
        }
    }

    public String getTipText() {
        return "";
    }

    public Dimension getPreferredSize() {
        return this.jPanel.getPreferredSize();
    }

    public void setTartgetObject(Object targetObjectLocal) {
        this.targetObject = targetObjectLocal;
    }
}

