/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.favourites;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.favourites.ArbilFavourites;
import nl.mpi.arbil.favourites.FavouritesExporterImpl;
import nl.mpi.arbil.favourites.FavouritesImporterImpl;
import nl.mpi.arbil.ui.favourites.ExportAction;
import nl.mpi.arbil.ui.favourites.ExportUI;
import nl.mpi.arbil.ui.favourites.ImportAction;
import nl.mpi.arbil.ui.favourites.ImportUI;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.flap.plugin.PluginDialogHandler;

public class FavouritesImportExportGUI
implements ArbilDataNodeContainer {
    private final JPanel panel;
    private final DefaultListModel nodesListModel;
    private final ListSelectionModel nodesListSelectionModel;
    private final Action importAction;
    private final Action exportAction;
    private final Action refreshAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            FavouritesImportExportGUI.this.update();
        }
    };
    private final TreeHelper treeHelper;
    private ArbilDataNode[] allFavourites = new ArbilDataNode[0];

    public FavouritesImportExportGUI(PluginDialogHandler dialog, SessionStorage sessionStorage, TreeHelper treeHelper, ApplicationVersion appVersion) {
        this(new ImportAction(dialog, new FavouritesImporterImpl(ArbilFavourites.getSingleInstance())), new ExportAction(dialog, new FavouritesExporterImpl(sessionStorage, appVersion)), treeHelper);
    }

    public FavouritesImportExportGUI(Action importAction, Action exportAction, TreeHelper treeHelper) {
        this.importAction = importAction;
        this.exportAction = exportAction;
        this.treeHelper = treeHelper;
        this.nodesListModel = new DefaultListModel();
        this.nodesListSelectionModel = new DefaultListSelectionModel();
        this.panel = this.createPanel();
        this.panel.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                FavouritesImportExportGUI.this.update();
            }
        });
        this.update();
    }

    private JPanel createPanel() {
        JPanel importExportPanel = new JPanel();
        importExportPanel.setLayout(new BoxLayout(importExportPanel, 3));
        importExportPanel.setPreferredSize(new Dimension(600, 400));
        JPanel importPanel = this.createImportPanel();
        importPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Import favourites"));
        importExportPanel.add(importPanel);
        JPanel exportPanel = this.createExportPanel();
        exportPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Export favourites"));
        importExportPanel.add(exportPanel);
        return importExportPanel;
    }

    private JPanel createImportPanel() {
        JPanel importPanel = new JPanel(new BorderLayout());
        JTextArea importInstructions = new JTextArea(String.format("Press the import button, then choose an existing directory that has an exported collection of favourites. The directory should contain a file called %s.\n", "favourites.config"));
        importInstructions.setEditable(false);
        importInstructions.setLineWrap(true);
        importInstructions.setWrapStyleWord(true);
        importInstructions.setOpaque(false);
        importPanel.add((Component)importInstructions, "North");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.add(Box.createHorizontalGlue());
        importPanel.add((Component)buttonsPanel, "South");
        ImportButton importButton = new ImportButton(this.importAction);
        importButton.setText("Import from disk");
        buttonsPanel.add(importButton);
        return importPanel;
    }

    private JPanel createExportPanel() {
        JPanel exportPanel = new JPanel(new BorderLayout());
        JTextArea exportInstructions = new JTextArea("Select one or more favourites that you wish to export from the list below, then press the export button. Then select the directory to which you would like to export the selected favourites.\n\nHint: you can use modifier keys on the keyboard to select or deselect individual favourites (CTRL or CMD) or to select a range (SHIFT).\n");
        exportInstructions.setEditable(false);
        exportInstructions.setLineWrap(true);
        exportInstructions.setWrapStyleWord(true);
        exportInstructions.setOpaque(false);
        exportPanel.add((Component)exportInstructions, "North");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.add(Box.createHorizontalGlue());
        exportPanel.add((Component)buttonsPanel, "South");
        JButton refreshButton = new JButton(this.refreshAction);
        refreshButton.setText("Refresh");
        buttonsPanel.add(refreshButton);
        final ExportButton exportButton = new ExportButton(this.exportAction);
        exportButton.setText("Export selection");
        buttonsPanel.add(exportButton);
        JList<Object> nodesList = new JList<Object>(this.nodesListModel);
        nodesList.setSelectionModel(this.nodesListSelectionModel);
        nodesList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setIcon(((ArbilDataNode)value).getIcon());
                return this;
            }
        });
        nodesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                exportButton.setEnabled(!FavouritesImportExportGUI.this.nodesListSelectionModel.isSelectionEmpty());
            }
        });
        nodesList.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        exportPanel.add(nodesList, "Center");
        return exportPanel;
    }

    public final void update() {
        this.getAllFavourites();
        this.updateFavouritesList();
        this.nodesListSelectionModel.addSelectionInterval(0, this.nodesListModel.getSize());
    }

    private void getAllFavourites() {
        for (ArbilDataNode node : this.allFavourites) {
            node.removeContainer(this);
        }
        for (ArbilDataNode node : this.allFavourites = this.treeHelper.getFavouriteNodes()) {
            node.registerContainer(this);
        }
    }

    private void updateFavouritesList() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FavouritesImportExportGUI.this.nodesListModel.removeAllElements();
                for (ArbilDataNode node : FavouritesImportExportGUI.this.allFavourites) {
                    FavouritesImportExportGUI.this.nodesListModel.addElement(node);
                }
            }
        });
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void dataNodeRemoved(ArbilNode an) {
        this.update();
    }

    public void dataNodeIconCleared(final ArbilNode an) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int index = FavouritesImportExportGUI.this.nodesListModel.indexOf(an);
                if (index >= 0) {
                    FavouritesImportExportGUI.this.nodesListModel.set(index, an);
                }
            }
        });
    }

    public void dataNodeChildAdded(ArbilNode an, ArbilNode an1) {
        this.update();
    }

    public boolean isFullyLoadedNodeRequired() {
        return false;
    }

    public void showDialog(JFrame owner) {
        JDialog dialog = new JDialog(owner);
        dialog.add(this.getPanel());
        dialog.setSize(600, 400);
        dialog.setVisible(true);
    }

    private class ImportButton
    extends JButton
    implements ImportUI {
        public ImportButton(Action a) {
            super(a);
        }

        public void refresh() {
            FavouritesImportExportGUI.this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportButton
    extends JButton
    implements ExportUI {
        public ExportButton(Action a) {
            super(a);
        }

        @Override
        public List<ArbilDataNode> getSelectedFavourites() {
            ArrayList<ArbilDataNode> selectedNodes = new ArrayList<ArbilDataNode>(FavouritesImportExportGUI.this.nodesListModel.getSize());
            for (int i = 0; i < FavouritesImportExportGUI.this.nodesListModel.getSize(); ++i) {
                if (!FavouritesImportExportGUI.this.nodesListSelectionModel.isSelectedIndex(i)) continue;
                selectedNodes.add((ArbilDataNode)FavouritesImportExportGUI.this.nodesListModel.elementAt(i));
            }
            return selectedNodes;
        }
    }
}

