/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.spider;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.mpi.bcarchive.spider.IMDIContentHandler;
import nl.mpi.bcarchive.spider.IMDINode;
import nl.mpi.bcarchive.spider.IMDINodeHandler;
import nl.mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXParseException;

public class IMDISpider {
    static Logger logger = Logger.getLogger(IMDISpider.class);
    private Set linkSet = new HashSet();
    private OurURL parentURL = null;
    private int handlerCnt = 1;
    private int sessionCount = 0;
    private int corpusCount = 0;
    private int lexiconCount = 0;
    private int catalogueCount = 0;
    private int mediaResourceCount = 0;
    private int writtenResourceCount = 0;
    private int lexiconResourceCount = 0;
    private int infoFileCount = 0;
    private IMDIContentHandler imdiCH = new IMDIContentHandler();

    public boolean run(OurURL url, IMDINodeHandler handler, boolean local) {
        block19: {
            if (this.linkSet.contains(url.toString())) {
                return true;
            }
            IMDISpider.myMessage("--> run: " + url);
            if (handler == null) {
                return false;
            }
            try {
                this.imdiCH = new IMDIContentHandler();
            }
            catch (Exception e) {
                handler.handleLinkError(url, this.parentURL);
                return false;
            }
            try {
                this.imdiCH.parse(url);
                this.linkSet.add(url.toString());
            }
            catch (IOException ioe) {
                IMDISpider.myError("Parse Error: I/O problem: " + ioe + " skipping: " + url);
                handler.handleParseError(url, this.parentURL);
                return false;
            }
            catch (SAXParseException saxe) {
                IMDISpider.myError("Parse Error: XML error: " + saxe + " skipping: " + url);
                handler.handleParseError(url, this.parentURL);
                return false;
            }
            catch (Exception e) {
                IMDISpider.myError("Parse Error: Exception: " + e + " skipping: " + url);
                e.printStackTrace();
                handler.handleParseError(url, this.parentURL);
                return false;
            }
            try {
                String imdiType = this.imdiCH.getImdiType();
                if (imdiType.equals("Session")) {
                    ++this.sessionCount;
                    handler.handleSession(url, this.parentURL);
                    this.handleMediaResources(handler, url, this.imdiCH.getMediaNodes());
                    this.handleWrittenResources(handler, url, this.imdiCH.getWrittenNodes());
                    this.handleLexiconResources(handler, url, this.imdiCH.getLexiconNodes());
                    this.handleInfoFiles(handler, url, this.imdiCH.getInfoNodes());
                    break block19;
                }
                if (imdiType.equals("Corpus")) {
                    ++this.corpusCount;
                    if (!handler.handleCorpus(url, this.parentURL)) {
                        return true;
                    }
                    this.handleInfoFiles(handler, url, this.imdiCH.getInfoNodes());
                    List cl = this.imdiCH.getCorpusLinks();
                    if (this.imdiCH.getCatalogueLink() != null) {
                        cl.add(this.imdiCH.getCatalogueLink());
                    }
                    boolean okay = true;
                    for (IMDINode node : cl) {
                        try {
                            OurURL curl = new OurURL(url, node.getURL().toString());
                            this.parentURL = url;
                            if (this.run(curl, handler, local)) continue;
                            okay = false;
                        }
                        catch (MalformedURLException mue) {
                            handler.handleLinkError(node.getURL(), url);
                            okay = false;
                        }
                    }
                    return okay;
                }
                if (imdiType.equals("Lexicon")) {
                    ++this.lexiconCount;
                    handler.handleLexicon(url, this.parentURL);
                    break block19;
                }
                if (imdiType.equals("Catalogue")) {
                    ++this.catalogueCount;
                    handler.handleCatalogue(url, this.parentURL);
                    break block19;
                }
                IMDISpider.myError("Invalid IMDI type: " + imdiType);
                return false;
            }
            catch (Exception e) {
                IMDISpider.myError("Handler Error: " + e);
                handler.handleParseError(url, this.parentURL);
                return false;
            }
        }
        return true;
    }

    private void handleMediaResources(IMDINodeHandler handler, OurURL url, List ml) {
        Iterator i = ml.iterator();
        while (i.hasNext()) {
            ++this.mediaResourceCount;
            IMDINode node = (IMDINode)i.next();
            OurURL murl = node.getURL();
            String context = node.getPath();
            handler.handleMediaFile(url, murl, context, this.parentURL);
        }
    }

    private void handleWrittenResources(IMDINodeHandler handler, OurURL url, List wl) {
        Iterator i = wl.iterator();
        while (i.hasNext()) {
            ++this.writtenResourceCount;
            IMDINode node = (IMDINode)i.next();
            OurURL murl = node.getURL();
            String context = node.getPath();
            handler.handleWrittenResource(url, murl, context, this.parentURL);
        }
    }

    private void handleLexiconResources(IMDINodeHandler handler, OurURL url, List wl) {
        Iterator i = wl.iterator();
        while (i.hasNext()) {
            ++this.lexiconResourceCount;
            IMDINode node = (IMDINode)i.next();
            OurURL murl = node.getURL();
            String context = node.getPath();
            handler.handleLexiconResource(url, murl, context, this.parentURL);
        }
    }

    private void handleInfoFiles(IMDINodeHandler handler, OurURL url, List il) {
        Iterator i = il.iterator();
        while (i.hasNext()) {
            ++this.infoFileCount;
            IMDINode node = (IMDINode)i.next();
            OurURL murl = node.getURL();
            String context = node.getPath();
            handler.handleInfoFile(url, murl, context, this.parentURL);
        }
    }

    public int getCorpusCount() {
        return this.corpusCount;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    public int getCatalogueCount() {
        return this.catalogueCount;
    }

    public int getMediaCount() {
        return this.mediaResourceCount / this.handlerCnt;
    }

    public int getWrittenCount() {
        return this.writtenResourceCount / this.handlerCnt;
    }

    public int getLexiconCount() {
        return this.lexiconResourceCount / this.handlerCnt;
    }

    public int getInfoCount() {
        return this.infoFileCount / this.handlerCnt;
    }

    private static void myError(String errorMessage) {
        logger.error((Object)errorMessage);
    }

    private static void myMessage(String errorMessage) {
        logger.debug((Object)("SPIDER: " + errorMessage));
    }
}

