/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import net.handle.hdllib.Cache;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.MemCache;
import net.handle.hdllib.Util;
import net.handle.server.SQLHandleStorage;
import net.handle.util.StreamTable;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.util.DBConnection;
import nl.mpi.util.OurURL;
import org.apache.log4j.Logger;

public class ArchiveObjectsDBImplHS
implements ArchiveObjectsDB {
    protected static Logger logger = Logger.getLogger((String)ArchiveObjectsDBImplHS.class.getName());
    protected static ArchiveAccessContext aac = null;
    protected String readOnlySetting = null;
    protected boolean translationMode = false;
    protected HandleResolver resolver = null;
    protected boolean useSQL = false;
    protected SQLHandleStorage sqlhs = null;
    protected DBConnection db = null;
    private PreparedStatement handleByContentSTM = null;
    private boolean status = false;

    private void initResolver() {
        int[] protos = new int[]{1, 2};
        MemCache cache1 = new MemCache();
        MemCache cache2 = new MemCache();
        cache1.setMaximumSize(0x1000000);
        cache2.setMaximumSize(0x1000000);
        this.resolver = new HandleResolver();
        if (this.resolver == null) {
            return;
        }
        this.resolver.setCache((Cache)cache1);
        this.resolver.setCertifiedCache((Cache)cache2);
        this.resolver.setPreferredProtocols(protos);
        this.status = true;
    }

    private boolean initSQL(StreamTable sqlConfig) {
        String dbURL = sqlConfig.getStr((Object)"sql_url");
        this.db = new DBConnection(dbURL, sqlConfig.getStr((Object)"sql_login"), sqlConfig.getStr((Object)"sql_passwd"), "ArchiveObjectsDBImplHS:initSQL()");
        this.readOnlySetting = sqlConfig.getStr((Object)"sql_read_only");
        try {
            this.handleByContentSTM = this.db.getConnection().prepareStatement("SELECT HANDLE,IDX FROM HANDLES WHERE TYPE=? AND DATA=?");
        }
        catch (SQLException sqle) {
            logger.error((Object)"initSQL: could not prepare SQL statements: ", (Throwable)sqle);
            return false;
        }
        return this.db.getStatus();
    }

    private void initDomain(StreamTable sqlConfig) {
        this.translationMode = false;
        this.useSQL = false;
        logger.debug((Object)"ArchiveObjectsDBImplHS: open SQLHandleStorage");
        try {
            this.sqlhs = new SQLHandleStorage();
        }
        catch (Exception e) {
            logger.error((Object)("initDomain: " + e));
            this.sqlhs = null;
        }
        if (sqlConfig == null) {
            logger.error((Object)"initDomain: sql_settings missing in config server_config");
            this.sqlhs = null;
        }
        if (this.sqlhs == null) {
            logger.warn((Object)"initDomain: cannot open SQL connection");
            return;
        }
        try {
            this.sqlhs.init(sqlConfig);
            logger.debug((Object)"initDomain: sqlhs.init done");
            if (!this.initSQL(sqlConfig)) {
                logger.error((Object)"initDomain: SQL init failed");
                this.sqlhs = null;
                return;
            }
        }
        catch (HandleException he) {
            logger.error((Object)("initDomain: Handle Exception during SQL init: " + (Object)((Object)he)), (Throwable)he);
            this.sqlhs = null;
            return;
        }
        catch (Exception e) {
            logger.error((Object)("initDomain: could not use the given DB connection configuration, error: " + e), (Throwable)e);
            this.sqlhs = null;
            return;
        }
        String prefix = aac.getHandlePrefix();
        if (prefix != null && this.haveNA(prefix)) {
            this.useSQL = true;
            logger.debug((Object)("Prefix is homed at this SQL DB: " + prefix));
        } else {
            this.useSQL = false;
            logger.warn((Object)("SQL DB ignored until known prefix is selected! Unknown prefix: " + prefix));
        }
        this.status = true;
    }

    protected void loadConfigFile(String configFileName) {
        try {
            StreamTable config = new StreamTable();
            File configFileFile = new File(configFileName);
            if (configFileFile.isDirectory()) {
                configFileName = configFileName + File.separator + "config.dct";
            }
            config.readFromFile(configFileName);
            config = (StreamTable)config.get((Object)"server_config");
            if (!"sql".equals(config.getStr((Object)"storage_type"))) {
                logger.error((Object)("constructor: " + configFileName + " has no SQL storage info"));
            } else {
                StreamTable sqlConfig = (StreamTable)config.get((Object)"sql_settings");
                this.initDomain(sqlConfig);
            }
        }
        catch (Exception e) {
            logger.error((Object)("constructor: could not use config from " + configFileName));
            this.useSQL = false;
        }
    }

    protected boolean haveNA(String prefix) {
        byte[] naHandle = Util.encodeString((String)("0.NA/" + prefix));
        logger.debug((Object)("haveNA: NA Test: '0.NA/" + prefix + "'"));
        try {
            if (!this.sqlhs.haveNA(naHandle)) {
                logger.warn((Object)("haveNA: SQL storage accessible but prefix " + prefix + " is not homed in it."));
                return false;
            }
        }
        catch (HandleException he) {
            logger.error((Object)("haveNA: Handle Exception: " + (Object)((Object)he)));
            return false;
        }
        return true;
    }

    public ArchiveObjectsDBImplHS() {
        this.initResolver();
        this.translationMode = false;
        Properties myProps = new Properties(System.getProperties());
        String configFileName = myProps.getProperty("HandleSystemConfig");
        if (configFileName != null) {
            logger.debug((Object)("ArchiveObjectsDBImplHS: Using config file " + configFileName));
            this.loadConfigFile(configFileName);
        } else {
            logger.debug((Object)"ArchiveObjectsDBImplHS: Read-only HS via TCP/IP, no HandleSystemConfig property");
        }
    }

    public ArchiveObjectsDBImplHS(boolean translate) {
        this.initResolver();
        this.translationMode = translate;
    }

    public ArchiveObjectsDBImplHS(String configFileName, boolean translate) {
        this.initResolver();
        this.translationMode = translate;
        this.loadConfigFile(configFileName);
    }

    public ArchiveObjectsDBImplHS(String jdbcurl, String username, String password, String drivername) {
        this.initResolver();
        this.translationMode = false;
        if (username == null) {
            username = "imdiArchive";
        }
        if (password == null) {
            password = "";
        }
        if (drivername == null) {
            if (jdbcurl.startsWith("jdbc:hsqldb")) {
                drivername = "org.hsqldb.jdbcDriver";
            }
            if (jdbcurl.startsWith("jdbc:postgresql")) {
                drivername = "org.postgresql.Driver";
            }
        }
        if (drivername == null) {
            logger.error((Object)("Unsupported jdbc URL scheme: " + jdbcurl));
            this.status = false;
            return;
        }
        StreamTable sqlConfig = new StreamTable();
        sqlConfig.put((Object)"sql_url", (Object)jdbcurl);
        sqlConfig.put((Object)"sql_driver", (Object)drivername);
        sqlConfig.put((Object)"sql_login", (Object)username);
        sqlConfig.put((Object)"sql_passwd", (Object)password);
        sqlConfig.put((Object)"sql_read_only", (Object)"no");
        this.initDomain(sqlConfig);
    }

    public ArchiveObjectsDBImplHS(String configFile) {
        this.initResolver();
        this.translationMode = false;
        this.loadConfigFile(configFile);
    }

    public boolean canWrite() {
        return false;
    }

    public void setArchiveRoots(ArchiveAccessContext userAAC) {
        boolean oldUseSQL = this.useSQL;
        String prefix = null;
        aac = userAAC;
        prefix = aac.getHandlePrefix();
        logger.info((Object)("setArchiveRoots called, new prefix: " + prefix));
        if (this.sqlhs == null) {
            return;
        }
        if (prefix != null && this.haveNA(prefix)) {
            this.useSQL = true;
            if (!oldUseSQL) {
                logger.info((Object)("SQL DB activated: New prefix is homed here: " + prefix));
            } else {
                logger.debug((Object)("SQL DB was already active, new prefix is also homed here: " + prefix));
            }
        } else {
            logger.warn((Object)("SQL DB ignored until known prefix is selected! Unknown prefix: " + prefix));
            this.useSQL = false;
        }
        this.status = true;
    }

    public ArchiveAccessContext getArchiveRoots() {
        return aac;
    }

    public OurURL getObjectURL(String nodeId, int context) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        URI objectURI = this.getObjectURI(id);
        if (objectURI == null) {
            return null;
        }
        String urlString = objectURI.toString();
        if (urlString.startsWith("hdl:")) {
            logger.info((Object)("getObjectURL: recursion! Handle=" + id + ", URL=" + urlString));
            urlString = urlString.substring(4);
            while (urlString.startsWith("/")) {
                urlString = urlString.substring(1);
            }
            if (aac.getHandlePrefix().equals(NodeIdUtils.handleToPrefix(urlString))) {
                return this.getObjectURL(urlString, context);
            }
            urlString = "hdl:" + urlString;
        }
        try {
            urlString = aac.toClassicURL(urlString, false, this).toString();
            URI result = aac.uriInContext(urlString, context);
            if (result == null) {
                logger.error((Object)("getObjectURL: urlInContext error, context: " + context));
                return null;
            }
            return new OurURL(result.toString());
        }
        catch (MalformedURLException mue) {
            logger.error((Object)("getObjectURL: malformed URL for ID: " + id + " URL: " + urlString));
            logger.error((Object)("getObjectURL: cannot generate URL: " + mue));
        }
        catch (URISyntaxException use) {
            logger.error((Object)("getObjectURL: malformed URI for ID: " + id + " exception: " + use));
        }
        return null;
    }

    public URI getObjectURI(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        String urlString = this.fetchHandleData(id, "URL");
        if (urlString == null) {
            return null;
        }
        try {
            return aac.stringToURI(urlString);
        }
        catch (URISyntaxException use) {
            logger.error((Object)("getObjectURI: DB contained invalid URI: " + urlString));
            throw new UnknownNodeException("getObjectURI: Bad URI: " + urlString);
        }
    }

    public OurURL getObjectURLForPid(String pid) throws UnknownNodeException {
        String methodSignature = "getObjectURLByPid";
        String urlstr = this.fetchHandleData(pid, "URL");
        if (urlstr != null) {
            try {
                return new OurURL(urlstr);
            }
            catch (MalformedURLException e) {
                logger.error((Object)(methodSignature + ": Failed to create OurURL object from url: " + urlstr), (Throwable)e);
            }
        }
        return null;
    }

    public String getObjectId(OurURL url, int context) {
        OurURL url2 = url;
        URI uri = null;
        try {
            uri = aac.uriToTableContext(new URI(url.toString()), context);
            uri = aac.uriInContext(uri.toString(), 3);
        }
        catch (URISyntaxException use) {
            logger.warn((Object)("getObjectId: malformed URI: " + url));
            uri = null;
        }
        if (uri == null) {
            return null;
        }
        return this.getObjectId(uri);
    }

    public String getObjectId(OurURL url) {
        int context = aac.getAccessContextFromURI(url.toString());
        return this.getObjectId(url, context);
    }

    public String getObjectId(URI uri) {
        if (uri == null || !uri.isAbsolute()) {
            logger.warn((Object)("getObjectId: Invalid URI, must specify schema/protocol: " + uri));
            return null;
        }
        int context = aac.getAccessContextFromURI(uri.toString());
        if (context == -1) {
            logger.error((Object)("getObjectId: Could not guess access context for URL: " + uri));
            context = 0;
        }
        uri = aac.uriToTableContext(uri, context);
        return this.getByValue("URL", uri.toString());
    }

    public String getObjectForPID(String pid) {
        return this.getByValue("PID", pid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getByValue(String name, String value) {
        if (!this.useSQL) {
            logger.error((Object)("getByValue: reverse lookup not possible without SQL connection! Name: " + name));
            return null;
        }
        if (!this.getStatus()) {
            logger.error((Object)"getByValue: DB connection not active!");
            return null;
        }
        ResultSet rs = null;
        String handle = null;
        try {
            PreparedStatement preparedStatement = this.handleByContentSTM;
            synchronized (preparedStatement) {
                this.handleByContentSTM.clearParameters();
                this.handleByContentSTM.setBytes(1, Util.encodeString((String)name));
                this.handleByContentSTM.setBytes(2, Util.encodeString((String)value));
                rs = this.handleByContentSTM.executeQuery();
                while (rs.next()) {
                    String aHandle = rs.getString("HANDLE");
                    int index = rs.getInt("IDX");
                    if (handle == null) {
                        handle = aHandle;
                        continue;
                    }
                    if (aHandle.equals(handle)) continue;
                    logger.error((Object)("getByValue: Value for " + name + " found in more than one handle! " + handle + " and " + aHandle));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getByValue: SQLException: " + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return this.translateToNodeId(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getObjectsByChecksum(String checksum) {
        if (!this.useSQL) {
            logger.error((Object)"getObjectsByChecksum: reverse lookup not possible without SQL connection!");
            return null;
        }
        if (!this.getStatus()) {
            logger.error((Object)"getObjectsByChecksum: DB connection not active!");
            return null;
        }
        if (checksum == null || !checksum.matches("^[a-f0-9]*$")) {
            logger.warn((Object)("getObjectsByChecksum: Invalid checksum, must be lower case hex: " + checksum));
            return null;
        }
        ResultSet rs = null;
        Object handle = null;
        TreeSet<String> items = new TreeSet<String>();
        try {
            PreparedStatement preparedStatement = this.handleByContentSTM;
            synchronized (preparedStatement) {
                this.handleByContentSTM.clearParameters();
                this.handleByContentSTM.setBytes(1, Util.encodeString((String)"CHECKSUM"));
                this.handleByContentSTM.setBytes(2, Util.encodeString((String)checksum.toString()));
                rs = this.handleByContentSTM.executeQuery();
                while (rs.next()) {
                    String item = this.translateToNodeId(rs.getString("HANDLE"));
                    items.add(item);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)("getObjectsByChecksum: SQLException: " + e));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return items.toArray(new String[0]);
    }

    public Timestamp getObjectTimestamp(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        String timeString = this.fetchHandleData(id, "CRAWLTIME");
        if (timeString == null) {
            return null;
        }
        return Timestamp.valueOf(timeString);
    }

    public Timestamp getObjectFileTime(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        String timeString = this.fetchHandleData(id, "FILETIME");
        if (timeString == null) {
            return null;
        }
        return Timestamp.valueOf(timeString);
    }

    public AccessInfo getObjectAccessInfo(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        String creator = this.fetchHandleData(id, "CREATOR");
        String owner = this.fetchHandleData(nodeId, "OWNER");
        String readRights = this.fetchHandleData(nodeId, "READRIGHTS");
        String writeRights = this.fetchHandleData(nodeId, "WRITERIGHTS");
        int accessLevel = Integer.parseInt(this.fetchHandleData(nodeId, "ACCESSLEVEL"));
        return new AccessInfo(creator, owner, readRights, writeRights, accessLevel);
    }

    public long getObjectSize(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        String size = this.fetchHandleData(id, "FILESIZE");
        if (size == null) {
            return 0L;
        }
        try {
            return Long.parseLong(size);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public String getObjectChecksum(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        return this.fetchHandleData(id, "CHECKSUM");
    }

    public String getObjectPID(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        return this.fetchHandleData(id, "PID");
    }

    public boolean isAccessible(String nodeId) throws UnknownNodeException {
        return this.getObjectSize(nodeId) > 0L;
    }

    public boolean isOnSite(String nodeId) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        String onsite = this.fetchHandleData(id, "ONSITE");
        if (onsite == null) {
            return false;
        }
        return onsite.trim().equalsIgnoreCase("true");
    }

    public boolean hasReadAccess(String nodeId, String uid) throws UnknownNodeException {
        String id = this.translateToHandle(nodeId);
        AccessInfo ai = this.getObjectAccessInfo(id);
        if (ai == null) {
            return false;
        }
        return ai.hasReadAccess(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNewArchiveObjectsSince(Timestamp timestamp, boolean onsiteonly, boolean urlformat, boolean usefiletime) {
        if (!this.useSQL) {
            logger.error((Object)"getNewArchiveObjectsSince: limited to SQL connections");
            return null;
        }
        if (!this.getStatus()) {
            logger.error((Object)"getNewArchiveObjectsSince: DB connection not active!");
            return null;
        }
        if (timestamp != null && timestamp.getTime() == 0L) {
            timestamp = null;
        }
        if (this.db.dbType != 1 && timestamp != null) {
            logger.error((Object)"getNewArchiveObjectsSince: bytea to varchar to timestamp only supported for PostgreSQL");
            return null;
        }
        String query = "SELECT HANDLE FROM HANDLES AS HA1 WHERE ";
        if (urlformat) {
            query = query + "PLACE.HANDLE = HA1.HANDLE";
        }
        if (timestamp != null) {
            query = query + " AND TYPE='";
            query = usefiletime ? query + "FILETIME" : query + "CRAWLTIME";
            query = query + "' AND cast(encode(DATA,'escape') AS TIMESTAMP) > '" + timestamp.toString() + "'";
        }
        if (onsiteonly) {
            query = query + " AND EXISTS (SELECT HANDLE FROM HANDLES AS HA2 WHERE HA2.HANDLE = HA1.HANDLE AND HA2.TYPE='ONSITE' AND HA2.DATA='" + Boolean.toString(true) + "'";
        }
        if (urlformat) {
            query = "SELECT HANDLE,DATA FROM HANDLES AS PLACE WHERE PLACE.TYPE = 'URL' AND EXISTS ( " + query + " )";
        }
        logger.debug((Object)("getNewArchiveObjectsSince: " + query));
        TreeSet<String[]> resultHandles = new TreeSet<String[]>();
        Vector<String> resultURLs = new Vector<String>();
        ResultSet rs = null;
        Statement statement = null;
        try {
            String[] res;
            statement = this.db.getConnection().createStatement();
            rs = statement.executeQuery(query);
            while (rs.next()) {
                res = this.translateToNodeId(Util.decodeString((byte[])rs.getBytes("HANDLE")));
                if (urlformat && !resultHandles.contains(res)) {
                    String url = new String(Util.decodeString((byte[])rs.getBytes("DATA")));
                    resultURLs.add(url);
                }
                resultHandles.add(res);
            }
            if (urlformat) {
                res = resultURLs.toArray(new String[0]);
                return res;
            }
            res = resultHandles.toArray(new String[0]);
            return res;
        }
        catch (SQLException e) {
            logger.error((Object)"getNewArchiveObjectsSince: ", (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            rs = null;
        }
        return null;
    }

    public void close() {
        this.status = false;
        if (this.sqlhs != null) {
            this.sqlhs.shutdown();
        }
        try {
            if (this.handleByContentSTM != null) {
                this.handleByContentSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.warn((Object)"close: SQL error in prepared statement close: ", (Throwable)sqle);
        }
        this.handleByContentSTM = null;
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
    }

    public boolean getStatus() {
        if (!this.useSQL && this.resolver == null) {
            this.status = false;
        }
        if (this.useSQL && (this.sqlhs == null || this.db == null || !this.db.getStatus())) {
            this.status = false;
        }
        return this.status;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    protected String translateToHandle(String nodeId) {
        if (!this.translationMode) {
            return nodeId;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            return nodeId;
        }
        return NodeIdUtils.nodeIdToHandle(nodeId, aac.getHandlePrefix());
    }

    protected String translateToNodeId(String handle) {
        if (!this.translationMode) {
            return handle;
        }
        if (NodeIdUtils.isNodeId(handle)) {
            return handle;
        }
        if (NodeIdUtils.handleToPrefix(handle).equals(aac.getHandlePrefix())) {
            return NodeIdUtils.handleToNodeId(handle, aac.getHandlePrefix());
        }
        return handle;
    }

    protected String fetchHandleData(String handle, String field) throws UnknownNodeException {
        block9: {
            if (handle.indexOf(47) == -1) {
                throw new UnknownNodeException("fetchHandleData: No handle: " + handle);
            }
            if (!this.getStatus()) {
                logger.error((Object)("fetchHandleData: DB connection not active, cannot fetch data for handle=" + handle + ", field=" + field));
                return null;
            }
            if (this.useSQL) {
                try {
                    return this.fetchHandleDataSQL(handle, field);
                }
                catch (UnknownNodeException une) {
                    if (this.resolver == null) {
                        throw new UnknownNodeException("fetchHandleData: no resolver, no SQL data for handle: " + handle);
                    }
                    if (!aac.getHandlePrefix().equals(NodeIdUtils.handleToPrefix(handle))) break block9;
                    throw new UnknownNodeException("fetchHandleData: our prefix but no SQL data found: " + handle);
                }
            }
        }
        try {
            return this.fetchHandleDataServer(handle, field);
        }
        catch (HandleException he) {
            if (he.getCode() == 9) {
                throw new UnknownNodeException("fetchHandleData: Handle not found: " + handle);
            }
            logger.error((Object)("fetchHandleData: HandleException: " + (Object)((Object)he)));
            return null;
        }
    }

    protected String fetchHandleDataServer(String handle, String field) throws HandleException {
        String[] fields = new String[]{field};
        if (this.resolver == null) {
            return null;
        }
        HandleValue[] results = this.resolver.resolveHandle(handle, fields, null);
        if (results == null || results.length < 1) {
            return null;
        }
        String data = null;
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null) {
                return data;
            }
            if (data == null) {
                data = results[i].getDataAsString();
                continue;
            }
            logger.warn((Object)("fetchHandleDataServer: Ignored extra value: " + results[i]));
        }
        return data;
    }

    protected String fetchHandleDataSQL(String handle, String field) throws UnknownNodeException {
        Vector val = this.fetchHandleSQL(handle, field);
        if (val == null || val.size() < 1) {
            this.fetchHandleSQL(handle, null);
            return null;
        }
        HandleValue[] values = val.toArray(new HandleValue[0]);
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || ++j <= 1) continue;
            logger.warn((Object)("fetchHandleDataSQL: Ignored extra value " + j + ": " + values[i].getDataAsString()));
        }
        if (values[0] == null) {
            return null;
        }
        return values[0].getDataAsString();
    }

    protected Vector fetchHandleSQL(String handle, String field) throws UnknownNodeException {
        byte[][] rawValues;
        Object types = new byte[1][];
        if (field != null) {
            types[0] = Util.encodeString((String)field);
        } else {
            types = null;
        }
        try {
            rawValues = this.sqlhs.getRawHandleValues(Util.encodeString((String)handle), null, (byte[][])types);
        }
        catch (HandleException he) {
            logger.error((Object)("fetchHandleDataSQL: internal error: " + (Object)((Object)he)));
            return null;
        }
        if (rawValues == null || rawValues.length < 1) {
            if (field != null) {
                return null;
            }
            throw new UnknownNodeException("fetchHandleSQL: no data for handle " + handle);
        }
        Vector<HandleValue> values = new Vector<HandleValue>();
        for (int i = 0; i < rawValues.length; ++i) {
            HandleValue value = new HandleValue();
            try {
                Encoder.decodeHandleValue((byte[])rawValues[i], (int)0, (HandleValue)value);
                values.add(value);
                continue;
            }
            catch (HandleException he) {
                logger.error((Object)("fetchHandleDataSQL: internal decoding error: " + (Object)((Object)he)));
                return null;
            }
        }
        return values;
    }

    static {
        aac = new ArchiveAccessContext();
        Properties myProps = new Properties(System.getProperties());
        String propertyfile = myProps.getProperty("Properties", "CorpusStructure.props");
        aac.loadPropertyFile("ArchiveRoots");
        aac.loadPropertyFile(propertyfile);
    }
}

