/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import net.handle.hdllib4.Codes;
import net.handle.hdllib4.HandleConfiguration;
import net.handle.hdllib4.HandleElement;
import net.handle.hdllib4.HandleElementSet;
import net.handle.hdllib4.HandleException;
import net.handle.hdllib4.HandleRequestPacket;
import net.handle.hdllib4.HandleResolutionInfo;
import net.handle.hdllib4.HandleResponse;
import net.handle.hdllib4.HandleResponsePacket;
import net.handle.hdllib4.HashBucket;
import net.handle.hdllib4.InvalidPacketException;
import net.handle.hdllib4.QueryOptions;
import net.handle.hdllib4.ResponsePacketListener;
import net.handle.hdllib4.ServerHashtable;
import net.handle.hdllib4.Util;
import net.handle.hdllib4.XdrEncodingException;

public class HandleResolver {
    protected static long sessionTag = 1L;
    public long udpTimeout;
    public long tcpTimeout;
    public int maxUDPRetries = -1;
    public int protocol = 1;
    public QueryOptions queryOptions;

    public static final void main(String[] argv) throws Exception {
        HandleResolver resolver = new HandleResolver();
        HandleResponse resp = HandleResolver.resolveHandle("10.1000/1", null);
        System.err.println("Got response: " + resp);
    }

    public HandleResolver() {
        this.protocol = HandleConfiguration.getPreferredProtocol();
        this.tcpTimeout = HandleConfiguration.getTcpTimeout();
        this.udpTimeout = HandleConfiguration.getUdpTimeout();
        this.queryOptions = new QueryOptions();
    }

    public HandleResolver(int protocol, long udpTimeout, long tcpTimeout) {
        this.protocol = protocol;
        this.tcpTimeout = tcpTimeout;
        this.udpTimeout = udpTimeout;
        this.queryOptions = new QueryOptions();
    }

    public HandleResponse sendResolveRequest(String handle, HashBucket bucket, long[] typesWanted, ResponsePacketListener listener, int command) throws HandleException {
        if (this.protocol == 0 && bucket.udpQueryPort > 0) {
            return this.sendUdpResolveRequest(handle, bucket, typesWanted, listener, command);
        }
        return this.sendTcpResolveRequest(handle, bucket, typesWanted, listener, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public HandleResponse sendUdpResolveRequest(String handle, HashBucket bucket, long[] typesWanted, ResponsePacketListener listener, int command) throws HandleException {
        HandleResponse handleResponse;
        int retries;
        DatagramSocket socket = null;
        long startTime = -1L;
        long mySession = sessionTag++;
        if (sessionTag < 0L) {
            sessionTag = 1L;
        }
        if (mySession < 0L) {
            mySession = 0L;
        }
        if ((retries = this.maxUDPRetries) < 0) {
            retries = (int)HandleConfiguration.getUdpMaxRetries();
        }
        InetAddress server = null;
        try {
            server = bucket.getInetAddress();
        }
        catch (UnknownHostException e) {
            throw new HandleException(7, "Unable to get server address from bucket: " + e.getMessage());
        }
        HandleRequestPacket request = new HandleRequestPacket(mySession, command, 1L, 1L, 0, handle, this.queryOptions, typesWanted, 0, null);
        byte[] requestBuf = request.buildRequest();
        DatagramPacket reqPacket = new DatagramPacket(requestBuf, requestBuf.length, server, bucket.udpQueryPort);
        HandleResponse response = new HandleResponse();
        try {
            socket = new DatagramSocket();
            socket.setSoTimeout((int)this.udpTimeout);
        }
        catch (Exception e) {
            try {
                socket.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new HandleException(7, String.valueOf(e) + " setting SO timeout");
        }
        long beginQueryTime = new Date().getTime();
        try {
            for (int attempt = 0; attempt < retries; ++attempt) {
                void var17_20;
                if (HandleResolutionInfo.DEBUG) {
                    if (attempt == 0) {
                        HandleResolutionInfo.out.println("Querying handle via UDP: \"" + handle + "\" at server: " + server.getHostAddress() + "; port: " + bucket.udpQueryPort);
                    } else {
                        HandleResolutionInfo.out.println("  Resending request for: \"" + handle + "\" at server: " + server.getHostAddress() + "; port: " + bucket.udpQueryPort);
                    }
                }
                try {
                    startTime = new Date().getTime();
                    socket.send(reqPacket);
                    ++HandleResolutionInfo.numberOfQueries;
                    ++HandleResolutionInfo.numberOfPacketsSent;
                    long whenToTimeout = startTime + this.udpTimeout;
                }
                catch (Exception e) {
                    throw new HandleException(7, String.valueOf(e) + " sending UDP request to " + server.getHostAddress());
                }
                while (!response.haveAllPackets() && new Date().getTime() <= var17_20) {
                    byte[] socketBuf = new byte[512];
                    DatagramPacket resPacket = new DatagramPacket(socketBuf, socketBuf.length);
                    try {
                        socket.receive(resPacket);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (resPacket.getLength() <= 0) continue;
                    ++HandleResolutionInfo.numberOfPacketsReceived;
                    try {
                        HandleResponsePacket hresPacket = new HandleResponsePacket(resPacket.getData(), resPacket.getLength());
                        if (hresPacket.packetHeader.sessionTag != mySession) continue;
                        if (hresPacket.packetHeader.errorCode == 6) {
                            byte[] redirServer = hresPacket.packetBody.getRedirectedHandleServer();
                            System.out.println("redirected handle server: " + new String(redirServer) + " ");
                            continue;
                        }
                        response.addPacket(hresPacket);
                    }
                    catch (Exception e) {
                        if (!HandleResolutionInfo.DEBUG) continue;
                        HandleResolutionInfo.out.println("\nError (" + e + ") decoding packet: " + resPacket.getData());
                    }
                }
                if (!response.haveAllPackets()) break block30;
                handleResponse = response;
                Object var27_28 = null;
                HandleResolutionInfo.totalResolutionTime += new Date().getTime() - beginQueryTime;
                if (socket == null) break block31;
            }
        }
        catch (Throwable throwable) {
            Object var27_30 = null;
            HandleResolutionInfo.totalResolutionTime += new Date().getTime() - beginQueryTime;
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        {
            block30: {
                block31: {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return handleResponse;
            }
            continue;
        }
        Object var27_29 = null;
        HandleResolutionInfo.totalResolutionTime += new Date().getTime() - beginQueryTime;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception e) {}
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public HandleResponse sendTcpResolveRequest(String handle, HashBucket bucket, long[] typesWanted, ResponsePacketListener listener, int command) throws HandleException {
        void var16_17;
        Socket socket = null;
        long startTime = -1L;
        long mySession = sessionTag++;
        if (sessionTag < 0L) {
            sessionTag = 1L;
        }
        if (mySession < 0L) {
            mySession = 0L;
        }
        InetAddress server = null;
        try {
            server = bucket.getInetAddress();
        }
        catch (UnknownHostException e) {
            throw new HandleException(7, "Unable to get server address from bucket: " + e.getMessage());
        }
        HandleRequestPacket request = new HandleRequestPacket(mySession, command, 1L, 1L, 0, handle, this.queryOptions, typesWanted, 0, null);
        byte[] requestBuf = request.buildRequest();
        HandleResponse response = new HandleResponse();
        if (HandleResolutionInfo.DEBUG) {
            HandleResolutionInfo.out.println("Querying handle via TCP: \"" + handle + "\" at server: " + server.getHostAddress() + "; port: " + bucket.tcpQueryPort);
        }
        try {
            socket = new Socket(server, bucket.tcpQueryPort);
            socket.setSoTimeout((int)this.tcpTimeout);
            startTime = new Date().getTime();
            OutputStream sockOut = socket.getOutputStream();
            sockOut.write(requestBuf);
            sockOut.flush();
            InputStream sockIn = socket.getInputStream();
            ++HandleResolutionInfo.numberOfQueries;
            ++HandleResolutionInfo.numberOfPacketsSent;
            long whenToTimeout = startTime + this.tcpTimeout;
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw new HandleException(11, String.valueOf(e) + " connecting to " + server.getHostAddress() + ":" + bucket.tcpQueryPort);
        }
        while (!response.haveAllPackets() && new Date().getTime() <= var16_17) {
            HandleResponsePacket resPacket = null;
            try {
                void var7_16;
                resPacket = new HandleResponsePacket((InputStream)var7_16);
            }
            catch (SocketException e) {
                throw new HandleException(11, String.valueOf(e) + " resolving handle \"" + handle + "\" at server " + server.getHostAddress());
            }
            catch (XdrEncodingException e) {
                if (HandleResolutionInfo.DEBUG) {
                    HandleResolutionInfo.out.println("\nError (" + e + ") decoding packet");
                }
            }
            catch (InterruptedIOException e) {
                e.printStackTrace(System.err);
                throw new HandleException(2, String.valueOf(e) + ": " + e.getMessage());
            }
            catch (IOException e) {
                throw new HandleException(11, String.valueOf(e) + ": " + e.getMessage());
            }
            catch (InvalidPacketException e) {
                throw new HandleException(9, String.valueOf(e) + ": " + e.getMessage());
            }
            if (resPacket == null) continue;
            ++HandleResolutionInfo.numberOfPacketsReceived;
            response.addPacket(resPacket);
        }
        HandleResolutionInfo.totalResolutionTime += new Date().getTime() - startTime;
        return response;
    }

    public static ServerHashtable extractServerTable(byte[] servicePointer) throws HandleException {
        try {
            String urnSchema = new String(servicePointer, 0, Math.min(Codes.MAX_SERVICE_ID_LENGTH, servicePointer.length), "UTF8");
            if (Util.compareArrays(servicePointer, Codes.HASH_ENCODING, Codes.MAX_SERVICE_ID_LENGTH)) {
                return new ServerHashtable(servicePointer, Codes.MAX_SERVICE_ID_LENGTH, servicePointer.length - Codes.MAX_SERVICE_ID_LENGTH);
            }
            throw new HandleException(21, "Unrecognized encoding schema: \"" + new String(servicePointer, 0, Codes.MAX_SERVICE_ID_LENGTH, "UTF8") + '\"');
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleException(7, "unable to decode UTF8 string");
        }
    }

    public HashBucket[] findHomeService(String handle) throws HandleException {
        int slashIndex = handle.indexOf(47);
        if (slashIndex <= 0 || slashIndex >= handle.length() - 1) {
            throw new HandleException(1, "Invalid handle: " + handle);
        }
        String authority = handle.substring(0, slashIndex).toUpperCase();
        String authHandle = "HA.AUTH/" + handle.substring(0, slashIndex).toUpperCase();
        if (authority.equals("HA.AUTH") || authority.equals("HA.SERV")) {
            authHandle = handle.toUpperCase();
            if (HandleConfiguration.getPreferredResolutionMethod() == 2) {
                HashBucket[] bucket = new HashBucket[]{HandleConfiguration.getSpecificServerInfo()};
                return bucket;
            }
            if (HandleConfiguration.getPreferredResolutionMethod() == 0) {
                return HandleConfiguration.getSpecificServiceTable().determineServer(handle, this.queryOptions);
            }
            return HandleConfiguration.getGlobalHashTable().determineServer(handle, this.queryOptions);
        }
        return HandleResolver.extractServerTable(this.getServicePointerForAuthority(authHandle)).determineServer(handle, this.queryOptions);
    }

    public ServerHashtable findService(String authority) throws HandleException {
        String authHandle = "ha.auth/" + authority;
        return HandleResolver.extractServerTable(this.getServicePointerForAuthority(authHandle));
    }

    public static HandleResponse resolveHandle(String handle, long[] typesWanted) throws HandleException {
        return HandleResolver.resolveHandle(handle, typesWanted, -1, -1);
    }

    public static HandleResponse resolveHandle(String handle, long[] typesWanted, int protocol, int method) throws HandleException {
        if (method < 0) {
            method = HandleConfiguration.getPreferredResolutionMethod();
        }
        if (protocol < 0) {
            protocol = HandleConfiguration.getPreferredProtocol();
        }
        HandleResolver resolver = new HandleResolver();
        resolver.protocol = protocol;
        if (method == 2) {
            return resolver.sendResolveRequest(handle, HandleConfiguration.getSpecificServerInfo(), typesWanted, null, 0);
        }
        if (method == 1) {
            return resolver.resolveHandleGlobally(handle, typesWanted);
        }
        return resolver.sendResolveRequestToService(handle, typesWanted, HandleConfiguration.getSpecificServiceTable());
    }

    public HandleResponse sendResolveRequestToService(String handle, long[] typesWanted, ServerHashtable table) throws HandleException {
        HashBucket[] serverBuckets;
        if (table == null) {
            throw new HandleException(7, "Got null service table");
        }
        try {
            serverBuckets = table.determineServer(handle, this.queryOptions);
        }
        catch (Exception e) {
            throw new HandleException(7, "Error(" + e + ") determining server within service for handle " + handle);
        }
        if (serverBuckets.length <= 0) {
            throw new HandleException(19, "No responsible servers found for handle \"" + handle + "\"");
        }
        for (int i = 0; i < serverBuckets.length; ++i) {
            try {
                HandleResponse response = this.sendResolveRequest(handle, serverBuckets[i], typesWanted, null, 0);
                if (response.errorCode == 4) {
                    HashBucket responsibleServer = new HashBucket();
                    responsibleServer.setFromForwardingInfo(response);
                    response = this.sendResolveRequest(handle, responsibleServer, typesWanted, null, 0);
                    if (response != null) {
                        response.requestWasForwarded = true;
                    }
                }
                if (!response.haveAllPackets() && (i != serverBuckets.length - 1 || !response.haveSomePackets())) continue;
                return response;
            }
            catch (HandleException e) {
                if (e.getCode() == 2) {
                    if (HandleResolutionInfo.DEBUG) {
                        HandleResolutionInfo.out.println("Error sending query request: " + e);
                    }
                    if (i != serverBuckets.length - 1) continue;
                    throw new HandleException(2, e.getMessage());
                }
                throw e;
            }
        }
        throw new HandleException(11, "Unable to get value for handle: \"" + handle + "\"");
    }

    public HandleResponse resolveHandleWithDefaultMethod(String handle, long[] typesWanted) throws HandleException {
        int method = HandleConfiguration.getPreferredResolutionMethod();
        if (method == 2) {
            return this.sendResolveRequest(handle, HandleConfiguration.getSpecificServerInfo(), typesWanted, null, 0);
        }
        if (method == 1) {
            return this.resolveHandleGlobally(handle, typesWanted);
        }
        return this.sendResolveRequestToService(handle, typesWanted, HandleConfiguration.getSpecificServiceTable());
    }

    public HandleResponse resolveHandleUsingService(String handle, long[] typesWanted, ServerHashtable serviceTable) throws HandleException {
        return this.sendResolveRequestToService(handle, typesWanted, serviceTable);
    }

    public HandleResponse resolveHandleGlobally(String handle, long[] typesWanted) throws HandleException {
        int slashIndex = handle.indexOf(47);
        if (slashIndex < 0) {
            throw new HandleException(1, "Handle \"" + handle + "\" contains no slash");
        }
        String authority = handle.substring(0, slashIndex);
        if (authority.toUpperCase().equals("HA.AUTH") || authority.toUpperCase().equals("HA.SERV")) {
            return this.sendResolveRequestToService(handle, typesWanted, HandleConfiguration.getGlobalHashTable());
        }
        ServerHashtable localService = this.findService(authority);
        if (typesWanted != null && typesWanted.length > 0) {
            long[] newTypes = new long[typesWanted.length + 3];
            System.arraycopy(typesWanted, 0, newTypes, 0, typesWanted.length);
            newTypes[newTypes.length - 3] = 11L;
            newTypes[newTypes.length - 2] = 10L;
            newTypes[newTypes.length - 1] = 9L;
            typesWanted = newTypes;
        }
        HandleResponse localResponse = this.sendResolveRequestToService(handle, typesWanted, localService);
        if (localResponse.errorCode != 0) {
            if (HandleResolutionInfo.DEBUG) {
                HandleResolutionInfo.out.println("Got error response from server: " + localResponse.errorCode);
            }
            return localResponse;
        }
        HandleElementSet items = localResponse.getPackagedData();
        if (items == null) {
            return localResponse;
        }
        boolean gotRedirect = false;
        HandleElement svcElement = items.getElementOfType(11L);
        if (svcElement == null) {
            svcElement = items.getElementOfType(10L);
            if (svcElement != null) {
                try {
                    localService = HandleResolver.extractServerTable(this.getServicePointerForAuthority(new String(svcElement.handleValue, "UTF8")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new HandleException(7, "unable to decode UTF8 string");
                }
                gotRedirect = true;
            }
        } else {
            localService = HandleResolver.extractServerTable(svcElement.handleValue);
            gotRedirect = true;
        }
        if (gotRedirect) {
            localResponse = this.sendResolveRequestToService(handle, typesWanted, localService);
        }
        return localResponse;
    }

    public byte[] getServicePointerForAuthority(String authority) throws HandleException {
        long[] typesWanted = new long[]{11L, 10L};
        HandleResponse response = this.sendResolveRequestToService(authority, typesWanted, HandleConfiguration.getGlobalHashTable());
        if (response.errorCode != 0) {
            throw new HandleException(24, "Got error code " + response.errorCode + " (" + Codes.getHPCodeDescription(response.errorCode) + ") while retrieving service information");
        }
        HandleElementSet items = response.getPackagedData();
        if (items == null) {
            throw new HandleException(2, "incomplete response querying service info for authority: \"" + authority + "\"");
        }
        HandleElement element = items.getElementOfType(11L);
        if (element != null) {
            return element.handleValue;
        }
        element = items.getElementOfType(10L);
        if (element != null) {
            typesWanted = new long[]{11L};
            try {
                response = this.sendResolveRequestToService(new String(element.handleValue, "UTF8"), typesWanted, HandleConfiguration.getGlobalHashTable());
            }
            catch (UnsupportedEncodingException e) {
                throw new HandleException(7, "unable to decode UTF8 string");
            }
            if (response != null && (items = response.getPackagedData()) != null && (element = items.getElementOfType(11L)) != null) {
                return element.handleValue;
            }
        }
        throw new HandleException(24, "Unable to find service info for naming authority \"" + authority + "\"");
    }

    public HandleResponse getServicePointerResponseForAuthority(String authority, boolean getAllTypes) throws HandleException {
        long[] typesWanted = null;
        if (!getAllTypes) {
            typesWanted = new long[]{11L, 10L};
        }
        HandleResponse response = this.sendResolveRequestToService(authority, typesWanted, HandleConfiguration.getGlobalHashTable());
        if (response.errorCode != 0) {
            throw new HandleException(24, "Got error code " + response.errorCode + " (" + Codes.getHPCodeDescription(response.errorCode) + ") while retrieving service information");
        }
        HandleElementSet items = response.getPackagedData();
        if (items == null) {
            throw new HandleException(2, "incomplete response querying service info for authority \"" + authority + "\"");
        }
        HandleElement element = items.getElementOfType(11L);
        if (element != null) {
            return response;
        }
        element = items.getElementOfType(10L);
        if (element != null) {
            typesWanted = null;
            if (!getAllTypes) {
                typesWanted = new long[]{11L};
            }
            try {
                response = this.sendResolveRequestToService(new String(element.handleValue, "UTF8"), typesWanted, HandleConfiguration.getGlobalHashTable());
            }
            catch (UnsupportedEncodingException e) {
                throw new HandleException(7, "unable to decode UTF8 string");
            }
            if (response != null && (items = response.getPackagedData()) != null && (element = items.getElementOfType(11L)) != null) {
                return response;
            }
        }
        throw new HandleException(24, "Unable to find service info for naming authority \"" + authority + "\"");
    }
}

