/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoaderCallBack;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.NodeCreationCallback;
import nl.mpi.arbil.data.metadatafile.ImdiUtils;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.favourites.ArbilFavourites;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MetadataBuilder.class);
    private static final ResourceBundle services = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Services");
    private static MessageDialogHandler messageDialogHandler;
    private static WindowManager windowManager;
    private static SessionStorage sessionStorage;
    private static TreeHelper treeHelper;
    private static DataNodeLoader dataNodeLoader;
    private ArbilComponentBuilder arbilComponentBuilder = new ArbilComponentBuilder();

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public void requestRootAddNode(String nodeType, String nodeTypeDisplayName) {
        ArbilDataNode arbilDataNode = dataNodeLoader.createNewDataNode(sessionStorage.getNewArbilFileName(sessionStorage.getSaveLocation(""), nodeType));
        this.requestAddNode(arbilDataNode, nodeType, nodeTypeDisplayName);
    }

    public void requestAddRootNode(ArbilDataNode addableNode, String nodeTypeDisplayNameLocal) {
        this.creatAddAddableNodeThread(null, new String[]{nodeTypeDisplayNameLocal}, new ArbilDataNode[]{addableNode}).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAddChildNode(ArbilDataNode destinationNode, String nodeType) {
        String targetXmlPath = destinationNode.getURI().getFragment();
        Object object = destinationNode.getParentDomLockObject();
        synchronized (object) {
            if (nodeType.startsWith(".") && destinationNode.isCmdiMetaDataNode()) {
                return this.arbilComponentBuilder.canInsertChildComponent(destinationNode, targetXmlPath, nodeType);
            }
            if (destinationNode.getNodeTemplate().isArbilChildNode(nodeType) && destinationNode.getNodeTemplate().getMaxOccursForTemplate(nodeType) >= 0) {
                logger.debug("adding to current node");
                try {
                    Document nodDom = ArbilComponentBuilder.getDocument(destinationNode.getURI());
                    if (nodDom != null) {
                        return MetadataReader.getSingleInstance().canInsertFromTemplate(destinationNode.getNodeTemplate(), nodeType, targetXmlPath, nodDom);
                    }
                    messageDialogHandler.addMessageDialogToQueue(services.getString("THE METADATA FILE COULD NOT BE OPENED"), services.getString("ADD NODE"));
                }
                catch (ParserConfigurationException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                catch (SAXException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                catch (IOException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                catch (ArbilMetadataException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            return true;
        }
    }

    public void requestAddNode(final ArbilDataNode destinationNode, final String nodeType, final String nodeTypeDisplayName) {
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        new Thread("requestAddNode"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArbilDataNode addedNode = null;
                destinationNode.updateLoadingState(1);
                try {
                    Object object = destinationNode.getParentDomLockObject();
                    synchronized (object) {
                        try {
                            logger.debug("requestAddNode: {} : {}", (Object)nodeType, (Object)nodeTypeDisplayName);
                            addedNode = this.processAddNodes(destinationNode, nodeType, destinationNode.getURI().getFragment(), nodeTypeDisplayName, null, null, null);
                        }
                        catch (ArbilMetadataException exception) {
                            messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), services.getString("INSERT NODE ERROR"));
                        }
                    }
                }
                finally {
                    destinationNode.updateLoadingState(-1);
                }
                if (addedNode != null) {
                    destinationNode.triggerNodeAdded(addedNode);
                }
            }

            private ArbilDataNode processAddNodes(ArbilDataNode destinationNode2, String nodeType2, String targetXmlPath, String nodeTypeDisplayName2, String favouriteUrlString, String mimeType, URI resourceUri) throws ArbilMetadataException {
                String newTableTitleString = destinationNode2.isMetaDataNode() && destinationNode2.getFile().exists() ? MessageFormat.format(services.getString("NEW {0} IN {1}"), nodeTypeDisplayName2, destinationNode2.toString()) : MessageFormat.format(services.getString("NEW {0}"), nodeTypeDisplayName2);
                logger.debug("addQueue:-\nnodeType: " + nodeType2 + "\ntargetXmlPath: " + targetXmlPath + "\nnodeTypeDisplayName: " + nodeTypeDisplayName2 + "\nfavouriteUrlString: " + favouriteUrlString + "\nresourceUrl: " + resourceUri + "\nmimeType: " + mimeType);
                URI addedNodeUri = MetadataBuilder.this.addChildNode(destinationNode2, nodeType2, targetXmlPath, resourceUri, mimeType);
                ArbilDataNode addedArbilNode = dataNodeLoader.getArbilDataNodeWithoutLoading(addedNodeUri);
                this.refreshNodes(destinationNode2, addedArbilNode);
                windowManager.openFloatingTableOnce(new URI[]{addedNodeUri}, newTableTitleString);
                return addedArbilNode;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void refreshNodes(ArbilDataNode destinationNode2, ArbilDataNode addedArbilNode) {
                if (addedArbilNode != null) {
                    addedArbilNode.getParentDomNode().updateLoadingState(1);
                    try {
                        addedArbilNode.scrollToRequested = true;
                        if (destinationNode2.getFile().exists()) {
                            destinationNode2.getParentDomNode().loadArbilDom();
                        }
                        if (destinationNode2.getParentDomNode() != addedArbilNode.getParentDomNode()) {
                            addedArbilNode.getParentDomNode().loadArbilDom();
                        }
                    }
                    finally {
                        addedArbilNode.getParentDomNode().updateLoadingState(-1);
                    }
                }
            }
        }.start();
    }

    public void requestAddNode(ArbilDataNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode) {
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        this.requestAddNodes(destinationNode, new String[]{nodeTypeDisplayNameLocal}, new ArbilDataNode[]{addableNode});
    }

    public void requestAddNodeAndResources(ArbilNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode, File[] resourceFiles, boolean copyDirectoryStructure, boolean metadataFilePerResource) {
        if (destinationNode instanceof ArbilDataNode && ((ArbilDataNode)destinationNode).getNeedsSaveToDisk(false)) {
            ((ArbilDataNode)destinationNode).saveChangesToCache(true);
        }
        new Thread(this.creatAddNodeAndResources(destinationNode, nodeTypeDisplayNameLocal, addableNode, resourceFiles, copyDirectoryStructure, metadataFilePerResource), "AddNodeAndResources").start();
    }

    public void requestAddNodes(ArbilDataNode destinationNode, String nodeTypeDisplayName, ArbilDataNode[] addableNodes) {
        Object[] nodeTypeDisplayNames = new String[addableNodes.length];
        Arrays.fill(nodeTypeDisplayNames, nodeTypeDisplayName);
        this.requestAddNodes(destinationNode, (String[])nodeTypeDisplayNames, addableNodes);
    }

    public void requestAddNodes(ArbilDataNode destinationNode, String[] nodeTypeDisplayNames, ArbilDataNode[] addableNode) {
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        this.creatAddAddableNodeThread(destinationNode, nodeTypeDisplayNames, addableNode).start();
    }

    private Thread creatAddAddableNodeThread(final ArbilDataNode destinationNode, final String[] nodeTypeDisplayNames, final ArbilDataNode[] addableNodes) {
        return new Thread("requestAddNode"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (destinationNode != null) {
                        destinationNode.updateLoadingState(1);
                    }
                    MetadataBuilder.this.addNodes(destinationNode, nodeTypeDisplayNames, addableNodes);
                }
                catch (ArbilMetadataException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), services.getString("INSERT NODE ERROR"));
                }
                catch (IOException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), services.getString("INSERT NODE ERROR"));
                }
                catch (UnsupportedOperationException exception) {
                    messageDialogHandler.addMessageDialogToQueue(exception.getLocalizedMessage(), services.getString("INSERT NODE ERROR"));
                }
                finally {
                    if (destinationNode != null) {
                        destinationNode.updateLoadingState(-1);
                    }
                }
            }
        };
    }

    private Runnable creatAddNodeAndResources(ArbilNode destinationNode, String nodeTypeDisplayNameLocal, ArbilDataNode addableNode, File[] resourceFiles, boolean copyDirectoryStructure, boolean metadataFilePerResource) {
        return new Runnable(){

            public void run() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(ArbilDataNode destinationNode, String[] nodeTypeDisplayNames, ArbilDataNode[] addableNodes) throws ArbilMetadataException, IOException {
        if (destinationNode == null) {
            this.doAddNodes(null, nodeTypeDisplayNames, addableNodes);
        } else {
            Object object = destinationNode.getParentDomLockObject();
            synchronized (object) {
                this.doAddNodes(destinationNode, nodeTypeDisplayNames, addableNodes);
            }
        }
    }

    private void doAddNodes(ArbilDataNode destinationNode, String[] nodeTypeDisplayName, ArbilDataNode[] addableNode) throws ArbilMetadataException, IOException {
        ArrayList<ArbilDataNode> dataNodeMeta = null;
        ArrayList<ArbilDataNode> dataNodeNonMeta = null;
        ArrayList<String> nodeTypeDisplayNameNonMeta = null;
        for (int i = 0; i < nodeTypeDisplayName.length; ++i) {
            if (addableNode[i].isMetaDataNode()) {
                if (dataNodeMeta == null) {
                    dataNodeMeta = new ArrayList<ArbilDataNode>(addableNode.length);
                }
                dataNodeMeta.add(addableNode[i]);
                continue;
            }
            if (dataNodeNonMeta == null) {
                dataNodeNonMeta = new ArrayList<ArbilDataNode>(addableNode.length);
                nodeTypeDisplayNameNonMeta = new ArrayList<String>(nodeTypeDisplayName.length);
            }
            dataNodeNonMeta.add(addableNode[i]);
            nodeTypeDisplayNameNonMeta.add(nodeTypeDisplayName[i]);
        }
        if (dataNodeMeta != null && dataNodeMeta.size() > 0) {
            this.addMetaDataNode(destinationNode, (List<ArbilDataNode>)dataNodeMeta);
        }
        if (dataNodeNonMeta != null && dataNodeNonMeta.size() > 0) {
            this.addNonMetaDataNode(destinationNode, nodeTypeDisplayNameNonMeta, (List<ArbilDataNode>)dataNodeNonMeta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNonMetaDataNode(ArbilDataNode destinationNode, List<String> nodeTypeDisplayNames, List<ArbilDataNode> addableNodes) throws ArbilMetadataException {
        ArrayList<URI> addedNodeURIs = new ArrayList<URI>(addableNodes.size());
        destinationNode.getParentDomNode().updateLoadingState(1);
        try {
            for (int i = 0; i < addableNodes.size(); ++i) {
                ArbilDataNode addableNode = addableNodes.get(i);
                String nodeTypeDisplayName = nodeTypeDisplayNames.get(i);
                ArbilDataNode[] sourceArbilNodeArray = addableNode.isContainerNode() ? addableNode.getChildArray() : new ArbilDataNode[]{addableNode};
                for (ArbilDataNode currentArbilNode : sourceArbilNodeArray) {
                    String nodeType;
                    if (destinationNode.isCmdiMetaDataNode()) {
                        new ArbilComponentBuilder().insertResourceProxy(destinationNode, addableNode);
                        continue;
                    }
                    String favouriteUrlString = null;
                    URI resourceUri = null;
                    String mimeType = null;
                    if (currentArbilNode.isArchivableFile() && !currentArbilNode.isMetaDataNode()) {
                        nodeType = MetadataReader.getSingleInstance().getNodeTypeFromMimeType(currentArbilNode.mpiMimeType);
                        if (nodeType == null) {
                            nodeType = this.handleUnknownMimetype(currentArbilNode);
                        }
                        resourceUri = currentArbilNode.getURI();
                        mimeType = currentArbilNode.mpiMimeType;
                        nodeTypeDisplayName = "Resource";
                    } else {
                        nodeType = ArbilFavourites.getSingleInstance().getNodeType(currentArbilNode, destinationNode);
                        favouriteUrlString = currentArbilNode.getUrlString();
                    }
                    if (nodeType == null) continue;
                    String targetXmlPath = destinationNode.getURI().getFragment();
                    logger.debug("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName + " : " + favouriteUrlString + " : " + resourceUri);
                    URI addedNodeUri = this.addChildNode(destinationNode, nodeType, targetXmlPath, resourceUri, mimeType);
                    addedNodeURIs.add(addedNodeUri);
                }
            }
            destinationNode.scrollToRequested = true;
            destinationNode.getParentDomNode().loadArbilDom();
        }
        finally {
            destinationNode.getParentDomNode().updateLoadingState(-1);
        }
        if (addedNodeURIs.size() > 0) {
            String title = addedNodeURIs.size() == 1 ? MessageFormat.format(services.getString("NEW RESOURCE IN %S"), destinationNode) : MessageFormat.format(services.getString("NEW RESOURCES IN %S"), destinationNode);
            windowManager.openFloatingTableOnce(addedNodeURIs.toArray(new URI[0]), title);
        }
    }

    private String handleUnknownMimetype(ArbilDataNode currentArbilNode) {
        if (0 == messageDialogHandler.showDialogBox(MessageFormat.format(services.getString("THERE IS NO CONTROLLED VOCABULARY FOR EITHER WRITTEN RESOURCE OR MEDIA FILE THAT MATCH \"{0}\"."), currentArbilNode.mpiMimeType) + "\n" + services.getString("THIS PROBABLY MEANS THAT THE FILE IS NOT ARCHIVABLE. HOWEVER, YOU CAN PROCEED BY MANUALLY SELECTING THE RESOURCE TYPE.") + "\n\n" + services.getString("DO YOU WANT TO PROCEED?") + "\n\n" + services.getString("WARNING: DOING THIS WILL NOT GUARANTEE THAT YOUR DATA WILL BE UPLOADABLE TO THE CORPUS SERVER!"), services.getString("ADD RESOURCE"), 0, -1)) {
            String originalMime = currentArbilNode.mpiMimeType;
            currentArbilNode.mpiMimeType = null;
            if (new ImdiUtils().overrideTypecheckerDecision(new ArbilDataNode[]{currentArbilNode})) {
                return MetadataReader.getSingleInstance().getNodeTypeFromMimeType(currentArbilNode.mpiMimeType);
            }
            currentArbilNode.mpiMimeType = originalMime;
        }
        return null;
    }

    private void addMetaDataNode(ArbilDataNode destinationNode, List<ArbilDataNode> addableNodes) throws ArbilMetadataException, IOException {
        for (ArbilDataNode addableNode : addableNodes) {
            URI addedNodeUri;
            if (addableNode.getURI().getFragment() == null) {
                addedNodeUri = destinationNode != null ? sessionStorage.getNewArbilFileName(destinationNode.getSubDirectory(), addableNode.getURI().getPath()) : sessionStorage.getNewArbilFileName(sessionStorage.getSaveLocation(""), addableNode.getURI().getPath());
                ArbilDataNode.getMetadataUtils(addableNode.getURI().toString()).copyMetadataFile(addableNode.getURI(), new File(addedNodeUri), null, true);
                ArbilDataNode addedNode = dataNodeLoader.getArbilDataNodeWithoutLoading(addedNodeUri);
                new ArbilComponentBuilder().removeArchiveHandles(addedNode);
                if (destinationNode == null) {
                    treeHelper.addLocation(addedNodeUri);
                    treeHelper.applyRootLocations();
                } else {
                    destinationNode.metadataUtils.addCorpusLink(destinationNode.getURI(), new URI[]{addedNodeUri});
                }
                addedNode.loadArbilDom();
                addedNode.scrollToRequested = true;
            } else {
                if (destinationNode == null) {
                    logger.warn("Attempt to add child node to local corpus root");
                    return;
                }
                addedNodeUri = this.arbilComponentBuilder.insertFavouriteComponent(destinationNode, addableNode);
                new ArbilComponentBuilder().removeArchiveHandles(destinationNode);
            }
            if (destinationNode != null) {
                destinationNode.getParentDomNode().loadArbilDom();
            }
            String newTableTitleString = "new " + addableNode + (destinationNode == null ? "" : " in " + destinationNode);
            windowManager.openFloatingTableOnce(new URI[]{addedNodeUri}, newTableTitleString);
        }
    }

    public URI addChildNode(ArbilDataNode destinationNode, String nodeType, String targetXmlPath, URI resourceUri, String mimeType) throws ArbilMetadataException {
        return this.addChildNode(destinationNode, nodeType, targetXmlPath, resourceUri, mimeType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addChildNode(ArbilDataNode destinationNode, String nodeType, String targetXmlPath, URI resourceUri, String mimeType, final NodeCreationCallback creationCallback) throws ArbilMetadataException {
        logger.debug("addChildNode:: {} : {}", (Object)nodeType, (Object)resourceUri);
        logger.debug("targetXmlPath:: {}", (Object)targetXmlPath);
        if (destinationNode.getNeedsSaveToDisk(false)) {
            destinationNode.saveChangesToCache(true);
        }
        URI addedNodePath = null;
        destinationNode.updateLoadingState(1);
        try {
            Object object = destinationNode.getParentDomLockObject();
            synchronized (object) {
                block27: {
                    if (destinationNode.getNeedsSaveToDisk(false)) {
                        destinationNode.saveChangesToCache(false);
                    }
                    if (nodeType.startsWith(".") && destinationNode.isCmdiMetaDataNode()) {
                        addedNodePath = this.arbilComponentBuilder.insertChildComponent(destinationNode, targetXmlPath, nodeType);
                    } else if (destinationNode.getNodeTemplate().isArbilChildNode(nodeType) || resourceUri != null && destinationNode.isSession()) {
                        logger.debug("adding to current node");
                        try {
                            Document nodDom = ArbilComponentBuilder.getDocument(destinationNode.getURI());
                            if (nodDom == null) {
                                messageDialogHandler.addMessageDialogToQueue(services.getString("THE METADATA FILE COULD NOT BE OPENED"), services.getString("ADD NODE"));
                                break block27;
                            }
                            addedNodePath = MetadataReader.getSingleInstance().insertFromTemplate(destinationNode.getNodeTemplate(), destinationNode.getURI(), destinationNode.getSubDirectory(), nodeType, targetXmlPath, nodDom, resourceUri, mimeType);
                            destinationNode.bumpHistory();
                            ArbilComponentBuilder.savePrettyFormatting(nodDom, destinationNode.getFile());
                            if (creationCallback == null) {
                                dataNodeLoader.requestReload(destinationNode);
                                break block27;
                            }
                            final URI newNodePath = addedNodePath;
                            dataNodeLoader.requestReload(destinationNode, new ArbilDataNodeLoaderCallBack(){

                                public void dataNodeLoaded(ArbilDataNode reloadedDestinationNode) {
                                    creationCallback.nodeCreated(reloadedDestinationNode, newNodePath);
                                }
                            });
                        }
                        catch (ParserConfigurationException ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                        catch (SAXException ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                        catch (IOException ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                    } else {
                        logger.debug("adding new metadata node of type {} as reference to {}", (Object)nodeType, (Object)destinationNode);
                        if (!destinationNode.equals(destinationNode.getParentDomNode())) {
                            logger.error("Node type '{}' not a child node according to template. Destination node '{}' not a parent dom node.", (Object)nodeType, (Object)destinationNode);
                            throw new ArbilMetadataException("Cannot create reference on child node");
                        }
                        URI targetFileURI = sessionStorage.getNewArbilFileName(destinationNode.getSubDirectory(), nodeType);
                        if (CmdiProfileReader.pathIsProfile(nodeType)) {
                            try {
                                addedNodePath = this.arbilComponentBuilder.createComponentFile(targetFileURI, new URI(nodeType), false);
                            }
                            catch (URISyntaxException ex) {
                                throw new ArbilMetadataException(String.format("Error while adding node to metadata hierarchy. Node type %s not a valid URI", nodeType), ex);
                            }
                        } else {
                            addedNodePath = MetadataReader.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
                        }
                        if (addedNodePath == null) {
                            throw new ArbilMetadataException("A node of the requested could not be created. See previous messages for details.");
                        }
                        if (destinationNode.getFile().exists()) {
                            destinationNode.getParentDomNode().getMetadataUtils().addCorpusLink(destinationNode.getURI(), new URI[]{addedNodePath});
                            destinationNode.getParentDomNode().loadArbilDom();
                            if (creationCallback != null) {
                                creationCallback.nodeCreated(destinationNode, addedNodePath);
                            }
                        } else {
                            treeHelper.addLocation(addedNodePath);
                            treeHelper.applyRootLocations();
                        }
                    }
                }
            }
        }
        finally {
            destinationNode.updateLoadingState(-1);
        }
        return addedNodePath;
    }
}

