/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.ImageIcon;
import nl.mpi.arbil.ArbilIcons;

public class MetadataFormat {
    private static final Collection<FormatType> knownFormats = new CopyOnWriteArraySet<FormatType>(Arrays.asList(new FormatType(".imdi", ".METATRANSCRIPT", null, true), new FormatType(".cmdi", ".CMD.Components", ArbilIcons.clarinIcon, false), new FormatType(".xml", "", ArbilIcons.clarinIcon, false), new FormatType(".kmdi", ".Kinnate.CustomData", ArbilIcons.kinOathIcon, false), new FormatType(".trx", "", ArbilIcons.clarinIcon, false)));

    public static boolean isPathImdi(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.isImdi;
        }
        return false;
    }

    public static boolean isPathCmdi(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return !formatType.isImdi;
        }
        return false;
    }

    public static ImageIcon getFormatIcon(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.imageIcon;
        }
        return null;
    }

    public static String getMetadataStartPath(String urlString) {
        for (FormatType formatType : knownFormats) {
            if (!urlString.endsWith(formatType.suffixString)) continue;
            return formatType.metadataStartXpath;
        }
        return null;
    }

    public static boolean isPathMetadata(String urlString) {
        return MetadataFormat.isPathImdi(urlString) || MetadataFormat.isPathCmdi(urlString);
    }

    static class FormatType {
        private boolean isImdi;
        private String suffixString;
        private String metadataStartXpath;
        private ImageIcon imageIcon;

        public FormatType(String suffixString, String metadataStartXpath, ImageIcon imageIcon, boolean isImdi) {
            this.isImdi = isImdi;
            this.suffixString = suffixString;
            this.metadataStartXpath = metadataStartXpath;
            this.imageIcon = imageIcon;
        }
    }
}

