/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Container;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilRootNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.favourites.ArbilFavourites;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ImportExportDialog;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilDragDrop {
    private static final Logger logger = LoggerFactory.getLogger(ArbilDragDrop.class);
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private final SessionStorage sessionStorage;
    private final ArbilTreeHelper treeHelper;
    private final WindowManager windowManager;
    private final MessageDialogHandler dialogHandler;
    private final TableController tableController;
    private final DataFlavor dataNodeFlavour;
    private final ArbilNodeSelection arbilNodeSelection;

    public ArbilDragDrop(SessionStorage sessionStorage, ArbilTreeHelper treeHelper, WindowManager windowManager, MessageDialogHandler dialogHandler, TableController tableController) {
        this.sessionStorage = sessionStorage;
        this.treeHelper = treeHelper;
        this.windowManager = windowManager;
        this.dialogHandler = dialogHandler;
        this.tableController = tableController;
        this.dataNodeFlavour = new DataFlavor(ArbilDataNode.class, "ArbilDataNode");
        this.arbilNodeSelection = new ArbilNodeSelection();
    }

    public void addDrag(JTable tableSource) {
        tableSource.setDragEnabled(true);
        this.setTransferHandlerOnComponent(tableSource);
    }

    public void addDrag(JTree treeSource) {
        treeSource.setDragEnabled(true);
        this.setTransferHandlerOnComponent(treeSource);
        treeSource.addTreeSelectionListener(this.arbilNodeSelection);
        DropTarget target = treeSource.getDropTarget();
        try {
            target.addDropTargetListener(new DropTargetAdapter(){

                public void dragOver(DropTargetDragEvent dtdEvent) {
                    logger.debug("arbilNodeSelection.dropAllowed: {}", (Object)((ArbilDragDrop)ArbilDragDrop.this).arbilNodeSelection.dropAllowed);
                    if (((ArbilDragDrop)ArbilDragDrop.this).arbilNodeSelection.dropAllowed) {
                        dtdEvent.acceptDrag(dtdEvent.getDropAction());
                    } else {
                        dtdEvent.rejectDrag();
                    }
                }

                public void drop(DropTargetDropEvent e) {
                }
            });
        }
        catch (TooManyListenersException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    public void addDrag(JList listSource) {
        listSource.setDragEnabled(true);
        this.setTransferHandlerOnComponent(listSource);
    }

    public void setTransferHandlerOnComponent(JComponent targetComponent) {
        targetComponent.setTransferHandler(this.arbilNodeSelection);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArbilNodeSelection
    extends TransferHandler
    implements Transferable,
    TreeSelectionListener {
        long dragStartMilliSeconds;
        DataFlavor[] flavors;
        ArbilDataNode[] draggedArbilNodes;
        DefaultMutableTreeNode[] draggedTreeNodes;
        private boolean selectionDraggedFromLocalCorpus;
        private boolean selectionContainsArchivableLocalFile;
        private boolean selectionContainsLocalFile;
        private boolean selectionContainsLocalDirectory;
        private boolean selectionContainsArbilResource;
        private boolean selectionContainsArbilCorpus;
        private boolean selectionContainsImdiCatalogue;
        private boolean selectionContainsImdiSession;
        private boolean selectionContainsCmdiMetadata;
        private boolean selectionContainsArbilChild;
        private boolean selectionContainsLocal;
        private boolean selectionContainsRemote;
        private boolean selectionContainsFavourite;
        private JComponent currentDropTarget;
        protected boolean dropAllowed;

        private ArbilNodeSelection() {
            this.flavors = new DataFlavor[]{ArbilDragDrop.this.dataNodeFlavour};
            this.selectionDraggedFromLocalCorpus = false;
            this.selectionContainsArchivableLocalFile = false;
            this.selectionContainsLocalFile = false;
            this.selectionContainsLocalDirectory = false;
            this.selectionContainsArbilResource = false;
            this.selectionContainsArbilCorpus = false;
            this.selectionContainsImdiCatalogue = false;
            this.selectionContainsImdiSession = false;
            this.selectionContainsCmdiMetadata = false;
            this.selectionContainsArbilChild = false;
            this.selectionContainsLocal = false;
            this.selectionContainsRemote = false;
            this.selectionContainsFavourite = false;
            this.currentDropTarget = null;
            this.dropAllowed = false;
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (evt.getSource() == this.currentDropTarget) {
                logger.debug("Drag target selection change: {}", (Object)evt.getSource().toString());
                if (evt.getSource() instanceof ArbilTree) {
                    this.dropAllowed = this.canDropToTarget((ArbilTree)evt.getSource());
                }
            }
        }

        private boolean canDropToTarget(ArbilTree dropTree) {
            ArbilNode currentLeadSelection = dropTree.getLeadSelectionNode();
            if (currentLeadSelection instanceof ArbilRootNode) {
                if (ArbilDragDrop.this.treeHelper.componentIsTheFavouritesTree(this.currentDropTarget)) {
                    logger.debug("favourites tree check");
                    return !this.selectionContainsFavourite;
                }
                if (ArbilDragDrop.this.treeHelper.componentIsTheLocalCorpusTree(this.currentDropTarget)) {
                    logger.debug("local corpus tree check");
                    return this.selectionContainsFavourite && !this.draggedNodesContainsChildNode() || this.selectionContainsArbilCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsCmdiMetadata;
                }
                logger.debug("no tree check");
            } else if (currentLeadSelection instanceof ArbilDataNode) {
                logger.debug("currentLeadSelection: {}", (Object)currentLeadSelection);
                if (ArbilDragDrop.this.treeHelper.componentIsTheLocalCorpusTree(this.currentDropTarget)) {
                    if (currentLeadSelection.isCmdiMetaDataNode()) {
                        return ((ArbilDataNode)currentLeadSelection).canHaveResource();
                    }
                    if (((ArbilDataNode)currentLeadSelection).isDirectory) {
                        return false;
                    }
                    if (currentLeadSelection.isCorpus()) {
                        if ((this.selectionContainsArbilCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession) && !this.selectionContainsCmdiMetadata) {
                            return true;
                        }
                    } else {
                        if (currentLeadSelection.isCatalogue()) {
                            return false;
                        }
                        if (currentLeadSelection.isSession() ? this.selectionContainsArchivableLocalFile || this.selectionContainsArbilChild : (currentLeadSelection.isEmptyMetaNode() ? this.selectionContainsArbilChild : currentLeadSelection.isChildNode() && (this.selectionContainsLocalFile || this.selectionContainsArbilChild && this.selectionContainsFavourite))) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            logger.debug("exportToClipboard: {}", (Object)comp);
            this.createTransferable(null);
            if (comp instanceof ArbilTree) {
                ArbilTree sourceTree = (ArbilTree)comp;
                ArbilDataNode[] selectedArbilDataNodes = sourceTree.getSelectedNodes();
                if (selectedArbilDataNodes != null) {
                    sourceTree.copyNodeUrlToClipboard(selectedArbilDataNodes);
                }
            } else if (comp instanceof ArbilTable) {
                ArbilTable sourceTable = (ArbilTable)comp;
                ArbilDragDrop.this.tableController.copySelectedTableRowsToClipBoard(sourceTable);
            } else {
                super.exportToClipboard(comp, clip, action);
            }
        }

        @Override
        public int getSourceActions(JComponent c) {
            if (c instanceof JTree || c instanceof JTable || c instanceof JList) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] flavor) {
            logger.debug("canImport: {}", (Object)comp);
            this.currentDropTarget = null;
            this.dropAllowed = false;
            if (comp instanceof JTree) {
                if (ArbilDragDrop.this.treeHelper.componentIsTheLocalCorpusTree(comp)) {
                    logger.debug("localcorpustree so can drop here");
                    if (this.selectionContainsArchivableLocalFile || this.selectionContainsArbilCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsCmdiMetadata || this.selectionContainsArbilChild) {
                        logger.debug("dragged contents are acceptable");
                        this.currentDropTarget = comp;
                        this.dropAllowed = comp instanceof ArbilTree && this.canDropToTarget((ArbilTree)comp);
                        return true;
                    }
                }
                if (ArbilDragDrop.this.treeHelper.componentIsTheFavouritesTree(comp)) {
                    logger.debug("favourites tree so can drop here");
                    if (this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsCmdiMetadata || this.selectionContainsArbilChild) {
                        logger.debug("dragged contents are acceptable");
                        this.currentDropTarget = comp;
                        this.dropAllowed = this.canDropToTarget((ArbilTree)comp);
                        return true;
                    }
                }
            } else {
                if (comp instanceof ArbilTable) {
                    return ((ArbilTable)comp).isAllowNodeDrop();
                }
                this.dropAllowed = null != this.findArbilDropableTarget(comp);
                logger.debug("dropAllowed: {}", (Object)this.dropAllowed);
                return this.dropAllowed;
            }
            logger.debug("canImport false");
            return false;
        }

        private Container findArbilDropableTarget(Container tempCom) {
            while (tempCom != null) {
                if (tempCom instanceof ArbilSplitPanel || tempCom instanceof JDesktopPane) {
                    logger.debug("canImport true");
                    return tempCom;
                }
                tempCom = tempCom.getParent();
            }
            return null;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            this.dragStartMilliSeconds = System.currentTimeMillis();
            this.draggedArbilNodes = null;
            this.draggedTreeNodes = null;
            this.selectionDraggedFromLocalCorpus = false;
            this.selectionContainsArchivableLocalFile = false;
            this.selectionContainsLocalFile = false;
            this.selectionContainsLocalDirectory = false;
            this.selectionContainsArbilResource = false;
            this.selectionContainsArbilCorpus = false;
            this.selectionContainsImdiCatalogue = false;
            this.selectionContainsImdiSession = false;
            this.selectionContainsCmdiMetadata = false;
            this.selectionContainsArbilChild = false;
            this.selectionContainsLocal = false;
            this.selectionContainsRemote = false;
            this.selectionContainsFavourite = false;
            if (comp instanceof ArbilTree) {
                ArbilTree draggedTree = (ArbilTree)comp;
                if (draggedTree.getSelectionCount() <= 1 && (draggedTree.getSelectionCount() != 1 || draggedTree.getSelectionPath().getPathCount() <= 1)) {
                    return null;
                }
                this.draggedArbilNodes = new ArbilDataNode[draggedTree.getSelectionCount()];
                this.draggedTreeNodes = new DefaultMutableTreeNode[draggedTree.getSelectionCount()];
                for (int selectedCount = 0; selectedCount < draggedTree.getSelectionCount(); ++selectedCount) {
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)draggedTree.getSelectionPaths()[selectedCount].getLastPathComponent();
                    if (parentNode.getUserObject() instanceof ArbilDataNode) {
                        this.draggedArbilNodes[selectedCount] = (ArbilDataNode)parentNode.getUserObject();
                        this.draggedTreeNodes[selectedCount] = parentNode;
                        continue;
                    }
                    this.draggedArbilNodes[selectedCount] = null;
                    this.draggedTreeNodes[selectedCount] = null;
                }
                this.classifyTransferableContents();
                return this;
            }
            if (comp instanceof ArbilTable) {
                this.draggedArbilNodes = ((ArbilTable)comp).getSelectedRowsFromTable();
                this.classifyTransferableContents();
                return this;
            }
            if (comp instanceof JList) {
                Object[] selectedValues = ((JList)comp).getSelectedValues();
                this.draggedArbilNodes = new ArbilDataNode[selectedValues.length];
                for (int selectedNodeCounter = 0; selectedNodeCounter < selectedValues.length; ++selectedNodeCounter) {
                    if (!(selectedValues[selectedNodeCounter] instanceof ArbilDataNode)) continue;
                    this.draggedArbilNodes[selectedNodeCounter] = (ArbilDataNode)selectedValues[selectedNodeCounter];
                }
                this.classifyTransferableContents();
                return this;
            }
            return null;
        }

        private void classifyTransferableContents() {
            logger.debug("classifyTransferableContents");
            for (ArbilDataNode currentDraggedObject : this.draggedArbilNodes) {
                if (currentDraggedObject == null) continue;
                if (currentDraggedObject.isLocal()) {
                    this.selectionContainsLocal = true;
                    logger.debug("selectionContainsLocal");
                    if (currentDraggedObject.isDirectory()) {
                        this.selectionContainsLocalDirectory = true;
                        logger.debug("selectionContainsLocalDirectory");
                    } else if (!currentDraggedObject.isMetaDataNode()) {
                        this.selectionContainsLocalFile = true;
                        logger.debug("selectionContainsLocalFile");
                        if (currentDraggedObject.isArchivableFile()) {
                            this.selectionContainsArchivableLocalFile = true;
                            logger.debug("selectionContainsArchivableLocalFile");
                        }
                    }
                } else {
                    this.selectionContainsRemote = true;
                    logger.debug("selectionContainsRemote");
                }
                if (!currentDraggedObject.isMetaDataNode()) continue;
                if (currentDraggedObject.isChildNode()) {
                    this.selectionContainsArbilChild = true;
                    logger.debug("selectionContainsImdiChild");
                    if (currentDraggedObject.hasResource()) {
                        this.selectionContainsArbilResource = true;
                        logger.debug("selectionContainsImdiResource");
                    }
                } else if (currentDraggedObject.isSession()) {
                    this.selectionContainsImdiSession = true;
                    logger.debug("selectionContainsImdiSession");
                } else if (currentDraggedObject.isCmdiMetaDataNode()) {
                    this.selectionContainsCmdiMetadata = true;
                    logger.debug("selectionContainsCmdiMetadata");
                } else if (currentDraggedObject.isCatalogue()) {
                    this.selectionContainsImdiCatalogue = true;
                    logger.debug("selectionContainsImdiCatalogue");
                } else if (currentDraggedObject.isCorpus()) {
                    this.selectionContainsArbilCorpus = true;
                    logger.debug("selectionContainsImdiCorpus");
                }
                if (!currentDraggedObject.isFavorite()) continue;
                this.selectionContainsFavourite = true;
                logger.debug("selectionContainsFavourite");
            }
            this.selectionDraggedFromLocalCorpus = this.draggedFromLocalCorpus();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (System.currentTimeMillis() - this.dragStartMilliSeconds < 100L) {
                return false;
            }
            try {
                logger.debug("importData: {}", (Object)comp);
                if (comp instanceof ArbilTable && this.draggedArbilNodes == null) {
                    ArbilDragDrop.this.tableController.pasteIntoSelectedTableRowsFromClipBoard((ArbilTable)comp);
                } else if (this.draggedArbilNodes != null) {
                    boolean bl = this.importNodes(comp);
                    return bl;
                }
            }
            catch (Exception ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
            }
            finally {
                this.createTransferable(null);
            }
            return false;
        }

        private boolean importNodes(JComponent comp) {
            if (comp instanceof ArbilTree && this.canDropToTarget((ArbilTree)comp)) {
                return this.importToTree((ArbilTree)comp);
            }
            Container target = this.findArbilDropableTarget(comp);
            if (target instanceof ArbilSplitPanel) {
                ArbilSplitPanel targetPanel = (ArbilSplitPanel)target;
                targetPanel.arbilTable.updateStoredColumnWidths();
                ArbilTableModel dropTableModel = targetPanel.arbilTable.getArbilTableModel();
                dropTableModel.addArbilDataNodes(this.draggedArbilNodes);
                return true;
            }
            if (target instanceof JDesktopPane) {
                ArbilDragDrop.this.windowManager.openFloatingTableOnce(this.draggedArbilNodes, null);
                return true;
            }
            return false;
        }

        private boolean importToTree(ArbilTree dropTree) {
            for (int draggedCounter = 0; draggedCounter < this.draggedArbilNodes.length; ++draggedCounter) {
                logger.debug("dragged: {}", (Object)this.draggedArbilNodes[draggedCounter]);
            }
            if (ArbilDragDrop.this.treeHelper.componentIsTheFavouritesTree(this.currentDropTarget)) {
                try {
                    boolean resultValue = ArbilFavourites.getSingleInstance().toggleFavouritesList(this.draggedArbilNodes, true);
                    return resultValue;
                }
                catch (ArbilMetadataException ex) {
                    logger.error("Error while adding favourite", (Throwable)ex);
                    return false;
                }
            }
            return this.importToLocalTree(dropTree);
        }

        private boolean draggedFromLocalCorpus() {
            if (this.draggedTreeNodes != null && this.draggedTreeNodes.length > 0) {
                return this.draggedTreeNodes[0].getRoot() == ArbilDragDrop.this.treeHelper.getLocalCorpusTreeModel().getRoot();
            }
            return false;
        }

        private boolean draggedNodesContainsChildNode() {
            if (this.draggedTreeNodes != null) {
                for (DefaultMutableTreeNode node : this.draggedTreeNodes) {
                    if (!(node.getUserObject() instanceof ArbilNode) || !((ArbilNode)node.getUserObject()).isChildNode()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean importToLocalTree(ArbilTree dropTree) {
            ArbilDataNode dropTargetDataNode;
            DefaultMutableTreeNode targetNode = ArbilDragDrop.this.treeHelper.getLocalCorpusTreeSingleSelection();
            Object dropTargetUserObject = targetNode.getUserObject();
            Vector<ArbilDataNode> importNodeList = new Vector<ArbilDataNode>();
            Hashtable<ArbilDataNode, Vector<ArbilDataNode>> arbilNodesDeleteList = new Hashtable<ArbilDataNode, Vector<ArbilDataNode>>();
            logger.debug("to: {}", dropTargetUserObject);
            if (!(dropTargetUserObject instanceof ArbilNode)) {
                return false;
            }
            ArbilNode dropTargetNode = (ArbilNode)dropTargetUserObject;
            ArbilDataNode arbilDataNode = dropTargetDataNode = dropTargetNode instanceof ArbilDataNode ? (ArbilDataNode)dropTargetNode : null;
            if (dropTargetDataNode != null && (dropTargetDataNode.getParentDomNode().isCmdiMetaDataNode() && !this.selectionDraggedFromLocalCorpus || dropTargetDataNode.isSession() || ".METATRANSCRIPT.Session.Resources.MediaFile".equals(dropTargetDataNode.getURI().getFragment())) && this.selectionContainsArchivableLocalFile && this.selectionContainsLocalFile && !this.selectionContainsLocalDirectory && !this.selectionContainsArbilResource && !this.selectionContainsArbilCorpus && !this.selectionContainsImdiSession && !this.selectionContainsArbilChild && this.selectionContainsLocal && !this.selectionContainsRemote) {
                logger.debug("ok to add local file");
                logger.debug("dragged: {}", (Object)this.draggedArbilNodes);
                new MetadataBuilder().requestAddNodes(dropTargetDataNode, widgets.getString("RESOURCE"), this.draggedArbilNodes);
                return true;
            }
            if (!(this.selectionContainsArchivableLocalFile && !this.selectionDraggedFromLocalCorpus || this.selectionContainsLocalDirectory || this.selectionContainsArbilResource || this.selectionContainsArbilCorpus && this.selectionContainsImdiSession)) {
                logger.debug("ok to move local IMDI");
                boolean moveMultiple = this.draggedArbilNodes.length > 1;
                boolean moveAll = false;
                boolean continueMove = true;
                for (int draggedCounter = 0; continueMove && draggedCounter < this.draggedArbilNodes.length; ++draggedCounter) {
                    ArbilDataNode currentNode = this.draggedArbilNodes[draggedCounter];
                    logger.debug("dragged: {}", (Object)currentNode);
                    if (currentNode.isChildNode() && (dropTargetDataNode == null || !MetadataReader.getSingleInstance().nodeCanExistInNode(dropTargetDataNode, currentNode))) continue;
                    boolean draggedIntoSelf = false;
                    for (DefaultMutableTreeNode ancestorNode = targetNode; ancestorNode != null; ancestorNode = (DefaultMutableTreeNode)ancestorNode.getParent()) {
                        if (!this.draggedTreeNodes[draggedCounter].equals(ancestorNode)) continue;
                        draggedIntoSelf = true;
                        logger.debug("found ancestor: {}:{}", (Object)this.draggedTreeNodes[draggedCounter], (Object)ancestorNode);
                    }
                    if (draggedIntoSelf) continue;
                    if (currentNode.isFavorite()) {
                        if (dropTargetNode instanceof ArbilRootNode) {
                            new MetadataBuilder().requestAddRootNode(currentNode, currentNode.toString());
                            continue;
                        }
                        if (dropTargetDataNode != null) {
                            new MetadataBuilder().requestAddNode(dropTargetDataNode, currentNode.toString(), currentNode);
                            continue;
                        }
                        BugCatcherManager.getBugCatcher().logError("Cannot handle node type for drag/drop: " + dropTargetNode.getClass().toString(), null);
                        continue;
                    }
                    if (!(this.draggedFromLocalCorpus() || currentNode.isLocal() && ArbilDragDrop.this.sessionStorage.pathIsInsideCache(currentNode.getFile()))) {
                        importNodeList.add(currentNode);
                        continue;
                    }
                    String targetNodeName = dropTargetNode.toString();
                    int detailsOption = 1;
                    if (!moveAll) {
                        Object[] objectArray;
                        JFrame jFrame = ArbilDragDrop.this.windowManager.getMainFrame();
                        String string = MessageFormat.format(widgets.getString("MOVE_SOURCE_NODE_TO_TARGET_NODE"), this.draggedTreeNodes[draggedCounter].getUserObject(), targetNodeName);
                        if (moveMultiple) {
                            Object[] objectArray2 = new Object[4];
                            objectArray2[0] = widgets.getString("MOVE");
                            objectArray2[1] = widgets.getString("MOVE ALL");
                            objectArray2[2] = widgets.getString("SKIP");
                            objectArray = objectArray2;
                            objectArray2[3] = widgets.getString("ABORT");
                        } else {
                            Object[] objectArray3 = new Object[2];
                            objectArray3[0] = widgets.getString("MOVE");
                            objectArray = objectArray3;
                            objectArray3[1] = widgets.getString("CANCEL");
                        }
                        detailsOption = JOptionPane.showOptionDialog(jFrame, string, "Arbil", -1, -1, null, objectArray, moveMultiple ? widgets.getString("SKIP") : widgets.getString("CANCEL"));
                        moveAll = moveMultiple && detailsOption == 1;
                        boolean bl = continueMove = !moveMultiple || detailsOption != 3;
                    }
                    if (!continueMove || !moveAll && detailsOption != 0) continue;
                    try {
                        this.doMoveLocalNodes(dropTargetUserObject, dropTargetDataNode, currentNode, draggedCounter, arbilNodesDeleteList);
                        continue;
                    }
                    catch (IOException ex) {
                        logger.error("Error moving {}", (Object)currentNode, (Object)ex);
                        continueMove = ArbilDragDrop.this.dialogHandler.showConfirmDialogBox(MessageFormat.format(widgets.getString("COULD NOT MOVE %S DUE TO ERROR. SEE LOG FOR DETAILS. CONTINUE MOVING NODES?"), currentNode), widgets.getString("ERROR MOVING NODES"));
                    }
                }
                if (importNodeList.size() > 0) {
                    try {
                        ImportExportDialog importExportDialog = new ImportExportDialog(dropTree);
                        if (dropTargetDataNode != null) {
                            importExportDialog.setDestinationNode(dropTargetDataNode);
                        }
                        importExportDialog.copyToCache(importNodeList);
                    }
                    catch (Exception e) {
                        logger.error("Exception while showing import dialog", (Throwable)e);
                    }
                }
                this.deleteMovedNodesOriginals(arbilNodesDeleteList);
                if (dropTargetDataNode != null) {
                    dropTargetDataNode.reloadNode();
                } else {
                    ArbilDragDrop.this.treeHelper.applyRootLocations();
                }
                return true;
            }
            return false;
        }

        private void doMoveLocalNodes(Object dropTargetUserObject, ArbilDataNode dropTargetDataNode, ArbilDataNode currentNode, int draggedCounter, Hashtable<ArbilDataNode, Vector<ArbilDataNode>> arbilNodesDeleteList) throws IOException {
            boolean addNodeResult = false;
            if (dropTargetUserObject instanceof ArbilDataNode) {
                if (dropTargetDataNode.isCorpus()) {
                    addNodeResult = dropTargetDataNode.addCorpusLink(currentNode);
                } else if (!dropTargetDataNode.isCmdiMetaDataNode() && (dropTargetDataNode.isEmptyMetaNode() || dropTargetDataNode.isSession())) {
                    if (MetadataReader.getSingleInstance().nodeCanExistInNode(dropTargetDataNode, currentNode)) {
                        try {
                            new MetadataBuilder().addNodes(dropTargetDataNode, new String[]{currentNode.toString()}, new ArbilDataNode[]{currentNode});
                            addNodeResult = true;
                        }
                        catch (ArbilMetadataException ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                            ArbilDragDrop.this.dialogHandler.addMessageDialogToQueue(ex.getLocalizedMessage(), widgets.getString("INSERT NODE ERROR"));
                        }
                    }
                } else if (dropTargetDataNode.isCmdiMetaDataNode()) {
                    if (currentNode.isMetaDataNode() && !currentNode.isCmdiMetaDataNode()) {
                        ArbilDragDrop.this.dialogHandler.addMessageDialogToQueue(widgets.getString("MOVING IMDI METADATA TO CMDI METADATA FILES IS CURRENTLY NOT SUPPORTED"), widgets.getString("NOT SUPPORTED"));
                    } else if (currentNode.isCmdiMetaDataNode() && currentNode.isChildNode()) {
                        try {
                            addNodeResult = null != new ArbilComponentBuilder().insertFavouriteComponent(dropTargetDataNode, currentNode);
                        }
                        catch (ArbilMetadataException ex) {
                            addNodeResult = false;
                        }
                    } else {
                        ArbilComponentBuilder arbilComponentBuilder = new ArbilComponentBuilder();
                        addNodeResult = null != arbilComponentBuilder.insertResourceProxy(dropTargetDataNode, currentNode);
                    }
                }
            } else {
                addNodeResult = ArbilDragDrop.this.treeHelper.addLocation(currentNode.getURI());
            }
            if (addNodeResult) {
                if (this.draggedTreeNodes[draggedCounter] != null) {
                    if (this.draggedTreeNodes[draggedCounter].getParent().equals(this.draggedTreeNodes[draggedCounter].getRoot())) {
                        logger.debug("dragged from root");
                        ArbilDragDrop.this.treeHelper.removeLocation(currentNode);
                        ArbilDragDrop.this.treeHelper.applyRootLocations();
                    } else {
                        ArbilDataNode parentNode = (ArbilDataNode)((DefaultMutableTreeNode)this.draggedTreeNodes[draggedCounter].getParent()).getUserObject();
                        logger.debug("removeing from parent: {}", (Object)parentNode);
                        if (!arbilNodesDeleteList.containsKey(parentNode)) {
                            arbilNodesDeleteList.put(parentNode, new Vector());
                        }
                        arbilNodesDeleteList.get(parentNode).add(currentNode);
                    }
                }
            } else {
                BugCatcherManager.getBugCatcher().logError("Could not add node " + currentNode.toString() + " to target " + dropTargetUserObject.toString(), null);
            }
        }

        private void deleteMovedNodesOriginals(Hashtable<ArbilDataNode, Vector<ArbilDataNode>> arbilNodesDeleteList) {
            for (Map.Entry<ArbilDataNode, Vector<ArbilDataNode>> entry : arbilNodesDeleteList.entrySet()) {
                ArbilDataNode currentParent = entry.getKey();
                Vector<ArbilDataNode> children = entry.getValue();
                if (currentParent.isCorpus()) {
                    logger.debug("deleting by corpus link");
                    ArbilDataNode[] arbilNodeArray = children.toArray(new ArbilDataNode[0]);
                    currentParent.deleteCorpusLink(arbilNodeArray);
                    continue;
                }
                if (!currentParent.isMetaDataNode()) continue;
                ArbilDragDrop.this.treeHelper.deleteChildNodes(currentParent, children);
            }
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            logger.debug("getTransferData");
            if (this.isDataFlavorSupported(flavor)) {
                return this.draggedArbilNodes;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            logger.debug("getTransferDataFlavors");
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            logger.debug("isDataFlavorSupported");
            return this.flavors[0].equals(flavor);
        }
    }
}

