/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.importexport.ArbilToHtmlConverter;
import nl.mpi.arbil.data.metadatafile.ImdiUtils;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;
import nl.mpi.flap.plugin.PluginDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ArbilContextMenu
extends JPopupMenu {
    private static final Logger logger = LoggerFactory.getLogger(ArbilContextMenu.class);
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus");
    private static MessageDialogHandler dialogHandler;
    private static DataNodeLoader dataNodeLoader;
    private static WindowManager windowManager;
    protected ArbilDataNode[] selectedTreeNodes = null;
    protected ArbilDataNode leadSelectedDataNode = null;
    private JMenuItem browseForResourceFileMenuItem = new JMenuItem();
    private JMenuItem viewXmlMenuItem = new JMenuItem();
    private JMenuItem viewXmlMenuItemFormatted = new JMenuItem();
    private JMenuItem openInExternalApplicationMenuItem = new JMenuItem();
    private JMenuItem openXmlMenuItemFormatted = new JMenuItem();
    private JMenuItem exportHtmlMenuItemFormatted = new JMenuItem();
    private JMenuItem overrideTypeCheckerDecision = new JMenuItem();
    private JMenuItem saveMenuItem = new JMenuItem();
    private LinkedHashMap<String, List<OrderedMenuItem>> itemsMap = new LinkedHashMap();
    protected static final String CATEGORY_NODE = "node";
    protected static final String CATEGORY_EDIT = "edit";
    protected static final String CATEGORY_ADD_FAVOURITES = "add+favourites";
    protected static final String CATEGORY_XML = "xml";
    protected static final String CATEGORY_DISK = "disk";
    protected static final String CATEGORY_REMOTE_CORPUS = "remote corpus";
    protected static final String CATEGORY_RESOURCE = "resource";
    protected static final String CATEGORY_WORKING_DIR = "working dir";
    protected static final String CATEGORY_TABLE_CELL_VIEW = "table cell1";
    protected static final String CATEGORY_TABLE_CELL_EDIT = "table cell2";
    protected static final String CATEGORY_TABLE_ROW = "table row";
    protected static final String CATEGORY_IMPORT = "import";
    protected static final int PRIORITY_TOP = 0;
    protected static final int PRIORITY_MIDDLE = 50;
    protected static final int PRIORITY_BOTTOM = 100;

    public static void setMessageDialogHandler(MessageDialogHandler dialogHandlerInstance) {
        dialogHandler = dialogHandlerInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setWindowManager(WindowManager windowManagerInstance) {
        windowManager = windowManagerInstance;
    }

    private void applyMenuItems() {
        boolean first = true;
        for (List<OrderedMenuItem> category : this.itemsMap.values()) {
            if (category.isEmpty()) continue;
            Collections.sort(category);
            if (!first) {
                this.add(new JSeparator());
            } else {
                first = false;
            }
            for (OrderedMenuItem item : category) {
                this.add(item.menuItem);
            }
        }
    }

    public void show(int posX, int posY) {
        this.setCommonInvisible();
        this.setAllInvisible();
        this.prepareItemCategories();
        this.setUpMenu();
        this.setUpCommonMenuItems();
        this.setUpCommonActions();
        this.applyMenuItems();
        this.configureMenuSeparators();
        super.show(this.getInvoker(), posX, posY);
        this.requestFocusInWindow();
    }

    protected abstract void setUpMenu();

    protected abstract void setAllInvisible();

    private void setUpCommonActions() {
        this.browseForResourceFileMenuItem.setText(menus.getString("BROWSE FOR RESOURCE FILE"));
        this.browseForResourceFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    File[] selectedFiles = dialogHandler.showFileSelectBox(menus.getString("SELECT RESOURCE FILE"), false, false, null, PluginDialogHandler.DialogueType.open, null);
                    if (selectedFiles != null && selectedFiles.length > 0) {
                        ArbilContextMenu.this.leadSelectedDataNode.resourceUrlField.setFieldValue(selectedFiles[0].toURL().toExternalForm(), true, false);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_RESOURCE, 0, this.browseForResourceFileMenuItem);
        this.saveMenuItem.setText(menus.getString("SAVE CHANGES TO DISK"));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode selectedNode : ArbilContextMenu.this.selectedTreeNodes) {
                        logger.debug("userObject: {}", (Object)selectedNode);
                        dataNodeLoader.requestReload(selectedNode.getParentDomNode());
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_DISK, 0, this.saveMenuItem);
        this.overrideTypeCheckerDecision.setText(menus.getString("OVERRIDE TYPE CHECKER DECISION"));
        this.overrideTypeCheckerDecision.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    new ImdiUtils().overrideTypecheckerDecision(ArbilContextMenu.this.selectedTreeNodes);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_WORKING_DIR, 0, this.overrideTypeCheckerDecision);
        this.openInExternalApplicationMenuItem.setText(menus.getString("OPEN IN EXTERNAL APPLICATION"));
        this.openInExternalApplicationMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilContextMenu.this.openFileInExternalApplication(ArbilContextMenu.this.selectedTreeNodes);
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_DISK, 100, this.openInExternalApplicationMenuItem);
        this.viewXmlMenuItem.setText(menus.getString("VIEW XML"));
        this.viewXmlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                        windowManager.openImdiXmlWindow(currentNode, false, false);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_XML, 0, this.viewXmlMenuItem);
        this.viewXmlMenuItemFormatted.setText(menus.getString("VIEW IMDI FORMATTED"));
        this.viewXmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                        windowManager.openImdiXmlWindow(currentNode, true, false);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_XML, 5, this.viewXmlMenuItemFormatted);
        this.openXmlMenuItemFormatted.setText(menus.getString("OPEN IMDI FORMATTED"));
        this.openXmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    for (ArbilDataNode currentNode : ArbilContextMenu.this.selectedTreeNodes) {
                        windowManager.openImdiXmlWindow(currentNode, true, true);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.addItem(CATEGORY_XML, 10, this.openXmlMenuItemFormatted);
        this.exportHtmlMenuItemFormatted.setText(menus.getString("EXPORT IMDI TO HTML"));
        this.exportHtmlMenuItemFormatted.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    URI uri = new ArbilToHtmlConverter().exportImdiToHtml(ArbilContextMenu.this.selectedTreeNodes);
                    if (uri != null) {
                        logger.debug("Converted to html in {}", (Object)uri.toString());
                        windowManager.openFileInExternalApplication(uri);
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                    dialogHandler.addMessageDialogToQueue(menus.getString("EXPORT TO HTML FAILED. CHECK THE ERROR LOG FOR DETAILS."), menus.getString("EXPORT FAILED"));
                }
            }
        });
        this.addItem(CATEGORY_XML, 15, this.exportHtmlMenuItemFormatted);
    }

    protected void setUpCommonMenuItems() {
        if (this.leadSelectedDataNode != null) {
            this.saveMenuItem.setVisible(this.leadSelectedDataNode.getNeedsSaveToDisk(false));
            if (this.leadSelectedDataNode.hasResource()) {
                this.browseForResourceFileMenuItem.setVisible(true);
            }
            if (!this.leadSelectedDataNode.isChildNode() && this.leadSelectedDataNode.isMetaDataNode()) {
                this.viewXmlMenuItem.setVisible(true);
                if (!this.leadSelectedDataNode.isCmdiMetaDataNode()) {
                    this.viewXmlMenuItemFormatted.setVisible(true);
                    this.openXmlMenuItemFormatted.setVisible(true);
                    this.exportHtmlMenuItemFormatted.setVisible(true);
                }
            }
            this.openInExternalApplicationMenuItem.setVisible(true);
            this.overrideTypeCheckerDecision.setVisible(!this.leadSelectedDataNode.isMetaDataNode() && this.leadSelectedDataNode.mpiMimeType == null);
        }
    }

    private void configureMenuSeparators() {
        boolean lastWasSeparator = true;
        Component lastVisibleComponent = null;
        for (Component currentComponent : this.getComponents()) {
            if (currentComponent instanceof JSeparator) {
                currentComponent.setVisible(!lastWasSeparator);
                lastWasSeparator = true;
            } else if (currentComponent.isVisible()) {
                lastWasSeparator = false;
            }
            if (!currentComponent.isVisible()) continue;
            lastVisibleComponent = currentComponent;
        }
        if (lastVisibleComponent != null && lastVisibleComponent instanceof JSeparator) {
            lastVisibleComponent.setVisible(false);
        }
    }

    private void openFileInExternalApplication(ArbilDataNode[] selectedNodes) {
        for (ArbilDataNode currentNode : selectedNodes) {
            URI targetUri = null;
            if (currentNode.hasResource()) {
                targetUri = currentNode.getFullResourceURI();
            } else {
                targetUri = currentNode.getURI();
                if (targetUri.getFragment() != null) {
                    try {
                        targetUri = new URI(targetUri.getScheme(), targetUri.getHost(), targetUri.getPath(), null);
                    }
                    catch (URISyntaxException ex) {
                        throw new AssertionError((Object)ex);
                    }
                }
            }
            windowManager.openFileInExternalApplication(targetUri);
        }
    }

    protected void setCommonInvisible() {
        this.viewXmlMenuItem.setVisible(false);
        this.viewXmlMenuItemFormatted.setVisible(false);
        this.openXmlMenuItemFormatted.setVisible(false);
        this.exportHtmlMenuItemFormatted.setVisible(false);
        this.overrideTypeCheckerDecision.setVisible(false);
        this.openInExternalApplicationMenuItem.setVisible(false);
        this.browseForResourceFileMenuItem.setVisible(false);
        this.saveMenuItem.setVisible(false);
    }

    protected void prepareItemCategories() {
        this.addItemCategory(CATEGORY_NODE);
        this.addItemCategory(CATEGORY_RESOURCE);
        this.addItemCategory(CATEGORY_EDIT);
        this.addItemCategory(CATEGORY_REMOTE_CORPUS);
        this.addItemCategory(CATEGORY_WORKING_DIR);
        this.addItemCategory(CATEGORY_TABLE_CELL_VIEW);
        this.addItemCategory(CATEGORY_TABLE_CELL_EDIT);
        this.addItemCategory(CATEGORY_TABLE_ROW);
        this.addItemCategory(CATEGORY_ADD_FAVOURITES);
        this.addItemCategory(CATEGORY_DISK);
        this.addItemCategory(CATEGORY_IMPORT);
        this.addItemCategory(CATEGORY_XML);
    }

    protected final void addItemCategory(String category) {
        if (!this.itemsMap.containsKey(category)) {
            this.itemsMap.put(category, new ArrayList());
        }
    }

    protected final void addItem(String category, int priority, JMenuItem item) {
        this.addItemCategory(category);
        this.itemsMap.get(category).add(new OrderedMenuItem(priority, item));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderedMenuItem
    implements Comparable<OrderedMenuItem> {
        private final JMenuItem menuItem;
        private final Integer itemPriority;

        private OrderedMenuItem(int priority, JMenuItem item) {
            this.menuItem = item;
            this.itemPriority = priority;
        }

        public int hashCode() {
            return this.itemPriority.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof OrderedMenuItem) {
                return this.itemPriority.equals(((OrderedMenuItem)o).itemPriority);
            }
            return false;
        }

        @Override
        public int compareTo(OrderedMenuItem o) {
            return this.itemPriority.compareTo(o.itemPriority);
        }
    }
}

