/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.batch.GenericBatch;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.FileOpt;
import net.handle.apps.gui.jwidget.DataListJPanel;
import net.handle.awt.AwtUtil;

public class BatchHandleJPanel
extends JPanel
implements ActionListener {
    BatchFileList batchFileList;
    BrowsePanel logFileBrowser;
    JRadioButton fileLogRadio;
    JRadioButton winLogRadio;
    JRadioButton stdoutLogRadio;
    TextArea logArea;
    JScrollPane logScrollPane;
    JButton submitButton;
    JButton stopButton;
    private HandleTool tool = null;
    private volatile GenericBatch currentBatch = null;
    private static volatile boolean stopSubmit = true;
    private Thread submitThread = null;

    public BatchHandleJPanel() {
        this(new HandleTool());
    }

    public BatchHandleJPanel(HandleTool tool) {
        this.tool = tool;
        GridBagLayout gridbag = new GridBagLayout();
        EtchedBorder etchBorder = new EtchedBorder();
        this.setLayout(gridbag);
        this.batchFileList = new BatchFileList();
        this.batchFileList.setBorder(new TitledBorder(new EtchedBorder(), " Batch File List "));
        this.submitButton = new JButton("Submit Batch");
        this.submitButton.addActionListener(this);
        this.stopButton = new JButton("Stop Batch");
        this.stopButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        JPanel submitPanel = new JPanel(gridbag);
        submitPanel.add((Component)this.submitButton, AwtUtil.getConstraints(1, 0, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        submitPanel.add((Component)this.stopButton, AwtUtil.getConstraints(2, 0, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
        this.fileLogRadio = new JRadioButton("File", false);
        this.fileLogRadio.addActionListener(this);
        this.stdoutLogRadio = new JRadioButton("Stdout", false);
        this.stdoutLogRadio.addActionListener(this);
        this.winLogRadio = new JRadioButton("Window", true);
        this.winLogRadio.addActionListener(this);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.fileLogRadio);
        bgroup.add(this.stdoutLogRadio);
        bgroup.add(this.winLogRadio);
        JPanel radioPanel = new JPanel(gridbag);
        radioPanel.add((Component)new JLabel("Output Log: "), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), 17, true, true));
        radioPanel.add((Component)this.fileLogRadio, AwtUtil.getConstraints(1, 0, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), 17, true, true));
        radioPanel.add((Component)this.stdoutLogRadio, AwtUtil.getConstraints(2, 0, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), 17, true, true));
        radioPanel.add((Component)this.winLogRadio, AwtUtil.getConstraints(3, 0, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), 17, true, true));
        this.logFileBrowser = new BrowsePanel("Log File:", true);
        this.logFileBrowser.setEnabled(false);
        this.logArea = new TextArea(15, 30);
        this.logArea.setEditable(false);
        JPanel logPanel = new JPanel(gridbag);
        logPanel.setBorder(new TitledBorder(new EtchedBorder(), " Batch Log "));
        logPanel.add((Component)radioPanel, AwtUtil.getConstraints(0, 0, 1.0, 0.1, 1, 1, new Insets(5, 5, 5, 5), true, true));
        logPanel.add((Component)this.logFileBrowser, AwtUtil.getConstraints(0, 1, 1.0, 0.1, 1, 1, new Insets(1, 5, 1, 5), true, true));
        logPanel.add((Component)this.logArea, AwtUtil.getConstraints(0, 2, 1.0, 1.0, 1, 3, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)submitPanel, AwtUtil.getConstraints(0, 0, 1.0, 0.1, 1, 1, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)this.batchFileList, AwtUtil.getConstraints(0, 1, 1.0, 0.1, 1, 2, new Insets(5, 5, 5, 5), true, true));
        this.add((Component)logPanel, AwtUtil.getConstraints(0, 3, 1.0, 1.0, 1, 5, new Insets(5, 5, 5, 5), true, true));
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.fileLogRadio || src == this.stdoutLogRadio || src == this.winLogRadio) {
            this.logFileBrowser.setEnabled(this.fileLogRadio.isSelected());
        } else if (src == this.submitButton) {
            stopSubmit = false;
            this.submitButton.setEnabled(false);
            this.stopButton.setEnabled(true);
            this.submitThread = new Thread(){

                public void run() {
                    BatchHandleJPanel.this.submitBatch();
                }
            };
            this.submitThread.start();
        } else if (src == this.stopButton) {
            stopSubmit = true;
            if (this.currentBatch != null) {
                this.currentBatch.stopBatch();
            }
            this.logArea.append("-->>>Stop batch process, waiting for finalization ...\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void submitBatch() {
        block41: {
            block38: {
                block32: {
                    block33: {
                        log = null;
                        batchReader = null;
                        try {
                            try {
                                block43: {
                                    block42: {
                                        vt = this.batchFileList.getItems();
                                        if (vt == null) break block42;
                                        if (vt.size() >= 1) break block43;
                                    }
                                    var20_5 = null;
                                    if (log == null) break block32;
                                    break block33;
                                }
                                if (this.fileLogRadio.isSelected()) {
                                    files = new File[1];
                                    if (this.logFileBrowser.getWriteFile(files) && files[0] != null) {
                                        log = new PrintWriter((Writer)new FileWriter(files[0]), true);
                                        this.logArea.append("\n-->>>Output log to file: " + files[0].getAbsolutePath() + "...\n\n");
                                    } else {
                                        log = new PrintWriter(new TextAreaOutputStream(this.logArea), true);
                                        this.logArea.append("\n-->>>Invalid log file: " + files[0].getAbsolutePath() + "\nOutput log to this window...\n\n");
                                    }
                                } else if (this.winLogRadio.isSelected()) {
                                    log = new PrintWriter(new TextAreaOutputStream(this.logArea), true);
                                    this.logArea.append("\n-->>>Output log to this window...\n\n");
                                } else {
                                    this.logArea.append("\n-->>>Output log to stdout...\n\n");
                                }
                                for (i = 0; i < vt.size() && !BatchHandleJPanel.stopSubmit; ++i) {
                                    block36: {
                                        batchFile = (File)vt.elementAt(i);
                                        try {
                                            try {
                                                this.logArea.append("\n-->>>Batch(" + batchFile.getAbsolutePath() + ") process started ...\n");
                                                calStart = Calendar.getInstance();
                                                currenttime = calStart.getTime().toString();
                                                timeStarted = System.currentTimeMillis();
                                                this.logArea.append("\n-->>>Started at " + currenttime + "\n");
                                                fin = new FileInputStream(batchFile);
                                                batchReader = new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8"));
                                                authInfo = this.tool.getAuthentication();
                                                this.currentBatch = new GenericBatch(batchReader, authInfo, log, this.tool.resolver.getSessionTracker());
                                                this.currentBatch.processBatch();
                                                calEnd = Calendar.getInstance();
                                                currenttime1 = calEnd.getTime().toString();
                                                this.logArea.append("\n-->>>Finished at " + currenttime1 + "\n");
                                                timeEnded = System.currentTimeMillis();
                                            }
                                            catch (Exception e1) {
                                                this.logArea.append("-->>>Batch caught exception: " + e1.getMessage());
                                                var17_25 = null;
                                                if (batchReader != null) {
                                                    try {
                                                        batchReader.close();
                                                    }
                                                    catch (Exception e1) {
                                                        // empty catch block
                                                    }
                                                }
                                                this.logArea.append("-->>>Batch(" + batchFile.getAbsolutePath() + ") process finished\n");
                                                continue;
                                            }
                                            var17_25 = null;
                                            if (batchReader == null) break block36;
                                        }
                                        catch (Throwable var16_27) {
                                            block37: {
                                                var17_25 = null;
                                                if (batchReader != null) {
                                                    ** try [egrp 4[TRYBLOCK] [4 : 533->540)] { 
lbl69:
                                                    // 1 sources

                                                    batchReader.close();
                                                    break block37;
lbl71:
                                                    // 1 sources

                                                    catch (Exception e1) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            this.logArea.append("-->>>Batch(" + batchFile.getAbsolutePath() + ") process finished\n");
                                            throw var16_27;
                                        }
                                        ** try [egrp 4[TRYBLOCK] [4 : 533->540)] { 
lbl77:
                                        // 1 sources

                                        batchReader.close();
                                        break block36;
lbl79:
                                        // 1 sources

                                        catch (Exception e1) {
                                            // empty catch block
                                        }
                                    }
                                    this.logArea.append("-->>>Batch(" + batchFile.getAbsolutePath() + ") process finished\n");
                                }
                                break block38;
                            }
                            catch (Throwable e) {
                                this.logArea.append("-->>>Caught exception: " + e.getMessage());
                                var20_7 = null;
                                if (log != null) {
                                    try {
                                        log.flush();
                                        log.close();
                                    }
                                    catch (Exception e2) {
                                        // empty catch block
                                    }
                                }
                                this.submitButton.setEnabled(true);
                                this.stopButton.setEnabled(false);
                                return;
                            }
                        }
                        catch (Throwable var19_28) {
                            block40: {
                                var20_8 = null;
                                if (log != null) {
                                    ** try [egrp 5[TRYBLOCK] [11 : 641->652)] { 
lbl105:
                                    // 1 sources

                                    log.flush();
                                    log.close();
                                    break block40;
lbl108:
                                    // 1 sources

                                    catch (Exception e2) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.submitButton.setEnabled(true);
                            this.stopButton.setEnabled(false);
                            throw var19_28;
                        }
                    }
                    ** try [egrp 5[TRYBLOCK] [11 : 641->652)] { 
lbl116:
                    // 1 sources

                    log.flush();
                    log.close();
                    break block32;
lbl119:
                    // 1 sources

                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                this.submitButton.setEnabled(true);
                this.stopButton.setEnabled(false);
                return;
            }
            var20_6 = null;
            if (log != null) {
                ** try [egrp 5[TRYBLOCK] [11 : 641->652)] { 
lbl129:
                // 1 sources

                log.flush();
                log.close();
                break block41;
lbl132:
                // 1 sources

                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        this.submitButton.setEnabled(true);
        this.stopButton.setEnabled(false);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Container c = f.getContentPane();
        c.add(new BatchHandleJPanel());
        f.setSize(500, 500);
        f.pack();
        f.setVisible(true);
    }

    class TextAreaOutputStream
    extends OutputStream {
        private TextArea textArea;

        TextAreaOutputStream(TextArea textArea) {
            this.textArea = textArea;
        }

        public void close() {
            this.textArea = null;
        }

        public void write(byte[] b) {
            this.textArea.append(new String(b));
        }

        public void write(byte[] b, int off, int len) {
            this.textArea.append(new String(b, off, len));
        }

        public void write(int b) {
            this.textArea.append(String.valueOf(b));
        }
    }

    class BatchFileList
    extends DataListJPanel
    implements ActionListener {
        BatchFileList() {
            int x = 0;
            int y = 0;
            GridBagLayout gridbag = new GridBagLayout();
            this.buttonPanel = new JPanel(gridbag);
            this.buttonPanel.add((Component)this.addItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
            this.buttonPanel.add((Component)this.editItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
            this.buttonPanel.add((Component)this.remItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
            this.buttonPanel.add((Component)this.viewItemButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
            this.buttonPanel.add((Component)this.clearButton, AwtUtil.getConstraints(x, y++, 1.0, 1.0, 1, 1, true, true));
            y = 0;
            this.savePanel = new JPanel(gridbag);
            this.savePanel.add((Component)this.saveButton, AwtUtil.getConstraints(x++, y, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
            this.savePanel.add((Component)this.loadButton, AwtUtil.getConstraints(x++, y, 1.0, 1.0, 1, 1, new Insets(5, 5, 5, 5), true, true));
            this.add((Component)this.pane, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 2, 10, true, true));
            this.add((Component)this.buttonPanel, AwtUtil.getConstraints(2, 0, 1.0, 1.0, 1, 10, true, true));
            this.add((Component)this.savePanel, AwtUtil.getConstraints(0, 11, 1.0, 1.0, 2, 1, true, true));
        }

        protected Object addData() {
            BrowsePanel browser = new BrowsePanel("Batch file: ", false);
            File[] files = new File[1];
            if (2 == JOptionPane.showConfirmDialog(this, browser, "Add batch file: ", 2, -1)) {
                return null;
            }
            if (!browser.getReadFile(files)) {
                return null;
            }
            return files[0];
        }

        protected Object modifyData(int ind) {
            File[] files = new File[1];
            File file = (File)this.items.elementAt(ind);
            BrowsePanel browser = new BrowsePanel("Batch: ", FileOpt.getParent(file), file.getName(), null, false);
            if (2 == JOptionPane.showConfirmDialog(this, browser, "Modify batch file: ", 2, -1)) {
                return null;
            }
            if (!browser.getReadFile(files)) {
                return null;
            }
            return files[0];
        }

        protected void viewData(int ind) {
            File file = (File)this.items.elementAt(ind);
            BrowsePanel browser = new BrowsePanel("Batch: ", FileOpt.getParent(file), file.getName(), null, false);
            JOptionPane.showMessageDialog(this, browser, "View batch file: ", -1);
        }

        protected boolean removeData(int ind) {
            return true;
        }

        protected void readData(File file) {
            BufferedReader in = null;
            if (file == null) {
                return;
            }
            int option = JOptionPane.showOptionDialog(this, "reset all or append as new", "Option :", 1, 3, null, new Object[]{"Reset All", "Append", "Cancel"}, "Reset All");
            if (option == 0) {
                this.clearAll();
            }
            try {
                FileInputStream fin = new FileInputStream(file);
                in = new BufferedReader(new InputStreamReader((InputStream)fin, "UTF-8"));
                String str = " ";
                while ((str = in.readLine()) != null) {
                    File f = new File(str);
                    if (f.exists() && f.canRead()) {
                        this.appendItem(f);
                        continue;
                    }
                    BatchHandleJPanel.this.logArea.append("Error: can not find the file->" + str + "\n");
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                try {
                    in.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return;
            }
        }

        protected void writeData(File file) {
        }
    }
}

