/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Vector;
import net.handle.hdllib.ParameterPair;
import net.handle.hdllib.ParameterSet;
import net.handle.util.StringUtils;

public abstract class ParameterParser {
    private static final String SECTION_DELIMITER_URI_CHARS = "?!#@^|&";

    public static ParameterSet parseParameters(String handleString) {
        int i;
        String parameterString = "";
        String handle = handleString;
        int atIndex = handleString.indexOf(64);
        int slashIndex = handleString.indexOf(47);
        if (slashIndex < 0) {
            return new ParameterSet(handleString, new ParameterPair[0], new ParameterPair[0], new ParameterPair[0]);
        }
        if (atIndex > 0 && atIndex < slashIndex) {
            parameterString = handle.substring(0, atIndex);
            handle = handle.substring(atIndex + 1);
        } else {
            if (atIndex < 0) {
                return new ParameterSet(handleString, new ParameterPair[0], new ParameterPair[0], new ParameterPair[0]);
            }
            if (atIndex == 0) {
                return new ParameterSet(handleString.substring(1), new ParameterPair[0], new ParameterPair[0], new ParameterPair[0]);
            }
        }
        int charIndex = 0;
        Vector handlePairs = new Vector();
        Vector defaultPairs = new Vector();
        Vector localPairs = new Vector();
        block4: while (charIndex < parameterString.length()) {
            int groupEnd;
            char ch = parameterString.charAt(charIndex);
            switch (ch) {
                case '(': {
                    groupEnd = parameterString.indexOf(41, charIndex);
                    if (groupEnd < 0) {
                        groupEnd = parameterString.length();
                    }
                    ParameterParser.parsePairs(parameterString.substring(charIndex + 1, groupEnd), handlePairs);
                    charIndex = groupEnd + 1;
                    continue block4;
                }
                case '{': {
                    groupEnd = parameterString.indexOf(125, charIndex);
                    if (groupEnd < 0) {
                        groupEnd = parameterString.length();
                    }
                    ParameterParser.parsePairs(parameterString.substring(charIndex + 1, groupEnd), localPairs);
                    charIndex = groupEnd + 1;
                    continue block4;
                }
            }
            int groupEnd1 = parameterString.indexOf(123, charIndex);
            int groupEnd2 = parameterString.indexOf(40, charIndex);
            groupEnd = parameterString.length();
            if (groupEnd1 > 0) {
                groupEnd = groupEnd1;
            }
            if (groupEnd2 > 0 && groupEnd2 < groupEnd) {
                groupEnd = groupEnd2;
            }
            ParameterParser.parsePairs(parameterString.substring(charIndex + 1, groupEnd), defaultPairs);
            charIndex = groupEnd + 1;
        }
        ParameterPair[] localPairArray = new ParameterPair[localPairs.size()];
        ParameterPair[] handlePairArray = new ParameterPair[handlePairs.size()];
        ParameterPair[] defaultPairArray = new ParameterPair[defaultPairs.size()];
        for (i = 0; i < localPairs.size(); ++i) {
            localPairArray[i] = (ParameterPair)localPairs.elementAt(i);
        }
        for (i = 0; i < handlePairs.size(); ++i) {
            handlePairArray[i] = (ParameterPair)handlePairs.elementAt(i);
        }
        for (i = 0; i < defaultPairs.size(); ++i) {
            defaultPairArray[i] = (ParameterPair)defaultPairs.elementAt(i);
        }
        return new ParameterSet(handle, defaultPairArray, handlePairArray, localPairArray);
    }

    public static ParameterSet parseHandleURI(String handleURI) {
        int i;
        int currIdx;
        int questionMarkEncountered = 0;
        boolean localParametersEntered = false;
        char[] chars = new char[handleURI.length()];
        handleURI.getChars(0, chars.length, chars, 0);
        int hdlStart = 0;
        for (currIdx = 0; currIdx < chars.length && SECTION_DELIMITER_URI_CHARS.indexOf(chars[currIdx]) < 0; ++currIdx) {
        }
        int hdlEnd = currIdx;
        String handle = StringUtils.decodeURLIgnorePlus(chars, hdlStart, hdlEnd - hdlStart);
        Vector handlePairs = null;
        Vector localPairs = null;
        block6: while (currIdx < chars.length) {
            char delim = chars[currIdx++];
            int paramStart = currIdx;
            while (currIdx < chars.length && SECTION_DELIMITER_URI_CHARS.indexOf(chars[currIdx]) < 0) {
                ++currIdx;
            }
            int paramEnd = currIdx;
            switch (delim) {
                case '?': {
                    if (++questionMarkEncountered != 1) continue block6;
                    if (handlePairs == null) {
                        handlePairs = new Vector();
                    }
                    ParameterParser.parsePairs(chars, paramStart, paramEnd, handlePairs);
                    continue block6;
                }
                case '&': {
                    if (questionMarkEncountered == 1) {
                        if (handlePairs == null) {
                            handlePairs = new Vector();
                        }
                        ParameterParser.parsePairs(chars, paramStart, paramEnd, handlePairs);
                    }
                    if (!localParametersEntered) continue block6;
                    if (localPairs == null) {
                        localPairs = new Vector();
                    }
                    ParameterParser.parsePairs(chars, paramStart, paramEnd, localPairs);
                    continue block6;
                }
                case '!': {
                    localParametersEntered = true;
                    if (localPairs == null) {
                        localPairs = new Vector();
                    }
                    ParameterParser.parsePairs(chars, paramStart, paramEnd, localPairs);
                    continue block6;
                }
            }
            System.err.println("unknown uri delimiter: " + delim);
        }
        ParameterPair[] handlePairArray = null;
        ParameterPair[] localPairArray = null;
        if (handlePairs != null) {
            handlePairArray = new ParameterPair[handlePairs.size()];
            for (i = 0; i < handlePairs.size(); ++i) {
                handlePairArray[i] = (ParameterPair)handlePairs.elementAt(i);
            }
        }
        if (localPairs != null) {
            localPairArray = new ParameterPair[localPairs.size()];
            for (i = 0; i < localPairs.size(); ++i) {
                localPairArray[i] = (ParameterPair)localPairs.elementAt(i);
            }
        }
        return new ParameterSet(handle, null, handlePairArray, localPairArray);
    }

    private static void parsePairs(String pairList, Vector pairVect) {
        int charIndex = 0;
        while (charIndex < pairList.length()) {
            int semIndex = pairList.indexOf(59, charIndex);
            int ampIndex = pairList.indexOf(38, charIndex);
            if (ampIndex >= 0 && ampIndex < semIndex) {
                semIndex = ampIndex;
            }
            if (semIndex < 0) {
                semIndex = pairList.length();
            }
            String thisPair = pairList.substring(charIndex, semIndex);
            charIndex = semIndex + 1;
            String name = "";
            String value = "";
            int eqIndex = thisPair.indexOf(61);
            if (eqIndex < 0) {
                value = thisPair;
            } else {
                name = thisPair.substring(0, eqIndex);
                value = thisPair.substring(eqIndex + 1);
            }
            pairVect.addElement(new ParameterPair(name, value));
        }
    }

    private static void parsePairs(char[] uri, int paramStart, int paramEnd, Vector pairVect) {
        ParameterPair pp;
        int idx = paramStart;
        int pairStart = paramStart;
        int eqIdx = -1;
        while (idx < paramEnd) {
            if (eqIdx < 0 && uri[idx] == '=') {
                eqIdx = idx;
            }
            if (uri[idx++] != ';') continue;
            pp = eqIdx >= 0 ? new ParameterPair(new String(uri, paramStart, eqIdx - paramStart), new String(uri, eqIdx + 1, idx - eqIdx - 1)) : new ParameterPair(new String(uri, paramStart, idx - paramStart - 1), "");
            pairVect.addElement(pp);
            paramStart = idx;
            eqIdx = -1;
        }
        if (paramStart != idx) {
            pp = eqIdx >= 0 ? new ParameterPair(new String(uri, paramStart, eqIdx - paramStart), new String(uri, eqIdx + 1, idx - eqIdx - 1)) : new ParameterPair(new String(uri, paramStart, idx - paramStart - 1), "");
            pairVect.addElement(pp);
        }
    }
}

