/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.DumpHandlesCallback;
import net.handle.hdllib.DumpHandlesRequest;
import net.handle.hdllib.DumpHandlesResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GenericResponse;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.NextTxnIdResponse;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.RetrieveTxnResponse;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.SessionExchangeKeyRequest;
import net.handle.hdllib.SessionInfo;
import net.handle.hdllib.SessionSetupRequest;
import net.handle.hdllib.SessionSetupResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionCallback;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;
import net.handle.security.HdlSecurityProvider;
import net.handle.server.AbstractServer;
import net.handle.server.HandleStorageFactory;
import net.handle.server.Main;
import net.handle.server.ReadOnlyTransactionQueue;
import net.handle.server.ServerSideSessionInfo;
import net.handle.server.SessionManager;
import net.handle.server.TransactionQueue;
import net.handle.util.IntTable;
import net.handle.util.StreamTable;
import net.handle.util.StreamVector;
import net.handle.util.StringUtils;

public final class HandleServer
extends AbstractServer {
    private static final byte[] MSG_INTERNAL_ERROR = Util.encodeString("Internal Error");
    private static final byte[] MSG_NOT_A_PRIMARY = Util.encodeString("Not a primary server");
    private static final byte[] MSG_SERVER_TEMPORARILY_DISABLED = Util.encodeString("Server temporarily disabled");
    private static final byte[] MSG_WRONG_SERVER_HASH = Util.encodeString("Request was hashed incorrectly");
    private static final byte[] MSG_NA_NOT_HOMED_HERE = Util.encodeString("That naming authority doesn't live here");
    private static final byte[] MSG_INDEXES_MUST_BE_POSITIVE = Util.encodeString("Value indexes must be non-negative");
    private static final byte[] MSG_EMPTY_VALUE_LIST = Util.encodeString("Value list was empty");
    private static final byte[] MSG_READ_ONLY_VALUE = Util.encodeString("Value is read-only");
    private static final byte[] MSG_NOT_A_NA_HANDLE = Util.encodeString("Handle is not a naming authority handle");
    private static final byte[] MSG_INVALID_ENCODING = Util.encodeString("Invalid UTF8 encoding");
    private static final byte[] MSG_INVALID_NA_HANDLE = Util.encodeString("Invalid naming authority handle");
    private static final byte[] MSG_SERVER_BACKUP = Util.encodeString("Server is doing backup now, only can resolve handles. Come back later");
    private static final byte[] MSG_NEED_RSA_EXCHANGEKEY = Util.encodeString("Invalid exchange key type. Need RSA public key.");
    private static final byte[] MSG_INVALID_SESSION_OR_TIMEOUT = Util.encodeString("Invalid session id or session time out. Please try again.");
    private static final byte[] MSG_NEED_LIST_HDLS_PERM = Util.encodeString("This server does not support the list handles operation.");
    public static final String CASE_SENSITIVE = "case_sensitive";
    public static final String SERVER_ADMIN_FULL_ACCESS = "server_admin_full_access";
    public static final String MAX_AUTH_TIME = "max_auth_time";
    public static final String THIS_SERVER_ID = "this_server_id";
    public static final String IS_PRIMARY = "is_primary";
    public static final String SERVER_ADMINS = "server_admins";
    public static final String BACKUP_ADMINS = "backup_admins";
    public static final String REPLICATION_ADMINS = "replication_admins";
    public static final String REPLICATION_INTERVAL = "replication_interval";
    public static final String DO_RECURSION = "allow_recursion";
    public static final String ALLOW_NA_ADMINS = "allow_na_admins";
    public static final String READ_ONLY_TXN_QUEUE = "read_only_txn_queue";
    public static final String ALLOW_LIST_HANDLES = "allow_list_hdls";
    public static final String PREFERRED_GLOBAL = "preferred_global";
    public static final String MAX_SESSION_TIME = "max_session_time";
    public static final String DB_TXN_QUEUE_DIR = "dbtxns";
    public static final String TXN_QUEUE_DIR = "txns";
    public static final String TXN_ID_FILE = "txn_id";
    public static final String STORAGE_FILE = "handles.jdb";
    public static final String NA_STORAGE_FILE = "nas.jdb";
    public static final String CACHE_STORAGE_FILE = "cache.jdb";
    public static final String STORAGE_FILE_BACKUP = "handles.jdb.backup";
    public static final String NA_STORAGE_FILE_BACKUP = "nas.jdb.backup";
    public static final String SITE_INFO_FILE = "siteinfo.bin";
    public static final String REPLICATION_FILE = "incoming.dct";
    public static final String LAST_TXN_ID = "last_txn_id";
    public static final String LAST_TIMESTAMP = "last_timestamp";
    public static final String REPLICATION_SOURCES = "sources";
    public static final String REPLICATION_AUTH = "replication_authentication";
    public static final String REPLICATION_SERVER_INFO_FILE = "txnsrcsv.bin";
    public static final String REPLICATION_STATUS_FILE = "txnstat.dct";
    public static final String REPLICATION_PRIV_KEY_FILE = "replpriv.bin";
    public static final String REPLICATION_SECRET_KEY_FILE = "replsec.bin";
    public static final String PRIVATE_KEY_FILE = "privkey.bin";
    public static final String REPLICATION_TIMEOUT = "replication_timeout";
    public static final String DO_REPLICATION = "do_replication";
    public static final int RECURSION_LIMIT = 10;
    public static final int LIST_HANDLES_PER_MSG = 50;
    private String TRANSACTION_LOCK;
    private String NEXT_TXN_ID_LOCK;
    private static final int NUM_DSA_AUTH_SIGNATURES = 20;
    private static final int NUM_SERVER_SIGNATURES = 50;
    private static final int[] DEL_HANDLE_PERM = new int[]{1};
    private static final int[] ADD_HANDLE_PERM = new int[]{0};
    private static final int[] READ_VAL_PERM = new int[]{7};
    private static final int[] ADD_ADM_PERM = new int[]{10};
    private static final int[] ADD_VAL_PERM = new int[]{6};
    private static final int[] ADD_ADM_AND_VAL_PERM = new int[]{10, 6};
    private static final int[] REM_VAL_PERM = new int[]{5};
    private static final int[] REM_ADM_PERM = new int[]{5};
    private static final int[] REM_ADM_AND_VAL_PERM = new int[]{9, 5};
    private static final int[] MOD_ADM_PERM = new int[]{8};
    private static final int[] MOD_VAL_PERM = new int[]{4};
    private static final int[] ADM_TO_VAL_PERM = new int[]{9, 4};
    private static final int[] VAL_TO_ADM_PERM = new int[]{4, 10};
    private static final int[] ADD_SUB_NA_PERM = new int[]{2};
    private static final int[] LIST_HDLS_PERM = new int[]{11};
    private static final byte[] SIGN_TEST = Util.encodeString("Testing...1..2..3");
    private GenericRequest nextTxnIdRequest;
    private boolean keepRunning;
    private boolean serverEnabled;
    private static int nextAuthId = 0;
    private long maxAuthTime;
    private HandleStorage storage;
    private IntTable pendingAuthorizations;
    private boolean caseSensitive;
    private boolean serverAdminFullAccess;
    private ValueReference[] serverAdmins;
    private ValueReference[] backupAdmins;
    private ValueReference[] replicationAdmins;
    private boolean useRSA;
    private TransactionQueueInterface txnQueue;
    private int currentSigIndex;
    private SiteInfo thisSite;
    private int thisServerNum;
    private PrivateKey privateKey;
    private Signature[] serverSignatures;
    private boolean allowRecursiveQueries;
    private boolean allowNAAdmins;
    private boolean allowListHdls;
    private String preferredGlobal;
    private boolean isPrimary;
    private boolean doReplication;
    private long nextTxnId;
    private File txnIdFile;
    private boolean nextTxnIdInitialized;
    private File replicationStatusFile;
    private File replicationSvrInfoFile;
    private AuthenticationInfo replicationAuth;
    private ReplicationDaemon replicationDaemon;
    private SiteInfo replicationSite;
    private long[] replicationLastTxnIds;
    private long[] replicationLastTimeStamps;
    private int replicationTimeout;
    private long replicationInterval;
    private SessionManager sessions;
    private String writeLock;
    static /* synthetic */ Class class$net$handle$hdllib$ResolutionResponse;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HandleServer(Main main, StreamTable config) throws Exception {
        Vector adminVect;
        int i;
        block76: {
            super(main, config);
            this.TRANSACTION_LOCK = "TRANSACTION_LOCK";
            this.NEXT_TXN_ID_LOCK = "NEXT_TXN_ID_LOCK";
            this.keepRunning = true;
            this.serverEnabled = true;
            this.caseSensitive = false;
            this.serverAdminFullAccess = false;
            this.serverAdmins = new ValueReference[0];
            this.backupAdmins = new ValueReference[0];
            this.replicationAdmins = new ValueReference[0];
            this.useRSA = false;
            this.currentSigIndex = 0;
            this.thisSite = null;
            this.thisServerNum = -1;
            this.privateKey = null;
            this.serverSignatures = null;
            this.allowRecursiveQueries = true;
            this.allowNAAdmins = true;
            this.allowListHdls = true;
            this.preferredGlobal = null;
            this.isPrimary = false;
            this.doReplication = false;
            this.nextTxnId = -1L;
            this.txnIdFile = null;
            this.nextTxnIdInitialized = false;
            this.replicationStatusFile = null;
            this.replicationSvrInfoFile = null;
            this.replicationSite = null;
            this.replicationTimeout = 300000;
            this.replicationInterval = 180000L;
            this.sessions = new SessionManager();
            this.writeLock = null;
            this.pendingAuthorizations = new IntTable();
            this.writeLock = String.valueOf(new Random().nextInt());
            if (config.containsKey(DO_RECURSION)) {
                this.allowRecursiveQueries = config.getBoolean(DO_RECURSION);
            }
            if (config.containsKey(SERVER_ADMIN_FULL_ACCESS)) {
                this.serverAdminFullAccess = config.getBoolean(SERVER_ADMIN_FULL_ACCESS);
            }
            if (config.containsKey(ALLOW_LIST_HANDLES)) {
                this.allowListHdls = config.getBoolean(ALLOW_LIST_HANDLES);
            }
            if (config.containsKey(ALLOW_NA_ADMINS)) {
                this.allowNAAdmins = config.getBoolean(ALLOW_NA_ADMINS);
            }
            if (config.containsKey(PREFERRED_GLOBAL)) {
                this.preferredGlobal = config.getStr(PREFERRED_GLOBAL);
                Properties p = new Properties(System.getProperties());
                p.put("hdllib.preferredGlobal", this.preferredGlobal);
                System.setProperties(p);
            }
            this.replicationTimeout = config.containsKey(REPLICATION_TIMEOUT) ? Integer.parseInt(String.valueOf(config.get(REPLICATION_TIMEOUT))) : 300000;
            try {
                int thisId = Integer.parseInt((String)config.get(THIS_SERVER_ID));
                SiteInfo site = new SiteInfo();
                File siteInfoFile = new File(main.getConfigDir(), SITE_INFO_FILE);
                if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                    System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath());
                    throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath());
                }
                byte[] siteInfoBuf = new byte[(int)siteInfoFile.length()];
                new FileInputStream(siteInfoFile).read(siteInfoBuf);
                Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
                this.thisServerNum = -1;
                for (i = 0; i < site.servers.length; ++i) {
                    if (site.servers[i].serverId != thisId) continue;
                    this.thisServerNum = i;
                }
                if (this.thisServerNum < 0) {
                    throw new Exception("Server ID " + thisId + " does not exist in site!");
                }
                this.thisSite = site;
            }
            catch (Exception e) {
                System.err.println("Invalid site/server specification: " + e);
                throw e;
            }
            byte[] secKey = null;
            try {
                int i2;
                int r;
                File privateKeyFile = new File(main.getConfigDir(), PRIVATE_KEY_FILE);
                if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
                    System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                    throw new Exception("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
                }
                FileInputStream in = new FileInputStream(privateKeyFile);
                byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
                for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
                }
                byte[] keyBytes = null;
                if (Util.requiresSecretKey(encKeyBytes)) {
                    secKey = Util.getPassphrase("Enter the passphrase for this server's authentication private key: ");
                }
                keyBytes = Util.decrypt(encKeyBytes, secKey);
                try {
                    this.privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
                }
                catch (Exception e) {
                    System.err.println("\n**************************************************************************\nError parsing private key, please make sure the passphrase is correct.\n**************************************************************************\n");
                    throw e;
                }
                for (i2 = 0; i2 < keyBytes.length; ++i2) {
                    keyBytes[i2] = 0;
                }
                this.serverSignatures = new Signature[50];
                for (i2 = 0; i2 < this.serverSignatures.length; ++i2) {
                    this.serverSignatures[i2] = Signature.getInstance("SHA1withDSA");
                    this.serverSignatures[i2].initSign(this.privateKey);
                }
                PublicKey pubKey = this.thisSite.servers[this.thisServerNum].getPublicKey();
                this.serverSignatures[0].update(SIGN_TEST);
                byte[] testSig = this.serverSignatures[0].sign();
                Signature verifier = Signature.getInstance(this.serverSignatures[0].getAlgorithm());
                verifier.initVerify(pubKey);
                verifier.update(SIGN_TEST);
                if (!verifier.verify(testSig)) {
                    throw new Exception("Private key doesn't match public key from site info!");
                }
            }
            catch (Exception e) {
                System.err.println("Unable to initialize server signature object: " + e);
                e.printStackTrace(System.err);
                throw e;
            }
            SessionManager.initializeSessionKeyRandom();
            this.sessions.checkTimeoutSession();
            int maxSessionTimeout = 86400;
            if (config.containsKey(MAX_SESSION_TIME)) {
                try {
                    maxSessionTimeout = Integer.parseInt(String.valueOf(config.get(MAX_SESSION_TIME)).trim());
                }
                catch (Exception e) {
                    main.logError(50, "Invalid session timeout allowance.  Using default (24 hours)");
                }
            }
            if (maxSessionTimeout < 60) {
                maxSessionTimeout = 60;
                main.logError(50, "Adjusted session timeout allowance. Using 1 minute.");
            }
            SessionInfo.setDefaultTimeout(maxSessionTimeout);
            try {
                HdlSecurityProvider.getInstance().sign_RSA_MD5_PKCS1(null, 0, 0, null);
            }
            catch (NoSuchAlgorithmException e) {
                this.useRSA = false;
            }
            catch (Exception e) {
                this.useRSA = true;
            }
            if (this.useRSA && !this.sessions.loadRSAKeys(secKey, main.getConfigDir())) {
                this.sessions.generateRSAKeys(secKey, main.getConfigDir());
            }
            for (int i3 = 0; secKey != null && i3 < secKey.length; ++i3) {
                secKey[i3] = 0;
            }
            this.isPrimary = this.thisSite.isPrimary;
            this.txnIdFile = new File(main.getConfigDir(), TXN_ID_FILE);
            InputStreamReader fin = null;
            try {
                try {
                    if (this.txnIdFile.exists()) {
                        int r;
                        char[] ch = new char[512];
                        fin = new FileReader(this.txnIdFile);
                        int n = 0;
                        while ((r = fin.read(ch, n, ch.length - n)) >= 0) {
                            n += r;
                        }
                        this.nextTxnId = Long.parseLong(new String(ch, 0, n).trim());
                        this.nextTxnIdInitialized = true;
                    } else {
                        this.nextTxnId = 1L;
                        this.nextTxnIdInitialized = false;
                    }
                }
                catch (Exception e) {
                    main.logError(50, "Invalid transaction ID! " + e);
                    throw e;
                }
                Object var14_43 = null;
                if (fin == null) break block76;
            }
            catch (Throwable throwable) {
                Object var14_44 = null;
                if (fin == null) throw throwable;
                try {
                    fin.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            fin.close();
        }
        if (config.containsKey(SERVER_ADMINS)) {
            try {
                adminVect = (Vector)config.get(SERVER_ADMINS);
                this.serverAdmins = new ValueReference[adminVect.size()];
                for (i = 0; i < adminVect.size(); ++i) {
                    String adminStr = String.valueOf(adminVect.elementAt(i));
                    int colIdx = adminStr.indexOf(58);
                    if (colIdx <= 0) {
                        throw new Exception("Invalid server administrator ID: \"" + adminStr + "\"");
                    }
                    this.serverAdmins[i] = new ValueReference(Util.encodeString(adminStr.substring(colIdx + 1)), Integer.parseInt(adminStr.substring(0, colIdx)));
                }
            }
            catch (Exception e) {
                throw new Exception("Error processing server administrator list: " + e);
            }
        }
        if (config.containsKey(BACKUP_ADMINS)) {
            try {
                adminVect = (Vector)config.get(BACKUP_ADMINS);
                this.backupAdmins = new ValueReference[adminVect.size()];
                for (i = 0; i < adminVect.size(); ++i) {
                    String adminStr = String.valueOf(adminVect.elementAt(i));
                    int colIdx = adminStr.indexOf(58);
                    if (colIdx <= 0) {
                        throw new Exception("Invalid server backup administrator ID: \"" + adminStr + "\"");
                    }
                    this.backupAdmins[i] = new ValueReference(Util.encodeString(adminStr.substring(colIdx + 1)), Integer.parseInt(adminStr.substring(0, colIdx)));
                }
            }
            catch (Exception e) {
                throw new Exception("Error processing server backup administrator list: " + e);
            }
        }
        if (config.containsKey(REPLICATION_ADMINS)) {
            try {
                adminVect = (Vector)config.get(REPLICATION_ADMINS);
                this.replicationAdmins = new ValueReference[adminVect.size()];
                for (i = 0; i < adminVect.size(); ++i) {
                    String adminStr = String.valueOf(adminVect.elementAt(i));
                    int colIdx = adminStr.indexOf(58);
                    if (colIdx <= 0) {
                        throw new Exception("Invalid replication administrator ID: \"" + adminStr + "\"");
                    }
                    this.replicationAdmins[i] = new ValueReference(Util.encodeString(adminStr.substring(colIdx + 1)), Integer.parseInt(adminStr.substring(0, colIdx)));
                }
            }
            catch (Exception e) {
                throw new Exception("Error processing replication administrator list: " + e);
            }
        } else {
            this.replicationAdmins = new ValueReference[0];
        }
        if (config.containsKey(REPLICATION_INTERVAL)) {
            String repIntStr = String.valueOf(config.get(REPLICATION_INTERVAL));
            try {
                this.replicationInterval = Long.parseLong(repIntStr);
            }
            catch (Exception e) {
                System.err.println("Error: invalid replication interval \"" + repIntStr + "\"; using default: " + this.replicationInterval + " milliseconds");
            }
        }
        boolean bl = this.doReplication = !this.isPrimary && config.getBoolean(DO_REPLICATION, true);
        if (this.isPrimary) {
            this.txnQueue = config.getBoolean(READ_ONLY_TXN_QUEUE, false) ? new ReadOnlyTransactionQueue(new File(main.getConfigDir(), TXN_QUEUE_DIR)) : new TransactionQueue(new File(main.getConfigDir(), TXN_QUEUE_DIR));
        } else if (this.doReplication) {
            if (!config.containsKey(REPLICATION_AUTH)) throw new HandleException(0, "Servers in non-primary sites need to specify replication authentication information");
            String replAuthSpec = config.getStr(REPLICATION_AUTH, "");
            String[] replFields = StringUtils.split(replAuthSpec, ':');
            if (replFields.length < 3) {
                throw new HandleException(0, "Invalid replication auth descriptor: " + replAuthSpec);
            }
            int replHdlIdx = Integer.parseInt(replFields[1]);
            if (replFields[0].equals("privatekey")) {
                byte[] privKeyBytes;
                block77: {
                    byte[] passphrase = null;
                    File privKeyFile = new File(main.getConfigDir(), REPLICATION_PRIV_KEY_FILE);
                    privKeyBytes = new byte[(int)privKeyFile.length()];
                    FileInputStream in = new FileInputStream(privKeyFile);
                    int r = 0;
                    for (int n = 0; n < privKeyBytes.length && (r = in.read(privKeyBytes, n, privKeyBytes.length - n)) >= 0; n += r) {
                    }
                    try {
                        try {
                            if (Util.requiresSecretKey(privKeyBytes)) {
                                passphrase = Util.getPassphrase("Enter the passphrase for this servers replication private key: ");
                            }
                            privKeyBytes = Util.decrypt(privKeyBytes, passphrase);
                        }
                        catch (Exception e) {
                            throw new HandleException(0, "Error decrypting private key: " + e);
                        }
                        Object var17_52 = null;
                        if (passphrase == null) break block77;
                    }
                    catch (Throwable throwable) {
                        Object var17_53 = null;
                        if (passphrase == null) throw throwable;
                        int i4 = 0;
                        while (i4 < passphrase.length) {
                            passphrase[i4] = 0;
                            ++i4;
                        }
                        throw throwable;
                    }
                    for (int i4 = 0; i4 < passphrase.length; ++i4) {
                        passphrase[i4] = 0;
                    }
                }
                Object info = null;
                this.replicationAuth = new PublicKeyAuthenticationInfo(Util.encodeString(replFields[2]), replHdlIdx, Util.getPrivateKeyFromBytes(privKeyBytes, 0));
            } else {
                if (!replAuthSpec.startsWith("secretkey:")) throw new HandleException(0, "Unknown authentication type: " + replFields[0]);
                File secKeyFile = new File(main.getConfigDir(), REPLICATION_SECRET_KEY_FILE);
                byte[] secKeyBytes = new byte[(int)secKeyFile.length()];
                FileInputStream in = new FileInputStream(secKeyFile);
                int r = 0;
                for (int n = 0; n < secKeyBytes.length && (r = in.read(secKeyBytes, n, secKeyBytes.length - n)) >= 0; n += r) {
                }
                this.replicationAuth = new SecretKeyAuthenticationInfo(Util.encodeString(replFields[2]), replHdlIdx, secKeyBytes);
            }
            this.loadReplicationInfo();
        }
        this.caseSensitive = config.getBoolean(CASE_SENSITIVE);
        this.storage = HandleStorageFactory.getStorage(main.getConfigDir(), config, this.isPrimary);
        try {
            this.maxAuthTime = Long.parseLong(String.valueOf(config.get(MAX_AUTH_TIME)).trim());
        }
        catch (Exception e) {
            System.err.println("Invalid authentication time allowance.  Using default (20 seconds)");
            this.maxAuthTime = 20000L;
        }
        final SiteInfo[] ss = new SiteInfo[]{this.thisSite};
        this.storage.scanNAs(new ScanCallback(){

            public void scanHandle(byte[] handle) {
                HandleServer.this.resolver.getConfiguration().setLocalSites(Util.decodeString(handle), ss);
            }
        });
        ChallengeResponse.initializeRandom();
        this.nextTxnIdRequest = new GenericRequest(Common.SERVER_TXN_ID_HANDLE, 1000, null);
        this.nextTxnIdRequest.certify = true;
        ChallengePurgeThread cpt = new ChallengePurgeThread();
        cpt.setDaemon(true);
        cpt.setPriority(1);
        cpt.start();
        if (this.isPrimary) return;
        if (!this.doReplication) return;
        this.replicationDaemon = new ReplicationDaemon();
        this.replicationDaemon.setDaemon(true);
        this.replicationDaemon.setPriority(1);
        this.replicationDaemon.start();
    }

    private void saveReplicationInfo() throws HandleException {
        try {
            StreamTable replicationConfig = new StreamTable();
            StreamVector sources = new StreamVector();
            replicationConfig.put(REPLICATION_SOURCES, sources);
            for (int i = 0; i < this.replicationLastTxnIds.length; ++i) {
                StreamTable sourceTable = new StreamTable();
                sourceTable.put(LAST_TXN_ID, String.valueOf(this.replicationLastTxnIds[i]));
                sourceTable.put(LAST_TIMESTAMP, String.valueOf(this.replicationLastTimeStamps[i]));
                sources.addElement(sourceTable);
            }
            replicationConfig.writeToFile(this.replicationStatusFile);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(1, "Error saving replication state: " + e);
        }
    }

    private void loadReplicationInfo() throws HandleException {
        try {
            int r;
            this.replicationSvrInfoFile = new File(this.main.getConfigDir(), REPLICATION_SERVER_INFO_FILE);
            if (!this.replicationSvrInfoFile.exists()) {
                throw new HandleException(11, "No replication site found (" + this.replicationSvrInfoFile + ")");
            }
            byte[] siteBuf = new byte[(int)this.replicationSvrInfoFile.length()];
            FileInputStream fin = new FileInputStream(this.replicationSvrInfoFile);
            for (int n = 0; n < siteBuf.length && (r = fin.read(siteBuf, n, siteBuf.length - n)) >= 0; n += r) {
            }
            fin.close();
            this.replicationSite = new SiteInfo();
            Encoder.decodeSiteInfoRecord(siteBuf, 0, this.replicationSite);
            this.replicationStatusFile = new File(this.main.getConfigDir(), REPLICATION_STATUS_FILE);
            if (!this.replicationStatusFile.exists()) {
                this.replicationLastTxnIds = new long[this.replicationSite.servers.length];
                this.replicationLastTimeStamps = new long[this.replicationLastTxnIds.length];
                for (int i = 0; i < this.replicationLastTxnIds.length; ++i) {
                    this.replicationLastTxnIds[i] = 0L;
                    this.replicationLastTimeStamps[i] = 0L;
                }
            } else {
                StreamTable replicationConfig = new StreamTable();
                replicationConfig.readFromFile(this.replicationStatusFile);
                StreamVector sources = (StreamVector)replicationConfig.get(REPLICATION_SOURCES);
                this.replicationLastTxnIds = new long[sources.size()];
                this.replicationLastTimeStamps = new long[sources.size()];
                for (int i = 0; i < sources.size(); ++i) {
                    StreamTable sourceTable = (StreamTable)sources.elementAt(i);
                    this.replicationLastTxnIds[i] = Long.parseLong(String.valueOf(sourceTable.get(LAST_TXN_ID)));
                    this.replicationLastTimeStamps[i] = Long.parseLong(String.valueOf(sourceTable.get(LAST_TIMESTAMP)));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error reading replication configuration: " + e);
            e.printStackTrace(System.err);
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(0, "Cannot read replication configuration: " + e);
        }
    }

    private void updateReplicationConfiguration(SiteInfo oldSiteInfo, int serverNum) throws HandleException {
        int i;
        if (!this.replicationSvrInfoFile.canWrite()) {
            this.main.logError(75, "I don't have permission to save the updated replication site info!");
            throw new HandleException(12, "Insufficient permissions to save the updated replication site info!");
        }
        if (!this.replicationStatusFile.canWrite()) {
            this.main.logError(75, "I don't have permission to save the updated replication state!");
            throw new HandleException(12, "Insufficient permissions to save the updated replication state!");
        }
        if (oldSiteInfo == null) {
            this.main.logError(75, "Missing replication source site information");
            return;
        }
        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, this.replicationAuth);
        Object exception = null;
        SiteInfo newSiteInfo = null;
        try {
            AbstractResponse response = this.resolver.sendRequestToServer(req, oldSiteInfo.servers[serverNum]);
            if (response.responseCode == 1) {
                newSiteInfo = ((GetSiteInfoResponse)response).siteInfo;
            }
        }
        catch (HandleException e) {
            this.main.logError(75, "Unable to retrieve updated site info from server: " + oldSiteInfo.servers[serverNum]);
        }
        for (int i2 = 0; newSiteInfo == null && i2 < oldSiteInfo.servers.length; ++i2) {
            try {
                AbstractResponse response = this.resolver.sendRequestToServer(req, oldSiteInfo.servers[i2]);
                if (response.responseCode != 1) continue;
                newSiteInfo = ((GetSiteInfoResponse)response).siteInfo;
                continue;
            }
            catch (HandleException e) {
                this.main.logError(75, "Unable to retrieve updated site info from server: " + oldSiteInfo.servers[serverNum]);
            }
        }
        if (newSiteInfo == null) {
            throw new HandleException(12, "Unable to update outdated site info!");
        }
        try {
            FileOutputStream out = new FileOutputStream(this.replicationStatusFile);
            out.close();
            out = new FileOutputStream(this.replicationSvrInfoFile);
            out.write(Encoder.encodeSiteInfoRecord(newSiteInfo));
            out.close();
        }
        catch (Exception e) {
            this.main.logError(75, "Unable to save replication source site info: " + e);
            throw new HandleException(12, "Unable to save updated site info: " + e);
        }
        long[] newLastTxnIds = new long[newSiteInfo.servers.length];
        long[] newLastTS = new long[newSiteInfo.servers.length];
        long minTxnId = -1L;
        long minLastTS = 0L;
        for (i = 0; i < oldSiteInfo.servers.length; ++i) {
            if (this.replicationLastTxnIds[i] < minTxnId || i == 0) {
                minTxnId = this.replicationLastTxnIds[i];
            }
            if (this.replicationLastTimeStamps[i] >= minLastTS && i != 0) continue;
            minLastTS = this.replicationLastTimeStamps[i];
        }
        for (i = 0; i < newLastTxnIds.length; ++i) {
            newLastTxnIds[i] = minTxnId;
            newLastTS[i] = minLastTS;
        }
        this.replicationSite = newSiteInfo;
        this.replicationLastTxnIds = newLastTxnIds;
        this.replicationLastTimeStamps = newLastTS;
        this.saveReplicationInfo();
    }

    private boolean pendingChallenge(int sessionId) {
        if (sessionId < 0) {
            return false;
        }
        ChallengeResponseInfo crInfo = (ChallengeResponseInfo)this.pendingAuthorizations.get(sessionId);
        return crInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ResponseMessageCallback callback, AbstractResponse response) throws HandleException {
        response.siteInfoSerial = this.thisSite.serialNumber;
        if (response.certify && (response.cacheCertify || response.signature == null)) {
            ServerSideSessionInfo sssinfo;
            boolean signed = false;
            if (response.sessionId > 0 && (sssinfo = this.getSession(response.sessionId)) != null && sssinfo.lastRequestId > 0 && response.opCode != 400 && response.opCode != 402) {
                try {
                    response.signMessage(sssinfo.getSessionKey());
                    signed = true;
                }
                catch (Exception e) {
                    this.main.logError(75, "Exception signing response: " + e);
                    signed = false;
                }
            }
            if (!signed) {
                try {
                    Signature sig;
                    int sigIndex = this.currentSigIndex++;
                    if (sigIndex >= this.serverSignatures.length) {
                        this.currentSigIndex = 0;
                        sigIndex = 0;
                    }
                    Signature signature = sig = this.serverSignatures[sigIndex];
                    synchronized (signature) {
                        response.signMessage(sig);
                    }
                }
                catch (Exception e) {
                    this.main.logError(75, "Exception signing response: " + e);
                }
            }
        }
        callback.handleResponse(response);
    }

    public void processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        if (!this.serverEnabled) {
            this.sendResponse(callback, new ErrorResponse(req, 2, MSG_SERVER_TEMPORARILY_DISABLED));
            return;
        }
        this.processRequest(req, null, null, callback);
    }

    private void processRequest(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq, ResponseMessageCallback callback) throws HandleException {
        if (req.sessionId > 0 && !this.pendingChallenge(req.sessionId) && !this.validSession(req)) {
            this.sendResponse(callback, new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT));
            return;
        }
        this.validSession(req);
        if (req.isAdminRequest && !this.isPrimary) {
            this.sendResponse(callback, new ErrorResponse(req, 301, MSG_NOT_A_PRIMARY));
        }
        switch (req.opCode) {
            case 2: {
                this.sendResponse(callback, new GetSiteInfoResponse(req, this.thisSite));
                break;
            }
            case 1: {
                this.sendResponse(callback, this.doResolution((ResolutionRequest)req, cRes, crReq));
                break;
            }
            case 105: {
                this.doListHandles(callback, (ListHandlesRequest)req, cRes, crReq);
                break;
            }
            case 400: {
                this.sendResponse(callback, this.doSessionSetup((SessionSetupRequest)req, cRes, crReq));
                break;
            }
            case 402: {
                this.sendResponse(callback, this.doKeyExchange((SessionExchangeKeyRequest)req, cRes, crReq));
                break;
            }
            case 401: {
                this.sendResponse(callback, this.doSessionTerminate((GenericRequest)req, cRes, crReq));
                break;
            }
            case 200: {
                ChallengeResponseInfo crInfo = (ChallengeResponseInfo)this.pendingAuthorizations.get(req.sessionId);
                if (crInfo == null || crInfo.hasExpired()) {
                    this.sendResponse(callback, new ErrorResponse(req, 405, null));
                    break;
                }
                this.processRequest(crInfo.originalRequest, crInfo.challenge, (ChallengeAnswerRequest)req, callback);
                break;
            }
            case 201: {
                this.sendResponse(callback, this.verifyChallenge((VerifyAuthRequest)req, cRes, crReq));
                break;
            }
            case 1002: {
                this.sendResponse(callback, this.doDumpHandles((DumpHandlesRequest)req, cRes, crReq));
                break;
            }
            case 102: {
                this.sendResponse(callback, this.doAddValue((AddValueRequest)req, cRes, crReq));
                break;
            }
            case 103: {
                this.sendResponse(callback, this.doRemoveValue((RemoveValueRequest)req, cRes, crReq));
                break;
            }
            case 104: {
                this.sendResponse(callback, this.doModifyValue((ModifyValueRequest)req, cRes, crReq));
                break;
            }
            case 100: {
                this.sendResponse(callback, this.doCreateHandle((CreateHandleRequest)req, cRes, crReq));
                break;
            }
            case 101: {
                this.sendResponse(callback, this.doDeleteHandle((DeleteHandleRequest)req, cRes, crReq));
                break;
            }
            case 1000: {
                this.sendResponse(callback, this.getNextTxnId((GenericRequest)req, cRes, crReq));
                break;
            }
            case 1001: {
                this.sendResponse(callback, this.doRetrieveTxnLog((RetrieveTxnRequest)req, cRes, crReq));
                break;
            }
            case 300: {
                this.sendResponse(callback, this.doHomeNA(req, cRes, crReq));
                break;
            }
            case 301: {
                this.sendResponse(callback, this.doUnhomeNA(req, cRes, crReq));
                break;
            }
            case 1003: {
                this.sendResponse(callback, this.doBackup((GenericRequest)req, cRes, crReq));
                break;
            }
            default: {
                throw new HandleException(1, "Unknown operation: " + req.opCode);
            }
        }
    }

    private final AbstractResponse getNextTxnId(GenericRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        return new NextTxnIdResponse((AbstractRequest)req, this.getNextTxnId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long getNextTxnId() throws HandleException {
        long thisTxnId;
        String string = this.NEXT_TXN_ID_LOCK;
        synchronized (string) {
            if (!this.nextTxnIdInitialized && this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(Common.SERVER_TXN_ID_HANDLE) != this.thisServerNum) {
                long tmpID = this.retrieveNextTxnId();
                this.nextTxnId = Math.max(this.nextTxnId + 1L, tmpID);
            } else {
                ++this.nextTxnId;
            }
            this.nextTxnIdInitialized = true;
            if (this.nextTxnId < 0L) {
                this.nextTxnId = 0L;
            }
            thisTxnId = this.nextTxnId;
            try {
                FileWriter fw = new FileWriter(this.txnIdFile);
                fw.write(String.valueOf(this.nextTxnId));
                fw.close();
            }
            catch (Exception e) {
                throw new HandleException(1, "Unable to store new transaction ID");
            }
        }
        return thisTxnId;
    }

    private final AbstractResponse doHomeNA(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!Util.startsWithCI(req.handle, Common.NA_HANDLE_PREFIX)) {
            this.main.logError(50, "Was asked to home non-naming authority handle: '" + Util.decodeString(req.handle) + "' ");
            return new ErrorResponse(req, 2, MSG_NOT_A_NA_HANDLE);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        boolean hasPermission = false;
        Vector<ValueReference> valuesToTraverse = new Vector<ValueReference>();
        ValueReference thisAdmin = null;
        if (crReq != null) {
            thisAdmin = new ValueReference(crReq.userIdHandle, crReq.userIdIndex);
        } else {
            ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
            if (sssinfo != null) {
                thisAdmin = new ValueReference(sssinfo.identityKeyHandle, sssinfo.identityKeyIndex);
            } else {
                return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
            }
        }
        for (int i = 0; i < this.serverAdmins.length; ++i) {
            ValueReference admin = this.serverAdmins[i];
            if (admin.equals(thisAdmin)) {
                hasPermission = true;
                break;
            }
            valuesToTraverse.addElement(admin);
        }
        if (!hasPermission && !this.isAdminInGroup(thisAdmin, valuesToTraverse, new Vector())) {
            return new ErrorResponse(req, 400, null);
        }
        AbstractResponse verifyResp = this.verifyIdentity(cRes, crReq, req);
        if (verifyResp != null) {
            return verifyResp;
        }
        if (this.thisSite.determineServerNum(req.handle) == this.thisServerNum) {
            try {
                if (!this.insertTransaction(req.handle, (byte)4)) {
                    this.main.logError(75, "Unable to save HOME-NA transaction.");
                    return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                }
            }
            catch (Exception e) {
                this.main.logError(75, "Error committing transaction: " + e);
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
        }
        try {
            this.storage.setHaveNA(req.handle, true);
        }
        catch (HandleException e) {
            this.main.logError(100, "Unable to \"home\" naming authority \"" + Util.decodeString(req.handle) + "\" after transaction was logged! - " + e);
            if (e.getCode() == 18) {
                return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
            }
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        SiteInfo[] ss = new SiteInfo[]{this.thisSite};
        this.resolver.getConfiguration().setLocalSites(new String(req.handle), ss);
        return new GenericResponse(req, 1);
    }

    private final AbstractResponse doUnhomeNA(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!Util.startsWithCI(req.handle, Common.NA_HANDLE_PREFIX)) {
            return new ErrorResponse(req, 2, MSG_NOT_A_NA_HANDLE);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        boolean hasPermission = false;
        Vector<ValueReference> valuesToTraverse = new Vector<ValueReference>();
        ValueReference thisAdmin = null;
        if (crReq != null && cRes != null) {
            thisAdmin = new ValueReference(crReq.userIdHandle, crReq.userIdIndex);
        } else {
            ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
            if (sssinfo != null) {
                thisAdmin = new ValueReference(sssinfo.identityKeyHandle, sssinfo.identityKeyIndex);
            } else {
                return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
            }
        }
        for (int i = 0; i < this.serverAdmins.length; ++i) {
            ValueReference admin = this.serverAdmins[i];
            if (admin.equals(thisAdmin)) {
                hasPermission = true;
                break;
            }
            valuesToTraverse.addElement(admin);
        }
        if (!hasPermission && !this.isAdminInGroup(thisAdmin, valuesToTraverse, new Vector())) {
            return new ErrorResponse(req, 400, null);
        }
        AbstractResponse verifyResp = this.verifyIdentity(cRes, crReq, req);
        if (verifyResp != null) {
            return verifyResp;
        }
        if (this.thisSite.determineServerNum(req.handle) == this.thisServerNum) {
            try {
                if (!this.insertTransaction(req.handle, (byte)5)) {
                    return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                }
            }
            catch (Exception e) {
                this.main.logError(75, "Error committing transaction: " + e);
            }
        }
        try {
            this.storage.setHaveNA(req.handle, false);
        }
        catch (HandleException e) {
            this.main.logError(100, "Unable to \"home\" naming authority \"" + Util.decodeString(req.handle) + "\" after transaction was logged! - " + e);
            if (e.getCode() == 18) {
                return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
            }
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        this.resolver.getConfiguration().setLocalSites(new String(req.handle), null);
        return new GenericResponse(req, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AbstractResponse doRetrieveTxnLog(RetrieveTxnRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        Object valuesToTraverse;
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        try {
            AbstractResponse verifyResp;
            ValueReference admin;
            int i;
            boolean hasPermission = false;
            valuesToTraverse = new Vector();
            ValueReference thisAdmin = null;
            if (crReq != null && cRes != null) {
                thisAdmin = new ValueReference(crReq.userIdHandle, crReq.userIdIndex);
            } else {
                ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
                if (sssinfo == null) {
                    ErrorResponse errorResponse = new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
                    return errorResponse;
                }
                thisAdmin = new ValueReference(sssinfo.identityKeyHandle, sssinfo.identityKeyIndex);
            }
            for (i = 0; i < this.replicationAdmins.length; ++i) {
                admin = this.replicationAdmins[i];
                if (admin.equals(thisAdmin)) {
                    hasPermission = true;
                    break;
                }
                ((Vector)valuesToTraverse).addElement(admin);
            }
            if (!hasPermission) {
                for (i = 0; i < this.serverAdmins.length; ++i) {
                    admin = this.serverAdmins[i];
                    if (admin.equals(thisAdmin)) {
                        hasPermission = true;
                        break;
                    }
                    ((Vector)valuesToTraverse).addElement(admin);
                }
                if (!this.isAdminInGroup(thisAdmin, (Vector)valuesToTraverse, new Vector())) {
                    ErrorResponse i2 = new ErrorResponse(req, 400, null);
                    return i2;
                }
            }
            if ((verifyResp = this.verifyIdentity(cRes, crReq, req)) != null) {
                AbstractResponse t = verifyResp;
                return t;
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Unable to authenticate retrieve txn req: " + e);
            valuesToTraverse = new ErrorResponse(req, 406, null);
            return valuesToTraverse;
        }
        finally {
            try {
                System.gc();
                System.runFinalization();
            }
            catch (Throwable t) {}
        }
        String start = new Date(req.lastQueryDate).toString();
        String end = new Date(System.currentTimeMillis()).toString();
        long count = this.nextTxnId - req.lastTxnId;
        if (count <= 0L) return new RetrieveTxnResponse(this.txnQueue, req, false, this.storage, this.privateKey);
        String msg = "";
        msg = req.lastTxnId == 1L ? "Replicating 1 transaction from [" + start + "] to [" + end + "]" : (req.lastTxnId > 1L ? "Replicating " + count + " transactions from [" + start + "] to [" + end + "]" : "Replicating all transactions");
        this.main.logError(25, msg);
        return new RetrieveTxnResponse(this.txnQueue, req, false, this.storage, this.privateKey);
    }

    private final AbstractResponse doDumpHandles(DumpHandlesRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        try {
            AbstractResponse verifyResp;
            ValueReference admin;
            int i;
            boolean hasPermission = false;
            Vector<ValueReference> valuesToTraverse = new Vector<ValueReference>();
            ValueReference thisAdmin = null;
            if (crReq != null && cRes != null) {
                thisAdmin = new ValueReference(crReq.userIdHandle, crReq.userIdIndex);
            } else {
                ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
                if (sssinfo != null) {
                    thisAdmin = new ValueReference(sssinfo.identityKeyHandle, sssinfo.identityKeyIndex);
                } else {
                    return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
                }
            }
            for (i = 0; i < this.replicationAdmins.length; ++i) {
                admin = this.replicationAdmins[i];
                if (admin.equals(thisAdmin)) {
                    hasPermission = true;
                    break;
                }
                valuesToTraverse.addElement(admin);
            }
            if (!hasPermission) {
                for (i = 0; i < this.serverAdmins.length; ++i) {
                    admin = this.serverAdmins[i];
                    if (admin.equals(thisAdmin)) {
                        hasPermission = true;
                        break;
                    }
                    valuesToTraverse.addElement(admin);
                }
                if (!this.isAdminInGroup(thisAdmin, valuesToTraverse, new Vector())) {
                    return new ErrorResponse(req, 400, null);
                }
            }
            if ((verifyResp = this.verifyIdentity(cRes, crReq, req)) != null) {
                return verifyResp;
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Unable to authenticate dump handles request: " + e);
            return new ErrorResponse(req, 406, null);
        }
        return new DumpHandlesResponse(req, this.storage, this.txnQueue, this.privateKey);
    }

    private final AbstractResponse verifyChallenge(VerifyAuthRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[] authSignature;
        boolean oldFormat;
        if (!this.storage.haveNA(Util.getNAHandle(req.handle))) {
            return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
        }
        byte[][] clumps = this.storage.getRawHandleValues(this.caseSensitive ? req.handle : Util.upperCase(req.handle), new int[]{req.handleIndex}, null);
        if (clumps == null || clumps.length <= 0) {
            return new VerifyAuthResponse(req, false);
        }
        HandleValue secretKeyValue = new HandleValue();
        Encoder.decodeHandleValue(clumps[0], 0, secretKeyValue);
        byte digestAlg = req.signedResponse[0];
        boolean bl = oldFormat = req.majorProtocolVersion == 5 && req.minorProtocolVersion == 0 || req.majorProtocolVersion == 2 && req.minorProtocolVersion == 0;
        if (oldFormat) {
            digestAlg = 1;
            authSignature = req.signedResponse;
        } else {
            switch (digestAlg) {
                case 1: {
                    authSignature = new byte[16];
                    System.arraycopy(req.signedResponse, 1, authSignature, 0, 16);
                    break;
                }
                case 2: {
                    authSignature = new byte[20];
                    System.arraycopy(req.signedResponse, 1, authSignature, 0, 20);
                    break;
                }
                default: {
                    authSignature = req.signedResponse;
                    digestAlg = 1;
                }
            }
        }
        byte[] realSignature = Util.doDigest(digestAlg, secretKeyValue.getData(), req.nonce, req.origRequestDigest, secretKeyValue.getData());
        if (realSignature != null && realSignature.length > 0) {
            return new VerifyAuthResponse(req, Util.equals(realSignature, authSignature));
        }
        return new VerifyAuthResponse(req, false);
    }

    private final AbstractResponse doDeleteHandle(DeleteHandleRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(req.handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        try {
            byte[][] clumps = this.storage.getRawHandleValues(this.caseSensitive ? req.handle : Util.upperCase(req.handle), null, Common.ADMIN_TYPES);
            if (clumps == null) {
                return new ErrorResponse(req, 100, null);
            }
            AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, DEL_HANDLE_PERM, clumps);
            if (authResp != null) {
                return authResp;
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Unable to authenticate delete handle request: " + e);
            return new ErrorResponse(req, 406, null);
        }
        try {
            if (!this.insertTransaction(req.handle, (byte)2)) {
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
            this.storage.deleteHandle(this.caseSensitive ? req.handle : Util.upperCase(req.handle));
        }
        catch (HandleException e) {
            this.main.logError(100, "Error committing transaction: " + e);
            switch (e.getCode()) {
                case 9: {
                    return new ErrorResponse(req, 100, null);
                }
                case 18: {
                    return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
                }
            }
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        return new GenericResponse(req, 1);
    }

    private static final int getHVByIndex(HandleValue[] values, int index) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].getIndex() != index) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractResponse doRemoveValue(RemoveValueRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(req.handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        if (!this.storage.haveNA(Util.getNAHandle(req.handle))) {
            return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        byte[] handle = this.caseSensitive ? req.handle : Util.upperCase(req.handle);
        Object object = this.getLock(this.writeLock, req.handle);
        synchronized (object) {
            byte[][] rawValues = this.storage.getRawHandleValues(handle, null, null);
            HandleValue[] values = new HandleValue[rawValues.length];
            for (int i = 0; i < rawValues.length; ++i) {
                values[i] = new HandleValue();
                Encoder.decodeHandleValue(rawValues[i], 0, values[i]);
            }
            boolean needsRemAdminPerm = false;
            boolean needsRemValuePerm = false;
            int[] toBeRemovedIdxs = new int[req.indexes.length];
            for (int i = 0; i < toBeRemovedIdxs.length; ++i) {
                toBeRemovedIdxs[i] = HandleServer.getHVByIndex(values, req.indexes[i]);
                if (toBeRemovedIdxs[i] < 0) {
                    return new ErrorResponse(req, 200, null);
                }
                HandleValue val = values[toBeRemovedIdxs[i]];
                if (val.hasType(Common.ADMIN_TYPE)) {
                    needsRemAdminPerm = true;
                    continue;
                }
                needsRemValuePerm = true;
            }
            int[] neededPerms = needsRemValuePerm && needsRemAdminPerm ? REM_ADM_AND_VAL_PERM : (needsRemAdminPerm ? REM_ADM_PERM : REM_VAL_PERM);
            AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, neededPerms, rawValues);
            if (authResp != null) {
                return authResp;
            }
            int removed = 0;
            for (int i = 0; i < toBeRemovedIdxs.length; ++i) {
                if (values[toBeRemovedIdxs[i]] != null) {
                    ++removed;
                }
                values[toBeRemovedIdxs[i]] = null;
            }
            HandleValue[] newValues = new HandleValue[values.length - removed];
            int j = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                newValues[j++] = values[i];
            }
            values = newValues;
            try {
                if (!this.insertTransaction(handle, (byte)3)) {
                    return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                }
                this.storage.updateValue(handle, values);
            }
            catch (HandleException e) {
                this.main.logError(100, "Error committing transaction: " + e);
                switch (e.getCode()) {
                    case 9: {
                        return new ErrorResponse(req, 100, null);
                    }
                    case 18: {
                        return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
                    }
                }
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
        }
        return new GenericResponse(req, 1);
    }

    private static final int[] combinePerms(int[] current, int[] toAppend) {
        if (current == null) {
            return toAppend;
        }
        if (toAppend == null) {
            return current;
        }
        int[] newPerms = new int[current.length + toAppend.length];
        System.arraycopy(current, 0, newPerms, 0, current.length);
        System.arraycopy(toAppend, 0, newPerms, current.length, toAppend.length);
        return newPerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractResponse doModifyValue(ModifyValueRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(req.handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        if (!this.storage.haveNA(Util.getNAHandle(req.handle))) {
            return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
        }
        boolean isAnonymous = (cRes == null || crReq == null) && !this.authenticatedSession(req);
        boolean needsAuthentication = false;
        byte[] handle = this.caseSensitive ? req.handle : Util.upperCase(req.handle);
        Object object = this.getLock(this.writeLock, req.handle);
        synchronized (object) {
            int i;
            AbstractResponse authResp;
            byte[][] rawValues = this.storage.getRawHandleValues(handle, null, null);
            HandleValue[] values = new HandleValue[rawValues.length];
            for (int i2 = 0; i2 < rawValues.length; ++i2) {
                values[i2] = new HandleValue();
                Encoder.decodeHandleValue(rawValues[i2], 0, values[i2]);
            }
            boolean needsModAdminPerm = false;
            boolean needsModValuePerm = false;
            boolean needsAdmToValPerm = false;
            boolean needsValToAdmPerm = false;
            int[] toBeModifiedIdxs = new int[req.values.length];
            for (int i3 = 0; i3 < toBeModifiedIdxs.length; ++i3) {
                toBeModifiedIdxs[i3] = HandleServer.getHVByIndex(values, req.values[i3].getIndex());
                if (toBeModifiedIdxs[i3] < 0) {
                    return new ErrorResponse(req, 200, null);
                }
                HandleValue val = values[toBeModifiedIdxs[i3]];
                if (!val.getAdminCanWrite()) {
                    return new ErrorResponse(req, 401, MSG_READ_ONLY_VALUE);
                }
                boolean oldValIsAdmin = val.hasType(Common.ADMIN_TYPE);
                boolean newValIsAdmin = req.values[i3].hasType(Common.ADMIN_TYPE);
                if (isAnonymous) {
                    if (!val.getAnyoneCanWrite()) {
                        return this.createChallenge(req);
                    }
                    if (oldValIsAdmin || newValIsAdmin) {
                        return this.createChallenge(req);
                    }
                }
                if (oldValIsAdmin && newValIsAdmin) {
                    needsModAdminPerm = true;
                    continue;
                }
                if (oldValIsAdmin && !newValIsAdmin) {
                    needsAdmToValPerm = true;
                    continue;
                }
                if (!oldValIsAdmin && newValIsAdmin) {
                    needsValToAdmPerm = true;
                    continue;
                }
                if (oldValIsAdmin || newValIsAdmin || val.getAnyoneCanWrite()) continue;
                needsModValuePerm = true;
            }
            int[] perms = null;
            if (needsModAdminPerm) {
                perms = HandleServer.combinePerms(perms, MOD_ADM_PERM);
            }
            if (needsModValuePerm) {
                perms = HandleServer.combinePerms(perms, MOD_VAL_PERM);
            }
            if (needsAdmToValPerm) {
                perms = HandleServer.combinePerms(perms, ADM_TO_VAL_PERM);
            }
            if (needsValToAdmPerm) {
                perms = HandleServer.combinePerms(perms, VAL_TO_ADM_PERM);
            }
            if (perms != null && (authResp = this.authenticateUser(req, cRes, crReq, perms, rawValues)) != null) {
                return authResp;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            for (i = 0; i < toBeModifiedIdxs.length; ++i) {
                values[toBeModifiedIdxs[i]] = req.values[i];
                values[toBeModifiedIdxs[i]].setTimestamp(now);
            }
            for (i = 0; i < values.length; ++i) {
                for (int j = i + 1; j < values.length; ++j) {
                    if (values[i].getIndex() != values[j].getIndex()) continue;
                    return new ErrorResponse(req, 2, Util.encodeString("Index conflict for " + values[j].getIndex()));
                }
            }
            try {
                if (!this.insertTransaction(handle, (byte)3)) {
                    return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                }
                this.storage.updateValue(handle, values);
            }
            catch (HandleException e) {
                this.main.logError(100, "Error committing transaction: " + e);
                switch (e.getCode()) {
                    case 9: {
                        return new ErrorResponse(req, 100, null);
                    }
                    case 18: {
                        return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
                    }
                }
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
        }
        return new GenericResponse(req, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractResponse doAddValue(AddValueRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[] handle;
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(req.handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        if (!this.storage.haveNA(Util.getNAHandle(req.handle))) {
            return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
        }
        for (int i = 0; i < req.values.length; ++i) {
            if (req.values[i].getIndex() >= 0) continue;
            return new ErrorResponse(req, 2, MSG_INDEXES_MUST_BE_POSITIVE);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        byte[] byArray = handle = this.caseSensitive ? req.handle : Util.upperCase(req.handle);
        if (req.values == null || req.values.length <= 0) {
            return new ErrorResponse(req, 2, MSG_EMPTY_VALUE_LIST);
        }
        Object object = this.getLock(this.writeLock, req.handle);
        synchronized (object) {
            int j;
            byte[][] rawValues = this.storage.getRawHandleValues(handle, null, null);
            boolean needsAddAdminPerm = false;
            boolean needsAddValuePerm = false;
            for (int i = 0; i < req.values.length; ++i) {
                if (req.values[i].hasType(Common.ADMIN_TYPE)) {
                    needsAddAdminPerm = true;
                    continue;
                }
                needsAddValuePerm = true;
            }
            int[] neededPerms = null;
            neededPerms = needsAddValuePerm && needsAddAdminPerm ? ADD_ADM_AND_VAL_PERM : (needsAddAdminPerm ? ADD_ADM_PERM : ADD_VAL_PERM);
            AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, neededPerms, rawValues);
            if (authResp != null) {
                return authResp;
            }
            HandleValue[] values = new HandleValue[rawValues.length + req.values.length];
            int i = 0;
            for (i = 0; i < rawValues.length; ++i) {
                values[i] = new HandleValue();
                Encoder.decodeHandleValue(rawValues[i], 0, values[i]);
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            for (j = 0; j < req.values.length; ++j) {
                req.values[j].setTimestamp(now);
                values[i + j] = req.values[j];
            }
            for (i = 0; i < values.length; ++i) {
                for (j = i + 1; j < values.length; ++j) {
                    if (values[i].getIndex() != values[j].getIndex()) continue;
                    return new ErrorResponse(req, 201, Util.encodeString("Index conflict for " + values[j].getIndex()));
                }
            }
            try {
                if (!this.insertTransaction(handle, (byte)3)) {
                    return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
                }
                this.storage.updateValue(handle, values);
            }
            catch (HandleException e) {
                this.main.logError(100, "Error committing transaction: " + e);
                switch (e.getCode()) {
                    case 9: {
                        return new ErrorResponse(req, 100, null);
                    }
                    case 18: {
                        return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
                    }
                }
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
        }
        return new GenericResponse(req, 1);
    }

    private final byte[][] getNAAdminValues(byte[] na) throws HandleException {
        if (!this.allowNAAdmins) {
            return new byte[0][];
        }
        ResolutionRequest authRequest = new ResolutionRequest(na, Common.ADMIN_TYPES, null, null);
        authRequest.certify = true;
        AbstractResponse response = this.resolver.processRequest(authRequest);
        if (response.getClass() != (class$net$handle$hdllib$ResolutionResponse == null ? (class$net$handle$hdllib$ResolutionResponse = HandleServer.class$("net.handle.hdllib.ResolutionResponse")) : class$net$handle$hdllib$ResolutionResponse)) {
            return null;
        }
        return ((ResolutionResponse)response).values;
    }

    private final AbstractResponse authenticateUser(AbstractRequest req, ChallengeResponse challenge, ChallengeAnswerRequest response, int[] operationIDs, byte[][] values) throws HandleException {
        Vector<ValueReference> valuesToTraverse;
        boolean hasAdminAccess;
        int identityIndex;
        byte[] identityHandle;
        block20: {
            identityHandle = null;
            identityIndex = -1;
            if (challenge != null && response != null) {
                identityHandle = response.userIdHandle;
                identityIndex = response.userIdIndex;
            } else {
                ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
                if (sssinfo == null) {
                    return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
                }
                identityHandle = sssinfo.identityKeyHandle;
                identityIndex = sssinfo.identityKeyIndex;
            }
            hasAdminAccess = false;
            valuesToTraverse = new Vector<ValueReference>();
            try {
                HandleValue tmpValue = new HandleValue();
                AdminRecord admin = new AdminRecord();
                if (!this.allowNAAdmins) {
                    values = new byte[0][];
                }
                if (values == null) break block20;
                for (int i = 0; i < ((byte[][])values).length; ++i) {
                    try {
                        Encoder.decodeHandleValue(values[i], 0, tmpValue);
                        if (!tmpValue.hasType(Common.ADMIN_TYPE)) continue;
                        Encoder.decodeAdminRecord(tmpValue.getData(), 0, admin);
                    }
                    catch (Exception e) {
                        this.main.logError(50, "Error decoding possible admin value: " + e);
                        continue;
                    }
                    boolean adminRecordIsRelevant = true;
                    for (int p = 0; p < operationIDs.length; ++p) {
                        if (admin.perms[operationIDs[p]]) continue;
                        adminRecordIsRelevant = false;
                        break;
                    }
                    if (!adminRecordIsRelevant) continue;
                    if (Util.equals(admin.adminId, identityHandle) && admin.adminIdIndex == identityIndex) {
                        hasAdminAccess = true;
                        break;
                    }
                    valuesToTraverse.addElement(new ValueReference(admin.adminId, admin.adminIdIndex));
                }
            }
            catch (Throwable e) {
                this.main.logError(50, "Error authenticating: " + e);
            }
        }
        if (!hasAdminAccess && this.serverAdminFullAccess) {
            for (int i = 0; this.serverAdmins != null && i < this.serverAdmins.length; ++i) {
                try {
                    if (Util.equals(identityHandle, this.serverAdmins[i].handle) && identityIndex == this.serverAdmins[i].index) {
                        hasAdminAccess = true;
                        break;
                    }
                    valuesToTraverse.addElement(this.serverAdmins[i]);
                    continue;
                }
                catch (Exception e) {
                    this.main.logError(50, "Error checking for server admin: " + e);
                }
            }
        }
        try {
            if (hasAdminAccess) {
                return this.verifyIdentity(challenge, response, req);
            }
            if (this.isAdminInGroup(new ValueReference(identityHandle, identityIndex), valuesToTraverse, new Vector())) {
                return this.verifyIdentity(challenge, response, req);
            }
            return new ErrorResponse(req, 400, null);
        }
        catch (Exception e) {
            this.main.logError(50, "Error authenticating: " + e);
            return new ErrorResponse(req, 400, null);
        }
    }

    private final AbstractResponse doCreateHandle(CreateHandleRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (this.thisSite.servers.length > 1 && this.thisSite.determineServerNum(req.handle) != this.thisServerNum) {
            return new ErrorResponse(req, 301, MSG_WRONG_SERVER_HASH);
        }
        if (!this.storage.haveNA(Util.getNAHandle(req.handle))) {
            return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
        }
        if (!Util.isValidString(req.handle, 0, req.handle.length)) {
            return new ErrorResponse(req, 102, MSG_INVALID_ENCODING);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        for (int i = 0; i < req.values.length; ++i) {
            if (req.values[i].getIndex() < 0) {
                return new ErrorResponse(req, 2, MSG_INDEXES_MUST_BE_POSITIVE);
            }
            for (int j = i + 1; j < req.values.length; ++j) {
                if (req.values[i].getIndex() != req.values[j].getIndex()) continue;
                return new ErrorResponse(req, 201, Util.encodeString("Index conflict for " + req.values[j].getIndex()));
            }
        }
        try {
            AbstractResponse authResp;
            boolean isSubNAHandle = Util.isSubNAHandle(req.handle);
            byte[] na = isSubNAHandle ? Util.getParentNAOfNAHandle(req.handle) : Util.getNAHandle(req.handle);
            byte[][] vals = this.getNAAdminValues(na);
            if (vals == null) {
                this.main.logError(50, "Unable to find admin group while creating handle");
            }
            if ((authResp = this.authenticateUser(req, cRes, crReq, isSubNAHandle ? ADD_SUB_NA_PERM : ADD_HANDLE_PERM, vals)) != null) {
                return authResp;
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Error while creating handle: " + e);
            return new ErrorResponse(req, 406, null);
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        for (int i = 0; req.values != null && i < req.values.length; ++i) {
            req.values[i].setTimestamp(now);
        }
        try {
            if (this.storage.getRawHandleValues(req.handle, null, null) != null) {
                return new ErrorResponse(req, 101, null);
            }
            if (!this.insertTransaction(req.handle, (byte)1)) {
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
            this.storage.createHandle(this.caseSensitive ? req.handle : Util.upperCase(req.handle), req.values);
        }
        catch (HandleException e) {
            this.main.logError(100, "Error committing transaction: " + e);
            switch (e.getCode()) {
                case 5: {
                    return new ErrorResponse(req, 101, null);
                }
                case 18: {
                    return new ErrorResponse(req, 303, MSG_SERVER_BACKUP);
                }
            }
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        return new GenericResponse(req, 1);
    }

    private final boolean haveHandle(byte[] handle) throws HandleException {
        if (!this.storage.haveNA(Util.getNAHandle(handle))) {
            return false;
        }
        if (this.thisSite.servers.length <= 1) {
            return true;
        }
        return this.thisSite.determineServerNum(handle) == this.thisServerNum;
    }

    private final AbstractResponse doResolution(ResolutionRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        byte[][] clumps = null;
        if (this.haveHandle(req.handle)) {
            try {
                clumps = this.storage.getRawHandleValues(this.caseSensitive ? req.handle : Util.upperCase(req.handle), req.requestedIndexes, req.requestedTypes);
            }
            catch (Exception e) {
                this.main.logError(75, String.valueOf(this.getClass()) + ": error getting values: " + e);
                e.printStackTrace(System.err);
                return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
            }
            if (clumps == null) {
                return new ErrorResponse(req, 100, null);
            }
            if (clumps.length == 0) {
                return new ErrorResponse(req, 200, null);
            }
            return this.checkReadAccess(req, clumps, cRes, crReq);
        }
        if (this.allowRecursiveQueries && req.recursive) {
            req.recursionCount = (short)(req.recursionCount + 1);
            if (req.recursionCount > 10) {
                return new ErrorResponse(req, 6, null);
            }
            req.recursive = false;
            req.clearBuffers();
            return this.resolver.processRequest(req);
        }
        return new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE);
    }

    private final void doListHandles(ResponseMessageCallback callback, ListHandlesRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!this.allowListHdls) {
            this.sendResponse(callback, new ErrorResponse(req, 5, MSG_NEED_LIST_HDLS_PERM));
        }
        if (!Util.startsWithCI(req.handle, Common.NA_HANDLE_PREFIX)) {
            this.sendResponse(callback, new ErrorResponse(req, 102, MSG_INVALID_NA_HANDLE));
            return;
        }
        if (!this.storage.haveNA(req.handle)) {
            this.sendResponse(callback, new ErrorResponse(req, 301, MSG_NA_NOT_HOMED_HERE));
            return;
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            this.sendResponse(callback, this.createChallenge(req));
            return;
        }
        try {
            byte[][] vals = this.getNAAdminValues(req.handle);
            AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, LIST_HDLS_PERM, vals);
            if (authResp != null) {
                this.sendResponse(callback, authResp);
                return;
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Auth error on list-handles request: " + e);
            this.sendResponse(callback, new ErrorResponse(req, 406, null));
            return;
        }
        ListHandlesResponse response = new ListHandlesResponse(req, null);
        Enumeration listEnum = this.storage.getHandlesForNA(req.handle);
        byte[][] handles = new byte[50][];
        int numHandles = 0;
        while (listEnum.hasMoreElements()) {
            handles[numHandles++] = (byte[])listEnum.nextElement();
            if (numHandles < 50) continue;
            response.handles = handles;
            response.clearBuffers();
            response.continuous = listEnum.hasMoreElements();
            numHandles = 0;
            this.sendResponse(callback, response);
        }
        if (numHandles > 0) {
            byte[][] tmpHandles = new byte[numHandles][];
            System.arraycopy(handles, 0, tmpHandles, 0, numHandles);
            response.handles = tmpHandles;
            response.clearBuffers();
            response.continuous = false;
            numHandles = 0;
            this.sendResponse(callback, response);
        }
    }

    private final AbstractResponse checkReadAccess(ResolutionRequest req, byte[][] clumps, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (req.ignoreRestrictedValues) {
            int numUnrestricted = 0;
            for (int i = 0; i < clumps.length; ++i) {
                if ((Encoder.getHandleValuePermissions(clumps[i], 0) & 2) == 0) continue;
                ++numUnrestricted;
            }
            byte[][] unrestrictedVals = new byte[numUnrestricted][];
            --numUnrestricted;
            for (int i = clumps.length - 1; i >= 0; --i) {
                if ((Encoder.getHandleValuePermissions(clumps[i], 0) & 2) == 0) continue;
                unrestrictedVals[numUnrestricted--] = clumps[i];
            }
            return new ResolutionResponse(req, req.handle, unrestrictedVals);
        }
        boolean needsauth = false;
        for (int i = 0; i < clumps.length; ++i) {
            byte perms = Encoder.getHandleValuePermissions(clumps[i], 0);
            if ((perms & 2) != 0) continue;
            if ((perms & 8) == 0) {
                return new ErrorResponse(req, 401, null);
            }
            needsauth = true;
            break;
        }
        if (!needsauth) {
            return new ResolutionResponse(req, req.handle, clumps);
        }
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        byte[][] adminClumps = this.storage.getRawHandleValues(this.caseSensitive ? req.handle : Util.upperCase(req.handle), Common.ADMIN_INDEXES, Common.ADMIN_TYPES);
        AbstractResponse authResp = this.authenticateUser(req, cRes, crReq, READ_VAL_PERM, adminClumps);
        if (authResp != null) {
            return authResp;
        }
        return new ResolutionResponse(req, req.handle, clumps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long retrieveNextTxnId() throws HandleException {
        long nextTxnId = -1L;
        String string = this.TRANSACTION_LOCK;
        synchronized (string) {
            try {
                AbstractResponse resp = this.resolver.sendRequestToSite(this.nextTxnIdRequest, this.thisSite);
                if (resp != null && resp.responseCode == 1) {
                    nextTxnId = ((NextTxnIdResponse)resp).nextTxnId;
                }
            }
            catch (Exception e) {
                this.main.logError(75, "Unable to acquire next transaction ID: " + e);
                if (e instanceof HandleException) {
                    throw (HandleException)e;
                }
                throw new HandleException(1, "Unable to acquire next transaction ID: " + e);
            }
        }
        if (nextTxnId < 0L) {
            this.main.logError(75, "Unable to acquire next transaction ID");
            throw new HandleException(1, "Unable to acquire next transaction ID");
        }
        return nextTxnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean insertTransaction(byte[] handle, byte action) {
        String string = this.TRANSACTION_LOCK;
        synchronized (string) {
            long nextTxnId;
            try {
                nextTxnId = this.getNextTxnId();
            }
            catch (Throwable e) {
                this.main.logError(75, "Unable to acquire next transaction ID: " + e);
                return false;
            }
            if (nextTxnId < 0L) {
                this.main.logError(75, "Unable to acquire next transaction ID");
                return false;
            }
            try {
                this.txnQueue.addTransaction(nextTxnId, handle, action, System.currentTimeMillis());
            }
            catch (Throwable e) {
                this.main.logError(75, "Unable to insert transaction into queue");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AbstractResponse createChallenge(AbstractRequest req) throws HandleException {
        ChallengeResponseInfo cri = new ChallengeResponseInfo();
        cri.timeStarted = System.currentTimeMillis();
        cri.challenge = new ChallengeResponse(req);
        cri.originalRequest = req;
        IntTable intTable = this.pendingAuthorizations;
        synchronized (intTable) {
            cri.sessionId = this.validSession(req) ? req.sessionId : HandleServer.getNextSessionId();
            cri.challenge.sessionId = cri.sessionId;
            this.pendingAuthorizations.put(cri.sessionId, cri);
        }
        return cri.challenge;
    }

    private static synchronized int getNextSessionId() {
        return ++nextAuthId;
    }

    private final boolean isAdminInGroup(ValueReference admin, Vector valuesToTraverse, Vector valuesTraversed) {
        while (valuesToTraverse.size() > 0) {
            ValueReference val = (ValueReference)valuesToTraverse.elementAt(0);
            valuesTraversed.addElement(val);
            ResolutionRequest req = new ResolutionRequest(val.handle, null, new int[]{val.index}, null);
            HandleValue groupValue = null;
            try {
                req.certify = true;
                AbstractResponse response = this.resolver.processRequest(req);
                if (response.responseCode == 1 && response.opCode == 1) {
                    ResolutionResponse resResponse = (ResolutionResponse)response;
                    groupValue = new HandleValue();
                    for (int v = 0; v < resResponse.values.length; ++v) {
                        Encoder.decodeHandleValue(resResponse.values[v], 0, groupValue);
                        if (!groupValue.hasType(Common.STD_TYPE_HSVALLIST)) continue;
                        ValueReference[] valuesInGroup = Encoder.decodeValueReferenceList(groupValue.getData(), 0);
                        for (int i = 0; i < valuesInGroup.length; ++i) {
                            if (admin.equals(valuesInGroup[i])) {
                                return true;
                            }
                            if (valuesToTraverse.contains(valuesInGroup[i]) || valuesTraversed.contains(valuesInGroup[i])) continue;
                            valuesToTraverse.addElement(valuesInGroup[i]);
                        }
                    }
                }
            }
            catch (Throwable e) {
                System.err.println("Error trying to resolve possible group: " + e);
                e.printStackTrace(System.err);
            }
            valuesToTraverse.removeElementAt(0);
        }
        return false;
    }

    private final AbstractResponse verifyIdentity(ChallengeResponse cRes, ChallengeAnswerRequest crReq, AbstractRequest origReq) throws HandleException {
        if (cRes == null && crReq == null && this.authenticatedSession(origReq)) {
            ServerSideSessionInfo sssinfo = this.getSession(origReq.sessionId);
            if (sssinfo == null) {
                return new ErrorResponse(origReq, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
            }
            if (origReq.signature == null || origReq.signature.length <= 0) {
                return new ErrorResponse(origReq, 404, Util.encodeString("Session request missing MAC code."));
            }
            byte[] sessionKey = sssinfo.getSessionKey();
            try {
                if (sessionKey != null && origReq.verifyMessage(sessionKey)) {
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.main.logError(50, "Error verifying session key:" + e);
            }
            return new ErrorResponse(origReq, 502, Util.encodeString("Session authentication failed."));
        }
        if (Util.equals(crReq.authType, Common.MD5_SECRET_KEY_TYPE)) {
            VerifyAuthRequest vaReq = new VerifyAuthRequest(crReq.userIdHandle, cRes.nonce, cRes.requestDigest, cRes.rdHashType, crReq.signedResponse, crReq.userIdIndex, null);
            vaReq.certify = true;
            AbstractResponse response = this.haveHandle(vaReq.handle) ? this.verifyChallenge(vaReq, null, null) : this.resolver.processRequest(vaReq);
            if (response instanceof VerifyAuthResponse && ((VerifyAuthResponse)response).isValid) {
                if (this.validSession(origReq)) {
                    this.setSessionAuthenticated(origReq, crReq, true);
                    boolean MACpass = true;
                    ServerSideSessionInfo ssinfo = this.getSession(origReq.sessionId);
                    if (ssinfo != null && ssinfo.getSessionKey() != null) {
                        try {
                            MACpass = origReq.verifyMessage(ssinfo.getSessionKey());
                        }
                        catch (Exception e) {
                            System.err.println("Error verifying the original request MAC code:" + e);
                            MACpass = false;
                        }
                    }
                    if (MACpass) {
                        return null;
                    }
                    new ErrorResponse(origReq, 502, Util.encodeString("The session key authentication failed."));
                }
                return null;
            }
            return new ErrorResponse(origReq, 403, null);
        }
        if (Util.equals(crReq.authType, Common.STD_TYPE_HSDSAPUBKEY) || Util.equals(crReq.authType, Common.PUBLIC_KEY_TYPE)) {
            ResolutionRequest req = new ResolutionRequest(crReq.userIdHandle, null, new int[]{crReq.userIdIndex}, null);
            req.certify = true;
            AbstractResponse response = null;
            response = this.haveHandle(req.handle) ? this.doResolution(req, null, null) : this.resolver.processRequest(req);
            if (response.getClass() == (class$net$handle$hdllib$ResolutionResponse == null ? (class$net$handle$hdllib$ResolutionResponse = HandleServer.class$("net.handle.hdllib.ResolutionResponse")) : class$net$handle$hdllib$ResolutionResponse)) {
                ResolutionResponse rresponse = (ResolutionResponse)response;
                HandleValue[] values = rresponse.getHandleValues();
                if (values == null || values.length < 1) {
                    return new ErrorResponse(origReq, 403, null);
                }
                try {
                    int algNameLen = Encoder.readInt(crReq.signedResponse, 0);
                    int offset = 0;
                    byte[] hashAlgId = Encoder.readByteArray(crReq.signedResponse, offset);
                    byte[] sigBytes = Encoder.readByteArray(crReq.signedResponse, offset += 4 + hashAlgId.length);
                    offset += 4 + sigBytes.length;
                    PublicKey pubKey = Util.getPublicKeyFromBytes(values[0].getData(), 0);
                    boolean verified = false;
                    Signature sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm()));
                    sig.initVerify(pubKey);
                    sig.update(cRes.nonce);
                    sig.update(cRes.requestDigest);
                    if (sig.verify(sigBytes)) {
                        if (this.validSession(origReq)) {
                            this.setSessionAuthenticated(origReq, crReq, true);
                            boolean MACpass = true;
                            ServerSideSessionInfo ssinfo = this.getSession(origReq.sessionId);
                            if (ssinfo != null && ssinfo.getSessionKey() != null) {
                                try {
                                    MACpass = origReq.verifyMessage(ssinfo.getSessionKey());
                                }
                                catch (Exception e) {
                                    System.err.println("Error verifying the original request MAC code:" + e);
                                    MACpass = false;
                                }
                            }
                            if (MACpass) {
                                return null;
                            }
                            new ErrorResponse(origReq, 502, Util.encodeString("The session key authentication failed."));
                        }
                        return null;
                    }
                    return new ErrorResponse(origReq, 403, null);
                }
                catch (Exception e) {
                    return new ErrorResponse(origReq, 403, null);
                }
            }
            return new ErrorResponse(origReq, 403, null);
        }
        return new ErrorResponse(origReq, 404, null);
    }

    private final AbstractResponse doBackup(GenericRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        AbstractResponse verifyResp;
        ValueReference admin;
        int i;
        if (!(cRes != null && crReq != null || this.authenticatedSession(req))) {
            return this.createChallenge(req);
        }
        boolean hasPermission = false;
        Vector<ValueReference> valuesToTraverse = new Vector<ValueReference>();
        ValueReference thisAdmin = null;
        if (crReq != null) {
            thisAdmin = new ValueReference(crReq.userIdHandle, crReq.userIdIndex);
        } else {
            ServerSideSessionInfo ssinfo = this.getSession(req.sessionId);
            if (ssinfo != null) {
                thisAdmin = new ValueReference(ssinfo.identityKeyHandle, ssinfo.identityKeyIndex);
            } else {
                return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
            }
        }
        for (i = 0; i < this.backupAdmins.length; ++i) {
            admin = this.backupAdmins[i];
            if (admin.equals(thisAdmin)) {
                hasPermission = true;
                break;
            }
            valuesToTraverse.addElement(admin);
        }
        if (!hasPermission) {
            for (i = 0; i < this.serverAdmins.length; ++i) {
                admin = this.serverAdmins[i];
                if (admin.equals(thisAdmin)) {
                    hasPermission = true;
                    break;
                }
                valuesToTraverse.addElement(admin);
            }
            if (!this.isAdminInGroup(thisAdmin, valuesToTraverse, new Vector())) {
                return new ErrorResponse(req, 400, null);
            }
        }
        if ((verifyResp = this.verifyIdentity(cRes, crReq, req)) != null) {
            return verifyResp;
        }
        try {
            this.storage.checkpointDatabase();
        }
        catch (Exception e) {
            this.main.logError(100, "Error backup server: " + e);
            return new ErrorResponse(req, 2, MSG_INTERNAL_ERROR);
        }
        return new GenericResponse(req, 1);
    }

    private final AbstractResponse doSessionTerminate(GenericRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        ServerSideSessionInfo ssinfo = this.getSession(req.sessionId);
        if (ssinfo != null) {
            boolean authenticated = false;
            try {
                authenticated = req.verifyMessage(ssinfo.getSessionKey());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                authenticated = false;
            }
            if (!authenticated) {
                return new ErrorResponse(req, 502, Util.encodeString("Invalid session key."));
            }
            this.sessions.removeSession(req.sessionId);
            return new GenericResponse(req, 1);
        }
        return new ErrorResponse(req, 500, Util.encodeString("Can not get session info."));
    }

    private final AbstractResponse doSessionSetup(SessionSetupRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        int sessionId;
        SessionSetupResponse rsp = new SessionSetupResponse(req, null);
        PublicKey pubKey = null;
        byte[] sessionKey = null;
        if (req.keyExchangeMode == 3) {
            if (!this.useRSA) {
                return new ErrorResponse(req, 501, Util.encodeString("KEY_EXCHANGE_CIPHER_HDL not supported"));
            }
            try {
                HandleValue[] vals = this.resolver.resolveHandle(Util.decodeString(req.exchangeKeyHandle), null, new int[]{req.exchangeKeyIndex});
                if (vals == null || vals.length == 0) {
                    this.main.logError(50, "Error initializing session with hdl cipher: no key found.");
                    return new ErrorResponse(req, 501, Util.encodeString("No key found in key exchange handle."));
                }
                pubKey = Util.getPublicKeyFromBytes(vals[0].getData(), 0);
                sessionKey = SessionManager.getGeneratedSecretKey();
                rsp.data = Util.encrypt(pubKey, sessionKey);
            }
            catch (Exception e) {
                this.main.logError(50, "Error initializing session with hdl cipher: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error performing hdl cipher key exchange."));
            }
        } else if (req.keyExchangeMode == 1) {
            if (!this.useRSA) {
                return new ErrorResponse(req, 501, Util.encodeString("KEY_EXCHANGE_CIPHER_CLIENT not supported"));
            }
            try {
                pubKey = Util.getPublicKeyFromBytes(req.publicKey, 0);
                sessionKey = SessionManager.getGeneratedSecretKey();
                rsp.data = Util.encrypt(pubKey, sessionKey);
            }
            catch (Exception e) {
                this.main.logError(50, "Error initializing client cipher session: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error performing client cipher key exchange."));
            }
        } else if (req.keyExchangeMode == 2) {
            if (!this.useRSA) {
                return new ErrorResponse(req, 501, Util.encodeString("KEY_EXCHANGE_CIPHER_SERVER not supported"));
            }
            try {
                rsp.data = Util.getBytesFromPublicKey(this.sessions.rsaPubKey);
            }
            catch (Exception e) {
                this.main.logError(50, "Error initializing server cipher session: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error initializing server cipher session: " + e));
            }
        } else if (req.keyExchangeMode == 4) {
            try {
                pubKey = Util.getPublicKeyFromBytes(req.publicKey, 0);
                HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
                DHPublicKey pub = (DHPublicKey)pubKey;
                DHParameterSpec dhSpec = pub.getParams();
                KeyPair kp = provider.generateDHKeyPair(dhSpec.getP(), dhSpec.getG());
                DHPrivateKey priv = (DHPrivateKey)kp.getPrivate();
                rsp.data = Util.getBytesFromPublicKey(kp.getPublic());
                sessionKey = provider.getDESKeyFromDH(pub, priv);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.main.logError(50, "Error initializing DH session: " + e);
                return new ErrorResponse(req, 501, Util.encodeString("Error encoding public session key"));
            }
        } else {
            return new ErrorResponse(req, 501, Util.encodeString("Unrecognized key exchange mode"));
        }
        rsp.sessionId = sessionId = HandleServer.getNextSessionId();
        ServerSideSessionInfo sinfo = new ServerSideSessionInfo(sessionId, sessionKey, req.identityHandle, req.identityIndex, pubKey, req.keyExchangeMode);
        sinfo.setTimeOut(req.timeout);
        sinfo.setEncryptedMesssageFlag(req.encryptAllSessionMsg);
        sinfo.setAuthenticateMessageFlag(req.authAllSessionMsg);
        this.sessions.addSession(sinfo);
        sinfo.lastRequestId = req.requestId;
        return rsp;
    }

    private final AbstractResponse doKeyExchange(SessionExchangeKeyRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        if (!this.validSession(req)) {
            this.main.logError(50, "Bad server-cipher key exchange request");
            return new ErrorResponse(req, 500, MSG_INVALID_SESSION_OR_TIMEOUT);
        }
        ServerSideSessionInfo sinfo = this.sessions.getSession(req.sessionId);
        if (sinfo.keyExchangeMode != 2) {
            this.main.logError(50, "Bad server-cipher key exchange request");
            return new ErrorResponse(req, 501, Util.encodeString("Invalid session id. Session failed."));
        }
        byte[] encSessionKey = req.getEncryptedSessionKey();
        byte[] sessionkey = null;
        try {
            sessionkey = Util.decrypt(this.sessions.rsaPrivKey, encSessionKey);
        }
        catch (Exception e) {
            return new ErrorResponse(req, 501, Util.encodeString("Can't decrypt client session key."));
        }
        if (sessionkey != null) {
            sinfo.setSessionKey(sessionkey);
        }
        return new GenericResponse(req, 1);
    }

    private boolean validSession(AbstractRequest req) {
        if (req.sessionId == 0) {
            return false;
        }
        ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
        if (sssinfo != null) {
            if (req.requestId > sssinfo.lastRequestId) {
                sssinfo.lastRequestId = req.requestId;
            }
            return true;
        }
        return false;
    }

    private boolean authenticatedSession(AbstractRequest req) {
        if (req.sessionId == 0) {
            return false;
        }
        ServerSideSessionInfo sssinfo = this.getSession(req.sessionId);
        if (sssinfo != null) {
            if (sssinfo.isSessionAnonymous()) {
                return false;
            }
            if (req.requestId > sssinfo.lastRequestId) {
                sssinfo.lastRequestId = req.requestId;
            }
            if (sssinfo.clientAuthenticated) {
                return true;
            }
        }
        return false;
    }

    private void setSessionAuthenticated(AbstractRequest req, ChallengeAnswerRequest caReq, boolean authenticated) {
        ServerSideSessionInfo ssinfo = null;
        if (req != null && req.sessionId > 0) {
            ssinfo = this.getSession(req.sessionId);
        }
        if (ssinfo != null) {
            if (authenticated) {
                if (ssinfo.identityKeyHandle == null || ssinfo.identityKeyIndex < 0) {
                    return;
                }
                if (!Util.equals(ssinfo.identityKeyHandle, caReq.userIdHandle) || ssinfo.identityKeyIndex != caReq.userIdIndex) {
                    return;
                }
            }
            ssinfo.clientAuthenticated = authenticated;
        }
    }

    public ServerSideSessionInfo getSession(int sessionId) {
        if (this.sessions == null) {
            return null;
        }
        return this.sessions.getSession(sessionId);
    }

    private Object getLock(String lockType, byte[] hdl) {
        return lockType;
    }

    public final void shutdown() {
        this.keepRunning = false;
        this.sessions.shutdown();
        this.txnQueue.shutdown();
        this.storage.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ChallengeResponseInfo {
        long timeStarted;
        int sessionId;
        ChallengeResponse challenge;
        AbstractRequest originalRequest;

        ChallengeResponseInfo() {
        }

        final boolean hasExpired() {
            return this.timeStarted < System.currentTimeMillis() - HandleServer.this.maxAuthTime;
        }
    }

    private class ChallengePurgeThread
    extends Thread {
        private ChallengePurgeThread() {
        }

        public void run() {
            while (HandleServer.this.keepRunning) {
                try {
                    Thread.currentThread();
                    Thread.sleep(30000L);
                    long now = System.currentTimeMillis();
                    IntTable.IntTableEnumerator intTableEnumerator = HandleServer.this.pendingAuthorizations.keys();
                    while (intTableEnumerator.hasMoreElements()) {
                        int key = intTableEnumerator.nextKey();
                        ChallengeResponseInfo cri = (ChallengeResponseInfo)HandleServer.this.pendingAuthorizations.get(key);
                        if (cri != null && !cri.hasExpired()) continue;
                        HandleServer.this.pendingAuthorizations.remove(key);
                    }
                }
                catch (Throwable e) {
                    HandleServer.this.main.logError(75, "Error purging pending authentications: " + e);
                }
            }
        }
    }

    private class TxnCallback
    implements TransactionCallback {
        private int currentServerNum = -1;
        private int txnCounter = 0;

        private TxnCallback() {
        }

        private void setServerNum(int newServerNum) {
            this.currentServerNum = newServerNum;
        }

        public void processTransaction(Transaction txn) throws HandleException {
            System.err.println("--Processing " + txn);
            switch (txn.action) {
                case 1: 
                case 3: {
                    try {
                        HandleServer.this.storage.deleteHandle(HandleServer.this.caseSensitive ? txn.handle : Util.upperCase(txn.handle));
                    }
                    catch (Exception e) {
                        System.err.println("Error deleting handle before re-creating during replication: " + e);
                        e.printStackTrace(System.err);
                    }
                    HandleServer.this.storage.createHandle(HandleServer.this.caseSensitive ? txn.handle : Util.upperCase(txn.handle), txn.values);
                    break;
                }
                case 2: {
                    if (HandleServer.this.storage.deleteHandle(HandleServer.this.caseSensitive ? txn.handle : Util.upperCase(txn.handle))) break;
                    HandleServer.this.main.logError(50, "Warning: got delete-handle transaction for non-existent handle: " + Util.decodeString(txn.handle));
                    break;
                }
                case 4: {
                    HandleServer.this.storage.setHaveNA(txn.handle, true);
                    break;
                }
                case 5: {
                    HandleServer.this.storage.setHaveNA(txn.handle, false);
                    break;
                }
                default: {
                    HandleServer.this.main.logError(75, "Encountered unknown transaction type (" + txn.action + ") during replication for handle: " + Util.decodeString(txn.handle));
                }
            }
            ((HandleServer)HandleServer.this).replicationLastTxnIds[this.currentServerNum] = txn.txnId;
        }

        public void finishProcessing(long date) {
            ((HandleServer)HandleServer.this).replicationLastTimeStamps[this.currentServerNum] = date;
        }
    }

    private class DumpHdlCallback
    implements DumpHandlesCallback {
        private int currentServerNum = -1;

        private DumpHdlCallback(int serverNum) {
            this.currentServerNum = serverNum;
            System.err.println("Starting dump of source server #" + serverNum);
        }

        public synchronized void addHandle(byte[] handle, HandleValue[] values) throws Exception {
            if (!HandleServer.this.caseSensitive) {
                handle = Util.upperCase(handle);
            }
            System.err.println("---> " + Util.decodeString(handle));
            try {
                HandleServer.this.storage.deleteHandle(handle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            HandleServer.this.storage.createHandle(handle, values);
        }

        public synchronized void addNamingAuthority(byte[] authHandle) throws Exception {
            System.err.println("NA-> " + Util.decodeString(authHandle));
            HandleServer.this.storage.setHaveNA(authHandle, true);
        }

        public synchronized void finishProcessing(long date, long txnId) {
            System.err.println("----finalizing dump from server: " + this.currentServerNum + " date: " + new Date(date) + "; last txnId: " + txnId);
            ((HandleServer)HandleServer.this).replicationLastTimeStamps[this.currentServerNum] = date;
            ((HandleServer)HandleServer.this).replicationLastTxnIds[this.currentServerNum] = txnId;
        }
    }

    private class ReplicationDaemon
    extends Thread {
        private HandleResolver retrievalResolver = new HandleResolver();

        private ReplicationDaemon() {
        }

        public void run() {
            boolean redumpNeeded = false;
            this.retrievalResolver.setTcpTimeout(HandleServer.this.replicationTimeout);
            while (HandleServer.this.keepRunning) {
                if (!redumpNeeded) {
                    try {
                        TxnCallback callback = new TxnCallback();
                        for (int i = 0; i < ((HandleServer)HandleServer.this).replicationSite.servers.length; ++i) {
                            RetrieveTxnRequest req = new RetrieveTxnRequest(HandleServer.this.replicationLastTxnIds[i], HandleServer.this.replicationLastTimeStamps[i], ((HandleServer)HandleServer.this).thisSite.hashOption, ((HandleServer)HandleServer.this).thisSite.servers.length, HandleServer.this.thisServerNum, HandleServer.this.replicationAuth);
                            req.encrypt = false;
                            req.certify = true;
                            try {
                                AbstractResponse res = this.retrievalResolver.sendRequestToServer(req, ((HandleServer)HandleServer.this).replicationSite.servers[i]);
                                if (res.responseCode == 1) {
                                    callback.setServerNum(i);
                                    PublicKey pubKey = ((HandleServer)HandleServer.this).replicationSite.servers[i].getPublicKey();
                                    int status = ((RetrieveTxnResponse)res).processStreamedPart(callback, pubKey);
                                    if (status == 1) {
                                        redumpNeeded = true;
                                        break;
                                    }
                                    if (status == 2) {
                                        HandleServer.this.saveReplicationInfo();
                                    } else {
                                        HandleServer.this.main.logError(75, "Unknown status code from server during replication: " + status);
                                    }
                                } else {
                                    HandleServer.this.main.logError(50, "Unexpected response to replication request: " + res);
                                }
                                if (res.siteInfoSerial <= ((HandleServer)HandleServer.this).replicationSite.serialNumber) continue;
                                HandleServer.this.main.logError(50, "Updating replication info from version " + ((HandleServer)HandleServer.this).replicationSite.serialNumber + " to version " + res.siteInfoSerial);
                                HandleServer.this.updateReplicationConfiguration(HandleServer.this.replicationSite, i);
                                break;
                            }
                            catch (HandleException e) {
                                HandleServer.this.main.logError(50, "Error doing replication at server: " + ((HandleServer)HandleServer.this).replicationSite.servers[i] + ": " + e);
                                e.printStackTrace(System.err);
                            }
                        }
                    }
                    catch (Throwable t) {
                        HandleServer.this.main.logError(75, "Error in replication daemon: " + t);
                        t.printStackTrace(System.err);
                    }
                }
                while (redumpNeeded) {
                    try {
                        System.err.println("------------------------------\n---- REDUMPING HANDLES!!! ----\n------------------------------");
                        HandleServer.this.serverEnabled = false;
                        for (int i = 0; i < HandleServer.this.replicationLastTimeStamps.length; ++i) {
                            ((HandleServer)HandleServer.this).replicationLastTimeStamps[i] = 0L;
                            ((HandleServer)HandleServer.this).replicationLastTxnIds[i] = 0L;
                        }
                        HandleServer.this.storage.deleteAllRecords();
                        DumpHandlesRequest req = new DumpHandlesRequest(((HandleServer)HandleServer.this).thisSite.hashOption, ((HandleServer)HandleServer.this).thisSite.servers.length, HandleServer.this.thisServerNum, HandleServer.this.replicationAuth);
                        Object error = null;
                        for (int i = 0; i < ((HandleServer)HandleServer.this).replicationSite.servers.length; ++i) {
                            AbstractResponse response = this.retrievalResolver.sendRequestToServer(req, ((HandleServer)HandleServer.this).replicationSite.servers[i]);
                            if (response.responseCode != 1) continue;
                            ((DumpHandlesResponse)response).processStreamedPart(new DumpHdlCallback(i), ((HandleServer)HandleServer.this).replicationSite.servers[i].getPublicKey());
                        }
                        HandleServer.this.saveReplicationInfo();
                        HandleServer.this.serverEnabled = true;
                        redumpNeeded = false;
                        System.err.println("------------------------------------\n---------- REDUMP FINISHED ---------\n------------------------------------");
                    }
                    catch (Throwable e) {
                        HandleServer.this.main.logError(75, "Error attempting to reload all handles: " + e);
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(HandleServer.this.replicationInterval);
                }
                catch (Throwable e) {
                    HandleServer.this.main.logError(50, "Error sleeping in replication thread: " + e);
                }
            }
        }
    }
}

