/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.spider;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import nl.mpi.bcarchive.spider.IMDINode;
import nl.mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IMDIContentHandler
implements ContentHandler {
    static Logger _logger = Logger.getLogger(IMDIContentHandler.class);
    private static String _imdiParser = "org.apache.xerces.parsers.SAXParser";
    private static String _imdiValidation = "http://xml.org/sax/features/validation";
    private static String _imdiNamespaces = "http://xml.org/sax/features/namespaces";
    private static String _imdiNSPrefixes = "http://xml.org/sax/features/namespace-prefixes";
    private XMLReader _imdiReader = null;
    private Locator _locator;
    private String _elementTextContent = "";
    private OurURL _baseURL;
    private String _currentImdiType = "Unknown";
    private String _currentLinkType = "Unknown";
    private String _currentFormat = "Unknown";
    private String _currentName = "Unknown";
    private String _currentTitle = "Unknown";
    private String _currentURID = null;
    private String _currentURL = null;
    private String _currentSelfURID = null;
    private String _currentCatalogueLink = null;
    private String _currentCatalogueURID = null;
    private Stack _currentContext;
    private Map _counterMap = null;
    private List _infoNodes = new ArrayList();
    private List _mediaNodes = new ArrayList();
    private List _writtenNodes = new ArrayList();
    private List _lexiconNodes = new ArrayList();
    private List _corpusLinks = new ArrayList();
    private long _lastModified = 0L;
    private long _fileSize = 0L;
    private boolean _blockAbsolute = true;
    private static final Set linkTypes = new HashSet();
    private static final Set skipNames;
    private static final Set multiNames;
    private static final Set linkNames;
    private static final Set imdiTypes;

    public IMDIContentHandler() {
        this(null);
    }

    public IMDIContentHandler(ErrorHandler eh) {
        this._imdiReader = this.createIMDIReader(this);
        this._imdiReader.setContentHandler(this);
        if (eh != null) {
            this._imdiReader.setErrorHandler(eh);
        }
    }

    public void parse(OurURL url) throws IOException, SAXException {
        URLConnection inputConn = url.openConnection();
        if (inputConn.getConnectTimeout() > 60000) {
            inputConn.setConnectTimeout(10000);
        }
        this.parse(inputConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(URLConnection inputConn) throws IOException, SAXException {
        this._lastModified = inputConn.getLastModified();
        this._fileSize = inputConn.getContentLength();
        InputStream inputStream = inputConn.getInputStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            String uri = inputConn.getURL().toString();
            int lastSlash = uri.lastIndexOf("/");
            if (lastSlash >= 0) {
                uri = uri.substring(0, lastSlash);
            }
            inputSource.setSystemId(uri + "/");
            this.init(new OurURL(inputConn.getURL()));
            this._imdiReader.parse(inputSource);
        }
        finally {
            inputStream.close();
            if (inputConn instanceof HttpURLConnection) {
                ((HttpURLConnection)inputConn).disconnect();
            }
        }
    }

    public void characters(char[] ch, int start, int end) {
        String str = new String(ch, start, end);
        this._elementTextContent = this._elementTextContent + str;
    }

    protected String getTextContent() {
        String content = new String(this._elementTextContent.trim());
        return content;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void processingInstruction(String target, String data) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
    }

    public void init(OurURL url) {
        this._currentContext = new Stack();
        this._counterMap = new HashMap();
        this._currentName = "Unknown";
        this._currentTitle = "Unknown";
        this._currentImdiType = "Unknown";
        this._currentLinkType = "Unknown";
        this._currentFormat = "Unknown";
        this._currentURID = null;
        this._currentURL = null;
        this._currentSelfURID = null;
        this._currentCatalogueLink = null;
        this._currentCatalogueURID = null;
        this._baseURL = url;
    }

    public void clearLists() {
        this._infoNodes = new ArrayList();
        this._mediaNodes = new ArrayList();
        this._writtenNodes = new ArrayList();
        this._lexiconNodes = new ArrayList();
        this._corpusLinks = new ArrayList();
    }

    public void setBlockAbsolute(boolean block) {
        this._blockAbsolute = block;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public String getImdiType() {
        return this._currentImdiType;
    }

    public String getURID() {
        return this._currentSelfURID;
    }

    public IMDINode getCatalogueLink() {
        if (this._currentCatalogueLink == null) {
            return null;
        }
        try {
            return new IMDINode(new OurURL(this._baseURL, this._currentCatalogueLink), "Corpus.Catalogue.CatalogueLink", "text/x-imdi+xml", this._currentCatalogueURID);
        }
        catch (MalformedURLException mue) {
            IMDIContentHandler.myError("getCatalogueLink: Error creating URL from: " + this._currentCatalogueLink);
            return null;
        }
    }

    public String getName() {
        return this._currentName;
    }

    public String getTitle() {
        return this._currentTitle;
    }

    public List getCorpusLinks() {
        return this._corpusLinks;
    }

    public List getMediaNodes() {
        return this._mediaNodes;
    }

    public List getWrittenNodes() {
        return this._writtenNodes;
    }

    public List getLexiconNodes() {
        return this._lexiconNodes;
    }

    public List getInfoNodes() {
        return this._infoNodes;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this._elementTextContent = "";
        this.enterContext(localName);
        if (imdiTypes.contains(localName)) {
            this._currentImdiType = localName;
            _logger.debug((Object)("IMDI Type: " + localName + " FILE: " + this._baseURL));
        }
        if (linkTypes.contains(localName)) {
            this._currentLinkType = localName;
        }
        if (linkNames.contains(localName)) {
            this._currentURID = this.getValue(atts, "ArchiveHandle");
        }
        if (localName.equals("Description")) {
            String link = this.getValue(atts, "Link");
            String urid = this.getValue(atts, "ArchiveHandle");
            this.storeLink(this._currentContext, "Link", localName, link, null, urid);
        }
        if (localName.equals("METATRANSCRIPT")) {
            this._currentSelfURID = this.getValue(atts, "ArchiveHandle");
            if (this._currentSelfURID != null && this._currentSelfURID.length() == 0) {
                this._currentSelfURID = null;
            }
        }
        if (localName.equals("Corpus")) {
            this._currentCatalogueLink = this.getValue(atts, "CatalogueLink");
            if (this._currentCatalogueLink != null && this._currentCatalogueLink.length() == 0) {
                this._currentCatalogueLink = null;
            }
            this._currentCatalogueURID = this.getValue(atts, "CatalogueHandle");
            if (this._currentCatalogueURID != null && this._currentCatalogueURID.length() == 0) {
                this._currentCatalogueURID = null;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.exitContextPrepare(localName);
        if (linkNames.contains(localName)) {
            this._currentURL = this.getTextContent();
        }
        if (linkTypes.contains(localName)) {
            this.storeLink(this._currentContext, localName, this._currentLinkType, this._currentURL, this._currentFormat, this._currentURID);
            this._currentLinkType = "Unknown";
            this._currentFormat = "Unknown";
            this._currentURID = null;
            this._currentURL = null;
        }
        this.exitContextCommit();
        String context = "";
        if (!this._currentContext.empty()) {
            context = ((ContextNode)this._currentContext.peek()).name;
        }
        if (localName.equals("Format")) {
            this._currentFormat = this.getTextContent();
        } else if (imdiTypes.contains(context) && localName.equals("Title")) {
            this._currentTitle = this.getTextContent();
        } else if (imdiTypes.contains(context) && localName.equals("Name")) {
            this._currentName = this.getTextContent();
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int end) {
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    protected String getValue(Attributes atts, String str) {
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getLocalName(i).equals(str)) continue;
            return atts.getValue(i);
        }
        return null;
    }

    private String getContextString(Stack context) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < context.size(); ++i) {
            ContextNode cn = (ContextNode)context.get(i);
            if (skipNames.contains(cn.name)) continue;
            str.append(cn.name);
            if (cn.multi) {
                str.append("(" + String.valueOf(cn.index) + ")");
            }
            if (i >= context.size() - 1) continue;
            str.append(".");
        }
        return str.toString();
    }

    private String getContextKey(Stack context) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < context.size(); ++i) {
            ContextNode cn = (ContextNode)context.get(i);
            str.append(cn.name);
            if (i >= context.size() - 1) continue;
            if (cn.multi) {
                str.append("(" + String.valueOf(cn.index) + ")");
            }
            str.append(".");
        }
        return str.toString();
    }

    private int getContextIndex(Stack context) {
        String key = this.getContextKey(context);
        Integer index = (Integer)this._counterMap.get(key);
        index = index == null ? new Integer(1) : new Integer(index + 1);
        this._counterMap.put(key, index);
        return index;
    }

    private void enterContext(String name) {
        ContextNode nc = new ContextNode(name);
        this._currentContext.push(nc);
        nc.putIndex(this.getContextIndex(this._currentContext));
    }

    private void exitContextPrepare(String name) throws SAXException {
        if (this._currentContext.empty()) {
            IMDIContentHandler.myError("element stack underflow for: " + name);
            throw new SAXException("XML element stack underflow for: " + name);
        }
        String other = ((ContextNode)this._currentContext.peek()).name;
        if (!name.equals(other)) {
            IMDIContentHandler.myError("element stack mismatch: " + other + " ... " + name);
            throw new SAXException("XML element stack mismatch: " + other + " ... " + name);
        }
    }

    private void exitContextCommit() {
        this._currentContext.pop();
    }

    private void storeLink(Stack context, String linkname, String linktype, String value, String format, String urid) {
        OurURL newURL = null;
        String path = this.getContextString(context);
        if (value == null || value.equals("")) {
            value = null;
        } else {
            if (this._blockAbsolute && this.isAbsolute(value)) {
                IMDIContentHandler.myError("storeLink: 'file:' URL must not be absolute in IMDI files: " + value);
                return;
            }
            try {
                newURL = new OurURL(this._baseURL, value);
            }
            catch (MalformedURLException mue) {
                IMDIContentHandler.myError("storeLink: Error creating URL from: " + value);
                return;
            }
        }
        if (urid != null && urid.equals("")) {
            urid = null;
        }
        if (newURL == null && urid == null) {
            return;
        }
        IMDINode node = new IMDINode(newURL, path, format, urid);
        if (linktype.equals("MediaFile")) {
            this._mediaNodes.add(node);
        } else if (linktype.equals("WrittenResource")) {
            this._writtenNodes.add(node);
        } else if (linktype.equals("LexiconResource")) {
            this._lexiconNodes.add(node);
        } else if (linktype.equals("Description")) {
            this._infoNodes.add(node);
        } else if (linktype.equals("CorpusLink")) {
            this._corpusLinks.add(node);
        } else {
            IMDIContentHandler.myError("storeLink: Unknown linktype: " + linktype + " node: " + node);
        }
    }

    private void printContext(Stack context) {
        _logger.debug((Object)this.getContextString(context));
    }

    private boolean isAbsolute(String value) {
        return value.startsWith("/") || value.startsWith("\\") || value.startsWith("file:///") || value.matches("^file:/\\w") || value.matches("^file:/*\\p{Alpha}:") || value.matches("^\\p{Alpha}:");
    }

    private static void myError(String errorMessage) {
        _logger.warn((Object)("ERROR: IMDIContentHandler: " + errorMessage));
    }

    private static void myDebug(String debugMessage) {
        _logger.debug((Object)("# DEBUG: IMDIContentHandler: " + debugMessage));
    }

    private XMLReader createIMDIReader(IMDIContentHandler imdiCH) {
        XMLReader xmlReader = null;
        try {
            xmlReader = XMLReaderFactory.createXMLReader(_imdiParser);
            try {
                xmlReader.setFeature(_imdiValidation, true);
                xmlReader.setFeature(_imdiNamespaces, true);
                xmlReader.setFeature(_imdiNSPrefixes, true);
                xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXException e) {
                _logger.warn((Object)("property not supported: " + e));
                throw e;
            }
        }
        catch (SAXException e) {
            IMDIContentHandler.myError("Parser init. error: " + e);
            System.exit(0);
        }
        return xmlReader;
    }

    static {
        linkTypes.add("MediaFile");
        linkTypes.add("WrittenResource");
        linkTypes.add("LexiconResource");
        linkTypes.add("CorpusLink");
        skipNames = new HashSet();
        skipNames.add("METATRANSCRIPT");
        skipNames.add("MDGroup");
        skipNames.add("Keys");
        skipNames.add("CommunicationContext");
        skipNames.add("Resources");
        multiNames = new HashSet();
        multiNames.add("MediaFile");
        multiNames.add("WrittenResource");
        multiNames.add("LexiconResource");
        multiNames.add("Source");
        multiNames.add("Anonyms");
        multiNames.add("Description");
        multiNames.add("Language");
        multiNames.add("Actor");
        multiNames.add("Region");
        multiNames.add("Key");
        linkNames = new HashSet();
        linkNames.add("ResourceLink");
        linkNames.add("Link");
        linkNames.add("CorpusLink");
        imdiTypes = new HashSet();
        imdiTypes.add("Unknown");
        imdiTypes.add("Corpus");
        imdiTypes.add("Session");
        imdiTypes.add("Lexicon");
        imdiTypes.add("Catalogue");
    }

    class ContextNode {
        String name;
        int index;
        boolean multi;

        ContextNode(String name) {
            this.multi = multiNames.contains(name);
            this.index = 0;
            this.name = name;
        }

        void putIndex(int index) {
            this.index = index;
        }
    }
}

