/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;
import java.util.Vector;
import net.handle.dnslib.DNSCache;
import net.handle.dnslib.DNSMessage;
import net.handle.dnslib.DNSQuestion;
import net.handle.dnslib.DNSResolutionException;
import net.handle.dnslib.DNSResourceAddressData;
import net.handle.dnslib.DNSResourceNameData;
import net.handle.dnslib.DNSResourceRecord;

public class DNSResolver {
    private static int nextID = new Random().nextInt();
    private InetAddress[] rootServers;
    private DNSCache cache = null;
    public static boolean DEBUG = true;
    public static final int DNS_PORT = 53;

    public static String convertDNSNameToString(String[] name, int offset, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            sb.append(name[i]);
            sb.append('.');
        }
        return sb.toString();
    }

    public static String convertDNSNameToString(String[] name) {
        return DNSResolver.convertDNSNameToString(name, 0, name.length);
    }

    public static String[] convertStringToDNSName(String hostName) {
        int dotIndex = 0;
        Vector<String> nameVector = new Vector<String>();
        do {
            String namePart;
            int nameStart = dotIndex;
            if ((dotIndex = hostName.indexOf(46, dotIndex)) >= 0) {
                namePart = hostName.substring(nameStart, dotIndex);
                ++dotIndex;
                if (namePart.length() <= 0) continue;
                nameVector.addElement(namePart);
                continue;
            }
            namePart = hostName.substring(nameStart);
            if (namePart.length() <= 0) continue;
            nameVector.addElement(namePart);
        } while (dotIndex >= 0);
        String[] dnsName = new String[nameVector.size()];
        for (int i = 0; i < dnsName.length; ++i) {
            dnsName[i] = (String)nameVector.elementAt(i);
        }
        return dnsName;
    }

    public DNSResolver() throws Exception {
        InetAddress[] tmp = new InetAddress[]{InetAddress.getByName("198.41.0.4"), InetAddress.getByName("128.9.0.107"), InetAddress.getByName("192.33.4.12"), InetAddress.getByName("128.8.10.90"), InetAddress.getByName("192.203.230.10"), InetAddress.getByName("192.5.5.241"), InetAddress.getByName("192.112.36.4"), InetAddress.getByName("128.63.2.53"), InetAddress.getByName("192.36.148.17")};
        this.rootServers = tmp;
    }

    public DNSResolver(DNSCache cache) throws Exception {
        this();
        this.cache = cache;
    }

    public DNSMessage resolveNameRecursively(String name, int recordType, int recordClass) throws Exception {
        return this.resolveNameRecursively(DNSResolver.convertStringToDNSName(name), recordType, recordClass);
    }

    public DNSMessage resolveNameRecursively(String[] name, int recordType, int recordClass, InetAddress[] nameServers, int depth) throws Exception {
        if (DEBUG) {
            for (int i = 0; i < depth; ++i) {
                System.err.print("  ");
            }
        }
        if (DEBUG) {
            System.err.println("Resolving name: " + DNSResolver.convertDNSNameToString(name) + "(" + recordType + "," + recordClass + ") via DNS");
        }
        boolean nsWasCached = false;
        if (this.cache != null) {
            try {
                DNSMessage message = this.cache.getDNSMessage(DNSResolver.convertDNSNameToString(name), recordType, recordClass);
                if (message != null) {
                    return message;
                }
            }
            catch (Exception e) {
                System.err.println("Exception using DNS cache: " + e);
            }
        }
        DNSMessage query = new DNSMessage();
        query.id = (char)nextID++;
        query.isQuery = false;
        query.opcode = 0;
        query.authAnswer = false;
        query.truncated = false;
        query.recursionDesired = true;
        query.recursionAvailable = false;
        query.responseCode = 0;
        query.questions = new DNSQuestion[1];
        query.questions[0] = new DNSQuestion(name, recordType, recordClass);
        query.answers = new DNSResourceRecord[0];
        query.nameServers = new DNSResourceRecord[0];
        query.additionalResources = new DNSResourceRecord[0];
        query.setDirty();
        if (this.cache != null && nameServers == null) {
            String[] parentDomain = new String[name.length];
            System.arraycopy(name, 0, parentDomain, 0, name.length);
            while (parentDomain.length > 0) {
                block12: {
                    try {
                        DNSMessage nsMessage = this.cache.getDNSMessage(DNSResolver.convertDNSNameToString(parentDomain), 2, recordClass);
                        if (nsMessage != null && nsMessage.additionalResources != null && nsMessage.additionalResources.length > 0) {
                            nameServers = this.extractNameServers(nsMessage);
                            nsWasCached = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUG) break block12;
                        System.err.println("Exception using DNS cache: " + e);
                    }
                }
                String[] tmpName = new String[parentDomain.length - 1];
                System.arraycopy(parentDomain, 1, tmpName, 0, tmpName.length);
                parentDomain = tmpName;
            }
        }
        return this.resolveNameStartingAt(query, name, recordType, recordClass, nameServers, depth);
    }

    private DNSMessage resolveNameStartingAt(DNSMessage query, String[] name, int recordType, int recordClass, InetAddress[] nameServers, int depth) throws Exception {
        if (nameServers == null) {
            nameServers = this.rootServers;
        }
        if (depth >= 20) {
            throw new DNSResolutionException("Too many hops resolving name: " + DNSResolver.convertDNSNameToString(name) + "");
        }
        DNSMessage response = null;
        try {
            response = this.queryServers(query, nameServers);
        }
        catch (Exception e) {
            if (DEBUG) {
                System.err.println("Error querying name service: " + e);
                e.printStackTrace(System.err);
            }
            throw e;
        }
        if (response.answers != null && response.answers.length > 0) {
            boolean gotAnswer = false;
            String[] cname = null;
            for (int i = 0; i < response.answers.length; ++i) {
                if (response.answers[i].qType == recordType) {
                    gotAnswer = true;
                    break;
                }
                if (response.answers[i].qType != 5) continue;
                cname = ((DNSResourceNameData)response.answers[i].rdata).getName();
            }
            if (gotAnswer) {
                this.saveToCache(name, recordType, recordClass, response);
            } else if (cname != null) {
                if (DEBUG) {
                    System.err.println("Resolving CNAME record (" + response.answers.length + "): " + DNSResolver.convertDNSNameToString(((DNSResourceNameData)response.answers[0].rdata).getName()));
                }
                DNSMessage origResponse = response;
                response = this.resolveNameRecursively(((DNSResourceNameData)response.answers[0].rdata).getName(), recordType, recordClass, this.extractNameServers(response), depth + 1);
                response.questions = query.questions;
                DNSResourceRecord[] newAnswers = new DNSResourceRecord[response.answers.length + origResponse.answers.length];
                System.arraycopy(origResponse.answers, 0, newAnswers, 0, origResponse.answers.length);
                System.arraycopy(response.answers, 0, newAnswers, origResponse.answers.length, response.answers.length);
                response.answers = newAnswers;
                response.setDirty();
                this.saveToCache(name, recordType, recordClass, response);
            }
            return response;
        }
        if (response.additionalResources == null || response.additionalResources.length <= 0) {
            this.saveToCache(name, recordType, recordClass, response);
            return response;
        }
        InetAddress[] newNameServers = this.extractNameServers(response);
        if (this.cache != null && newNameServers.length > 0) {
            response.questions[0].qName = response.nameServers[0].qName;
            response.questions[0].qType = response.nameServers[0].qType;
            response.answers = response.nameServers;
            response.nameServers = new DNSResourceRecord[0];
            response.authAnswer = false;
            response.setDirty();
            this.saveToCache(response.questions[0].qName, response.answers[0].qType, response.answers[0].qClass, response);
        }
        return this.resolveNameStartingAt(query, name, recordType, recordClass, newNameServers, depth + 1);
    }

    public InetAddress[] extractNameServers(DNSMessage message) {
        if (message.additionalResources == null) {
            return null;
        }
        if (message.additionalResources.length <= 0) {
            return new InetAddress[0];
        }
        InetAddress[] nameServers = new InetAddress[message.additionalResources.length];
        for (int n = 0; n < nameServers.length; ++n) {
            try {
                nameServers[n] = ((DNSResourceAddressData)message.additionalResources[n].rdata).getAddress();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return nameServers;
    }

    public DNSMessage resolveNameRecursively(String[] name, int recordType, int recordClass) throws Exception {
        return this.resolveNameRecursively(name, recordType, recordClass, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSMessage queryServers(DNSMessage message, InetAddress[] servers) throws Exception {
        int i;
        DatagramSocket sock = new DatagramSocket();
        sock = new DatagramSocket();
        sock.setSoTimeout(10000);
        byte[] queryBuf = message.getPacketBuffer();
        InetAddress[] tmpServers = new InetAddress[servers.length];
        System.arraycopy(servers, 0, tmpServers, 0, servers.length);
        servers = tmpServers;
        Random rand = new Random();
        for (i = 0; i < servers.length; ++i) {
            int swap = (int)(rand.nextFloat() * (float)servers.length);
            if (i == swap) continue;
            InetAddress tmp = servers[swap];
            servers[swap] = servers[i];
            servers[i] = tmp;
        }
        try {
            i = 0;
            while (true) {
                if (i < servers.length) {
                    try {
                        DatagramPacket packet = new DatagramPacket(queryBuf, queryBuf.length, servers[i], 53);
                        if (DEBUG) {
                            System.err.println(" ---Sending BIND query to: " + servers[i].getHostAddress() + "---");
                        }
                        sock.send(packet);
                        packet = new DatagramPacket(new byte[1024], 1024);
                        sock.receive(packet);
                        DNSMessage dNSMessage = new DNSMessage(packet.getData(), 0, packet.getLength());
                        return dNSMessage;
                    }
                    catch (Exception e) {
                        if (i == servers.length - 1) {
                            throw e;
                        }
                        ++i;
                        continue;
                    }
                }
                break;
            }
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception e) {}
        }
        throw new DNSResolutionException("Unable to query any nameservers");
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.err.println("Usage: java net.handle.dns.DNSResolver <dns-name>");
            return;
        }
        try {
            DNSCache cache = new DNSCache("dns_cache.db");
            DNSResolver resolver = new DNSResolver(cache);
            System.err.println("Name to resolve: " + argv[0]);
            DNSMessage result = resolver.resolveNameRecursively(argv[0], 1, 1);
            System.err.println("Got addresses: ");
            for (int i = 0; i < result.answers.length; ++i) {
                result.answers[i].printValues(System.err);
            }
        }
        catch (Exception e) {
            System.err.println("Got exception: " + e);
            e.printStackTrace(System.err);
        }
    }

    private void saveToCache(String[] name, int qType, int qClass, DNSMessage response) {
        if (this.cache == null) {
            return;
        }
        try {
            this.cache.setMessageData(DNSResolver.convertDNSNameToString(name), qType, qClass, response);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void printPacket(DatagramPacket pkt) {
        byte[] buf = pkt.getData();
        for (int i = 0; i < pkt.getLength(); ++i) {
            if (i % 16 == 0 && i != 0) {
                System.err.print("\n");
            }
            if (buf[i] >= 97 && buf[i] <= 122 || buf[i] >= 65 && buf[i] <= 90 || buf[i] == 46) {
                System.err.print(" " + (char)buf[i]);
                continue;
            }
            System.err.print(" \\" + (buf[i] & 0xFF));
        }
        System.err.print("\n");
    }
}

