/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import net.handle.dnslib.DNSResourceAddressData;
import net.handle.dnslib.DNSResourceData;
import net.handle.dnslib.DNSResourceHInfoData;
import net.handle.dnslib.DNSResourceMXData;
import net.handle.dnslib.DNSResourceNameData;
import net.handle.dnslib.DNSResourceOpaqueData;
import net.handle.dnslib.DNSResourceSOAData;

public class DNSResourceRecord {
    public String[] qName;
    public int qType;
    public int qClass;
    public int ttl;
    public DNSResourceData rdata;

    public DNSResourceRecord(String[] qName, int qType, int qClass, int ttl, byte[] rdata) {
        this.qName = qName;
        this.qType = qType;
        this.qClass = qClass;
        this.ttl = ttl;
        this.rdata = this.readData(qType, rdata, 0, rdata.length);
    }

    private DNSResourceData readData(int type, byte[] buf, int offset, int length) {
        if (buf == null) {
            buf = new byte[]{};
        }
        switch (this.qType) {
            case 1: {
                return new DNSResourceAddressData(buf, offset, length);
            }
            case 2: 
            case 5: 
            case 12: {
                return new DNSResourceNameData(buf, offset, length);
            }
            case 6: {
                return new DNSResourceSOAData(buf, offset, length);
            }
            case 13: {
                System.err.println("RR record of HINFO type: " + this.qType);
                return new DNSResourceHInfoData(buf, offset, length);
            }
            case 15: {
                return new DNSResourceMXData(buf, offset, length);
            }
        }
        System.err.println("RR record of unknown type: " + this.qType);
        return new DNSResourceOpaqueData(buf, offset, length);
    }

    public DNSResourceRecord() {
        this.qName = null;
        this.qType = -1;
        this.qClass = -1;
        this.ttl = 0;
        this.rdata = new DNSResourceOpaqueData();
    }

    public DNSResourceRecord(byte[] buf, int offset) {
        this.decode(buf, offset);
    }

    public int decode(byte[] buf, int offset) {
        int origLoc = offset;
        Vector nameVect = new Vector();
        offset += DNSResourceRecord.readNameFromPointer(buf, offset, nameVect);
        this.qName = new String[nameVect.size()];
        for (int i = 0; i < this.qName.length; ++i) {
            this.qName[i] = (String)nameVect.elementAt(i);
        }
        this.qType = (buf[offset++] & 0xFF) << 8 | buf[offset++] & 0xFF;
        this.qClass = (buf[offset++] & 0xFF) << 8 | buf[offset++] & 0xFF;
        this.ttl = (buf[offset++] & 0xFF) << 24 | (buf[offset++] & 0xFF) << 16 | (buf[offset++] & 0xFF) << 8 | buf[offset++] & 0xFF;
        int dataLen = (buf[offset++] & 0xFF) << 8 | buf[offset++] & 0xFF;
        this.rdata = this.readData(this.qType, buf, offset, dataLen);
        return (offset += dataLen) - origLoc;
    }

    public int encode(byte[] msgBuf, int location, Hashtable nameTable) {
        int origLoc = location;
        location += DNSResourceRecord.writeNameToPointer(this.qName, msgBuf, location, nameTable);
        msgBuf[location++] = (byte)((this.qType & 0xFF00) >> 8);
        msgBuf[location++] = (byte)(this.qType & 0xFF);
        msgBuf[location++] = (byte)((this.qClass & 0xFF00) >> 8);
        msgBuf[location++] = (byte)(this.qClass & 0xFF);
        msgBuf[location++] = (byte)((this.ttl & 0xFF000000) >> 24);
        msgBuf[location++] = (byte)((this.ttl & 0xFF0000) >> 16);
        msgBuf[location++] = (byte)((this.ttl & 0xFF00) >> 8);
        msgBuf[location++] = (byte)(this.ttl & 0xFF);
        int rdataLen = this.rdata.encodeData(msgBuf, location + 2, nameTable);
        msgBuf[location++] = (byte)((rdataLen & 0xFF00) >> 8);
        msgBuf[location++] = (byte)(rdataLen & 0xFF);
        return (location += rdataLen) - origLoc;
    }

    public void printValues(PrintStream out) {
        String name = "null";
        if (this.qName != null) {
            name = "";
            for (int i = 0; i < this.qName.length; ++i) {
                name = name + this.qName[i] + '.';
            }
        }
        out.println("name=\"" + name + "\" type=" + this.qType + " class=" + this.qClass + " ttl=" + this.ttl + " rdata=" + this.rdata);
    }

    public static int writeNameToPointer(String[] domainName, byte[] buf, int offset, Hashtable nameTable) {
        int origOffset = offset;
        for (int i = 0; i < domainName.length; ++i) {
            if (domainName[i].length() <= 0) continue;
            byte[] thisName = domainName[i].getBytes();
            buf[offset++] = (byte)thisName.length;
            System.arraycopy(thisName, 0, buf, offset, thisName.length);
            offset += thisName.length;
        }
        buf[offset++] = 0;
        return offset - origOffset;
    }

    public static int readNameFromPointer(byte[] buf, int offset, Vector nameVector) {
        int origLoc = offset;
        byte b;
        while ((b = buf[offset++]) != 0) {
            if ((b & 0xC0) >= 192) {
                int destOffset = (b & 0x3F) << 8 | 0xFF & buf[offset++];
                DNSResourceRecord.readNameFromPointer(buf, destOffset, nameVector);
                return offset - origLoc;
            }
            nameVector.addElement(new String(buf, offset, (int)b));
            offset += b;
        }
        return offset - origLoc;
    }
}

