/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.util.StreamTable;
import net.handle.util.StreamVector;

public class ConfigCommon {
    public static StreamTable configuration(int serverType, boolean disableUDP, int port, boolean logAccesses, InetAddress listenAddr, int threadCount, int httpPort, String logSavingInterval, boolean caseSensitive, int maxAuthTime, int maxSessionTime, int serverId, boolean isPrimary, String defaultServerAdmin, String replicationAdminStr, String replicationAuthStr) {
        StreamTable config = new StreamTable();
        StreamTable tcpConfig = new StreamTable();
        StreamTable httpConfig = new StreamTable();
        StreamTable udpConfig = new StreamTable();
        StreamTable svrConfig = new StreamTable();
        StreamTable logSaveConfig = new StreamTable();
        StreamVector sv = new StreamVector();
        StreamVector saVect = new StreamVector();
        config.put("no_udp_resolution", disableUDP ? "y" : "n");
        config.put("interfaces", sv);
        sv.addElement("hdl_udp");
        sv.addElement("hdl_tcp");
        sv.addElement("hdl_http");
        String portStr = String.valueOf(port);
        String accessesToBeLogged = logAccesses ? "yes" : "no";
        String hostAddress = listenAddr.getHostAddress();
        config.put("hdl_tcp_config", tcpConfig);
        tcpConfig.put("bind_port", portStr);
        tcpConfig.put("num_threads", String.valueOf(threadCount));
        tcpConfig.put("backlog", String.valueOf(5));
        tcpConfig.put("log_accesses", accessesToBeLogged);
        tcpConfig.put("bind_address", hostAddress);
        config.put("hdl_http_config", httpConfig);
        httpConfig.put("bind_port", String.valueOf(httpPort));
        httpConfig.put("num_threads", String.valueOf(threadCount));
        httpConfig.put("backlog", String.valueOf(5));
        httpConfig.put("log_accesses", accessesToBeLogged);
        httpConfig.put("bind_address", hostAddress);
        config.put("hdl_udp_config", udpConfig);
        udpConfig.put("bind_port", portStr);
        udpConfig.put("num_threads", String.valueOf(threadCount));
        udpConfig.put("log_accesses", accessesToBeLogged);
        udpConfig.put("bind_address", hostAddress);
        if (!logSavingInterval.equals("Never")) {
            config.put("log_save_config", logSaveConfig);
            logSaveConfig.put("log_save_interval", logSavingInterval);
        }
        svrConfig.put("this_server_id", String.valueOf(serverId));
        svrConfig.put("server_admins", saVect);
        if (serverType == 0) {
            config.put("server_type", "server");
            config.put("server_config", svrConfig);
            svrConfig.put("case_sensitive", caseSensitive ? "yes" : "no");
            svrConfig.put("max_auth_time", String.valueOf(maxAuthTime));
            svrConfig.put("max_session_time", String.valueOf(maxSessionTime));
            if (isPrimary) {
                StreamVector backupVect = new StreamVector();
                svrConfig.put("backup_admins", backupVect);
                backupVect.addElement(defaultServerAdmin);
                StreamVector raVect = new StreamVector();
                svrConfig.put("replication_admins", raVect);
                raVect.addElement(replicationAdminStr);
            } else {
                svrConfig.put("replication_authentication", "privatekey:" + replicationAuthStr);
            }
            saVect.addElement(defaultServerAdmin);
        } else {
            config.put("server_type", "cache");
            config.put("cache_config", svrConfig);
        }
        return config;
    }

    public static StreamTable contactDataTable(String orgName, String contactName, String contactPhone, String contactEmail) {
        StreamTable contactData = new StreamTable();
        contactData.put("org_name", orgName);
        if (contactName != null && !contactName.equals("")) {
            contactData.put("contact_name", contactName);
        }
        if (contactPhone == null && !contactPhone.equals("")) {
            contactData.put("contact_phone", contactPhone);
        }
        contactData.put("contact_email", contactEmail);
        return contactData;
    }

    public static void writeReplicationSiteFile(String statDirName, String statFileName, File replicationSiteFile, SiteInfo replicationSite) throws IOException {
        File replStatFile = new File(statDirName, statFileName);
        if (replStatFile.exists()) {
            replStatFile.delete();
        }
        FileOutputStream replSiteOut = new FileOutputStream(replicationSiteFile);
        replSiteOut.write(Encoder.encodeSiteInfoRecord(replicationSite));
        replSiteOut.close();
    }

    public static void createSiteBundle(String siteBundleDir, String siteBundleName, boolean isPrimary, String replicationAdminStr, File adminPubKeyFile, File replPubKeyFile, String replicationAuthStr, SiteInfo siteInfo, File contactDataFile) throws Exception {
        byte[] publicKey = null;
        ZipOutputStream bundle = new ZipOutputStream(new FileOutputStream(new File(siteBundleDir, siteBundleName)));
        if (isPrimary) {
            bundle.putNextEntry(new ZipEntry("repl_admin"));
            bundle.write(Util.encodeString(replicationAdminStr + "\n"));
            publicKey = ConfigCommon.contentsOf(adminPubKeyFile);
            bundle.putNextEntry(new ZipEntry("admpub.bin"));
            bundle.write(publicKey);
        } else {
            publicKey = ConfigCommon.contentsOf(replPubKeyFile);
            bundle.putNextEntry(new ZipEntry("replpub.bin"));
            bundle.write(publicKey);
            bundle.putNextEntry(new ZipEntry("replid.txt"));
            bundle.write(Util.encodeString(replicationAuthStr + "\n"));
        }
        bundle.putNextEntry(new ZipEntry("siteinfo.bin"));
        bundle.write(Encoder.encodeSiteInfoRecord(siteInfo));
        String contents = ConfigCommon.charContentsOf(contactDataFile);
        bundle.putNextEntry(new ZipEntry("contactdata.dct"));
        bundle.write(Util.encodeString(contents));
        bundle.close();
    }

    private static byte[] contentsOf(File f) throws Exception {
        int bytesRead = 0;
        byte[] buffer = new byte[(int)f.length()];
        FileInputStream inputStream = new FileInputStream(f);
        for (int totalBytesRead = 0; totalBytesRead < buffer.length && (bytesRead = inputStream.read(buffer, totalBytesRead, buffer.length - totalBytesRead)) >= 0; totalBytesRead += bytesRead) {
        }
        inputStream.close();
        return buffer;
    }

    private static String charContentsOf(File f) throws Exception {
        int charsRead = 0;
        char[] buffer = new char[(int)f.length()];
        InputStreamReader reader = new InputStreamReader(new FileInputStream(f));
        for (int totalCharsRead = 0; totalCharsRead < buffer.length && (charsRead = reader.read(buffer, totalCharsRead, buffer.length - totalCharsRead)) >= 0; totalCharsRead += charsRead) {
        }
        reader.close();
        return new String(buffer);
    }

    public static final boolean badHHMMSS(String timeString) {
        if (timeString != null && timeString.length() > 0) {
            String tStr = timeString;
            if (tStr.length() == 7) {
                tStr = "0" + tStr;
            }
            if (tStr.length() == 8 && tStr.substring(2, 3).equals(":") && tStr.substring(5, 6).equals(":")) {
                try {
                    int h = Integer.parseInt(tStr.substring(0, 2));
                    int m = Integer.parseInt(tStr.substring(3, 5));
                    int s = Integer.parseInt(tStr.substring(6, 8));
                    return h < 0 || h > 23 || m < 0 || m > 59 || s < 0 || s > 59;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public static boolean validPhoneNumberChar(char c) {
        return c >= '0' && c <= '9' || c == ' ' || c == '-' || c == '(' || c == ')';
    }
}

