/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueueListener;
import net.handle.hdllib.TransactionScannerInterface;
import net.handle.hdllib.Util;
import net.handle.util.StringUtils;

public class ReadOnlyTransactionQueue
implements TransactionQueueInterface {
    private File queueDir;
    private File queueIndexFile;
    private Vector cachedQueueFiles;
    private long indexModDate = 0L;
    private Calendar calendar;

    public ReadOnlyTransactionQueue(File queueDir) throws Exception {
        this.queueDir = queueDir;
        this.queueIndexFile = new File(queueDir, "index");
        this.calendar = Calendar.getInstance();
        this.loadIndex();
    }

    public synchronized long getFirstDate() {
        Vector queueFiles = null;
        try {
            queueFiles = this.loadIndex();
        }
        catch (Exception e) {
            System.err.println("Error trying to read queue:  " + e);
            e.printStackTrace(System.err);
            System.err.println("returning value that may cause a reload!");
            return Long.MAX_VALUE;
        }
        if (queueFiles.size() <= 0) {
            return Long.MAX_VALUE;
        }
        QueueFileEntry entry = (QueueFileEntry)queueFiles.elementAt(0);
        return entry.startDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLastTxnId() {
        Vector queueFiles = null;
        try {
            queueFiles = this.loadIndex();
        }
        catch (Exception e) {
            System.err.println("Error trying to read queue:  " + e);
            e.printStackTrace(System.err);
            System.err.println("returning value that may cause a reload!");
            return Long.MAX_VALUE;
        }
        if (queueFiles.size() <= 0) {
            return 0L;
        }
        long txnId = 0L;
        try {
            Transaction txn;
            QueueScanner scanner = new QueueScanner(queueFiles, (QueueFileEntry)queueFiles.elementAt(queueFiles.size() - 1));
            do {
                if ((txn = scanner.nextTransaction()) == null) continue;
                txnId = txn.txnId;
            } while (txn != null);
        }
        catch (Exception e) {
            System.err.println("Error getting transaction ID: " + e + "\n   using " + txnId);
        }
        finally {
            try {
                System.gc();
                System.runFinalization();
            }
            catch (Throwable t) {}
        }
        return txnId;
    }

    private synchronized int getQueueFileName(Date dt) {
        this.calendar.setTime(dt);
        return this.calendar.get(1) * 10000 + this.calendar.get(2) * 100 + this.calendar.get(5);
    }

    private synchronized Vector loadIndex() throws Exception {
        String line;
        if (!this.queueIndexFile.exists()) {
            if (this.cachedQueueFiles == null) {
                this.cachedQueueFiles = new Vector();
            }
            return this.cachedQueueFiles;
        }
        if (this.queueIndexFile.lastModified() == this.indexModDate && this.cachedQueueFiles != null) {
            return this.cachedQueueFiles;
        }
        Vector<QueueFileEntry> queueFiles = new Vector<QueueFileEntry>();
        long modDate = this.queueIndexFile.lastModified();
        BufferedReader reader = new BufferedReader(new FileReader(this.queueIndexFile));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            long startDate = Long.parseLong(StringUtils.fieldIndex(line, '\t', 0));
            long firstTxnId = Long.parseLong(StringUtils.fieldIndex(line, '\t', 1));
            int queueNumber = Integer.parseInt(StringUtils.fieldIndex(line, '\t', 2));
            queueFiles.addElement(new QueueFileEntry(startDate, firstTxnId, queueNumber));
        }
        this.cachedQueueFiles = queueFiles;
        this.indexModDate = modDate;
        return queueFiles;
    }

    public void addQueueListener(TransactionQueueListener l) {
        System.err.println("Warning: listener added to a transaction queue that does not support listeners");
    }

    public void removeQueueListener(TransactionQueueListener l) {
    }

    public void addTransaction(long txnId, byte[] handle, byte action, long date) throws Exception {
        throw new HandleException(18, "Transaction queue is read-only");
    }

    protected synchronized void addTransaction(Transaction txn) throws Exception {
        throw new HandleException(18, "Transaction queue is read-only");
    }

    private synchronized QueueFileEntry getNextQueue(Vector queueFiles, QueueFileEntry presentQueue) {
        for (int i = queueFiles.size() - 2; i >= 0; --i) {
            QueueFileEntry qfe = (QueueFileEntry)queueFiles.elementAt(i);
            if (qfe != presentQueue) continue;
            return (QueueFileEntry)queueFiles.elementAt(i + 1);
        }
        return null;
    }

    protected int nextField(int currPos, String txnStr) throws Exception {
        if (currPos >= txnStr.length()) {
            throw new Exception("No more fields in transaction");
        }
        for (int i = currPos + 1; i < txnStr.length(); ++i) {
            if (txnStr.charAt(i) != '|') continue;
            return i;
        }
        throw new Exception("Invalid transaction record: " + txnStr);
    }

    protected Transaction decodeTransaction(String txnStr) {
        try {
            int sepIdx = -1;
            Transaction txn = new Transaction();
            int n = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.txnId = Long.parseLong(txnStr.substring(n, sepIdx));
            int n2 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.action = (byte)Integer.parseInt(txnStr.substring(n2, sepIdx));
            int n3 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.date = Long.parseLong(txnStr.substring(n3, sepIdx));
            int n4 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.hashOnAll = Integer.parseInt(txnStr.substring(n4, sepIdx));
            int n5 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.hashOnNA = Integer.parseInt(txnStr.substring(n5, sepIdx));
            int n6 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.hashOnId = Integer.parseInt(txnStr.substring(n6, sepIdx));
            int n7 = sepIdx + 1;
            sepIdx = this.nextField(sepIdx, txnStr);
            txn.handle = Util.encodeHexString(txnStr.substring(n7, sepIdx));
            return txn;
        }
        catch (Exception e) {
            System.err.println("Exception decoding transaction: \n  " + txnStr + "\n  " + e);
            e.printStackTrace(System.err);
            return null;
        }
    }

    public synchronized void shutdown() {
    }

    public synchronized TransactionScannerInterface getScanner(long lastTxnID) throws Exception {
        Vector queueFiles = this.loadIndex();
        if (queueFiles.size() <= 0) {
            return null;
        }
        QueueFileEntry queueEntry = null;
        for (int i = 0; i < queueFiles.size(); ++i) {
            QueueFileEntry nextEntry = (QueueFileEntry)queueFiles.elementAt(i);
            if (nextEntry.firstTxnId >= 0L && nextEntry.firstTxnId > lastTxnID) {
                if (queueEntry == null) {
                    return new QueueScanner(queueFiles, nextEntry);
                }
                return new QueueScanner(queueFiles, queueEntry);
            }
            queueEntry = nextEntry;
        }
        if (queueEntry == null) {
            return new QueueScanner(queueFiles, (QueueFileEntry)queueFiles.elementAt(0));
        }
        return new QueueScanner(queueFiles, queueEntry);
    }

    class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            try {
                ReadOnlyTransactionQueue.this.shutdown();
            }
            catch (Throwable t) {
                System.err.println("Error finalizing txn queue: " + t);
            }
        }
    }

    public class QueueScanner
    implements TransactionScannerInterface {
        private Vector queueFiles;
        private BufferedReader reader;
        private QueueFileEntry queueFileEntry;
        private long firstDateInLog;

        protected QueueScanner(Vector queueFiles, QueueFileEntry queueFileEntry) throws Exception {
            this.queueFiles = queueFiles;
            this.firstDateInLog = queueFileEntry.getStartDate();
            this.connectToQueue(queueFileEntry);
        }

        public long getFirstDateInLog() {
            return this.firstDateInLog;
        }

        private void connectToQueue(QueueFileEntry nextQueue) throws Exception {
            block6: {
                this.queueFileEntry = nextQueue;
                this.reader = null;
                try {
                    File f = this.queueFileEntry.getQueueFile();
                    if (f.exists() && f.canRead()) {
                        this.reader = new BufferedReader(new FileReader(f));
                        break block6;
                    }
                    throw new Exception("Cannot access file: " + f);
                }
                catch (Exception e) {
                    throw new Exception("Unable to open transaction log: " + e);
                }
                finally {
                    System.gc();
                    System.runFinalization();
                }
            }
        }

        public synchronized Transaction nextTransaction() throws Exception {
            Transaction txn;
            String line = null;
            while (true) {
                if ((line = this.reader.readLine()) == null) {
                    QueueFileEntry nextQueue = ReadOnlyTransactionQueue.this.getNextQueue(this.queueFiles, this.queueFileEntry);
                    if (nextQueue == null) {
                        return null;
                    }
                    this.connectToQueue(nextQueue);
                    continue;
                }
                if (line.trim().length() <= 0) continue;
                txn = ReadOnlyTransactionQueue.this.decodeTransaction(line);
                if (txn.action != 0) break;
            }
            return txn;
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class QueueFileEntry {
        private long startDate;
        private long firstTxnId;
        private int queueNumber;
        private File queueFile = null;

        QueueFileEntry(long startDate, long firstTxnId, int queueNumber) {
            this.startDate = startDate;
            this.firstTxnId = firstTxnId;
            this.queueNumber = queueNumber;
        }

        long getStartDate() {
            return this.startDate;
        }

        long getFirstTxnId() {
            return this.firstTxnId;
        }

        long getQueueNumber() {
            return this.queueNumber;
        }

        synchronized File getQueueFile() {
            if (this.queueFile == null) {
                this.queueFile = new File(ReadOnlyTransactionQueue.this.queueDir, String.valueOf(this.queueNumber) + ".q");
            }
            return this.queueFile;
        }

        public String toString() {
            return String.valueOf(this.queueNumber) + "; firsttxn=" + this.firstTxnId + "; startDate=" + this.startDate + "; file=" + this.queueFile;
        }

        public boolean equals(Object obj) {
            return obj instanceof QueueFileEntry && ((QueueFileEntry)obj).getQueueNumber() == (long)this.queueNumber;
        }
    }
}

