/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConnections {
    private static final Logger logger = LoggerFactory.getLogger(URLConnections.class);
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    private final int maxRedirects;

    public URLConnections() {
        this(5);
    }

    public URLConnections(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public URL getUrlCheckRedirects(URLConnection c) throws IOException {
        int redirects = 0;
        URL result = c.getURL();
        try {
            boolean redir;
            do {
                HttpURLConnection http;
                int stat;
                if (c instanceof HttpURLConnection) {
                    ((HttpURLConnection)c).setInstanceFollowRedirects(false);
                }
                c.getInputStream();
                redir = false;
                if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
                URL target = this.handleRedirect(http, redirects);
                redir = true;
                c = target.openConnection();
                ++redirects;
                result = target;
            } while (redir);
        }
        catch (IOException ex) {
            logger.error("IOException: {}", (Object)result);
            logger.debug("IOException", (Throwable)ex);
        }
        return result;
    }

    public InputStream openStreamCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL target = this.handleRedirect(http, redirects);
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    private URL handleRedirect(HttpURLConnection http, int redirectCount) throws SecurityException, MalformedURLException {
        URL base = http.getURL();
        String loc = http.getHeaderField("Location");
        URL target = loc == null ? null : new URL(base, loc);
        http.disconnect();
        if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirectCount >= this.maxRedirects) {
            throw new SecurityException("illegal URL redirect");
        }
        return target;
    }
}

