/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core.handle;

import java.net.URI;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import nl.mpi.archiving.corpusstructure.core.handle.HandleResolver;
import nl.mpi.archiving.corpusstructure.core.handle.InvalidHandleException;

public class HandleApiResolver
implements HandleResolver {
    private static final String GLOBAL_RESOLVER = "hdl.handle.net";
    protected final net.handle.hdllib.HandleResolver api = new net.handle.hdllib.HandleResolver();

    @Override
    public URI resolve(URI uri) throws InvalidHandleException {
        try {
            if (uri.getScheme() == null) {
                throw new InvalidHandleException("Scheme is required");
            }
            if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
                if (uri.getHost().equals(GLOBAL_RESOLVER)) {
                    String hdl = uri.getPath();
                    if (hdl.startsWith("/")) {
                        hdl = hdl.substring(1, hdl.length());
                    }
                    if (hdl.startsWith("hdl:")) {
                        hdl = hdl.substring(4, hdl.length());
                    }
                    return URI.create(this.resolve(hdl));
                }
                throw new InvalidHandleException("http(s) handle uri did not start with hdl.handle.net");
            }
            if (uri.getScheme().equalsIgnoreCase("hdl")) {
                return URI.create(this.resolve(uri.getRawSchemeSpecificPart()));
            }
            throw new InvalidHandleException("Handle uri scheme [" + uri.getScheme() + "] is invalid.");
        }
        catch (HandleException ex) {
            throw new InvalidHandleException("Handle resolution error", ex);
        }
    }

    protected String resolve(String handle) throws HandleException {
        String[] types = new String[]{"URL"};
        HandleValue[] values = this.api.resolveHandle(handle, types, null);
        return values[0].getDataAsString();
    }
}

