/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleUtils {
    private static final Logger logger = LoggerFactory.getLogger(HandleUtils.class);
    public static final String HANDLE_SERVER_URI = "http://hdl.handle.net/";
    private static final String HDL_SCHEME_PREFIX = "hdl:";
    public static final int REDIRECT_TIMEOUT = 30000;

    public boolean isHandle(String resourceRef) {
        return resourceRef.startsWith(HANDLE_SERVER_URI) || resourceRef.startsWith(HDL_SCHEME_PREFIX);
    }

    public URI resolveHandle(String resourceRef) throws URISyntaxException {
        if (resourceRef != null && resourceRef.length() > 0) {
            if (resourceRef.startsWith("hdl://")) {
                return new URI(resourceRef.replace("hdl://", HANDLE_SERVER_URI));
            }
            if (resourceRef.startsWith(HDL_SCHEME_PREFIX)) {
                return new URI(resourceRef.replace(HDL_SCHEME_PREFIX, HANDLE_SERVER_URI));
            }
            return new URI(resourceRef);
        }
        return null;
    }

    public URI resolveHandle(URI resourceURI) {
        if ("hdl".equals(resourceURI.getScheme())) {
            return URI.create(HANDLE_SERVER_URI + resourceURI.toString().replaceFirst("^hdl:", ""));
        }
        return resourceURI;
    }

    public URI followRedirect(URI handleURI) {
        if (handleURI.getScheme().startsWith("http") || handleURI.getScheme().equalsIgnoreCase("hdl")) {
            try {
                URL uRL = this.resolveHandle(handleURI).toURL();
                logger.trace("Resolved {} to {}", (Object)handleURI, (Object)uRL);
                URLConnection uRLConnection = uRL.openConnection();
                int maxRedirects = 5;
                while (maxRedirects > 0) {
                    if (!(uRLConnection instanceof HttpURLConnection)) continue;
                    HttpURLConnection httpConnection = (HttpURLConnection)uRLConnection;
                    httpConnection.setInstanceFollowRedirects(true);
                    int stat = httpConnection.getResponseCode();
                    if (stat < 300 || stat > 307 || stat == 306 || stat == 304) break;
                    try {
                        String locationField = uRLConnection.getHeaderField("Location");
                        if (locationField == null) continue;
                        uRLConnection = new URI(locationField).toURL().openConnection();
                    }
                    catch (URISyntaxException exception) {
                        logger.debug("get document 303 check on URL {} failed", (Object)exception.getMessage());
                    }
                }
                return uRLConnection.getURL().toURI();
            }
            catch (ConnectException ex) {
                logger.warn("Connection to {} could not be established, could not check for a redirect (timeout is {}ms}): {}", new Object[]{handleURI, 30000, ex.getMessage()});
                logger.info("Connection could not be established while looking for redirect", (Throwable)ex);
            }
            catch (IOException ex) {
                logger.warn("Could not follow redirects for {}: {}", (Object)handleURI, (Object)ex.getMessage());
                logger.info("Could not follow redirects", (Throwable)ex);
            }
            catch (URISyntaxException ex) {
                logger.warn("Could not follow redirects for {}: {}", (Object)handleURI, (Object)ex.getMessage());
                logger.info("Could not follow redirects", (Throwable)ex);
            }
        }
        return handleURI;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        new HandleUtils().followRedirect(URI.create("http://hdl.handle.net/1839/00-0000-0000-0001-53A6-F@format=cmdi"));
    }
}

