/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.metadatafile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.clarin.profiles.CmdiProfileReader;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeService;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.IMDIVocabularies;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.userstorage.ArbilConfiguration;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataReader {
    private static final Logger logger = LoggerFactory.getLogger(MetadataReader.class);
    private static MetadataReader singleInstance = null;
    private static MessageDialogHandler messageDialogHandler;
    private static DataNodeLoader dataNodeLoader;
    private static ApplicationVersionManager versionManager;
    public static final String imdiPathSeparator = ".";
    private static final ResourceBundle services;
    private ArbilConfiguration applicationConfiguration = new ArbilConfiguration();
    private static final Pattern CMD_SCHEMA_LOCATION_PATTERN;
    private static final CopyOnWriteArrayList<String> IGNORED_METADATA_TYPES;
    private static final String MD_SELF_LINK = "MdSelfLink";
    private static final String HDL = "hdl:";
    private static final String HTTPHDLHANDLENET = "http://hdl.handle.net/";

    public static synchronized MetadataReader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new MetadataReader();
        }
        return singleInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public static void setVersionManager(ApplicationVersionManager versionManagerInstance) {
        versionManager = versionManagerInstance;
    }

    public boolean nodeCanExistInNode(ArbilDataNode targetDataNode, ArbilDataNode childDataNode) {
        String targetImdiPath = MetadataReader.getNodePath(targetDataNode);
        String childPath = MetadataReader.getNodePath(childDataNode);
        targetImdiPath = targetImdiPath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        childPath = childPath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        int targetBranchCount = targetImdiPath.replaceAll("[^(]*", "").length();
        int childBranchCount = childPath.replaceAll("[^(]*", "").length();
        boolean hasCorrectSubNodeCount = childBranchCount - targetBranchCount < 2;
        return hasCorrectSubNodeCount && !childPath.equals(targetImdiPath) && childPath.startsWith(targetImdiPath);
    }

    public static String getNodePath(ArbilDataNode targetDataNode) {
        String xpath = targetDataNode.isSession() ? ".METATRANSCRIPT.Session" : (targetDataNode.isCatalogue() ? ".METATRANSCRIPT.Catalogue" : ".METATRANSCRIPT.Corpus");
        String[] nodePathArray = targetDataNode.getUrlString().split("#");
        if (nodePathArray.length > 1) {
            String nodePath;
            xpath = nodePath = nodePathArray[1].toString();
        }
        return xpath;
    }

    private URL constructTemplateUrl(String templateType) {
        URL templateUrl;
        if (CmdiProfileReader.pathIsProfile(templateType)) {
            try {
                return new URL(templateType);
            }
            catch (MalformedURLException ex) {
                BugCatcherManager.getBugCatcher().logError(ex);
                templateUrl = null;
            }
        } else {
            templateUrl = MetadataReader.class.getResource("/nl/mpi/arbil/resources/templates/" + templateType.substring(1) + ".xml");
        }
        if (templateUrl == null) {
            try {
                templateUrl = ArbilTemplateManager.getSingleInstance().getDefaultComponentOfTemplate(templateType).toURI().toURL();
            }
            catch (MalformedURLException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
                return null;
            }
        }
        return templateUrl;
    }

    public URI addFromTemplate(File destinationFile, String templateType) {
        logger.debug("addFromJarTemplateFile: {} : {}", (Object)templateType, (Object)destinationFile);
        URL templateUrl = this.constructTemplateUrl(templateType);
        if (templateUrl == null) {
            return null;
        }
        try {
            MetadataReader.copyToDisk(templateUrl, destinationFile);
        }
        catch (IOException ex) {
            logger.warn("Could not copy template file from {} to {} due to an I/O exception: {}", new Object[]{templateUrl, destinationFile, ex.getMessage()});
            logger.debug("Details for I/O exception while copying from template file", (Throwable)ex);
            return null;
        }
        URI addedPathUri = destinationFile.toURI();
        try {
            Document addedDocument = ArbilComponentBuilder.getDocument(addedPathUri);
            if (addedDocument == null) {
                messageDialogHandler.addMessageDialogToQueue(services.getString("ERROR INSERTING CREATE DATE"), services.getString("ADD FROM TEMPLATE"));
            } else {
                Node linkNode = XPathAPI.selectSingleNode((Node)addedDocument, (String)"/:METATRANSCRIPT");
                NamedNodeMap metatranscriptAttributes = linkNode.getAttributes();
                ApplicationVersion currentVersion = versionManager.getApplicationVersion();
                String arbilVersionString = "Arbil." + currentVersion.currentMajor + imdiPathSeparator + currentVersion.currentMinor + imdiPathSeparator + currentVersion.currentRevision;
                arbilVersionString = arbilVersionString + ":" + metatranscriptAttributes.getNamedItem("Originator").getNodeValue();
                metatranscriptAttributes.getNamedItem("Originator").setNodeValue(arbilVersionString);
                metatranscriptAttributes.getNamedItem("Date").setNodeValue(new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()));
                ArbilComponentBuilder.savePrettyFormatting(addedDocument, new File(addedPathUri));
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        return addedPathUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToDisk(URL sourceURL, File targetFile) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = sourceURL.openStream();
            out = new FileOutputStream(targetFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            in = null;
            out.flush();
            ((OutputStream)out).close();
            out = null;
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public String getNodeTypeFromMimeType(String mimeType) {
        logger.debug("getNodeTypeFromMimeType: {}", (Object)mimeType);
        for (String[] formatType : new String[][]{{"http://www.mpi.nl/IMDI/Schema/WrittenResource-Format.xml", ".METATRANSCRIPT.Session.Resources.WrittenResource", "Manual/WrittenResource"}, {"http://www.mpi.nl/IMDI/Schema/MediaFile-Format.xml", ".METATRANSCRIPT.Session.Resources.MediaFile", "Manual/MediaFile"}}) {
            if (formatType[2].equals(mimeType)) {
                logger.debug("UsingOverrideNodeType: {}", (Object)formatType[1]);
                return formatType[1];
            }
            if (!IMDIVocabularies.getSingleInstance().vocabularyContains(formatType[0], mimeType)) continue;
            logger.debug("NodeType: {}", (Object)formatType[1]);
            return formatType[1];
        }
        return null;
    }

    private String getNamedAttributeValue(NamedNodeMap namedNodeMap, String attributeName) {
        Node nameNode = namedNodeMap.getNamedItem(attributeName);
        if (nameNode != null) {
            return nameNode.getNodeValue();
        }
        return null;
    }

    public URI correctLinkPath(URI parentPath, String linkString) {
        URI linkURI = null;
        try {
            linkURI = !linkString.toLowerCase().startsWith("http:") && !linkString.toLowerCase().startsWith("file:") ? parentPath.resolve(new URI(null, linkString, null)) : (linkString.toLowerCase().startsWith("&root;") ? parentPath.resolve(new URI(null, linkString.substring(6), null)) : parentPath.resolve(linkString));
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError(parentPath.toString() + " : " + linkString, exception);
        }
        if (linkURI != null) {
            linkURI = ArbilDataNodeService.normaliseURI(linkURI);
        }
        return linkURI;
    }

    private void showDomIdFoundMessage() {
        if (!dataNodeLoader.nodesNeedSave()) {
            messageDialogHandler.addMessageDialogToQueue(services.getString("A DOM ID ATTRIBUTE HAS BEEN FOUND IN ONE OR MORE FILES, THESE FILES WILL NEED TO BE SAVED TO CORRECT THIS."), services.getString("LOAD IMDI FILES"));
        }
    }

    public int iterateChildNodes(ArbilDataNode parentNode, List<String[]> childLinks, Node startNode, String nodePath, String fullNodePath, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, Map<String, Integer> siblingNodePathCounter, int nodeOrderCounter, boolean shallowLoading) {
        if (!parentChildTree.containsKey(parentNode)) {
            parentChildTree.put(parentNode, new HashSet());
        }
        for (Node childNode = startNode; childNode != null; childNode = childNode.getNextSibling()) {
            ArbilDataNode destinationNode;
            String localName = childNode.getLocalName();
            NamedNodeMap childNodeAttributes = childNode.getAttributes();
            if (localName == null) continue;
            String childNodePath = new StringBuilder(3).append(nodePath).append(imdiPathSeparator).append(localName).toString();
            if (childNodePath.equals(".CMD.Header")) {
                for (Node headerNode = childNode.getFirstChild(); headerNode != null; headerNode = headerNode.getNextSibling()) {
                    String textContent;
                    if (!MD_SELF_LINK.equals(headerNode.getLocalName()) || (textContent = headerNode.getTextContent()) == null) continue;
                    if (textContent.startsWith(HDL)) {
                        parentNode.archiveHandle = textContent;
                    } else if (textContent.startsWith(HTTPHDLHANDLENET)) {
                        parentNode.archiveHandle = textContent.replace(HTTPHDLHANDLENET, HDL);
                    }
                    parentNode.archiveUri = textContent;
                }
                continue;
            }
            if (childNodePath.equals(".CMD.Resources") || childNodePath.equals(".Kinnate.Entity")) continue;
            if (childNodeAttributes != null) {
                this.removeImdiNodeIds(childNodeAttributes, parentNode);
            }
            if (fullNodePath.length() == 0) {
                this.getTemplate(childNode, parentNode, childNodeAttributes);
            }
            if (localName.equals("Corpus")) {
                this.getImdiCatalogue(childNodeAttributes, parentNode, childLinks, parentChildTree);
            }
            ArbilDataNode parentDomNode = parentNode.getParentDomNode();
            ArbilTemplate parentNodeTemplate = parentDomNode.getNodeTemplate();
            StringBuilder fullSubNodePath = new StringBuilder(fullNodePath).append(imdiPathSeparator).append(localName);
            String parentNodePath = this.determineParentPath(parentNode);
            String combinedPath = parentNodePath + childNodePath;
            String childsMetaNode = parentNodeTemplate.pathIsChildNode(combinedPath);
            int maxOccurs = parentNodeTemplate.getMaxOccursForTemplate(combinedPath);
            String siblingNodePath = childNodePath;
            if (childsMetaNode != null) {
                try {
                    StringBuilder siblingSpacer;
                    ArbilDataNode metaNode = null;
                    String pathUrlXpathSeparator = "";
                    if (!parentNode.getUrlString().contains("#")) {
                        pathUrlXpathSeparator = "#";
                    }
                    boolean isSingleton = false;
                    StringBuilder nodeURIStringBuilder = new StringBuilder(4).append(parentNode.getURI().toString()).append(pathUrlXpathSeparator).append(siblingNodePath);
                    if (!this.applicationConfiguration.isVerbatimXmlTreeStructure() && (maxOccurs > 1 || maxOccurs == -1) || !(parentDomNode.nodeTemplate instanceof CmdiTemplate)) {
                        isSingleton = maxOccurs == 1;
                        metaNode = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI(nodeURIStringBuilder.toString()));
                        metaNode.setParentDomNode(parentDomNode);
                        metaNode.setNodeText(childsMetaNode);
                        if (!parentChildTree.containsKey(metaNode)) {
                            parentChildTree.put(metaNode, new HashSet());
                        }
                        if (!isSingleton) {
                            parentChildTree.get(parentNode).add(metaNode);
                        }
                        siblingSpacer = new StringBuilder(3).append("(").append(parentChildTree.get(metaNode).size() + 1).append(")");
                    } else {
                        int siblingCount = this.countSiblings(parentChildTree, parentNode, localName);
                        siblingSpacer = new StringBuilder(3).append("(").append(siblingCount).append(")");
                    }
                    fullSubNodePath.append((CharSequence)siblingSpacer);
                    nodeURIStringBuilder.append((CharSequence)siblingSpacer);
                    ArbilDataNode subNode = dataNodeLoader.getArbilDataNodeWithoutLoading(new URI(nodeURIStringBuilder.toString()));
                    subNode.setParentDomNode(parentDomNode);
                    if (metaNode != null && !isSingleton) {
                        parentChildTree.get(metaNode).add(subNode);
                        metaNode.setContainerNode(true);
                    } else {
                        parentChildTree.get(parentNode).add(subNode);
                        subNode.setSingletonMetadataNode(isSingleton);
                    }
                    if (!parentChildTree.containsKey(subNode)) {
                        parentChildTree.put(subNode, new HashSet());
                    }
                    destinationNode = subNode;
                }
                catch (URISyntaxException ex) {
                    destinationNode = parentNode;
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
                siblingNodePath = "";
            } else {
                destinationNode = parentNode;
            }
            if (shallowLoading && destinationNode != parentDomNode) continue;
            nodeOrderCounter = this.enterChildNodesRecursion(parentNode, childLinks, childNode, childNodeAttributes, destinationNode, localName, parentNodePath, siblingNodePath, fullSubNodePath.toString(), parentChildTree, siblingNodePathCounter, nodeOrderCounter, shallowLoading);
        }
        return nodeOrderCounter;
    }

    private int enterChildNodesRecursion(ArbilDataNode parentNode, List<String[]> childLinks, Node childNode, NamedNodeMap childNodeAttributes, ArbilDataNode destinationNode, String localName, String parentNodePath, String siblingNodePath, String fullSubNodePath, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, Map<String, Integer> siblingNodePathCounter, int nodeOrderCounter, boolean shallowLoading) throws DOMException {
        boolean shouldAddCurrent;
        NodeList childNodes = childNode.getChildNodes();
        boolean bl = shouldAddCurrent = childNodes.getLength() == 0 && localName != null || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3;
        if (!siblingNodePathCounter.containsKey(fullSubNodePath)) {
            siblingNodePathCounter.put(fullSubNodePath, 0);
        } else {
            siblingNodePathCounter.put(fullSubNodePath, siblingNodePathCounter.get(fullSubNodePath) + 1);
        }
        if (parentNode.getParentDomNode().getNodeTemplate().pathIsEditableField(parentNodePath + siblingNodePath)) {
            String fieldValue = childNodes.getLength() == 1 ? childNodes.item(0).getTextContent() : "";
            nodeOrderCounter = this.addEditableField(nodeOrderCounter, destinationNode, siblingNodePath, fieldValue, siblingNodePathCounter, fullSubNodePath, parentNode, childLinks, parentChildTree, childNodeAttributes, shouldAddCurrent);
        } else {
            this.addReferencedResources(parentNode, parentChildTree, childNodeAttributes, childLinks, destinationNode);
            if (childNodeAttributes != null && parentNode.isCmdiMetaDataNode()) {
                nodeOrderCounter = this.addCmdiAttributeFields(nodeOrderCounter, childNodeAttributes, destinationNode, siblingNodePath, siblingNodePathCounter, fullSubNodePath, parentNode, childLinks, parentChildTree);
            }
        }
        return this.iterateChildNodes(destinationNode, childLinks, childNode.getFirstChild(), siblingNodePath, fullSubNodePath, parentChildTree, siblingNodePathCounter, nodeOrderCounter, shallowLoading);
    }

    private int countSiblings(Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, ArbilDataNode parentNode, String localName) {
        int siblingCount = 1;
        for (ArbilDataNode siblingNode : parentChildTree.get(parentNode)) {
            String siblingPath = siblingNode.getURIFragment();
            if (siblingPath == null) continue;
            siblingPath = siblingPath.substring(siblingPath.lastIndexOf(imdiPathSeparator) + 1);
            if (!localName.equals(siblingPath = siblingPath.replaceAll("\\(\\d+\\)", ""))) continue;
            ++siblingCount;
        }
        return siblingCount;
    }

    private void removeImdiNodeIds(NamedNodeMap attributesMap, ArbilDataNode parentNode) {
        if (attributesMap.getNamedItem("id") != null && !parentNode.hasDomIdAttribute && !parentNode.isCmdiMetaDataNode()) {
            parentNode.hasDomIdAttribute = true;
            this.showDomIdFoundMessage();
            parentNode.setDataNodeNeedsSaveToDisk(null, false);
        }
    }

    private int addEditableField(int nodeOrderCounter, ArbilDataNode destinationNode, String siblingNodePath, String fieldValue, Map<String, Integer> siblingNodePathCounter, String fullSubNodePath, ArbilDataNode parentNode, List<String[]> childLinks, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, NamedNodeMap childNodeAttributes, boolean shouldAddCurrent) {
        boolean allowsLanguageId;
        HashMap<String, Object> attributesValueMap;
        List<String[]> attributePaths;
        ArbilTemplate template;
        String keyName;
        String languageId;
        String archiveHandle;
        String cvUrlString;
        String cvType;
        if (childNodeAttributes != null) {
            cvType = this.getNamedAttributeValue(childNodeAttributes, "Type");
            cvUrlString = this.getNamedAttributeValue(childNodeAttributes, "Link");
            archiveHandle = this.getNamedAttributeValue(childNodeAttributes, "ArchiveHandle");
            String languageIdAttribute = this.getNamedAttributeValue(childNodeAttributes, "LanguageId");
            languageId = languageIdAttribute != null ? languageIdAttribute : this.getNamedAttributeValue(childNodeAttributes, "xml:lang");
            keyName = this.getNamedAttributeValue(childNodeAttributes, "Name");
        } else {
            cvType = null;
            cvUrlString = null;
            keyName = null;
            languageId = null;
            archiveHandle = null;
        }
        if (destinationNode.isCmdiMetaDataNode() && (template = destinationNode.getNodeTemplate()) instanceof CmdiTemplate) {
            String nodePath = fullSubNodePath.replaceAll("\\(\\d+\\)", "");
            CmdiTemplate cmdiTemplate = (CmdiTemplate)template;
            attributePaths = cmdiTemplate.getEditableAttributesForPath(nodePath);
            attributesValueMap = new HashMap<String, Object>();
            if (childNodeAttributes != null) {
                for (int i = 0; i < childNodeAttributes.getLength(); ++i) {
                    Node attrNode = childNodeAttributes.item(i);
                    String path = nodePath + ".@" + CmdiTemplate.getAttributePathSection(attrNode.getNamespaceURI(), attrNode.getLocalName());
                    attributesValueMap.put(path, attrNode.getNodeValue());
                }
            }
            allowsLanguageId = cmdiTemplate.pathAllowsLanguageId(nodePath);
        } else {
            allowsLanguageId = languageId != null;
            attributePaths = null;
            attributesValueMap = null;
        }
        ArbilField fieldToAdd = new ArbilField(nodeOrderCounter++, destinationNode, siblingNodePath, fieldValue, siblingNodePathCounter.get(fullSubNodePath), allowsLanguageId, attributePaths, attributesValueMap);
        fieldToAdd.setArchiveHandle(archiveHandle);
        if (childNodeAttributes != null) {
            fieldToAdd.setFieldAttribute(cvType, cvUrlString, languageId, keyName);
            if (fieldToAdd.xmlPath.endsWith("Description") && cvUrlString != null && cvUrlString.length() > 0) {
                URI correcteLink = this.correctLinkPath(parentNode.getURI(), cvUrlString);
                childLinks.add(new String[]{correcteLink.toString(), "Info Link"});
                ArbilDataNode descriptionLinkNode = dataNodeLoader.getArbilDataNodeWithoutLoading(correcteLink);
                descriptionLinkNode.isInfoLink = true;
                descriptionLinkNode.setLoadingState(ArbilDataNode.LoadingState.LOADED);
                parentChildTree.get(parentNode).add(descriptionLinkNode);
                descriptionLinkNode.addField(fieldToAdd);
            }
            this.addReferencedResources(parentNode, parentChildTree, childNodeAttributes, childLinks, destinationNode);
        }
        if (shouldAddCurrent) {
            if (fieldToAdd.isDisplayable()) {
                destinationNode.addField(fieldToAdd);
            } else if (fieldToAdd.xmlPath.startsWith(".METATRANSCRIPT.Corpus.CorpusLink") && fieldValue.length() > 0) {
                URI linkPath = this.correctLinkPath(parentNode.getURI(), fieldToAdd.getFieldValue());
                childLinks.add(new String[]{linkPath.toString(), "IMDI Link"});
                ArbilDataNode linkedNode = dataNodeLoader.getArbilDataNodeWithoutLoading(linkPath);
                linkedNode.setNodeText(fieldToAdd.getKeyName());
                parentChildTree.get(parentNode).add(linkedNode);
            }
        }
        fieldToAdd.finishLoading();
        return nodeOrderCounter;
    }

    private int addCmdiAttributeFields(int nodeOrderCounter, NamedNodeMap childNodeAttributes, ArbilDataNode destinationNode, String siblingNodePath, Map<String, Integer> siblingNodePathCounter, String fullSubNodePath, ArbilDataNode parentNode, List<String[]> childLinks, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree) throws DOMException {
        for (int i = 0; i < childNodeAttributes.getLength(); ++i) {
            Node attrNode = childNodeAttributes.item(i);
            String attrName = CmdiTemplate.getAttributePathSection(attrNode.getNamespaceURI(), attrNode.getLocalName());
            String attrPath = siblingNodePath + ".@" + attrName;
            String fullAttrPath = fullSubNodePath + ".@" + attrName;
            if (!siblingNodePathCounter.containsKey(fullAttrPath)) {
                siblingNodePathCounter.put(fullAttrPath, 0);
            }
            if (!parentNode.getNodeTemplate().pathIsEditableField(fullAttrPath.replaceAll("\\(\\d*?\\)", ""))) continue;
            nodeOrderCounter = this.addEditableField(nodeOrderCounter, destinationNode, attrPath, attrNode.getNodeValue(), siblingNodePathCounter, fullAttrPath, parentNode, childLinks, parentChildTree, null, true);
        }
        return nodeOrderCounter;
    }

    private void addReferencedResources(ArbilDataNode parentNode, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, NamedNodeMap childNodeAttributes, List<String[]> childLinks, ArbilDataNode destinationNode) {
        CmdiComponentLinkReader cmdiComponentLinkReader;
        String clarinRefIds = this.getNamedAttributeValue(childNodeAttributes, "ref");
        if (clarinRefIds != null && clarinRefIds.length() > 0 && (cmdiComponentLinkReader = parentNode.getCmdiComponentLinkReader()) != null) {
            for (String refId : clarinRefIds.split(" ")) {
                if ((refId = refId.trim()).length() <= 0) continue;
                CmdiComponentLinkReader.CmdiResourceLink clarinLink = cmdiComponentLinkReader.getResourceLink(refId);
                this.addResourceLinkNode(parentNode, destinationNode, parentChildTree, clarinLink, childLinks);
            }
        }
    }

    public void addUnreferencedResources(ArbilDataNode parentNode, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, List<String[]> childLinks) {
        CmdiComponentLinkReader cmdiComponentLinkReader = parentNode.getCmdiComponentLinkReader();
        if (cmdiComponentLinkReader != null) {
            for (CmdiComponentLinkReader.CmdiResourceLink link : cmdiComponentLinkReader.cmdiResourceLinkArray) {
                if (link.getReferencingNodesCount() != 0) continue;
                this.addResourceLinkNode(parentNode, parentNode, parentChildTree, link, childLinks);
            }
        }
    }

    private void addResourceLinkNode(ArbilDataNode parentNode, ArbilDataNode destinationNode, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree, CmdiComponentLinkReader.CmdiResourceLink clarinLink, List<String[]> childLinks) {
        if (clarinLink != null && !IGNORED_METADATA_TYPES.contains(clarinLink.resourceType)) {
            try {
                URI resourceRef = parentNode.isLocal() && clarinLink.getLocalUri() != null ? clarinLink.getLocalUri() : (clarinLink.resourceRef != null && clarinLink.resourceRef.length() > 0 ? clarinLink.getResolvedLinkUri() : null);
                if (resourceRef != null) {
                    childLinks.add(new String[]{clarinLink.toString(), clarinLink.resourceProxyId});
                    ArbilDataNode resourceLinkNode = dataNodeLoader.getArbilDataNodeWithoutLoading(resourceRef);
                    resourceLinkNode.setResourceNode(!clarinLink.resourceType.equals("Metadata"));
                    parentChildTree.get(destinationNode).add(resourceLinkNode);
                    clarinLink.addReferencingNode();
                }
            }
            catch (URISyntaxException ex) {
                logger.info("Error while reading resource link. Link not added: {}", (Object)clarinLink);
            }
        }
    }

    private String determineParentPath(ArbilDataNode parentNode) {
        String parentNodePath = parentNode.getURIFragment();
        parentNodePath = parentNodePath == null ? "" : parentNodePath.replaceAll("\\(\\d+\\)", "");
        return parentNodePath;
    }

    private void getTemplate(Node childNode, ArbilDataNode parentNode, NamedNodeMap attributesMap) throws DOMException {
        if (!childNode.getLocalName().equals("METATRANSCRIPT")) {
            String schemaLocationString = this.getSchemaLocation(childNode, parentNode);
            if (schemaLocationString != null) {
                parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getCmdiTemplate(schemaLocationString);
            } else {
                String message = "Could not find the schema url: " + childNode.toString();
                BugCatcherManager.getBugCatcher().logError(new Exception(message));
                messageDialogHandler.addMessageDialogToQueue(services.getString("COULD NOT FIND THE SCHEMA URL, SOME NODES WILL NOT DISPLAY CORRECTLY."), services.getString("CMDI SCHEMA LOCATION"));
            }
        } else if (attributesMap != null) {
            Node archiveHandleAtt = attributesMap.getNamedItem("ArchiveHandle");
            parentNode.archiveHandle = archiveHandleAtt != null ? archiveHandleAtt.getNodeValue() : null;
            Node templateOriginatorAtt = attributesMap.getNamedItem("Originator");
            if (templateOriginatorAtt != null) {
                String templateOriginator = templateOriginatorAtt.getNodeValue();
                int separatorIndex = templateOriginator.indexOf(":");
                if (separatorIndex > -1) {
                    parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getTemplate(templateOriginator.substring(separatorIndex + 1));
                } else {
                    Node templateTypeAtt = attributesMap.getNamedItem("Type");
                    if (templateTypeAtt != null) {
                        String templateType = templateTypeAtt.getNodeValue();
                        parentNode.nodeTemplate = ArbilTemplateManager.getSingleInstance().getTemplate(templateType);
                    }
                }
            }
        }
    }

    private String getSchemaLocation(Node rootNode, ArbilDataNode parentNode) throws DOMException {
        Node schemaLocationNode = rootNode.getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocationNode != null) {
            String schemaLocationString = this.getCmdSchemaLocation(schemaLocationNode);
            if (schemaLocationString == null) {
                schemaLocationString = this.getSingleSchemaLocation(schemaLocationNode);
            }
            String resolvedSchemaLocation = parentNode.getURI().resolve(schemaLocationString).toString();
            logger.debug("Found schema location for CMD namespace: {} (resolves to {})", (Object)schemaLocationString, (Object)resolvedSchemaLocation);
            return resolvedSchemaLocation;
        }
        Node noNamespaceSchemaLocationNode = rootNode.getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        if (noNamespaceSchemaLocationNode != null) {
            return noNamespaceSchemaLocationNode.getNodeValue();
        }
        return null;
    }

    private String getCmdSchemaLocation(Node schemaLocationNode) throws DOMException {
        Matcher cmdSchemaLocationMatcher = CMD_SCHEMA_LOCATION_PATTERN.matcher(schemaLocationNode.getNodeValue());
        if (cmdSchemaLocationMatcher.find()) {
            return cmdSchemaLocationMatcher.group(1);
        }
        return null;
    }

    private String getSingleSchemaLocation(Node schemaLocationNode) throws DOMException {
        String schemaLocationString = schemaLocationNode.getNodeValue();
        String[] schemaLocation = schemaLocationString.split("\\s");
        schemaLocationString = schemaLocation[schemaLocation.length - 1];
        return schemaLocationString;
    }

    private void getImdiCatalogue(NamedNodeMap attributesMap, ArbilDataNode parentNode, List<String[]> childLinks, Map<ArbilDataNode, Set<ArbilDataNode>> parentChildTree) throws DOMException {
        String catalogueLink;
        Node catalogueLinkAtt = attributesMap.getNamedItem("CatalogueLink");
        if (catalogueLinkAtt != null && (catalogueLink = catalogueLinkAtt.getNodeValue()).length() > 0) {
            URI correcteLink = this.correctLinkPath(parentNode.getURI(), catalogueLink);
            childLinks.add(new String[]{correcteLink.toString(), "CatalogueLink"});
            parentChildTree.get(parentNode).add(dataNodeLoader.getArbilDataNodeWithoutLoading(correcteLink));
        }
    }

    public void setApplicationConfiguration(ArbilConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    static {
        services = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Services");
        CMD_SCHEMA_LOCATION_PATTERN = Pattern.compile("http:\\/\\/www.clarin.eu\\/cmd\\/\\s+(\\S+)", 8);
        IGNORED_METADATA_TYPES = new CopyOnWriteArrayList<String>(new String[]{"SearchPage", "LandingPage", "SearchService"});
    }
}

