/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.favourites;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;
import nl.mpi.arbil.favourites.FavouritesImportExportException;
import nl.mpi.arbil.favourites.FavouritesImporter;
import nl.mpi.arbil.ui.favourites.ImportUI;
import nl.mpi.flap.plugin.PluginDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(ImportAction.class);
    private final PluginDialogHandler dialogHandler;
    private final FavouritesImporter importer;
    private static final Map<String, FileFilter> importFileMap = Collections.singletonMap("favsExport", new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() && new File(f, "favourites.config").exists() || f.getName().equals("favourites.config");
        }

        public String getDescription() {
            return widgets.getString("FAVOURITES EXPORT FILE");
        }
    });
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");

    public ImportAction(PluginDialogHandler dialogHandler, FavouritesImporter importer) {
        super("import");
        this.dialogHandler = dialogHandler;
        this.importer = importer;
    }

    public void actionPerformed(ActionEvent e) {
        this.importFavourites();
        if (e.getSource() instanceof ImportUI) {
            ((ImportUI)e.getSource()).refresh();
        }
    }

    private void importFavourites() {
        String chooserTitle = widgets.getString("SELECT FAVOURITES EXPORT TO IMPORT");
        File[] exportLocation = this.dialogHandler.showFileSelectBox(chooserTitle, false, false, importFileMap, PluginDialogHandler.DialogueType.open, null);
        if (exportLocation != null && exportLocation.length > 0 && exportLocation[0] != null) {
            try {
                if (exportLocation[0].isDirectory()) {
                    this.importer.importFavourites(exportLocation[0]);
                } else {
                    this.importer.importFavourites(exportLocation[0].getParentFile());
                }
                this.dialogHandler.addMessageDialogToQueue(widgets.getString("FAVOURITES HAVE BEEN IMPORTED"), widgets.getString("IMPORT COMPLETE"));
            }
            catch (FavouritesImportExportException ex) {
                logger.error("An error occurred while importing favourites", (Throwable)ex);
                this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("FAVOURITES_AN ERROR OCCURRED WHILE IMPORTING FAVOURITES"), ex.getMessage()), "Error");
            }
        }
    }
}

