/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.dom;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.mpi.metadata.api.MetadataDocumentException;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.dom.MetadataDocumentReader;
import nl.mpi.metadata.api.model.HeaderInfo;
import nl.mpi.metadata.api.model.MetadataDocument;
import nl.mpi.metadata.cmdi.api.dom.CMDIComponentReader;
import nl.mpi.metadata.cmdi.api.dom.CMDINamespaceContext;
import nl.mpi.metadata.cmdi.api.dom.CMDIResourceProxyReader;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElementFactory;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIDocumentImpl;
import nl.mpi.metadata.cmdi.api.type.CMDIProfile;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileContainer;
import nl.mpi.metadata.cmdi.api.type.CMDITypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDIDocumentReader
implements MetadataDocumentReader<CMDIDocument> {
    private static final Logger logger = LoggerFactory.getLogger(CMDIDocumentReader.class);
    private static final CMDINamespaceContext CMDI_NAMESPACE_CONTEXT = new CMDINamespaceContext();
    private final CMDIProfileContainer profileContainer;
    private final CMDIComponentReader componentReader;
    private final CMDIResourceProxyReader resourceReader;

    public CMDIDocumentReader(CMDIProfileContainer profileContainer, CMDIMetadataElementFactory elementFactory) {
        this(profileContainer, new CMDIComponentReader(elementFactory), new CMDIResourceProxyReader());
    }

    public CMDIDocumentReader(CMDIProfileContainer profileContainer, CMDIComponentReader componentReader, CMDIResourceProxyReader resourceReader) {
        this.profileContainer = profileContainer;
        this.componentReader = componentReader;
        this.resourceReader = resourceReader;
    }

    @Override
    public CMDIDocument read(Document document, URI documentURI) throws MetadataException, DOMException, IOException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(CMDI_NAMESPACE_CONTEXT);
        logger.debug("Getting profile for {}", (Object)documentURI);
        CMDIProfile profile = this.getProfileForDocument(document, documentURI, xPath);
        logger.debug("Creating document for {}", (Object)documentURI);
        CMDIDocument cmdiDocument = this.createCMDIDocument(xPath, document, documentURI, profile);
        logger.debug("Finished reading {}: {}", (Object)cmdiDocument);
        logger.debug("Reading header for {}", (Object)documentURI);
        this.readHeader(cmdiDocument, document, xPath);
        logger.debug("Reading resource proxies for {}", (Object)documentURI);
        this.resourceReader.readResourceProxies(cmdiDocument, document, xPath);
        logger.debug("Reading components for {}", (Object)documentURI);
        this.componentReader.readComponents(cmdiDocument, document, xPath);
        cmdiDocument.setAllClean();
        return cmdiDocument;
    }

    private CMDIDocument createCMDIDocument(XPath xPath, Document document, URI documentURI, CMDIProfile profile) throws MetadataException {
        String rootComponentNodePath = profile.getPathString();
        try {
            Node rootComponentNode = (Node)xPath.evaluate(rootComponentNodePath, document, XPathConstants.NODE);
            if (rootComponentNode == null) {
                throw new MetadataException(String.format("Root component node not found at specified path: %1$s", rootComponentNodePath));
            }
            logger.debug("Found documentNode at {}", (Object)rootComponentNodePath);
            return new CMDIDocumentImpl(profile, documentURI);
        }
        catch (XPathExpressionException ex) {
            throw new MetadataException(String.format("XPathExpressionException while looking up root component node at specified path: %1$s", rootComponentNodePath), ex);
        }
    }

    private CMDIProfile getProfileForDocument(Document document, URI documentURI, XPath xPath) throws MetadataException, IOException {
        try {
            URI profileURI = this.getProfileURI(document, xPath);
            if (profileURI == null) {
                throw new MetadataException("No profile URI found in metadata document");
            }
            if (documentURI != null) {
                profileURI = documentURI.resolve(profileURI);
            }
            try {
                return this.profileContainer.getProfile(profileURI);
            }
            catch (CMDITypeException ctEx) {
                throw new MetadataException(String.format("CMDITypeException occurred while trying to retrieve profile $1%s. See nested exception for details.", profileURI), ctEx);
            }
        }
        catch (XPathExpressionException ex) {
            throw new MetadataException("XPathExpressionException while looking for profile URI in metadata document. See nested exception for details.", ex);
        }
        catch (URISyntaxException uEx) {
            throw new MetadataException("URISyntaxException while looking for profile URI in metadata document. See nested exception for details.", uEx);
        }
    }

    protected URI getProfileURI(Document document, XPath xPath) throws URISyntaxException, XPathExpressionException {
        String schemaLocationValue = xPath.evaluate("/cmd:CMD/@xsi:schemaLocation", document);
        if (schemaLocationValue != null) {
            String schemaLocationString = schemaLocationValue.trim();
            String[] schemaLocationTokens = schemaLocationString.split("\\s+");
            if (schemaLocationTokens.length == 2) {
                URI documentNSUri;
                if (logger.isWarnEnabled() && !new URI(schemaLocationTokens[0]).equals(documentNSUri = this.getDocumentNamespace(document))) {
                    logger.warn("Found one schema location for document, but namespace does not match document namespace. Document namespace is {}, location specified for {}", (Object)documentNSUri, (Object)schemaLocationTokens[0]);
                }
                return new URI(schemaLocationTokens[1]);
            }
            URI documentNSUri = this.getDocumentNamespace(document);
            for (int i = 0; i < schemaLocationTokens.length; i += 2) {
                if (!documentNSUri.equals(new URI(schemaLocationTokens[i]))) continue;
                return new URI(schemaLocationTokens[i + 1]);
            }
        }
        return null;
    }

    private URI getDocumentNamespace(Document document) throws URISyntaxException {
        String documentNS;
        Element documentElement = document.getDocumentElement();
        if (documentElement != null && (documentNS = documentElement.getNamespaceURI()) != null) {
            return new URI(documentNS);
        }
        logger.warn("Cannot find namespace in document, assuming standard namespace {}", (Object)"http://www.clarin.eu/cmd/");
        return new URI("http://www.clarin.eu/cmd/");
    }

    private void readHeader(CMDIDocument cmdiDocument, Document document, XPath xPath) throws MetadataDocumentException {
        try {
            Node headerNode = (Node)xPath.evaluate("/cmd:CMD/cmd:Header", document, XPathConstants.NODE);
            if (headerNode == null) {
                throw new MetadataDocumentException((MetadataDocument)cmdiDocument, "Header node not found in CMDI document");
            }
            NodeList headerChildren = headerNode.getChildNodes();
            for (int i = 0; i < headerChildren.getLength(); ++i) {
                Node headerChild = headerChildren.item(i);
                if (!(headerChildren.item(i) instanceof Element)) continue;
                this.addHeaderInformationFromDocument(headerChild, cmdiDocument);
            }
        }
        catch (XPathExpressionException ex) {
            throw new MetadataDocumentException(cmdiDocument, "XPathExpressionException while reading header information in document. See nested exception for details.", ex);
        }
    }

    private void addHeaderInformationFromDocument(Node headerChild, CMDIDocument cmdiDocument) throws DOMException {
        HeaderInfo headerInfo = new HeaderInfo(headerChild.getLocalName(), headerChild.getTextContent());
        try {
            cmdiDocument.putHeaderInformation(headerInfo);
        }
        catch (MetadataException mdEx) {
            logger.warn("Skipping header that is rejected by document", (Throwable)mdEx);
        }
    }
}

