/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.identifierresolver;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import nl.mpi.metadata.api.model.MetadataDocument;
import nl.mpi.metadata.identifierresolver.IdentifierResolver;

public class ChainingIdentifierResolver
implements IdentifierResolver {
    private List<IdentifierResolver> chain;

    public ChainingIdentifierResolver() {
        this(new CopyOnWriteArrayList<IdentifierResolver>());
    }

    public ChainingIdentifierResolver(IdentifierResolver ... chain) {
        this(Arrays.asList(chain));
    }

    public ChainingIdentifierResolver(List<IdentifierResolver> chain) {
        this.chain = new CopyOnWriteArrayList<IdentifierResolver>(chain);
    }

    @Override
    public boolean canResolve(MetadataDocument document, URI identifier) {
        for (IdentifierResolver resolver : this.chain) {
            if (!resolver.canResolve(document, identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public URL resolveIdentifier(MetadataDocument document, URI identifier) {
        for (IdentifierResolver resolver : this.chain) {
            if (!resolver.canResolve(document, identifier)) continue;
            return resolver.resolveIdentifier(document, identifier);
        }
        return null;
    }

    public List<IdentifierResolver> getChain() {
        return new ArrayList<IdentifierResolver>(this.chain);
    }

    public void setChain(List<IdentifierResolver> chain) {
        this.chain = new CopyOnWriteArrayList<IdentifierResolver>(chain);
    }
}

