/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.evpull.BracketedDocumentIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.SingletonEventIterator;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private boolean textOnly;
    private String constantText;

    public DocumentInstr(boolean textOnly, String constantText, String baseURI) {
        this.textOnly = textOnly;
        this.constantText = constantText;
        this.setBaseURI(baseURI);
    }

    public int getImplementationMethod() {
        return 1;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public CharSequence getConstantText() {
        return this.constantText;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.setLazyConstruction(visitor.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/lazyConstructionMode"));
        return super.simplify(visitor);
    }

    protected void checkContentSequence(StaticContext env) throws XPathException {
        DocumentInstr.checkContentSequence(env, this.content, this.getValidationOptions());
    }

    protected static void checkContentSequence(StaticContext env, Expression content, ParseOptions validationOptions) throws XPathException {
        Expression[] components = content instanceof Block ? ((Block)content).getChildren() : new Expression[]{content};
        int validation = validationOptions == null ? 3 : validationOptions.getSchemaValidationMode();
        SchemaType type = validationOptions == null ? null : validationOptions.getTopLevelType();
        int elementCount = 0;
        boolean isXSLT = content.getHostLanguage() == 50;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        for (Expression component : components) {
            SchemaDeclaration decl;
            XPathException de;
            ItemType it = component.getItemType(th);
            if (!(it instanceof NodeTest)) continue;
            int possibleNodeKinds = ((NodeTest)it).getNodeKindMask();
            if (possibleNodeKinds == 4) {
                de = new XPathException("Cannot create an attribute node whose parent is a document node");
                de.setErrorCode(isXSLT ? "XTDE0420" : "XPTY0004");
                de.setLocator(component);
                throw de;
            }
            if (possibleNodeKinds == 8192) {
                de = new XPathException("Cannot create a namespace node whose parent is a document node");
                de.setErrorCode(isXSLT ? "XTDE0420" : "XQTY0024");
                de.setLocator(component);
                throw de;
            }
            if (possibleNodeKinds != 2) continue;
            if (++elementCount > 1 && (validation == 1 || validation == 2 || type != null)) {
                de = new XPathException("A valid document must have only one child element");
                if (isXSLT) {
                    de.setErrorCode("XTTE1550");
                } else {
                    de.setErrorCode("XQDY0061");
                }
                de.setLocator(component);
                throw de;
            }
            if (validation != 1 || !(component instanceof FixedElement) || (decl = env.getConfiguration().getElementDeclaration(((FixedElement)component).getElementName().getFingerprint())) == null) continue;
            ((FixedElement)component).getContentExpression().checkPermittedContents(decl.getType(), env, true);
        }
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        p |= 0x800000;
        if (this.getValidationAction() == 4) {
            p |= 0x4000000;
        }
        return p;
    }

    public Expression getStringValueExpression() {
        if (this.textOnly) {
            if (this.constantText != null) {
                return new StringLiteral(new UntypedAtomicValue(this.constantText));
            }
            if (this.content instanceof ValueOf) {
                return ((ValueOf)this.content).convertToCastAsString();
            }
            StringJoin fn = (StringJoin)SystemFunctionCall.makeSystemFunction("string-join", new Expression[]{this.content, new StringLiteral(StringValue.EMPTY_STRING)});
            CastExpression cast = new CastExpression(fn, BuiltInAtomicType.UNTYPED_ATOMIC, false);
            ExpressionTool.copyLocationInfo(this, cast);
            return cast;
        }
        throw new AssertionError((Object)"getStringValueExpression() called on non-text-only document instruction");
    }

    public Expression copy() {
        DocumentInstr doc = new DocumentInstr(this.textOnly, this.constantText, this.getBaseURI());
        doc.setContentExpression(this.content.copy());
        doc.setValidationAction(this.getValidationAction(), this.getSchemaType());
        doc.setLazyConstruction(this.isLazyConstruction());
        return doc;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.DOCUMENT;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.preservingTypes && !this.textOnly) {
            SequenceReceiver out = context.getReceiver();
            out.startDocument(0);
            this.content.process(context);
            out.endDocument();
            return null;
        }
        DocumentInfo item = this.evaluateItem(context);
        if (item != null) {
            SequenceReceiver out = context.getReceiver();
            out.append(item, this.locationId, 2);
        }
        return null;
    }

    public DocumentInfo evaluateItem(XPathContext context) throws XPathException {
        DocumentInfo root;
        Controller controller = context.getController();
        assert (controller != null);
        if (this.isLazyConstruction() && (!controller.getExecutable().isSchemaAware() || this.getValidationAction() == 3 && this.getSchemaType() == null)) {
            return context.getConfiguration().makeUnconstructedDocument(this, context);
        }
        if (this.textOnly) {
            CharSequence textValue;
            if (this.constantText != null) {
                textValue = this.constantText;
            } else {
                Item item;
                FastStringBuffer sb = new FastStringBuffer(64);
                SequenceIterator<? extends Item> iter = this.content.iterate(context);
                while ((item = iter.next()) != null) {
                    sb.append(item.getStringValueCS());
                }
                textValue = sb.condense();
            }
            root = new TextFragmentValue(textValue, this.getBaseURI());
            root.setConfiguration(controller.getConfiguration());
        } else {
            try {
                SequenceReceiver saved = context.getReceiver();
                Builder builder = controller.makeBuilder();
                builder.setBaseURI(this.getBaseURI());
                builder.setTiming(false);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setHostLanguage(this.getHostLanguage());
                builder.setPipelineConfiguration(pipe);
                context.changeOutputDestination(builder, this.getValidationOptions());
                SequenceReceiver out = context.getReceiver();
                out.open();
                out.startDocument(0);
                this.content.process(context);
                out.endDocument();
                out.close();
                context.setReceiver(saved);
                root = (DocumentInfo)builder.getCurrentRoot();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        }
        return root;
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.getValidationAction() != 3) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        return new BracketedDocumentIterator(this.content.iterateEvents(context));
    }

    public int getInstructionNameCode() {
        return 146;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("documentNode");
        out.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        SchemaType schemaType = this.getSchemaType();
        if (schemaType != null) {
            out.emitAttribute("type", schemaType.getDescription());
        }
        this.content.explain(out);
        out.endElement();
    }
}

