/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.translation.tools;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import nl.mpi.translation.tools.Translator;
import nl.mpi.translation.tools.UrlStreamResolver;
import nl.mpi.translation.tools.util.TranslationServiceErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatorImpl
implements Translator {
    private static final Logger logger = LoggerFactory.getLogger(TranslatorImpl.class);
    private static final String SAXON_TRANSFORMER_IMPL_CLASS_NAME = "net.sf.saxon.TransformerFactoryImpl";
    private static final String SAXON_MESSAGE_EMITTER_CLASSNAME = "net.sf.saxon.serialize.MessageWarner";
    private static final URL DEFAULT_CMDI2IMDI_XSLT = TranslatorImpl.class.getClassLoader().getResource("templates/cmdi2imdi/cmdi2imdiMaster.xslt");
    private static final URL DEFAULT_IMDI2CMDI_XSLT = TranslatorImpl.class.getClassLoader().getResource("templates/imdi2cmdi/imdi2cmdi.xslt");
    private static final Pattern CMDI_URL_PATTERN = Pattern.compile("^.*\\.cmdi(\\?.*)?$", 2);
    private static final Pattern IMDI_URL_PATTERN = Pattern.compile("^.*\\.imdi(\\?.*)?$", 2);
    private final TransformerFactory transfFactory;
    private final XMLInputFactory xmlInputFactory;
    private final Templates cmdi2imdiCachedXSLT;
    private final Templates imdi2cmdiCachedXSLT;
    private Map<String, Object> transformationParameters;
    private final UrlStreamResolver urlStreamResolver;

    public TranslatorImpl(UrlStreamResolver urlStreamResolver) throws TransformerConfigurationException, IOException {
        this(DEFAULT_IMDI2CMDI_XSLT, DEFAULT_CMDI2IMDI_XSLT, urlStreamResolver);
    }

    public TranslatorImpl(String imdi2cmdiXsltPath, String cmdi2imdiXsltPath, UrlStreamResolver urlStreamResolver) throws MalformedURLException, TransformerConfigurationException, IOException {
        this(Strings.isNullOrEmpty((String)imdi2cmdiXsltPath) ? DEFAULT_IMDI2CMDI_XSLT : new File(imdi2cmdiXsltPath).toURI().toURL(), Strings.isNullOrEmpty((String)cmdi2imdiXsltPath) ? DEFAULT_CMDI2IMDI_XSLT : new File(cmdi2imdiXsltPath).toURI().toURL(), urlStreamResolver);
    }

    public TranslatorImpl(URL imdi2CmdiXsltLocation, URL cmdi2ImdiXsltLocation, UrlStreamResolver urlStreamResolver) throws TransformerConfigurationException, IOException {
        this.urlStreamResolver = urlStreamResolver;
        this.transfFactory = this.createTransformerFactory();
        this.transfFactory.setErrorListener(new TranslationServiceErrorListener(logger));
        logger.debug("Instantiated XML transformer factory of type {}", this.transfFactory.getClass());
        if (this.transfFactory instanceof TransformerFactoryImpl) {
            logger.debug("Telling Saxon to send messages as warnings to logger");
            Configuration tfConfig = ((TransformerFactoryImpl)this.transfFactory).getConfiguration();
            tfConfig.setMessageEmitterClass(SAXON_MESSAGE_EMITTER_CLASSNAME);
        }
        this.xmlInputFactory = XMLInputFactory.newInstance();
        logger.debug("Instantiated XML input factory of type {}", this.xmlInputFactory.getClass());
        this.cmdi2imdiCachedXSLT = this.initTemplates(cmdi2ImdiXsltLocation);
        this.imdi2cmdiCachedXSLT = this.initTemplates(imdi2CmdiXsltLocation);
        logger.info("Translator initialized");
        logger.debug("Using XSLT Transformer: '{}'", this.cmdi2imdiCachedXSLT.getClass());
        logger.info("Using CMDI2IMDI stylesheet: '{}'", (Object)cmdi2ImdiXsltLocation);
        logger.info("Using IMDI2CMDI stylesheet: '{}'", (Object)imdi2CmdiXsltLocation);
    }

    private Templates initTemplates(URL xsltURL) throws FileNotFoundException, TransformerConfigurationException, IOException {
        if (xsltURL == null) {
            throw new FileNotFoundException("CMDI2IMDI stylesheet: '" + xsltURL + "' (no such file or directory)");
        }
        StreamSource sourceXSLT = new StreamSource(xsltURL.openStream(), xsltURL.toExternalForm());
        return this.transfFactory.newTemplates(sourceXSLT);
    }

    private TransformerFactory createTransformerFactory() throws TransformerFactoryConfigurationError {
        try {
            logger.debug("Trying to get instance of '{}' transformer implementation", (Object)SAXON_TRANSFORMER_IMPL_CLASS_NAME);
            return TransformerFactory.newInstance(SAXON_TRANSFORMER_IMPL_CLASS_NAME, null);
        }
        catch (TransformerFactoryConfigurationError tfc) {
            logger.warn("Could not load class for Saxon transformer, trying default as backup. This will probably lead to runtime errors!");
            logger.debug("javax.xml.transform.TransformerFactory={}", (Object)System.getProperty("javax.xml.transform.TransformerFactory"));
            logger.debug("Exception thrown by TransformerFactory.newInstance()", (Throwable)tfc);
            return TransformerFactory.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getIMDI(URL cmdiFileURL, String serviceURI) throws TransformerException, XMLStreamException, IOException {
        InputStream input = this.urlStreamResolver.getStream(cmdiFileURL);
        try {
            String string;
            XMLStreamReader xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(input, "UTF-8");
            try {
                StAXSource source = new StAXSource(xmlStreamReader);
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                String inputUrl = cmdiFileURL.toString();
                if (TranslatorImpl.isImdiURl(inputUrl)) {
                    logger.warn("Input document seems to be already IMDI! Returning original document.");
                    this.writeURLContentsToStream(cmdiFileURL, sw);
                } else {
                    if (!TranslatorImpl.isCmdiUrl(inputUrl)) {
                        logger.info("Input document language could not be confirmed! CMDI assumed.");
                    }
                    this.transform(this.cmdi2imdiCachedXSLT, source, result, serviceURI, inputUrl);
                }
                sw.flush();
                string = sw.toString();
            }
            catch (Throwable throwable) {
                xmlStreamReader.close();
                throw throwable;
            }
            xmlStreamReader.close();
            return string;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCMDI(URL imdiFileURL, String serviceURI) throws TransformerException, XMLStreamException, IOException {
        InputStream input = this.urlStreamResolver.getStream(imdiFileURL);
        try {
            String string;
            XMLStreamReader xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(input, "UTF-8");
            try {
                StAXSource source = new StAXSource(xmlStreamReader);
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                String inputUrl = imdiFileURL.toString();
                if (TranslatorImpl.isCmdiUrl(inputUrl)) {
                    logger.warn("Input document seems to be already CMDI! Returning original document.");
                    this.writeURLContentsToStream(imdiFileURL, sw);
                } else {
                    if (!TranslatorImpl.isImdiURl(inputUrl)) {
                        logger.info("Input document language could not be confirmed! IMDI assumed.");
                    }
                    this.transform(this.imdi2cmdiCachedXSLT, source, result, serviceURI, inputUrl);
                }
                sw.flush();
                string = sw.toString();
            }
            catch (Throwable throwable) {
                xmlStreamReader.close();
                throw throwable;
            }
            xmlStreamReader.close();
            return string;
        }
        finally {
            input.close();
        }
    }

    private void transform(Templates templates, Source source, Result result, String serviceURI, String inputUrl) throws TransformerException, TransformerConfigurationException {
        Transformer transformer = templates.newTransformer();
        transformer.setParameter("service-base-uri", serviceURI);
        transformer.setParameter("source-location", inputUrl);
        if (this.transformationParameters != null) {
            for (Map.Entry<String, Object> param : this.transformationParameters.entrySet()) {
                logger.trace("Setting additional transformation parameter: {} = '{}'", (Object)param.getKey(), param.getValue());
                transformer.setParameter(param.getKey(), param.getValue());
            }
        }
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeURLContentsToStream(URL cmdiFileURL, StringWriter sw) throws IOException {
        InputStream urlInputStream = cmdiFileURL.openConnection().getInputStream();
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(urlInputStream, "UTF-8"));
            try {
                String line;
                while ((line = rd.readLine()) != null) {
                    sw.write(line);
                }
            }
            finally {
                rd.close();
            }
        }
        finally {
            urlInputStream.close();
        }
    }

    @Override
    public void setTransformationParameters(Map<String, Object> params) {
        this.transformationParameters = params;
    }

    private static boolean isCmdiUrl(String cmdiFileURL) {
        return CMDI_URL_PATTERN.matcher(cmdiFileURL).matches();
    }

    private static boolean isImdiURl(String imdiFileURL) {
        return IMDI_URL_PATTERN.matcher(imdiFileURL).matches();
    }
}

