-- Database: corpusstructure

-- DROP DATABASE corpusstructure;

CREATE DATABASE corpusstructure2
  WITH OWNER = webuser
       ENCODING = 'UTF8'
       TABLESPACE = pg_default
       LC_COLLATE = 'en_US.UTF-8'
       LC_CTYPE = 'en_US.UTF-8'
       CONNECTION LIMIT = -1;

-- Sequence: aoid_seq

-- DROP SEQUENCE aoid_seq;

CREATE SEQUENCE aoid_seq
  INCREMENT 1
  MINVALUE 0
  MAXVALUE 9223372036854775807
  START 2355537
  CACHE 1;
ALTER TABLE aoid_seq OWNER TO webuser;


-- Table: archiveobjects

-- DROP TABLE archiveobjects;

CREATE TABLE archiveobjects (
  id integer NOT NULL DEFAULT nextval('aoid_seq'::regclass),
  uri character varying NOT NULL,
  profile_uri character varying,
  pid character varying,
  onsite boolean DEFAULT true,
  last_update timestamp without time zone NOT NULL,
  -- physical file properties
  filesize bigint,
  checksum character varying,
  filetime timestamp without time zone,
  creator character varying, -- first owner of the file, cannot change
  owner character varying, -- initially the creator but can change over time
  -- logical file properties
  nodetype integer,
  format character varying,
  "name" character varying NOT NULL,
  -- permission info
  readrights integer NOT NULL,
  writerights integer NOT NULL,
  accesslevel integer,
  CONSTRAINT pk_archiveobjects PRIMARY KEY (id)
) WITH (
  OIDS=FALSE
);
ALTER TABLE archiveobjects OWNER TO webuser;

-- Sequence: csid_seq

-- DROP SEQUENCE csid_seq;

CREATE SEQUENCE csid_seq
  INCREMENT 1
  MINVALUE 0
  MAXVALUE 9223372036854775807
  START 2355537
  CACHE 1;
ALTER TABLE csid_seq OWNER TO webuser;

-- Table: corpusstructure

-- DROP TABLE corpusstructure;

CREATE TABLE corpusstructure
(
  id integer NOT NULL DEFAULT nextval('csid_seq'::regclass),
  ao_id integer NOT NULL,
  canonical boolean DEFAULT false,
  "valid" boolean DEFAULT true,
  vpath0 integer,
  vpath1 integer,
  vpath2 integer,
  vpath character varying,

  CONSTRAINT pk_corpusstructure PRIMARY KEY (id)
) WITH (
  OIDS=FALSE
);
ALTER TABLE corpusstructure OWNER TO webuser;

-- Sequence: userid_seq

-- DROP SEQUENCE userid_seq;

CREATE SEQUENCE userid_seq
  INCREMENT 1
  MINVALUE 0
  MAXVALUE 9223372036854775807
  START 2355537
  CACHE 1;
ALTER TABLE userid_seq OWNER TO webuser;

-- Table: users

-- DROP TABLE users;

CREATE TABLE users
(
  id integer NOT NULL DEFAULT nextval('userid_seq'::regclass),
  uid character varying,
  CONSTRAINT pk_users PRIMARY KEY (id)
) WITH (
  OIDS=FALSE
);
ALTER TABLE users OWNER TO webuser;

-- Sequence: groupid_seq

-- DROP SEQUENCE groupid_seq;

CREATE SEQUENCE groupid_seq
  INCREMENT 1
  MINVALUE 0
  MAXVALUE 9223372036854775807
  START 2355537
  CACHE 1;
ALTER TABLE groupid_seq OWNER TO webuser;

-- Table: groups

-- DROP TABLE groups;

CREATE TABLE groups
(
  id integer NOT NULL,-- DEFAULT nextval('groupid_seq'::regclass),
  CONSTRAINT pk_groups PRIMARY KEY (id)
) WITH (
  OIDS=FALSE
);
ALTER TABLE groups OWNER TO webuser;

-- Table: user_groups

-- DROP TABLE user_groups;

CREATE TABLE user_groups
(
  group_id integer NOT NULL,
  user_id   integer NOT NULL,
  CONSTRAINT pk_user_groups PRIMARY KEY (group_id, user_id)
) WITH (
  OIDS=FALSE
);
ALTER TABLE user_groups OWNER TO webuser;



ALTER TABLE corpusstructure ADD CONSTRAINT aofk FOREIGN KEY (ao_id) REFERENCES archiveobjects (id) MATCH FULL;

ALTER TABLE user_groups ADD CONSTRAINT useridfk FOREIGN KEY (user_id) REFERENCES users (id) MATCH FULL;
ALTER TABLE user_groups ADD CONSTRAINT groupidfk FOREIGN KEY (group_id) REFERENCES groups (id) MATCH FULL;

ALTER TABLE archiveobjects ADD CONSTRAINT readrightsfk FOREIGN KEY (readrights) REFERENCES groups (id) MATCH FULL;
ALTER TABLE archiveobjects ADD CONSTRAINT writerightsfk FOREIGN KEY (writerights) REFERENCES groups (id) MATCH FULL;
