/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryLibrary;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.QueryReader;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class LoadXqueryModule
extends SystemFunction
implements Callable {
    private static final Map<String, SequenceType> requiredTypes = new HashMap<String, SequenceType>(20);

    private Sequence checkOption(MapItem map, String keyName, XPathContext context) throws XPathException {
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        StringValue key = new StringValue(keyName);
        if (map.get(key) != null) {
            RoleDiagnostic role = new RoleDiagnostic(15, keyName, 0);
            role.setErrorCode("FOQM0007");
            Sequence converted = th.applyFunctionConversionRules(map.get(key), requiredTypes.get(keyName), role, ExplicitLocation.UNKNOWN_LOCATION);
            converted = SequenceTool.toGroundedValue(converted);
            return converted;
        }
        return null;
    }

    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        Controller newController;
        StreamSource[] streamSources;
        MapItem options = args.length == 2 ? (MapItem)args[1].head() : new HashTrieMap(context);
        Sequence xqueryVersionOption = this.checkOption(options, "xquery-version", context);
        Sequence locationHintsOption = this.checkOption(options, "location-hints", context);
        Sequence variablesOption = this.checkOption(options, "variables", context);
        Sequence contextItemOption = this.checkOption(options, "context-item", context);
        Sequence vendorOptionsOption = this.checkOption(options, "vendor-options", context);
        String moduleUri = args[0].head().getStringValue();
        if (moduleUri.isEmpty()) {
            throw new XPathException("First argument of fn:load-xquery-module() must not be a zero length string", "FOQM0001");
        }
        ArrayList<String> locationHints = new ArrayList<String>();
        if (locationHintsOption != null) {
            Item hint;
            SequenceIterator iterator = locationHintsOption.iterate();
            while ((hint = iterator.next()) != null) {
                locationHints.add(hint.getStringValue());
            }
        }
        Configuration config = context.getConfiguration();
        StaticQueryContext staticQueryContext = config.newStaticQueryContext();
        ModuleURIResolver moduleURIResolver = config.getModuleURIResolver();
        if (moduleURIResolver == null) {
            moduleURIResolver = new StandardModuleURIResolver(config);
        }
        staticQueryContext.setModuleURIResolver(moduleURIResolver);
        staticQueryContext.setLanguageVersion(31);
        String baseURI = this.getRetainedStaticContext().getStaticBaseUriString();
        staticQueryContext.setBaseURI(baseURI);
        try {
            String[] hints = locationHints.toArray(new String[locationHints.size()]);
            streamSources = staticQueryContext.getModuleURIResolver().resolve(moduleUri, baseURI, hints);
            if (streamSources == null) {
                streamSources = new StandardModuleURIResolver(config).resolve(moduleUri, baseURI, hints);
            }
        }
        catch (XPathException e) {
            e.maybeSetErrorCode("FOQM0002");
            throw e;
        }
        if (streamSources.length == 0) {
            throw new XPathException("No library module found with specified target namespace " + moduleUri, "FOQM0002");
        }
        try {
            String sourceQuery = QueryReader.readSourceQuery(streamSources[0], config.getValidCharacterChecker());
            staticQueryContext.compileLibrary(sourceQuery);
        }
        catch (XPathException e) {
            throw new XPathException(e.getMessage(), "FOQM0003");
        }
        QueryLibrary lib = staticQueryContext.getCompiledLibrary(moduleUri);
        if (lib == null) {
            throw new XPathException("The library module located does not have the expected namespace " + moduleUri, "FOQM0002");
        }
        QueryModule main = new QueryModule(staticQueryContext);
        main.setPackageData(lib.getPackageData());
        main.setExecutable(lib.getExecutable());
        lib.link(main);
        XQueryExpression xqe = new XQueryExpression(new ContextItemExpression(), main, false);
        DynamicQueryContext dqc = new DynamicQueryContext(context.getConfiguration());
        if (variablesOption != null) {
            AtomicValue key;
            HashTrieMap extVariables = (HashTrieMap)variablesOption.head();
            AtomicIterator iterator = extVariables.keys();
            while ((key = iterator.next()) != null) {
                dqc.setParameter(((QNameValue)key).getStructuredQName(), extVariables.get(key));
            }
        }
        try {
            newController = xqe.newController(dqc);
        }
        catch (XPathException e) {
            if (e.getErrorCodeLocalPart().equals("XPDY0002")) {
                throw new XPathException(e.getMessage(), "FOQM0004");
            }
            throw e;
        }
        if (contextItemOption != null) {
            newController.setGlobalContextItem(contextItemOption.head());
        }
        XPathContextMajor newContext = newController.newXPathContext();
        HashTrieMap variablesMap = new HashTrieMap(newContext);
        for (GlobalVariable var : lib.getGlobalVariables()) {
            Sequence value;
            QNameValue qNameValue = new QNameValue(var.getVariableQName(), BuiltInAtomicType.QNAME);
            if (!qNameValue.getNamespaceURI().equals(moduleUri)) continue;
            try {
                value = var.evaluateVariable(newContext);
            }
            catch (XPathException e) {
                e.setIsGlobalError(false);
                if (e.getErrorCodeLocalPart().equals("XPTY0004")) {
                    throw new XPathException(e.getMessage(), "FOQM0005");
                }
                if (e.getErrorCodeLocalPart().equals("XPDY0002")) {
                    throw new XPathException(e.getMessage(), "FOQM0004");
                }
                throw e;
            }
            variablesMap = variablesMap.addEntry(qNameValue, value);
        }
        HashTrieMap functionsMap = new HashTrieMap(newContext);
        XQueryFunctionLibrary functionLib = lib.getGlobalFunctionLibrary();
        Iterator<XQueryFunction> functionIterator = functionLib.getFunctionDefinitions();
        if (functionIterator.hasNext()) {
            while (functionIterator.hasNext()) {
                XQueryFunction function = functionIterator.next();
                QNameValue functionQName = new QNameValue(function.getFunctionName(), BuiltInAtomicType.QNAME);
                if (!functionQName.getNamespaceURI().equals(moduleUri)) continue;
                UserFunction userFunction = function.getUserFunction();
                userFunction.setPreallocatedController(newController);
                HashTrieMap newMap = functionsMap.get(functionQName) != null ? ((HashTrieMap)functionsMap.get(functionQName)).addEntry(new Int64Value(function.getNumberOfArguments()), function.getUserFunction()) : HashTrieMap.singleton(new Int64Value(function.getNumberOfArguments()), function.getUserFunction(), context);
                functionsMap = functionsMap.addEntry(functionQName, newMap);
            }
        }
        HashTrieMap map = new HashTrieMap(context);
        map = map.addEntry(new StringValue("variables"), variablesMap);
        map = map.addEntry(new StringValue("functions"), functionsMap);
        return map;
    }

    static {
        requiredTypes.put("xquery-version", SequenceType.SINGLE_DECIMAL);
        requiredTypes.put("location-hints", SequenceType.STRING_SEQUENCE);
        requiredTypes.put("context-item", SequenceType.OPTIONAL_ITEM);
        requiredTypes.put("variables", SequenceType.makeSequenceType(new MapType(BuiltInAtomicType.QNAME, SequenceType.ANY_SEQUENCE), 16384));
        requiredTypes.put("vendor-options", SequenceType.makeSequenceType(new MapType(BuiltInAtomicType.QNAME, SequenceType.ANY_SEQUENCE), 16384));
    }
}

