/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import nl.nikhef.slcshttps.CAConnection;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.crypto.CSR;
import nl.nikhef.slcshttps.gui.GraphTools;
import nl.nikhef.slcshttps.gui.SURFCAPopupComm;
import nl.nikhef.slcshttps.util.BareBonesBrowserLaunch;
import nl.nikhef.slcshttps.util.ConsoleTools;

public class SURFCAHttps
extends CAHttps {
    public static final String COMMPROP = "nl.nikhef.slcshttps.comm";
    public static final String CERT_URL_PROPERTY = "nl.nikhef.slcshttps.CERT_URL";
    public static final String AUTH_URL_PROPERTY = "nl.nikhef.slcshttps.AUTH_URL";
    public static final String AUTH_URL;
    public static final String CERT_URL;
    private static String commString;
    private static SURFCACommunicator defaultComm;
    private static boolean showSuccess;
    private SURFCACommunicator comm = null;

    public SURFCAHttps() throws KeyStoreException {
        this(null, null, null, null);
    }

    public SURFCAHttps(SURFCACommunicator sURFCACommunicator) throws KeyStoreException {
        this(null, null, null, sURFCACommunicator);
    }

    public SURFCAHttps(PrintStream printStream, PrintStream printStream2, InputStream inputStream, SURFCACommunicator sURFCACommunicator) throws KeyStoreException {
        super(printStream, printStream2, inputStream);
        SURFCACommunicator sURFCACommunicator2 = this.comm = sURFCACommunicator == null ? defaultComm : sURFCACommunicator;
        if (AUTH_URL == null) {
            throw new RuntimeException("Property nl.nikhef.slcshttps.AUTH_URL is not set");
        }
        if (CERT_URL == null) {
            throw new RuntimeException("Property nl.nikhef.slcshttps.CERT_URL is not set");
        }
    }

    public void initialize() throws IOException {
        this.initialize(AUTH_URL);
    }

    public void initialize(String string) throws IOException {
        this.comm.preBrowse();
        CSR cSR = this.cryptoStore.getCSR();
        if (cSR == null) {
            this.comm.error("Cannot find a Certificate Signing request in the CryptoStore", null);
            throw new IOException("Empty CSR in CryptoStore, cannot send");
        }
        String string2 = "";
        try {
            string2 = string + cSR.hash();
        }
        catch (IOException iOException) {
            this.comm.error("Failed to get hash for Certificate Signing Request from CryptoStore", iOException);
            throw iOException;
        }
        try {
            BareBonesBrowserLaunch.openURL(string2);
        }
        catch (Exception exception) {
            if (!this.comm.retry("Cannot open webbrowser to:\n<I>" + string2 + "</I>", exception)) {
                // empty if block
            }
            throw new IOException(exception.getMessage());
        }
        this.comm.postBrowse();
    }

    public void storeCertificate() throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(CERT_URL, false);
    }

    public void storeCertificate(boolean bl) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(CERT_URL, bl);
    }

    public void storeCertificate(String string) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(string, false);
    }

    public void storeCertificate(String string, boolean bl) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        boolean bl2;
        CAConnection cAConnection = null;
        int n = 200;
        X509Certificate x509Certificate = null;
        CSR cSR = this.cryptoStore.getCSR();
        if (cSR == null) {
            this.comm.error("Cannot find a Certificate Signing request in the CryptoStore", null);
            throw new KeyStoreException("Empty CSR in CryptoStore");
        }
        do {
            bl2 = false;
            try {
                cAConnection = new CAConnection(string);
            }
            catch (IOException iOException) {
                bl2 = this.comm.retry("Could not connect to\n<I>" + string + "</I>", iOException);
                if (bl2) continue;
                throw iOException;
            }
            try {
                n = cAConnection.postString("csr=" + cSR.pemString());
            }
            catch (IOException iOException) {
                bl2 = this.comm.retry("Error during POST of pemstring to\n<I>" + string + "</I>", iOException);
                if (bl2) continue;
                throw iOException;
            }
            if (n != 200) {
                bl2 = this.comm.retry("Expected response 200, found:\n<I>" + cAConnection.getResponseMessage() + "</I>\nfrom:\n<I>" + string + "</I>", null);
                if (bl2) continue;
                throw new IOException("Expected 200, found " + n);
            }
            try {
                x509Certificate = cAConnection.getCert();
            }
            catch (CertificateException certificateException) {
                String string2 = cAConnection.getResponse();
                if (string2.length() > 500) {
                    string2 = string2.substring(0, 499) + "\n...[REST OF RESPONSE SUPPRESSED]...";
                }
                if (bl2 = this.comm.retry("Server response from\n<I>" + string + "</I>\nis not a valid certificate:\n<I>" + string2 + "</I>\nMake sure you have successfully logged in!", null)) continue;
                throw certificateException;
            }
            catch (IOException iOException) {
                bl2 = this.comm.retry("Error while downloading certificate from\n<I>" + string + "</I>", iOException);
                if (bl2) continue;
                throw iOException;
            }
            if (x509Certificate != null || (bl2 = this.comm.retry("Downloaded certificate is empty", null))) continue;
            throw new CertificateException("Downloaded certificate is empty");
        } while (bl2);
        try {
            this.cryptoStore.storeCertificate(x509Certificate);
            this.comm.success(x509Certificate.getSubjectX500Principal().toString());
        }
        catch (Exception exception) {
            this.comm.error("Cannot store certificate in CryptoStore", exception);
            throw new KeyStoreException(exception.getMessage());
        }
        if (bl) {
            try {
                this.setSSLSocketFactory();
            }
            catch (Exception exception) {
                this.comm.error("Cannot set the SSLSocketFactory", exception);
                throw new KeyManagementException(exception.getMessage());
            }
        }
    }

    public static String setCommunicator(String string) {
        commString = !GraphTools.isGraphic() ? "stdio" : (string == null ? "stdio" : string.toLowerCase());
        if ("popup".equals(commString)) {
            defaultComm = new SURFCAPopupComm();
            return commString;
        }
        if ("stdio".equals(commString)) {
            defaultComm = new StdioComm();
            return commString;
        }
        defaultComm = new StdioComm();
        return commString;
    }

    public static String getCommunicator() {
        return commString;
    }

    public static void setShowSuccess(boolean bl) {
        showSuccess = bl;
    }

    public static boolean getShowSuccess() {
        return showSuccess;
    }

    static {
        CERT_URL = System.getProperty(CERT_URL_PROPERTY);
        String string = System.getProperty(AUTH_URL_PROPERTY);
        AUTH_URL = string == null || string.startsWith("http://") || string.startsWith("https://") ? string : CERT_URL + string;
        commString = null;
        defaultComm = null;
        string = System.getProperty(COMMPROP);
        SURFCAHttps.setCommunicator(string);
        showSuccess = CAHttps.showSuccess;
    }

    static class StdioComm
    implements SURFCACommunicator {
        StdioComm() {
        }

        public void preBrowse() throws IOException {
            System.out.println("A new webbrowser or webbrowsertab is about to start.\nYou will be asked to choose your Identity Provider and log in.\n1) When ready press ENTER and follow instructions in BROWSER...\n2) When DONE press enter AGAIN!!");
            ConsoleTools.readLine();
        }

        public void postBrowse() throws IOException {
            System.out.println("Browser started/called, waiting for second ENTER...");
            ConsoleTools.readLine();
        }

        public void error(String string, Exception exception) {
            String string2 = string.replaceAll("</*I>", " ");
            System.err.println("Error: " + string2);
            if (exception != null) {
                System.err.println(" " + exception.getMessage());
            }
        }

        public boolean retry(String string, Exception exception) {
            this.error(string, exception);
            try {
                return ConsoleTools.getConfirm("Retry");
            }
            catch (IOException iOException) {
                System.err.println("Caught exception: " + iOException.getMessage());
                return false;
            }
        }

        public void success(String string) {
            if (SURFCAHttps.getShowSuccess()) {
                System.out.println("Successfully imported certificate for\n " + string);
            }
        }
    }

    public static interface SURFCACommunicator {
        public void preBrowse() throws IOException;

        public void postBrowse() throws IOException;

        public void error(String var1, Exception var2);

        public boolean retry(String var1, Exception var2);

        public void success(String var1);
    }
}

