/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.MacAdapter;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.metadatafile.MetadataReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.ArbilDragDrop;
import nl.mpi.arbil.ui.ArbilTableController;
import nl.mpi.arbil.ui.ArbilTaskStatusBar;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.menu.ArbilMenuBar;
import nl.mpi.arbil.userstorage.ArbilConfiguration;
import nl.mpi.arbil.userstorage.ArbilConfigurationManager;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilLogConfigurer;
import nl.mpi.arbil.util.ArbilMimeHashQueue;
import nl.mpi.arbil.util.AuthenticatorStub;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbilcommons.ui.LocalisationSelector;
import nl.mpi.flap.plugin.PluginSessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbilMain
extends JFrame {
    private static final Logger logger = LoggerFactory.getLogger(ArbilMain.class);
    private JSplitPane mainSplitPane;
    private ArbilMenuBar arbilMenuBar;
    private ArbilTaskStatusBar statusBar;
    private final ArbilTreeHelper treeHelper;
    private final ArbilTreeController treeController;
    private final ArbilWindowManager windowManager;
    private final ApplicationVersionManager versionManager;
    private final ArbilMimeHashQueue mimeHashQueue;
    private final ArbilLogConfigurer logConfigurer;
    private final ArbilTableController tableController;
    private final ArbilSessionStorage sessionStorage;
    private final ArbilDataNodeLoader dataNodeLoader;

    public static void main(String[] args) {
        ArbilVersion arbilVersion = new ArbilVersion();
        final ArbilLogConfigurer logConfigurer = new ArbilLogConfigurer(arbilVersion, "arbil-log-");
        if (System.getProperty("java.util.logging.config.file") == null) {
            logConfigurer.configureLoggingFromResource(ArbilMain.class, "/logging-initial.properties");
        }
        logger.info("Starting Arbil");
        final ApplicationVersionManager versionManager = new ApplicationVersionManager(arbilVersion);
        final ArbilSessionStorage sessionStorage = new ArbilSessionStorage();
        System.setProperty("sun.swing.enableImprovedDragGesture", "true");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ArbilIcons.setVersionManager(versionManager);
                ArbilMain.checkLocalisation(sessionStorage);
                try {
                    new ArbilMain(sessionStorage, versionManager, logConfigurer).run();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
    }

    public ArbilMain(ArbilSessionStorage sessionStorage, ApplicationVersionManager versionManager, ArbilLogConfigurer logConfigurer) {
        this.versionManager = versionManager;
        this.logConfigurer = logConfigurer;
        this.sessionStorage = sessionStorage;
        ArbilDesktopInjector injector = new ArbilDesktopInjector();
        injector.injectHandlers(sessionStorage, versionManager, logConfigurer);
        this.treeHelper = injector.getTreeHelper();
        this.treeController = injector.getTreeController();
        this.windowManager = injector.getWindowManager();
        this.mimeHashQueue = injector.getMimeHashQueue();
        this.tableController = injector.getTableController();
        this.dataNodeLoader = injector.getDataNodeLoader();
    }

    public void run() {
        ArbilConfiguration config = this.readConfig();
        this.initApplication();
        this.initUI(config);
        this.checkFirstRun();
    }

    private ArbilConfiguration readConfig() {
        ArbilConfigurationManager configManager = new ArbilConfigurationManager(this.sessionStorage);
        ArbilConfiguration appConfig = configManager.read();
        ArbilTemplateManager.getSingleInstance().setApplicationConfiguration(appConfig);
        MetadataReader.getSingleInstance().setApplicationConfiguration(appConfig);
        MetadataBuilder.setApplicationConfiguration(appConfig);
        return appConfig;
    }

    private void initApplication() {
        try {
            Authenticator.setDefault(new AuthenticatorStub(this.windowManager));
        }
        catch (SecurityException sEx) {
            BugCatcherManager.getBugCatcher().logError("Failed to set custom Authenticator. Default authentication dialogs may appear.", sEx);
        }
        this.treeHelper.init();
        this.mimeHashQueue.init();
    }

    private void initUI(ArbilConfiguration appConfig) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ArbilMain.this.arbilMenuBar.performCleanExit();
            }
        });
        boolean macHandlersInitialized = this.initMacHandlers();
        this.initComponents();
        this.windowManager.addTaskListener(this.statusBar);
        PreviewSplitPanel previewSplitPanel = new PreviewSplitPanel(this.windowManager, this.tableController);
        this.mainSplitPane.setRightComponent(previewSplitPanel);
        ArbilDragDrop dragDrop = new ArbilDragDrop(this.sessionStorage, this.treeHelper, this.windowManager, this.windowManager, this.tableController);
        this.windowManager.setDragDrop(dragDrop);
        ArbilTreePanels arbilTreePanels = new ArbilTreePanels(this.treeHelper, this.treeController, previewSplitPanel, dragDrop);
        this.mainSplitPane.setLeftComponent(arbilTreePanels);
        ArbilMenuBar.HostOS hostOs = macHandlersInitialized ? ArbilMenuBar.HostOS.MACOS : ArbilMenuBar.HostOS.OTHER;
        this.arbilMenuBar = new ArbilMenuBar(appConfig, this.sessionStorage, this.windowManager, this.windowManager, this.treeHelper, this.dataNodeLoader, this.mimeHashQueue, this.versionManager, this.logConfigurer, null, previewSplitPanel, hostOs);
        this.setJMenuBar(this.arbilMenuBar);
        this.mainSplitPane.setDividerLocation(0.25);
        this.windowManager.loadGuiState(this, this.statusBar);
        this.setTitle(this.versionManager.getApplicationVersion().applicationTitle + " " + this.versionManager.getApplicationVersion().compileDate);
        this.setIconImage(ArbilIcons.getSingleInstance().linorgIcon.getImage());
        this.setVisible(true);
        if (this.sessionStorage.loadBoolean("checkNewVersionAtStart", true)) {
            this.versionManager.checkForUpdate();
        }
    }

    private boolean initMacHandlers() {
        MacAdapter macAdapter = new MacAdapter(){

            protected boolean performApplicationExit() {
                return ArbilMain.this.arbilMenuBar.performCleanExit();
            }

            protected void performApplicationAbout() {
                ArbilMain.this.windowManager.openAboutPage();
            }
        };
        try {
            if (macAdapter.initMacApplicationHandlers()) {
                logger.debug("Mac handlers succesfully congifured");
                return true;
            }
        }
        catch (MacAdapter.MacAdapterException exception) {
            logger.error("Could not configure MacOS application handlers", (Throwable)exception);
        }
        return false;
    }

    private void checkFirstRun() {
        this.windowManager.showSetupWizardIfFirstRun();
        this.windowManager.openIntroductionPage();
    }

    private static void checkLocalisation(SessionStorage sessionStorage) {
        String availableLanguages = ResourceBundle.getBundle("nl/mpi/arbil/localisation/AvailableLanguages").getString("LANGUAGE CODES");
        LocalisationSelector localisationSelector = new LocalisationSelector((PluginSessionStorage)sessionStorage, availableLanguages.split(","));
        if (!localisationSelector.hasSavedLocal()) {
            String please_select_your_preferred_language = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("PLEASE SELECT YOUR PREFERRED LANGUAGE");
            String language_Selection = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("LANGUAGE SELECTION");
            String system_Default = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("SYSTEM DEFAULT");
            localisationSelector.askUser(null, (Icon)ArbilIcons.getSingleInstance().linorgIcon, please_select_your_preferred_language, language_Selection, system_Default);
        }
        localisationSelector.setLanguageFromSaved();
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.statusBar = new ArbilTaskStatusBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Arbil");
        this.mainSplitPane.setDividerLocation(100);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setName("mainSplitPane");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
    }
}

