/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.arbil.search.ArbilNodeSearchTerm;
import nl.mpi.arbil.ui.ArbilNodeSearchColumnComboBox;
import nl.mpi.arbil.ui.ArbilNodeSearchPanel;
import nl.mpi.arbil.util.BugCatcherManager;

public class ArbilNodeSearchTermPanel
extends JPanel
implements ArbilNodeSearchTerm {
    private JPanel thisPanel = this;
    private ArbilNodeSearchPanel parentPanel;
    private JComboBox notComboBox;
    private JComboBox booleanComboBox;
    private JComboBox nodeTypeComboBox;
    private JButton removeButton;
    private JTextField searchField;
    private ArbilNodeSearchColumnComboBox searchColumn;
    protected boolean notEqual = false;
    protected boolean booleanAnd = false;
    protected String nodeType = "";
    protected String searchString = "";
    protected String searchFieldName = "";

    public ArbilNodeSearchTermPanel(ArbilNodeSearchPanel parentPanelLocal) {
        this.parentPanel = parentPanelLocal;
        this.nodeTypeComboBox = new JComboBox();
        this.searchField = new JTextField("<value (optional)>");
        this.searchField.setForeground(Color.lightGray);
        this.searchColumn = new ArbilNodeSearchColumnComboBox("<column (optional)>", "");
        this.searchColumn.getTextField().setForeground(Color.lightGray);
        this.notComboBox = new JComboBox();
        this.booleanComboBox = new JComboBox();
        this.removeButton = new JButton();
        this.setLayout(new BoxLayout(this, 2));
        this.booleanComboBox.setModel(new DefaultComboBoxModel<Object>(ArbilNodeSearchTerm.BOOLEAN_TYPES.toArray()));
        this.booleanComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchTermPanel.this.parentPanel.stopSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(this.booleanComboBox);
        this.nodeTypeComboBox.setModel(new DefaultComboBoxModel<Object>(NODE_TYPES.toArray()));
        this.nodeTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchTermPanel.this.parentPanel.stopSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(this.nodeTypeComboBox);
        this.searchField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ArbilNodeSearchTermPanel.this.searchField.getText().equals("<value (optional)>")) {
                    ArbilNodeSearchTermPanel.this.searchField.setText("");
                    ArbilNodeSearchTermPanel.this.searchField.setForeground(Color.BLACK);
                }
            }

            public void focusLost(FocusEvent e) {
                if (ArbilNodeSearchTermPanel.this.searchField.getText().length() == 0) {
                    ArbilNodeSearchTermPanel.this.searchField.setText("<value (optional)>");
                    ArbilNodeSearchTermPanel.this.searchField.setForeground(Color.lightGray);
                }
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ArbilNodeSearchTermPanel.this.parentPanel.startSearch();
                }
            }
        });
        this.searchColumn.getTextField().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (ArbilNodeSearchTermPanel.this.searchColumn.getText().equals("<column (optional)>")) {
                    ArbilNodeSearchTermPanel.this.searchColumn.setText("");
                    ArbilNodeSearchTermPanel.this.searchColumn.getTextField().setForeground(Color.BLACK);
                }
            }

            public void focusLost(FocusEvent e) {
                if (ArbilNodeSearchTermPanel.this.searchColumn.getText().length() == 0) {
                    ArbilNodeSearchTermPanel.this.searchColumn.setText("<column (optional)>");
                    ArbilNodeSearchTermPanel.this.searchColumn.getTextField().setForeground(Color.lightGray);
                }
            }
        });
        this.searchColumn.getTextField().addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ArbilNodeSearchTermPanel.this.parentPanel.stopSearch();
            }
        });
        this.searchColumn.getTextField().setColumns(10);
        this.add(this.searchColumn);
        this.searchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ArbilNodeSearchTermPanel.this.parentPanel.stopSearch();
            }
        });
        this.searchField.setColumns(20);
        this.add(this.searchField);
        this.notComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"==", "!="}));
        this.notComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchTermPanel.this.parentPanel.stopSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(this.notComboBox);
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilNodeSearchTermPanel.this.parentPanel.getSearchTermsPanel().remove(ArbilNodeSearchTermPanel.this.thisPanel);
                    ArbilNodeSearchTermPanel.this.parentPanel.revalidate();
                    ArbilNodeSearchTermPanel.this.parentPanel.stopSearch();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(this.removeButton);
    }

    public void populateSearchTerm() {
        if (this.searchField.getText().equals("<value (optional)>")) {
            this.setSearchString("");
        } else {
            this.setSearchString(this.searchField.getText());
        }
        if (this.searchColumn.getText().equals("<column (optional)>")) {
            this.setSearchFieldName("");
        } else {
            this.setSearchFieldName(this.searchColumn.getText());
        }
        this.setNodeType(this.nodeTypeComboBox.getSelectedItem().toString());
        if (this.booleanComboBox.isVisible()) {
            this.setBooleanAnd(this.booleanComboBox.getSelectedItem().toString().equals("and"));
        } else {
            this.setBooleanAnd(true);
        }
        this.setNotEqual(this.notComboBox.getSelectedItem().toString().equals("!="));
    }

    public void addCurrentSearchColumnOption() {
        if (this.searchFieldName != null && !"".equals(this.searchFieldName)) {
            this.searchColumn.addOption(this.searchFieldName);
        }
    }

    public void setBooleanVisible(boolean visibleValue) {
        this.booleanComboBox.setVisible(visibleValue);
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getSearchFieldName() {
        return this.searchFieldName;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public boolean isBooleanAnd() {
        return this.booleanAnd;
    }

    public boolean isNotEqual() {
        return this.notEqual;
    }

    public void setBooleanAnd(boolean booleanAnd) {
        this.booleanAnd = booleanAnd;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setNotEqual(boolean notEqual) {
        this.notEqual = notEqual;
    }

    public void setSearchFieldName(String searchFieldName) {
        this.searchFieldName = searchFieldName;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }
}

