/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.wizard.setup;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.CmdiProfilesPanel;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizardModel;
import nl.mpi.arbil.ui.wizard.setup.TextInstructionWizardContent;

public class CmdiProfileSelectContent
extends TextInstructionWizardContent {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private CmdiProfilesPanel profilesPanel;

    public CmdiProfileSelectContent(ArbilSetupWizardModel model, JDialog wizardDialog) {
        super("/nl/mpi/arbil/resources/html/wizard/CmdiProfileSelect.html");
        this.profilesPanel = new CmdiProfilesPanel(wizardDialog);
        this.profilesPanel.setBorder(BorderFactory.createTitledBorder(widgets.getString("SETUP_CLARIN PROFILES")));
        this.profilesPanel.setPreferredSize(new Dimension(200, 300));
        this.profilesPanel.setInstructionsVisible(false);
        this.profilesPanel.setVisible(false);
        this.add((Component)this.profilesPanel, "Center");
    }

    public void beforeShow() {
        this.profilesPanel.setVisible(true);
        this.profilesPanel.populateList();
        this.profilesPanel.loadProfileDescriptions(false);
    }

    public boolean beforeNext() {
        boolean doNext;
        if (this.profilesSelected()) {
            doNext = true;
        } else {
            boolean bl = doNext = 0 == JOptionPane.showConfirmDialog(this, widgets.getString("SETUP_YOU HAVE NOT YET SELECTED PROFILES TO USE. ARE YOU SURE YOU WANT TO CONTINUE?"), widgets.getString("SETUP_NO PROFILES SELECTED"), 2, 2);
        }
        if (doNext) {
            this.profilesPanel.setVisible(false);
        }
        return doNext;
    }

    public boolean beforePrevious() {
        this.profilesPanel.setVisible(false);
        return true;
    }

    public Object getNext() {
        return ArbilSetupWizard.REMOTE_LOCATIONS;
    }

    public Object getPrevious() {
        return ArbilSetupWizard.METADATA_FORMAT_SELECT;
    }

    private boolean profilesSelected() {
        for (String template : ArbilTemplateManager.getSingleInstance().getSelectedTemplates()) {
            if (!template.startsWith("clarin:")) continue;
            return true;
        }
        return false;
    }
}

