/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.validation;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nl.mpi.metadata.api.util.DefaultResourceResolver;
import nl.mpi.metadata.api.validation.MetadataValidator;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class DefaultCMDIValidator
implements MetadataValidator<CMDIDocument> {
    private LSResourceResolver resourceResolver;

    public DefaultCMDIValidator() {
        this(new DefaultResourceResolver());
    }

    public DefaultCMDIValidator(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    @Override
    public void validateMetadataDocument(CMDIDocument document, ErrorHandler errorHandler) throws SAXException {
        try {
            Validator validator = this.createValidator(document.getType().getSchemaLocation().toURL());
            validator.setErrorHandler(errorHandler);
            StreamSource xmlFile = new StreamSource(new File(document.getFileLocation()));
            validator.validate(xmlFile);
        }
        catch (IOException ioEx) {
            throw new RuntimeException("I/O error while validating CMDI document", ioEx);
        }
    }

    protected Validator createValidator(URL schemaFile) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(this.getResourceResolver());
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        return validator;
    }

    protected void configureSchemaFactory(SchemaFactory schemaFactory) {
        schemaFactory.setResourceResolver(this.getResourceResolver());
    }

    protected void configureValidator(Validator validator) {
        validator.setResourceResolver(this.getResourceResolver());
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }
}

