/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.Util;

public class HDLCreate {
    public static void main(String[] argv) {
        if (argv.length != 4) {
            System.err.println("usage: java net.handle.apps.simple.HDLCreate <auth handle> <auth index> <privkey> <handle>");
            System.exit(-1);
        }
        byte[] key = null;
        try {
            File f = new File(argv[2]);
            FileInputStream fs = new FileInputStream(f);
            key = new byte[(int)f.length()];
            int n = 0;
            while (n < key.length) {
                key[n++] = (byte)fs.read();
            }
            fs.read(key);
        }
        catch (Throwable t) {
            System.err.println("Cannot read private key " + argv[2] + ": " + t);
            System.exit(-1);
        }
        HandleResolver resolver = new HandleResolver();
        PrivateKey privkey = null;
        byte[] secKey = null;
        try {
            if (Util.requiresSecretKey(key)) {
                secKey = Util.getPassphrase("passphrase: ");
            }
            key = Util.decrypt(key, secKey);
            privkey = Util.getPrivateKeyFromBytes(key, 0);
        }
        catch (Throwable t) {
            System.err.println("Can't load private key in " + argv[2] + ": " + t);
            System.exit(-1);
        }
        try {
            PublicKeyAuthenticationInfo auth = new PublicKeyAuthenticationInfo(argv[0].getBytes("UTF8"), Integer.valueOf(argv[1]), privkey);
            AdminRecord admin = new AdminRecord(argv[0].getBytes("UTF8"), 300, true, true, true, true, true, true, true, true, true, true, true, true);
            int timestamp = (int)(System.currentTimeMillis() / 1000L);
            HandleValue[] val = new HandleValue[]{new HandleValue(100, "HS_ADMIN".getBytes("UTF8"), Encoder.encodeAdminRecord(admin), 0, 86400, timestamp, null, true, true, true, false)};
            CreateHandleRequest req = new CreateHandleRequest(argv[3].getBytes("UTF8"), val, (AuthenticationInfo)auth);
            resolver.traceMessages = true;
            AbstractResponse response = resolver.processRequest(req);
            if (response.responseCode == 1) {
                System.out.println("\nGot Response: \n" + response);
            } else {
                System.out.println("\nGot Error: \n" + response);
            }
        }
        catch (Throwable t) {
            System.err.println("\nError: " + t);
        }
    }
}

