/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.handle.hdllib.SiteInfo;
import net.handle.jdb.DBHash;
import net.handle.server.DBTxn;

public class SplitRecoveryLog {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy.MM.dd:hh:mm::ss");
    private long startDate = -1L;
    private File origDir;
    private DBHash[] destDBs;
    private File txnFile;
    private int numDBs;

    public static void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            System.err.println("usage: java net.handle.apps.tools.SplitRecoveryLog [-d <sincedate>] <sourcedir> <destdir1> <destdir2> ...");
            return;
        }
        SplitRecoveryLog splitter = new SplitRecoveryLog(argv);
        splitter.doit();
        splitter.cleanup();
    }

    SplitRecoveryLog(String[] argv) throws Exception {
        int logIdx = 0;
        String sinceDateStr = null;
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-d")) continue;
            sinceDateStr = argv[i + 1];
            logIdx = i + 2;
            ++i;
        }
        if (sinceDateStr != null) {
            Date dt = this.dateFormat.parse(sinceDateStr);
            this.startDate = dt.getTime();
            System.err.println("using date: " + dt);
        }
        this.origDir = new File(argv[logIdx]);
        this.txnFile = new File(this.origDir, "dbtxns.log");
        int destIdx = logIdx + 1;
        if (!this.txnFile.exists() || !this.txnFile.canRead()) {
            throw new Exception("Unable to read transaction file in source dir: " + this.origDir);
        }
        this.numDBs = argv.length - destIdx;
        this.destDBs = new DBHash[this.numDBs];
        for (int i = 0; i < this.numDBs; ++i) {
            System.err.println("loading dest db: " + argv[i + destIdx]);
            this.destDBs[i] = new DBHash(new File(argv[i + destIdx], "handles.jdb"), 5000, 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doit() throws Exception {
        System.err.println("Restoring from transactions...");
        System.err.flush();
        BufferedInputStream txnInput = new BufferedInputStream(new FileInputStream(this.txnFile));
        int count = 0;
        int skipped = 0;
        long lastDate = 0L;
        DBTxn txn = null;
        try {
            System.err.println("start date: " + this.startDate);
            while ((txn = DBTxn.readTxn(txnInput)) != null) {
                lastDate = txn.getDate();
                if (this.startDate != -1L && this.startDate > lastDate) {
                    if (++skipped % 400 != 0) continue;
                    System.err.print("\rskipped: " + count);
                    continue;
                }
                if (++count < 100) {
                    System.err.println("processing record " + count + ": " + txn + " date: " + lastDate);
                }
                switch (txn.getAction()) {
                    case 0: {
                        this.destDBs[SiteInfo.determineServerNum(txn.getKey(), 2, this.numDBs)].setValue(txn.getKey(), txn.getValue());
                        break;
                    }
                    case 1: {
                        this.destDBs[SiteInfo.determineServerNum(txn.getKey(), 2, this.numDBs)].deleteValue(txn.getKey());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        System.err.println("\nDELETING EVERYTHING!!!!");
                        for (int i = 0; i < this.destDBs.length; ++i) {
                            this.destDBs[i].deleteAllRecords();
                        }
                        break;
                    }
                    default: {
                        throw new Exception("Error: Unknown action in transaction log: " + txn.getAction());
                    }
                }
                if (count % 1000 != 0) continue;
                System.err.print("\rprocessed: " + count);
            }
            Object var9_7 = null;
            System.err.println("\rprocessed: " + count + " last date: " + this.dateFormat.format(new Date(lastDate)));
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            System.err.println("\rprocessed: " + count + " last date: " + this.dateFormat.format(new Date(lastDate)));
            throw throwable;
        }
        ((InputStream)txnInput).close();
    }

    void cleanup() throws Exception {
        for (int i = 0; i < this.destDBs.length; ++i) {
            this.destDBs[i].close();
        }
    }
}

