/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.SecureRandom;
import java.util.Random;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;

public class ChallengeResponse
extends AbstractResponse {
    private static Random random = null;
    private static final String randomLock = "randomLock";
    public byte[] nonce;

    public ChallengeResponse(int opCode, byte[] nonce) {
        super(opCode, 402);
        this.nonce = nonce;
    }

    public ChallengeResponse(AbstractRequest req) throws HandleException {
        super(req, 402);
        if (this.requestDigest == null) {
            this.takeDigestOfRequest(req);
        }
        this.returnRequestDigest = true;
        this.generateChallenge(req);
    }

    public static final void initializeRandom() {
        ChallengeResponse.initializeRandom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void initializeRandom(byte[] seed) {
        if (random != null) return;
        String string = randomLock;
        synchronized (randomLock) {
            if (random != null) return;
            random = seed == null ? new SecureRandom() : new SecureRandom(seed);
            random.nextInt();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Random getRandom() {
        if (random == null) {
            ChallengeResponse.initializeRandom();
        }
        return random;
    }

    private void generateChallenge(AbstractRequest req) throws HandleException {
        this.nonce = new byte[16];
        ChallengeResponse.getRandom().nextBytes(this.nonce);
    }
}

